/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import oracle.ide.util.IdeUtil;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.IntersectionType;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.internal.compiler.ConstantExpressionEvaluator;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.JavaWildcardType;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceBlockElement;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeArgument;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.UnresolvedType;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInfixExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInvokeExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceLiteralExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceUnaryExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceWrapperExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceBlockStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceExpressionStatement;
import oracle.javatools.parser.java.v2.util.Conversions;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.style.CodingStyleManager;
import oracle.jdeveloper.style.CodingStyleOptions;

public class JavaHelper {
    public static final int _CONVERTIBLE = 4;
    public static final int _CASTABLE = 2;
    public static final int _INCOMPATIBLE = 1;
    public static final int _UNRESOLVED = 0;
    public static final int _CONSTANT = 8;
    public static final int _UNCHECKED = 16;
    public static final int INVOCABLE = 4;
    public static final int INVOCABLE_UNCHECKED = 20;
    public static final int NARROWABLE = 12;
    public static final int UNNARROWABLE = 10;
    public static final int CASTABLE = 2;
    public static final int CASTABLE_UNCHECKED = 18;
    public static final int INCOMPATIBLE_CASTABLE = 3;
    public static final int INCOMPATIBLE = 1;
    public static final int UNKNOWN = 0;
    private static final String[] NO_STRINGS = new String[0];
    public static final int ACCESSIBLE = 1;
    public static final int SAME_TOP_LEVEL_CLASS = 2;
    public static final int SAME_PACKAGE = 4;
    public static final int SAME_HIERARCHY = 8;

    private JavaHelper() {
    }

    public static int analyzeAssignmentConversion(JavaType toType, JavaType fromType, SourceExpression fromExpression, JavaProvider provider) {
        int max;
        int min;
        JavaMethod functionalInterfaceMethod;
        if (fromExpression != null && fromExpression.getSymbolKind() == 79 && (functionalInterfaceMethod = CommonUtilities.getFunctionalInterfaceMethod((JavaType)toType)) != null) {
            toType = functionalInterfaceMethod.getReturnType();
        }
        if (toType == null || fromType == null) {
            return 0;
        }
        if (toType.getElementKind() == 12 || fromType.getElementKind() == 12) {
            return JavaHelper.analyzeIntersectionConversion(toType, fromType, provider);
        }
        int analysis = JavaHelper.analyzeMethodInvocationConversion(toType, fromType, provider);
        if (analysis != 2 || fromExpression == null || !fromType.isPrimitive()) {
            return analysis;
        }
        switch (fromType.getName()) {
            case "byte": 
            case "short": 
            case "char": 
            case "int": {
                break;
            }
            default: {
                return 2;
            }
        }
        PrimitiveType toPrimitive = JavaHelper.unbox(toType);
        if (toPrimitive == null) {
            return 2;
        }
        Object constantObject = ConstantExpressionEvaluator.evaluate((SourceExpression)fromExpression);
        if (constantObject == null) {
            return 2;
        }
        switch (toPrimitive.primCode) {
            case 1: {
                min = -128;
                max = 127;
                break;
            }
            case 3: {
                min = Short.MIN_VALUE;
                max = Short.MAX_VALUE;
                break;
            }
            case 2: {
                min = 0;
                max = 65535;
                break;
            }
            case 4: {
                min = Integer.MIN_VALUE;
                max = Integer.MAX_VALUE;
                break;
            }
            default: {
                return 2;
            }
        }
        int constantInt = constantObject instanceof Character ? ((Character)constantObject).charValue() : ((Number)constantObject).intValue();
        if (min <= constantInt && constantInt <= max) {
            return 12;
        }
        return 10;
    }

    public static int analyzeMethodInvocationConversion(JavaType toType, JavaType fromType, JavaProvider provider) {
        if (toType == null || fromType == null) {
            return 0;
        }
        if (fromType.equals(toType)) {
            return 4;
        }
        if (toType.getName().equals("null")) {
            return 0;
        }
        PrimitiveType fromPrimitive = JavaHelper.unbox(fromType);
        PrimitiveType toPrimitive = JavaHelper.unbox(toType);
        if (fromType.isPrimitive()) {
            if (toType.isPrimitive()) {
                if (fromType.getName().equals("null")) {
                    return 1;
                }
                return JavaHelper.analyzePrimitiveConversion(toPrimitive, fromPrimitive);
            }
            if (fromType.getName().equals("null")) {
                return 4;
            }
            if (CommonUtilities.provider2JdkVersion((JavaProvider)provider).isJdk5OrAbove()) {
                int analysis;
                JavaType boxedFromType = JavaHelper.box((JavaType)fromPrimitive, provider);
                if (boxedFromType != null && (analysis = JavaHelper.analyzeReferenceConversion(toType, boxedFromType, provider)) != 1) {
                    return analysis;
                }
                if (toPrimitive != null) {
                    return JavaHelper.analyzePrimitiveConversion(toPrimitive, fromPrimitive);
                }
            }
            return 1;
        }
        if (toType.isPrimitive()) {
            assert (!fromType.isPrimitive());
            if (CommonUtilities.provider2JdkVersion((JavaProvider)provider).isJdk5OrAbove() && fromPrimitive != null) {
                int analysis = JavaHelper.analyzePrimitiveConversion(toPrimitive, fromPrimitive);
                if (analysis != 2) {
                    return analysis;
                }
                return 3;
            }
            return 1;
        }
        return JavaHelper.analyzeReferenceConversion(toType, fromType, provider);
    }

    public static int analyzeReferenceConversion(JavaType toType, JavaType fromType, JavaProvider provider) {
        if (toType == null || fromType == null) {
            return 0;
        }
        if (toType.equals(fromType)) {
            return 4;
        }
        if (fromType.isArray()) {
            if (toType.isArray()) {
                JavaType toComponent = toType.getComponentType();
                JavaType fromComponent = fromType.getComponentType();
                if (toComponent == null || fromComponent == null) {
                    return 0;
                }
                if (fromComponent.getName().equals("null")) {
                    return 4;
                }
                if (toComponent.isPrimitive()) {
                    if (fromComponent.equals(toComponent)) {
                        return 4;
                    }
                    return 1;
                }
                return JavaHelper.analyzeMethodInvocationConversion(toComponent, fromComponent, provider);
            }
            if (toType instanceof JavaTypeVariable || toType instanceof JavaWildcardType) {
                Collection bounds = toType instanceof JavaTypeVariable ? ((JavaTypeVariable)toType).getBounds() : ((JavaWildcardType)toType).getUpperBounds();
                if (bounds.isEmpty()) {
                    return 20;
                }
                JavaType bound = (JavaType)bounds.iterator().next();
                if (bound.equals(toType)) {
                    return 0;
                }
                int code = JavaHelper.analyzeMethodInvocationConversion(bound, fromType, provider);
                if (code != 1) {
                    code |= 0x10;
                }
                return code;
            }
            if (toType.isInterface()) {
                String toName = toType.getQualifiedName();
                if ("java.lang.Cloneable".equals(toName) || "java.io.Serializable".equals(toName)) {
                    return 4;
                }
                return 1;
            }
            if ("java.lang.Object".equals(toType.getQualifiedName())) {
                return 4;
            }
            return 1;
        }
        if (fromType instanceof JavaTypeVariable || fromType instanceof JavaWildcardType) {
            Collection bounds = fromType instanceof JavaTypeVariable ? ((JavaTypeVariable)fromType).getBounds() : ((JavaWildcardType)fromType).getUpperBounds();
            if (bounds.isEmpty()) {
                return JavaHelper.analyzeReferenceConversion(toType, (JavaType)provider.getClass("java.lang.Object"), provider);
            }
            JavaType bound = (JavaType)bounds.iterator().next();
            if (bound.equals(fromType)) {
                return 0;
            }
            return JavaHelper.analyzeReferenceConversion(toType, bound, provider);
        }
        if (fromType.isInterface()) {
            int unchecked = JavaHelper.unchecked(fromType, toType);
            if (toType.isArray()) {
                String fromName = fromType.getQualifiedName();
                if ("java.lang.Cloneable".equals(fromName) || "java.io.Serializable".equals(fromName)) {
                    return 2 | unchecked;
                }
                return 1 | unchecked;
            }
            if (toType.isInterface()) {
                if (Conversions.isSubtypeOfImpl((JavaType)fromType, (JavaType)toType)) {
                    return 4 | unchecked;
                }
                return 2 | unchecked;
            }
            if ("java.lang.Object".equals(toType.getQualifiedName())) {
                return 4 | unchecked;
            }
            if (!toType.isFinal() || Conversions.isSubtypeOfImpl((JavaType)toType, (JavaType)fromType)) {
                return 2 | unchecked;
            }
            return 1;
        }
        int unchecked = JavaHelper.unchecked(fromType, toType);
        if (toType.isArray()) {
            if ("java.lang.Object".equals(fromType.getQualifiedName())) {
                return 2 | unchecked;
            }
            return 1 | unchecked;
        }
        if (toType instanceof JavaTypeVariable) {
            Collection bounds = ((JavaTypeVariable)toType).getBounds();
            if (bounds.isEmpty()) {
                return 4 | unchecked;
            }
            JavaType bound = (JavaType)bounds.iterator().next();
            if (bound.equals(toType)) {
                return 0;
            }
            return JavaHelper.analyzeReferenceConversion(bound, fromType, provider);
        }
        if (toType.isInterface()) {
            if (Conversions.isSubtypeOfImpl((JavaType)fromType, (JavaType)toType, (Conversions.ConversionType)Conversions.ConversionType.ASSIGNMENT)) {
                return 4 | unchecked;
            }
            if (Conversions.isSubtypeOfImpl((JavaType)fromType, (JavaType)toType, (Conversions.ConversionType)Conversions.ConversionType.CASTING)) {
                return 2 | unchecked;
            }
            if (!fromType.isFinal()) {
                return 2 | unchecked;
            }
            return 1;
        }
        if (Conversions.isSubtypeOfImpl((JavaType)fromType, (JavaType)toType, (Conversions.ConversionType)Conversions.ConversionType.ASSIGNMENT)) {
            return 4 | unchecked;
        }
        if (Conversions.isSubtypeOfImpl((JavaType)fromType, (JavaType)toType, (Conversions.ConversionType)Conversions.ConversionType.CASTING)) {
            return 2 | unchecked;
        }
        if (Conversions.isSubtypeOfImpl((JavaType)toType, (JavaType)fromType)) {
            return 2 | unchecked;
        }
        return 1;
    }

    private static int analyzeIntersectionConversion(JavaType toTypeIn, JavaType fromTypeIn, JavaProvider provider) {
        if (toTypeIn == null || fromTypeIn == null) {
            return 0;
        }
        ArrayList<JavaType> toTypes = new ArrayList<JavaType>();
        if (toTypeIn.getElementKind() == 12) {
            toTypes.addAll(((IntersectionType)toTypeIn).getTypes());
        } else {
            toTypes.add(toTypeIn);
        }
        ArrayList<JavaType> fromTypes = new ArrayList<JavaType>();
        if (fromTypeIn.getElementKind() == 12) {
            fromTypes.addAll(((IntersectionType)fromTypeIn).getTypes());
        } else {
            fromTypes.add(fromTypeIn);
        }
        int finalResult = 0;
        for (JavaType toType : toTypes) {
            int thisResult = 0;
            for (JavaType fromType : fromTypes) {
                int result = JavaHelper.analyzeAssignmentConversion(toType, fromType, null, provider);
                if ((result & 1) != 0) continue;
                if ((result & 4) != 0) {
                    thisResult = 4;
                    break;
                }
                if ((result & 2) == 0) continue;
                thisResult = 2;
            }
            if (thisResult == 0) {
                return 1;
            }
            finalResult |= thisResult;
        }
        if ((finalResult & 2) != 0) {
            return 2;
        }
        return 4;
    }

    private static int unchecked(JavaType fromType, JavaType toType) {
        if (JavaHelper.isRaw(fromType) && toType != null && toType.hasTypeParameters() && toType.hasActualTypeArguments() && !JavaHelper.hasUnboundedWildcardsOnly(toType)) {
            return 16;
        }
        return 0;
    }

    private static boolean hasUnboundedWildcardsOnly(JavaType type) {
        for (JavaType argument : type.getActualTypeArguments()) {
            if (argument instanceof JavaWildcardType) {
                JavaWildcardType wildcard = (JavaWildcardType)argument;
                if (wildcard.getUpperBounds().isEmpty() && wildcard.getLowerBounds().isEmpty()) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static int analyzePrimitiveConversion(PrimitiveType toPrimitive, PrimitiveType fromPrimitive) {
        if (fromPrimitive == null || toPrimitive == null) {
            return 0;
        }
        switch (fromPrimitive.primCode) {
            case 0: {
                return toPrimitive.primCode == 0 ? 4 : 1;
            }
            case 1: {
                switch (toPrimitive.primCode) {
                    case 0: {
                        return 1;
                    }
                    case 2: {
                        return 2;
                    }
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        return 4;
                    }
                    case 9: {
                        return 1;
                    }
                }
            }
            case 3: {
                switch (toPrimitive.primCode) {
                    case 0: {
                        return 1;
                    }
                    case 1: 
                    case 2: {
                        return 2;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        return 4;
                    }
                    case 9: {
                        return 1;
                    }
                }
            }
            case 2: {
                switch (toPrimitive.primCode) {
                    case 0: {
                        return 1;
                    }
                    case 1: 
                    case 3: {
                        return 2;
                    }
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        return 4;
                    }
                    case 9: {
                        return 1;
                    }
                }
            }
            case 4: {
                switch (toPrimitive.primCode) {
                    case 0: {
                        return 1;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        return 2;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        return 4;
                    }
                    case 9: {
                        return 1;
                    }
                }
            }
            case 5: {
                switch (toPrimitive.primCode) {
                    case 0: {
                        return 1;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        return 2;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        return 4;
                    }
                    case 9: {
                        return 1;
                    }
                }
            }
            case 6: {
                switch (toPrimitive.primCode) {
                    case 0: {
                        return 1;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        return 2;
                    }
                    case 6: 
                    case 7: {
                        return 4;
                    }
                    case 9: {
                        return 1;
                    }
                }
            }
            case 7: {
                switch (toPrimitive.primCode) {
                    case 0: {
                        return 1;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        return 2;
                    }
                    case 7: {
                        return 4;
                    }
                    case 9: {
                        return 1;
                    }
                }
            }
            case 9: {
                return 1;
            }
        }
        assert (false) : "from " + fromPrimitive + ", to " + toPrimitive;
        return 0;
    }

    public static JavaType box(JavaType type, JavaProvider provider) {
        switch (type.getName()) {
            case "boolean": {
                return provider.getClass("java.lang.Boolean");
            }
            case "byte": {
                return provider.getClass("java.lang.Byte");
            }
            case "char": {
                return provider.getClass("java.lang.Character");
            }
            case "short": {
                return provider.getClass("java.lang.Short");
            }
            case "int": {
                return provider.getClass("java.lang.Integer");
            }
            case "long": {
                return provider.getClass("java.lang.Long");
            }
            case "float": {
                return provider.getClass("java.lang.Float");
            }
            case "double": {
                return provider.getClass("java.lang.Double");
            }
        }
        return null;
    }

    public static PrimitiveType unbox(JavaType type) {
        PrimitiveType[] TYPES = PrimitiveType.PRIMITIVE_objects;
        switch (type.getRawName()) {
            case "boolean": 
            case "java.lang.Boolean": {
                return TYPES[0];
            }
            case "byte": 
            case "java.lang.Byte": {
                return TYPES[1];
            }
            case "char": 
            case "java.lang.Character": {
                return TYPES[2];
            }
            case "short": 
            case "java.lang.Short": {
                return TYPES[3];
            }
            case "int": 
            case "java.lang.Integer": {
                return TYPES[4];
            }
            case "long": 
            case "java.lang.Long": {
                return TYPES[5];
            }
            case "float": 
            case "java.lang.Float": {
                return TYPES[6];
            }
            case "double": 
            case "java.lang.Double": {
                return TYPES[7];
            }
            case "null": {
                return TYPES[8];
            }
            case "void": {
                return TYPES[9];
            }
        }
        return null;
    }

    public static SourceExpression createComplementExpression(SourceExpression expression) {
        SourceUnaryExpression result;
        assert (expression.getParent() == null);
        assert (expression.getResolvedType().getQualifiedName().equals("boolean"));
        SourceFactory factory = expression.getOwningSourceFile().getFactory();
        boolean wrapped = expression instanceof SourceWrapperExpression;
        if (wrapped) {
            expression = expression.getFirstOperand();
            expression.removeSelf();
        }
        block0 : switch (expression.getSymbolKind()) {
            case 68: {
                boolean value = ((SourceLiteralExpression)expression).getLiteral().literalBoolean;
                result = factory.createExpression(String.valueOf(!value));
                break;
            }
            case 76: {
                switch (expression.getOperatorCode()) {
                    case 41: {
                        SourceExpression operand = expression.getFirstOperand();
                        operand.removeSelf();
                        result = operand;
                        break block0;
                    }
                }
                result = null;
                break;
            }
            case 66: {
                switch (expression.getOperatorCode()) {
                    case 30: {
                        result = JavaHelper.createInfixExpression(21, expression, false, factory);
                        break block0;
                    }
                    case 25: {
                        result = JavaHelper.createInfixExpression(22, expression, false, factory);
                        break block0;
                    }
                    case 22: {
                        result = JavaHelper.createInfixExpression(25, expression, false, factory);
                        break block0;
                    }
                    case 21: {
                        result = JavaHelper.createInfixExpression(30, expression, false, factory);
                        break block0;
                    }
                    case 20: {
                        result = JavaHelper.createInfixExpression(42, expression, false, factory);
                        break block0;
                    }
                    case 42: {
                        result = JavaHelper.createInfixExpression(20, expression, false, factory);
                        break block0;
                    }
                    case 7: {
                        result = JavaHelper.createInfixExpression(10, expression, true, factory);
                        break block0;
                    }
                    case 3: {
                        result = JavaHelper.createInfixExpression(43, expression, true, factory);
                        break block0;
                    }
                    case 10: {
                        result = JavaHelper.createInfixExpression(7, expression, true, factory);
                        break block0;
                    }
                    case 43: {
                        result = JavaHelper.createInfixExpression(3, expression, true, factory);
                        break block0;
                    }
                    case 12: {
                        result = JavaHelper.createInfixExpression(20, expression, false, factory);
                        break block0;
                    }
                }
                result = null;
                break;
            }
            case 72: {
                SourceExpression condition = expression.getOperandAt(0);
                SourceExpression operand1 = expression.getOperandAt(1);
                SourceExpression operand2 = expression.getOperandAt(2);
                condition.removeSelf();
                operand1.removeSelf();
                operand2.removeSelf();
                result = factory.createQuestionExpression(condition, JavaHelper.createComplementExpression(operand1), JavaHelper.createComplementExpression(operand2));
                break;
            }
            case 65: 
            case 69: 
            case 73: {
                result = factory.createUnaryExpression(41, expression);
                break;
            }
            default: {
                result = null;
            }
        }
        if (result != null) {
            if (wrapped) {
                return factory.createWrapperExpression((SourceExpression)result);
            }
            return result;
        }
        return factory.createUnaryExpression(41, (SourceExpression)factory.createWrapperExpression(expression));
    }

    private static SourceInfixExpression createInfixExpression(int operator, SourceExpression expression, boolean complement, SourceFactory factory) {
        int count = expression.getOperandCount();
        SourceExpression[] operands = new SourceExpression[count];
        int i = count;
        while (--i >= 0) {
            SourceExpression operand = expression.getOperandAt(i);
            operand.removeSelf();
            if (complement) {
                operand = JavaHelper.createComplementExpression(operand);
            }
            operands[i] = operand;
        }
        return factory.createInfixExpression(operator, operands);
    }

    public static SourceBlockStatement createBlockStatement(SourceBlockElement element) {
        assert (element.getParent() == null);
        if (element.getSymbolKind() == 45) {
            return (SourceBlockStatement)element;
        }
        SourceFactory factory = element.getOwningSourceFile().getFactory();
        SourceBlock block = factory.createBlock(new SourceElement[]{element});
        return factory.createBlockStatement(block);
    }

    public static SourceExpressionStatement createAssignmentStatement(String name, SourceExpression expression) {
        SourceFactory factory = expression.getOwningSourceFile().getFactory();
        return factory.createExpressionStatement((SourceExpression)factory.createAssignment(6, (SourceExpression)factory.createSimpleNameExpression(name), expression));
    }

    public static SourceExpression extractInitializer(SourceLocalVariable variable) {
        SourceTypeReference type;
        SourceExpression initializer = variable.getInitializer();
        initializer.removeSelf();
        if (initializer instanceof SourceListExpression && (type = variable.getSourceType()).isArray()) {
            SourceFactory factory = variable.getOwningSourceFile().getFactory();
            initializer = factory.createNewInitializedArrayExpression(factory.createType(type.getName(), type.getArrayDimension()), (SourceListExpression)initializer);
        }
        return initializer;
    }

    public static SourceMethod createConstructor(SourceClass type, String[] parameterTypeNames, String[] suggestedNames) {
        SourceFactory factory = type.getOwningSourceFile().getFactory();
        HashSet<String> usedNames = new HashSet<String>();
        SourceLocalVariable[] parameters = new SourceLocalVariable[parameterTypeNames.length];
        for (int i = 0; i < parameters.length; ++i) {
            String typeName = parameterTypeNames[i];
            if (typeName == null) {
                typeName = "java.lang.Object";
            }
            String typeToCreate = typeName.lastIndexOf(60) > 0 ? typeName : JavaHelper.lastToken(typeName, '.');
            SourceTypeReference parameterType = factory.createType(typeToCreate);
            String suggestedName = suggestedNames != null && i < suggestedNames.length ? suggestedNames[i] : null;
            String parameterName = JavaHelper.getParameterName(suggestedName, typeName, usedNames);
            parameters[i] = factory.createLocalVariable(parameterType, parameterName);
        }
        SourceMethod constructor = factory.createConstructor(factory.createFormalParameterList(parameters), null, factory.createBlock());
        type.getSourceConstructors().add(constructor);
        constructor.setModifiers(type.getModifiers() & 7);
        return constructor;
    }

    public static SourceMethod createMethod(SourceClass type, String methodName, String returnTypeName, String[] parameterTypeNames, String[] suggestedNames) {
        SourceFactory factory = type.getOwningSourceFile().getFactory();
        SourceTypeReference returnType = null;
        if (returnTypeName != null) {
            returnType = factory.createType(returnTypeName);
        }
        HashSet<String> usedNames = new HashSet<String>();
        SourceLocalVariable[] parameters = new SourceLocalVariable[parameterTypeNames != null ? parameterTypeNames.length : 0];
        for (int i = 0; i < parameters.length; ++i) {
            String typeName = parameterTypeNames[i];
            if (typeName == null || typeName.equals("null")) {
                typeName = "java.lang.Object";
            }
            SourceTypeReference parameterType = factory.createType(typeName);
            String suggestedName = suggestedNames != null && i < suggestedNames.length ? suggestedNames[i] : null;
            String parameterName = JavaHelper.getParameterName(suggestedName, parameterTypeNames[i], usedNames);
            parameters[i] = factory.createLocalVariable(parameterType, parameterName);
        }
        SourceBlock block = !type.isInterface() ? factory.createBlock() : null;
        SourceMethod method = factory.createMethod(returnType, methodName, factory.createFormalParameterList(parameters), null, block);
        type.getSourceMethods().add(method);
        if (!type.isInterface()) {
            method.setModifiers(1);
        }
        return method;
    }

    public static Collection<JavaMethod> getUnimplementedMethods(SourceClass type) {
        LinkedHashMap<String, ArrayList<JavaMethod>> implementations = new LinkedHashMap<String, ArrayList<JavaMethod>>();
        LinkedHashMap<String, ArrayList<JavaMethod>> abstractMethods = new LinkedHashMap<String, ArrayList<JavaMethod>>();
        Collection erasedMethods = CommonUtilities.getMethods((JavaType)type);
        HashMap<JavaMethod, JavaMethod> originalMethods = new HashMap<JavaMethod, JavaMethod>(erasedMethods.size());
        boolean foundJavaLangObject = false;
        for (JavaMethod method : erasedMethods) {
            JavaClass abstractOwner;
            if (method.isPrivate() || method.isStatic()) continue;
            JavaMethod originalMethod = method;
            method = method.getMethodErasure();
            originalMethods.put(method, originalMethod);
            String methodName = method.getName();
            ArrayList<JavaMethod> signatureImplementations = (ArrayList<JavaMethod>)implementations.get(methodName);
            ArrayList<JavaMethod> signatureAbstractMethods = (ArrayList<JavaMethod>)abstractMethods.get(methodName);
            List<JavaMethod> equivalentImplementations = JavaHelper.findEquivalentMethods(method, (List<JavaMethod>)signatureImplementations);
            List<JavaMethod> equivalentAbstractMethods = JavaHelper.findEquivalentMethods(method, (List<JavaMethod>)signatureAbstractMethods);
            if (!method.isAbstract()) {
                JavaClass owner;
                if (!foundJavaLangObject && (owner = method.getOwningClass()) != null && owner.getRawName().equals("java.lang.Object")) {
                    foundJavaLangObject = true;
                }
                boolean addMethod = true;
                if ((method.getModifiers() & 0x200) != 0) {
                    for (JavaMethod abstractMethod : equivalentAbstractMethods) {
                        abstractOwner = abstractMethod.getOwningClass();
                        if (abstractOwner == null || abstractMethod.isSynthetic() && abstractOwner.isInterface() && !abstractOwner.isAnnotation()) continue;
                        addMethod = false;
                    }
                }
                if (addMethod) {
                    if (signatureImplementations == null) {
                        signatureImplementations = new ArrayList<JavaMethod>();
                        implementations.put(methodName, signatureImplementations);
                    }
                    signatureImplementations.add(method);
                    equivalentImplementations.add(method);
                }
            } else {
                Iterator<JavaMethod> iter = equivalentImplementations.iterator();
                while (iter.hasNext()) {
                    JavaClass implOwner;
                    JavaMethod implementation = iter.next();
                    if ((implementation.getModifiers() & 0x200) == 0 || (implOwner = implementation.getOwningClass()).isSubtypeOf((JavaType)(abstractOwner = method.getOwningClass()))) continue;
                    signatureImplementations.remove(implementation);
                    if (signatureImplementations.isEmpty()) {
                        implementations.remove(methodName);
                    }
                    iter.remove();
                }
                boolean storeIt = true;
                for (JavaMethod abstractMethod : equivalentAbstractMethods) {
                    storeIt = false;
                    if (!JavaHelper.methodHasWeakerAccess(method, abstractMethod)) continue;
                    storeIt = true;
                    signatureAbstractMethods.remove(abstractMethod);
                    break;
                }
                if (storeIt) {
                    if (signatureAbstractMethods == null) {
                        signatureAbstractMethods = new ArrayList<JavaMethod>();
                        abstractMethods.put(methodName, signatureAbstractMethods);
                    }
                    signatureAbstractMethods.add(method);
                    equivalentAbstractMethods.add(method);
                }
            }
            for (JavaMethod abstractMethod : equivalentAbstractMethods) {
                for (JavaMethod implementation : equivalentImplementations) {
                    if (JavaHelper.methodHasWeakerAccess(abstractMethod, implementation)) continue;
                    JavaClass abstractOwner2 = abstractMethod.getOwningClass();
                    JavaClass implOwner = implementation.getOwningClass();
                    if (!abstractOwner2.isInterface() && abstractOwner2.isSubtypeOf((JavaType)implOwner)) continue;
                    signatureAbstractMethods.remove(abstractMethod);
                    if (!signatureAbstractMethods.isEmpty()) continue;
                    abstractMethods.remove(methodName);
                }
            }
        }
        if (!foundJavaLangObject) {
            return Collections.emptyList();
        }
        ArrayList<JavaMethod> unimplementedMethods = new ArrayList<JavaMethod>();
        for (List methods : abstractMethods.values()) {
            for (JavaMethod method : methods) {
                JavaMethod originalMethod = (JavaMethod)originalMethods.get(method);
                unimplementedMethods.add(originalMethod);
            }
        }
        return unimplementedMethods;
    }

    private static List<JavaMethod> findEquivalentMethods(JavaMethod method, List<JavaMethod> list) {
        ArrayList<JavaMethod> results = new ArrayList<JavaMethod>();
        if (list == null) {
            return results;
        }
        block0: for (JavaMethod otherMethod : list) {
            JavaType[] otherParamTypes;
            JavaType[] paramTypes = method.getParameterTypes();
            if (paramTypes.length != (otherParamTypes = otherMethod.getParameterTypes()).length) continue;
            for (int x = 0; x < paramTypes.length; ++x) {
                JavaType paramType = paramTypes[x];
                JavaType otherParamType = otherParamTypes[x];
                if (paramType == null || otherParamType == null) continue;
                paramType = paramType.getNonParameterizedType();
                otherParamType = otherParamType.getNonParameterizedType();
                if (paramType.getElementKind() == 10 || paramType.isArray() && paramType.getBaseComponentType().getElementKind() == 10 || otherParamType.getElementKind() == 10 || otherParamType.isArray() && otherParamType.getBaseComponentType().getElementKind() == 10) continue;
                if (paramType.isArray() != otherParamType.isArray() || paramType.getArrayDimensions() != otherParamType.getArrayDimensions()) continue block0;
                if (paramType.isArray()) {
                    paramType = paramType.getBaseComponentType();
                    otherParamType = otherParamType.getBaseComponentType();
                }
                if (!paramType.equals(otherParamType)) continue block0;
            }
            results.add(otherMethod);
        }
        return results;
    }

    public static Collection<JavaMethod> getOverrideEligibleMethods(JavaClass type) {
        HashSet<String> signatures = new HashSet<String>();
        LinkedHashMap<String, JavaMethod> methods = new LinkedHashMap<String, JavaMethod>();
        if (type == null) {
            return methods.values();
        }
        TreeSet<JavaMethod> typeMethods = new TreeSet<JavaMethod>(new ClosestMethodFirstComparator());
        typeMethods.addAll(type.getMethods());
        if (type.isInterface()) {
            JavaHelper.removeNonPublicObjectMethods(typeMethods);
        }
        for (JavaMethod method : typeMethods) {
            String signature = JavaHelper.createSignature(method);
            if (signatures.add(signature)) {
                JavaClass owningClass = method.getOwningClass();
                if (type.equals(owningClass) || method.isFinal() || method.isPrivate() || method.isStatic() || method.isPackagePrivate() && !type.getPackageName().equals(owningClass.getPackageName())) continue;
                methods.put(signature, method);
                continue;
            }
            JavaMethod otherMethod = (JavaMethod)methods.get(signature);
            if (otherMethod == null || !otherMethod.isAbstract() || method.isAbstract()) continue;
            methods.put(signature, method);
        }
        return methods.values();
    }

    private static String createSignature(JavaMethod method) {
        String signature;
        if (method == null) {
            return "";
        }
        String name = method.getName();
        Collection parameters = method.getParameters();
        if (parameters.isEmpty()) {
            signature = name;
        } else {
            StringBuilder buffer = new StringBuilder(name);
            for (JavaVariable parameter : parameters) {
                buffer.append(',');
                JavaType parameterType = parameter.getResolvedType();
                if (parameterType != null) {
                    JavaClass erasure = parameterType.getTypeErasure();
                    String erasureName = erasure.getQualifiedName();
                    buffer.append(erasureName);
                    continue;
                }
                buffer.append(parameter.getUnresolvedType().getSimplifiedName());
            }
            signature = buffer.toString();
        }
        return signature;
    }

    private static boolean methodHasWeakerAccess(JavaMethod method1, JavaMethod method2) {
        boolean inInterface;
        JavaClass owningClass = method1.getOwningClass();
        boolean bl = inInterface = owningClass != null && owningClass.isInterface();
        if (method1.isPublic() || inInterface) {
            return !method2.isPublic();
        }
        if (method1.isProtected()) {
            return method2.isPackagePrivate() || method2.isPrivate();
        }
        if (method1.isPackagePrivate()) {
            return method2.isPrivate();
        }
        return false;
    }

    public static String getParameterName(String suggestedName, JavaHasType hasType, Set<String> usedNames) {
        JavaType type = hasType.getResolvedType();
        String typeName = type != null ? type.getName() : hasType.getUnresolvedType().getSimplifiedName();
        return JavaHelper.getParameterName(suggestedName, typeName, usedNames);
    }

    public static String getParameterName(String suggestedName, String typeName, Set<String> usedNames) {
        if (suggestedName == null || suggestedName.isEmpty()) {
            int length;
            typeName = JavaHelper.lastToken(typeName, '.');
            boolean plural = typeName.endsWith("]");
            for (length = 0; length < typeName.length() && Character.isJavaIdentifierPart(typeName.charAt(length)); ++length) {
            }
            suggestedName = "boolean".equals(typeName = typeName.substring(0, length)) || "byte".equals(typeName) || "short".equals(typeName) || "char".equals(typeName) || "short".equals(typeName) || "int".equals(typeName) || "long".equals(typeName) || "float".equals(typeName) || "double".equals(typeName) ? typeName.substring(0, 1) : JavaHelper.decapitalize(typeName);
            if (plural && Locale.getDefault().getLanguage().equals(Locale.ENGLISH.getLanguage()) && !suggestedName.endsWith("s")) {
                suggestedName = suggestedName + 's';
            }
        }
        CodingStyleManager manager = CodingStyleManager.getCodingStyleManager();
        CodingStyleOptions style = manager.getCodingStyleOptions();
        String name = suggestedName;
        int suffix = 0;
        while (usedNames.contains(name = style.getParameterName(name)) || IdeUtil.isJavaReservedWord((String)name)) {
            name = suggestedName + ++suffix;
        }
        usedNames.add(name);
        return name;
    }

    public static String getParameterName(JavaVariable variable, Set<String> usedNames) {
        SourceVariable sourceVariable = (SourceVariable)variable.getSourceElement();
        String parameterName = sourceVariable != null ? sourceVariable.getName() : null;
        return JavaHelper.getParameterName(parameterName, (JavaHasType)variable, usedNames);
    }

    public static SourceExpression getDefaultInitializer(SourceFactory factory, JavaType type) {
        if (type.isArray() && type.getBaseComponentType().getElementKind() == 10) {
            return factory.createExpression("null");
        }
        return JavaHelper.getDefaultInitializer(factory, type.getTypeErasure().getQualifiedName());
    }

    public static SourceExpression getDefaultInitializer(SourceFactory factory, String type) {
        String text;
        int bracket = type.lastIndexOf(91);
        if (bracket > 0) {
            text = "new " + JavaHelper.arrayName(type);
        } else if (type.equals("boolean")) {
            text = "false";
        } else if (type.equals("byte")) {
            text = "0";
        } else if (type.equals("char")) {
            text = "0";
        } else if (type.equals("short")) {
            text = "0";
        } else if (type.equals("int")) {
            text = "0";
        } else if (type.equals("long")) {
            text = "0L";
        } else if (type.equals("float")) {
            text = "0.0f";
        } else if (type.equals("double")) {
            text = "0.0";
        } else if ("java.util.List".equals(type)) {
            switch (factory.getSourceFile().getJdkVersion()) {
                case JDK_1_3: 
                case JDK_1_4: {
                    text = "java.util.Collections.EMPTY_LIST";
                    break;
                }
                default: {
                    text = "java.util.Collections.emptyList()";
                    break;
                }
            }
        } else if ("java.util.Set".equals(type) || "java.util.Collection".equals(type)) {
            switch (factory.getSourceFile().getJdkVersion()) {
                case JDK_1_3: 
                case JDK_1_4: {
                    text = "java.util.Collections.EMPTY_SET";
                    break;
                }
                default: {
                    text = "java.util.Collections.emptySet()";
                    break;
                }
            }
        } else if ("java.util.Map".equals(type)) {
            switch (factory.getSourceFile().getJdkVersion()) {
                case JDK_1_3: 
                case JDK_1_4: {
                    text = "java.util.Collections.EMPTY_MAP";
                    break;
                }
                default: {
                    text = "java.util.Collections.emptyMap()";
                    break;
                }
            }
        } else {
            text = "null";
        }
        return factory.createExpression(text);
    }

    public static SourceExpression getDefaultInitializer(SourceFactory factory, UnresolvedType type) {
        String typeName = type.getSimplifiedName();
        String text = typeName.indexOf(91) >= 0 ? "new " + JavaHelper.arrayName(typeName) : "null";
        return factory.createExpression(text);
    }

    private static String arrayName(String type) {
        int index = type.lastIndexOf(91);
        if (index >= 0) {
            return JavaHelper.arrayName(type.substring(0, index)) + "[0]";
        }
        return type;
    }

    public static String[] getQualifiedNames(JavaType[] types) {
        if (types == null) {
            return null;
        }
        if (types.length == 0) {
            return NO_STRINGS;
        }
        String[] names = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            JavaType type = types[i];
            if (type == null) continue;
            names[i] = type.getQualifiedName();
        }
        return names;
    }

    public static String[] getQualifiedNames(Collection<JavaType> types) {
        if (types == null) {
            return null;
        }
        int size = types.size();
        if (size == 0) {
            return NO_STRINGS;
        }
        String[] names = new String[size];
        int index = 0;
        for (JavaType type : types) {
            if (type != null) {
                names[index] = type.getQualifiedName();
            }
            ++index;
        }
        return names;
    }

    public static String[] getNames(JavaType[] types) {
        if (types == null) {
            return null;
        }
        if (types.length == 0) {
            return NO_STRINGS;
        }
        String[] names = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            JavaType type = types[i];
            if (type == null) continue;
            names[i] = type.getName();
        }
        return names;
    }

    public static JavaType[] getTypes(String[] typeNames, JavaManager manager) {
        int length = typeNames.length;
        if (length == 0) {
            return JavaType.EMPTY_ARRAY;
        }
        JavaType[] types = new JavaType[length];
        for (int i = 0; i < length; ++i) {
            JavaClass type = manager.getClass(typeNames[i]);
            if (type == null) {
                return null;
            }
            types[i] = type;
        }
        return types;
    }

    public static String getSimplifiedName(JavaHasType hasType) {
        if (hasType == null) {
            return "";
        }
        JavaType type = hasType.getResolvedType();
        if (type != null) {
            if (JavaHelper.isRaw(type)) {
                return type.getTypeErasure().getName();
            }
            int dimensions = 0;
            while (type.isArray()) {
                type = type.getComponentType();
                ++dimensions;
            }
            StringBuffer buffer = new StringBuffer();
            switch (type.getElementKind()) {
                case 3: {
                    if (type.hasTypeParameters()) {
                        if (type.hasActualTypeArguments()) {
                            buffer.append(type.getName());
                            buffer.append('<');
                            Collection parameters = type.getActualTypeArguments();
                            String separator = "";
                            for (JavaType parameter : parameters) {
                                buffer.append(separator);
                                buffer.append(JavaHelper.getSimplifiedName((JavaHasType)parameter));
                                separator = ",";
                            }
                            buffer.append('>');
                            break;
                        }
                        buffer.append(type.getTypeErasure().getName());
                        break;
                    }
                    buffer.append(type.getName());
                    break;
                }
                case 11: {
                    JavaWildcardType wildcard = (JavaWildcardType)type;
                    Collection upper = wildcard.getUpperBounds();
                    Collection lower = wildcard.getLowerBounds();
                    if (!upper.isEmpty()) {
                        buffer.append("? extends ");
                        buffer.append(JavaHelper.getSimplifiedName((JavaHasType)((JavaType)upper.iterator().next())));
                        break;
                    }
                    if (!lower.isEmpty()) {
                        buffer.append("? super ");
                        buffer.append(JavaHelper.getSimplifiedName((JavaHasType)((JavaType)lower.iterator().next())));
                        break;
                    }
                    buffer.append('?');
                    break;
                }
                default: {
                    buffer.append(type.getName());
                }
            }
            while (--dimensions >= 0) {
                buffer.append("[]");
            }
            return buffer.toString();
        }
        return hasType.getUnresolvedType().getSimplifiedName();
    }

    public static boolean isRaw(JavaType type) {
        return type != null && type.hasTypeParameters() && !type.hasActualTypeArguments();
    }

    public static String getQualifiedName(JavaType type) {
        if (type == null) {
            return null;
        }
        return type.getQualifiedName();
    }

    public static SourceImport addImport(SourceFile file, String typeName) {
        return JavaHelper.addImport(file, typeName, false);
    }

    public static SourceImport addImport(SourceFile file, String typeName, boolean returnExistingImport) {
        return JavaHelper.addImport(file, typeName, returnExistingImport, false);
    }

    public static SourceImport addStaticImport(SourceFile file, String memberName, boolean returnExistingImport) {
        return JavaHelper.addImport(file, memberName, returnExistingImport, true);
    }

    private static SourceImport addImport(SourceFile file, String nameToImport, boolean returnExistingImport, boolean staticImport) {
        CodingStyleManager codingStyleManager;
        CodingStyleOptions options;
        SourceImport impor;
        if (nameToImport == null) {
            return null;
        }
        String originalNameToImport = nameToImport;
        while (nameToImport.endsWith("[]")) {
            nameToImport = nameToImport.substring(0, nameToImport.length() - 2);
        }
        if (nameToImport.equals("void")) {
            return null;
        }
        if (nameToImport.equals("int")) {
            return null;
        }
        if (nameToImport.equals("short")) {
            return null;
        }
        if (nameToImport.equals("long")) {
            return null;
        }
        if (nameToImport.equals("boolean")) {
            return null;
        }
        if (nameToImport.equals("float")) {
            return null;
        }
        if (nameToImport.equals("char")) {
            return null;
        }
        if (nameToImport.equals("byte")) {
            return null;
        }
        if (nameToImport.equals("double")) {
            return null;
        }
        if (nameToImport.equals("?")) {
            return null;
        }
        String qualifier = "";
        if (nameToImport.startsWith("?")) {
            JavaType typeArgType;
            SourceTypeArgument typeArg = file.getFactory().createTypeArgumentFromText(nameToImport);
            JavaType javaType = typeArgType = typeArg != null ? typeArg.getResolvedType() : null;
            if (typeArgType != null && typeArgType.getElementKind() == 11) {
                Collection bounds = ((JavaWildcardType)typeArgType).getLowerBounds();
                SourceImport ret = null;
                for (JavaType bound : bounds) {
                    ret = JavaHelper.addImport(file, bound.getQualifiedName(), returnExistingImport);
                }
                bounds = ((JavaWildcardType)typeArgType).getUpperBounds();
                for (JavaType bound : bounds) {
                    ret = JavaHelper.addImport(file, bound.getQualifiedName(), returnExistingImport);
                }
                return returnExistingImport ? ret : null;
            }
            assert (false) : "Not a valid import name: " + originalNameToImport;
            return null;
        }
        if (nameToImport.lastIndexOf(60) > 0) {
            SourceTypeReference actualType = file.getFactory().createType(nameToImport);
            if (actualType != null) {
                List typeArguments = actualType.getTypeArguments();
                for (SourceTypeArgument typeArgument : typeArguments) {
                    JavaType argumentType = typeArgument.getResolvedType();
                    if (argumentType == null) continue;
                    JavaHelper.addImport(file, argumentType.getQualifiedName(), returnExistingImport);
                }
                nameToImport = actualType.getName();
            } else {
                assert (false) : "Not a valid import name: " + originalNameToImport;
                return null;
            }
        }
        boolean validName = CommonUtilities.isValidImportName((String)nameToImport);
        assert (validName) : "Not a valid import name: " + originalNameToImport;
        if (!validName) {
            return null;
        }
        int dot = nameToImport.lastIndexOf(46);
        if (dot > 0 && (qualifier = nameToImport.substring(0, dot)).equals("java.lang")) {
            return null;
        }
        if (qualifier.length() == 0) {
            return null;
        }
        if (qualifier.equals(file.getPackageName())) {
            return null;
        }
        int index = 0;
        List imports = file.getSourceImports();
        ArrayList<SourceImport> narrowedTargetImports = new ArrayList<SourceImport>();
        if (!imports.isEmpty()) {
            int n = imports.size();
            for (int i = 0; i < n; ++i) {
                String imporPackageName;
                impor = (SourceImport)imports.get(i);
                String existingName = impor.getName();
                if (nameToImport.compareTo(existingName) > 0) {
                    index = i + 1;
                }
                if (existingName.endsWith(".*")) {
                    if (!(existingName = existingName.substring(0, existingName.length() - 2)).equals(qualifier)) continue;
                    return returnExistingImport ? impor : null;
                }
                if (existingName.equals(nameToImport)) {
                    return returnExistingImport ? impor : null;
                }
                int dotIndex = existingName.lastIndexOf(46);
                if (dotIndex <= 0 || !qualifier.equals(imporPackageName = existingName.substring(0, dotIndex))) continue;
                narrowedTargetImports.add(impor);
            }
        }
        CodingStyleOptions codingStyleOptions = options = (codingStyleManager = CodingStyleManager.getCodingStyleManager()) == null ? null : codingStyleManager.getCodingStyleOptions();
        if (options != null && options.getUseWideImports() && narrowedTargetImports.size() + 1 >= options.getWideImportThreshold()) {
            impor = file.getFactory().createImportDeclaration(qualifier + ".*");
            if (staticImport) {
                impor.addModifiers(8);
            }
            imports.add(index, impor);
            imports.removeAll(narrowedTargetImports);
            return impor;
        }
        impor = file.getFactory().createImportDeclaration(nameToImport);
        if (staticImport) {
            impor.addModifiers(8);
        }
        imports.add(index, impor);
        return impor;
    }

    private static void removeNonPublicObjectMethods(Collection<JavaMethod> typeMethods) {
        Iterator<JavaMethod> iTypeMethod = typeMethods.iterator();
        while (iTypeMethod.hasNext()) {
            JavaMethod typeMethod = iTypeMethod.next();
            if (typeMethod.isPublic() || !"java.lang.Object".equals(typeMethod.getOwningClass().getQualifiedName())) continue;
            iTypeMethod.remove();
        }
    }

    public static DeclarationClassification getClassification(JavaHasType declaration) {
        if (declaration == null) {
            return DeclarationClassification.NONE;
        }
        if (declaration.isSourceElement()) {
            switch (declaration.getSourceElement().getSymbolKind()) {
                case 1: {
                    return DeclarationClassification.ANNOTATION;
                }
                case 3: {
                    return DeclarationClassification.CLASS;
                }
                case 7: {
                    return DeclarationClassification.FIELD;
                }
                case 6: {
                    return DeclarationClassification.METHOD;
                }
                case 10: {
                    return DeclarationClassification.FIELD;
                }
                case 13: {
                    return DeclarationClassification.PARAMETER;
                }
                case 17: {
                    return DeclarationClassification.VARIABLE;
                }
                case 19: {
                    return DeclarationClassification.METHOD;
                }
            }
        } else {
            switch (declaration.getElementKind()) {
                case 2: {
                    return DeclarationClassification.ANNOTATION;
                }
                case 3: {
                    return DeclarationClassification.CLASS;
                }
                case 5: {
                    return DeclarationClassification.FIELD;
                }
                case 7: {
                    return DeclarationClassification.VARIABLE;
                }
                case 8: {
                    return DeclarationClassification.METHOD;
                }
            }
        }
        return DeclarationClassification.NONE;
    }

    public static JavaType[] getArgumentTypes(SourceInvokeExpression methodCall) {
        int count = methodCall.getArgumentCount();
        if (count == 0) {
            return JavaType.EMPTY_ARRAY;
        }
        JavaType[] types = new JavaType[count];
        for (int i = 0; i < types.length; ++i) {
            SourceExpression argument = methodCall.getArgumentAt(i);
            types[i] = argument.getResolvedType();
        }
        return types;
    }

    public static JavaType[] getNonsyntheticParameterTypes(JavaMethod method) {
        JavaVariable parameter;
        Collection parameters = method.getParameters();
        Iterator iterator = parameters.iterator();
        int size = parameters.size();
        if (size == 0) {
            return JavaType.EMPTY_ARRAY;
        }
        while ((parameter = (JavaVariable)iterator.next()).isSynthetic()) {
            --size;
            if (iterator.hasNext()) continue;
        }
        JavaType[] types = new JavaType[size];
        if (size > 0) {
            types[0] = parameter.getResolvedType();
        }
        for (int i = 1; i < size; ++i) {
            types[i] = ((JavaVariable)iterator.next()).getResolvedType();
        }
        return types;
    }

    public static boolean isSuperclassOf(JavaType supertype, JavaType subtype) {
        return subtype.isSubtypeOf(supertype);
    }

    public static boolean isSubclassOf(JavaType subtype, JavaType supertype) {
        return subtype.isSubtypeOf(supertype);
    }

    public static JavaType getTopLevelType(JavaMember member) {
        if (member == null) {
            return null;
        }
        JavaType type = member instanceof JavaType ? (JavaType)member : member.getOwningClass();
        JavaClass parent = type.getOwningClass();
        while (parent != null) {
            type = parent;
            parent = type.getOwningClass();
        }
        return type;
    }

    public static boolean isAccessibleFrom(JavaMember declaration, SourceElement referringElement) {
        return (JavaHelper.analyzeMemberAccess(declaration, referringElement) & 1) != 0;
    }

    public static int analyzeMemberAccess(JavaMember declaration, SourceElement referringElement) {
        boolean sameHierarchy;
        if (declaration == null || referringElement == null) {
            return 0;
        }
        JavaType declarationType = declaration instanceof JavaType ? (JavaType)declaration : declaration.getOwningClass();
        SourceClass referringType = CommonUtilities.getEnclosingType((SourceElement)referringElement);
        if (referringType == null && referringElement instanceof JavaType) {
            referringType = (JavaType)referringElement;
        }
        JavaClass owningClass = declaration.getOwningClass();
        int declarationAccess = declaration.getModifiers();
        if (owningClass != null) {
            do {
                int owningClassAccess;
                if (!JavaHelper.hasMoreRestrictedAccess(owningClassAccess = owningClass.getModifiers(), declarationAccess)) continue;
                declarationAccess = owningClassAccess;
            } while ((owningClass = owningClass.getOwningClass()) != null);
        }
        if (referringType == null) {
            return Modifier.isPublic(declarationAccess) ? 1 : 0;
        }
        boolean sameTopLevelClass = JavaHelper.getTopLevelType((JavaMember)referringType).equals(JavaHelper.getTopLevelType(declaration));
        boolean samePackage = referringType.getPackage().equals(declarationType.getPackage());
        block1: while (true) {
            owningClass = declarationType;
            while (!(sameHierarchy = JavaHelper.isSuperclassOf((JavaType)owningClass, (JavaType)referringType))) {
                if ((owningClass = owningClass.getOwningClass()) != null) continue;
                if ((referringType = referringType.getOwningClass()) != null) continue block1;
            }
            break;
        }
        boolean accessible = Modifier.isPublic(declarationAccess) | sameTopLevelClass | (samePackage && !Modifier.isPrivate(declarationAccess)) | (sameHierarchy && Modifier.isProtected(declarationAccess));
        int bits = 0;
        if (accessible) {
            bits |= 1;
        }
        if (sameHierarchy) {
            bits |= 8;
        }
        if (samePackage) {
            bits |= 4;
        }
        if (sameTopLevelClass) {
            bits |= 2;
        }
        return bits;
    }

    public static JavaType getInvocationTargetType(SourceInvokeExpression methodCall) {
        JavaType res;
        if (methodCall instanceof SourceNewClassExpression) {
            return CommonUtilities.getInitialTypeContaining((SourceNewClassExpression)((SourceNewClassExpression)methodCall));
        }
        if (methodCall instanceof SourceMethodCallExpression && ((res = CommonUtilities.getInitialTypeContaining((SourceMethodCallExpression)((SourceMethodCallExpression)methodCall))) != null || methodCall.getLhsOperand() != null)) {
            return res;
        }
        return CommonUtilities.getEnclosingType((SourceElement)methodCall);
    }

    public static boolean isSerializableType(JavaType type, JavaManager manager) {
        JavaClass JAVA_IO_SERIALIZABLE = manager.getClass("java.io.Serializable");
        JavaClass JAVA_UTIL_COLLECTION = manager.getClass("java.util.Collection");
        JavaClass JAVA_UTIL_MAP = manager.getClass("java.util.Map");
        if (JAVA_IO_SERIALIZABLE == null || JAVA_UTIL_COLLECTION == null || JAVA_UTIL_MAP == null) {
            return false;
        }
        if (type != null && !type.isPrimitive()) {
            if (JAVA_IO_SERIALIZABLE.isAssignableFrom(type)) {
                if (type.isArray() || JAVA_UTIL_COLLECTION.isAssignableFrom(type) || JAVA_UTIL_MAP.isAssignableFrom(type)) {
                    return JavaHelper.isComponentSerializable(type, manager);
                }
                return true;
            }
            if (JAVA_UTIL_COLLECTION.isAssignableFrom(type) || JAVA_UTIL_MAP.isAssignableFrom(type)) {
                if (!type.isAbstract() && !type.isInterface()) {
                    return false;
                }
                return JavaHelper.isComponentSerializable(type, manager);
            }
        } else {
            return true;
        }
        return false;
    }

    private static boolean isComponentSerializable(JavaType fieldType, JavaManager manager) {
        ArrayList<JavaType> componentTypes = null;
        if (fieldType.isArray()) {
            JavaType baseComponentType = fieldType.getBaseComponentType();
            if (baseComponentType != null) {
                componentTypes = new ArrayList<JavaType>();
                componentTypes.add(baseComponentType);
            }
        } else {
            componentTypes = fieldType.getActualTypeArguments();
        }
        if (componentTypes != null && !componentTypes.isEmpty()) {
            JavaType type;
            boolean isSerializable = true;
            Iterator iterator = componentTypes.iterator();
            while (iterator.hasNext() && (isSerializable = JavaHelper.isSerializableType(type = (JavaType)iterator.next(), manager))) {
            }
            return isSerializable;
        }
        return true;
    }

    public static boolean isStatic(SourceMethodCallExpression invocation, SourceMember enclosingMember) {
        JavaHasType lhs = invocation.getResolvedLhs();
        if (lhs != null) {
            return lhs instanceof JavaType;
        }
        return enclosingMember == null || enclosingMember.isStatic();
    }

    public static String lastToken(String string, char delimiter) {
        return string.substring(string.lastIndexOf(delimiter) + 1);
    }

    public static String decapitalize(String string) {
        int i;
        int count = string.length();
        StringBuffer buffer = new StringBuffer(string);
        for (i = 0; i < count && Character.isUpperCase(string.charAt(i)); ++i) {
        }
        if (i <= 1 || i < count) {
            // empty if block
        }
        while (true) {
            int n = --i;
            --i;
            if (n <= 0) break;
            buffer.setCharAt(i, Character.toLowerCase(buffer.charAt(i)));
        }
        return buffer.toString();
    }

    private static boolean hasMoreRestrictedAccess(int modifier1, int modifier2) {
        int access1 = Modifier.isPrivate(modifier1) ? 1 : (Modifier.isProtected(modifier1) ? 3 : (Modifier.isPublic(modifier1) ? 4 : 2));
        int access2 = Modifier.isPrivate(modifier2) ? 1 : (Modifier.isProtected(modifier2) ? 3 : (Modifier.isPublic(modifier2) ? 4 : 2));
        return access1 < access2;
    }

    public static enum DeclarationClassification {
        NONE,
        ANNOTATION,
        CLASS,
        METHOD,
        FIELD,
        PARAMETER,
        VARIABLE;

    }

    private static class ClosestMethodFirstComparator
    implements Comparator<JavaMethod> {
        private ClosestMethodFirstComparator() {
        }

        @Override
        public int compare(JavaMethod o1, JavaMethod o2) {
            JavaClass cls2;
            JavaClass cls1 = o1.getOwningClass();
            if (cls1 == (cls2 = o2.getOwningClass())) {
                return JavaHelper.createSignature(o1).compareTo(JavaHelper.createSignature(o2));
            }
            boolean truth1 = cls1.isAssignableFrom((JavaType)cls2);
            boolean truth2 = cls2.isAssignableFrom((JavaType)cls1);
            if (truth1 && !truth2) {
                return 1;
            }
            if (truth2 && !truth1) {
                return -1;
            }
            return JavaHelper.createSignature(o1).compareTo(JavaHelper.createSignature(o2));
        }
    }
}

