/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compiler;

class CompilerOption {
    private String compilerName;
    private String category;
    private boolean turnedOn;
    private String name;
    private String argument;
    private String description;
    private boolean isPath;

    CompilerOption(String compilerName, String category, boolean turnedOn, String name, String argument, String description, boolean isPath) {
        this.setCompilerName(compilerName);
        this.setCategory(category);
        this.setTurnedOn(turnedOn);
        this.setName(name);
        this.setArgument(argument);
        this.setDescription(description);
        this.isPath = isPath;
    }

    static CompilerOption createCompilerOption(CompilerOption defaultOption, String qualifiedOptionName, String optionValue) {
        int index = qualifiedOptionName.indexOf(46);
        if (index > 0) {
            boolean turnedOn;
            String compilerName = qualifiedOptionName.substring(0, index);
            String optionName = qualifiedOptionName.substring(index + 1);
            String optionArgument = defaultOption.getArgument();
            if (optionValue.startsWith("true")) {
                turnedOn = true;
                if (optionValue.length() > 4) {
                    optionArgument = optionValue.substring(4);
                }
            } else if (optionValue.startsWith("false")) {
                turnedOn = false;
                if (optionValue.length() > 5) {
                    optionArgument = optionValue.substring(5);
                }
            } else {
                return defaultOption;
            }
            return new CompilerOption(compilerName, defaultOption.getCategory(), turnedOn, optionName, optionArgument, defaultOption.getDescription(), defaultOption.isPath);
        }
        return defaultOption;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof CompilerOption) {
            CompilerOption otherOption = (CompilerOption)other;
            return otherOption.getCompilerName().equalsIgnoreCase(this.getCompilerName()) && otherOption.getCategory().equalsIgnoreCase(this.getCategory()) && otherOption.isTurnedOn() == this.isTurnedOn() && otherOption.getName().equalsIgnoreCase(this.getName()) && this.argumentsEqual(otherOption) && otherOption.getDescription().equalsIgnoreCase(this.getDescription()) && otherOption.isPath() == this.isPath();
        }
        return false;
    }

    private boolean argumentsEqual(CompilerOption otherOption) {
        if (this.getArgument() == null && otherOption.getArgument() == null) {
            return true;
        }
        if (this.getArgument() == null || otherOption.getArgument() == null) {
            return false;
        }
        return this.getArgument().equalsIgnoreCase(otherOption.getArgument());
    }

    public int hashCode() {
        int hash = this.getCompilerName().hashCode() + this.getCategory().hashCode() + this.getName().hashCode() + this.getDescription().hashCode();
        hash = this.isTurnedOn() ? (hash += 37) : (hash += 47);
        return hash;
    }

    String getCompilerName() {
        return this.compilerName;
    }

    void setCompilerName(String compilerName) {
        this.compilerName = compilerName;
    }

    String getCategory() {
        return this.category;
    }

    void setCategory(String category) {
        this.category = category;
    }

    boolean isTurnedOn() {
        return this.turnedOn;
    }

    void setTurnedOn(boolean value) {
        this.turnedOn = value;
    }

    String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    String getArgument() {
        return this.argument;
    }

    void setArgument(String argument) {
        this.argument = argument;
    }

    String getDescription() {
        return this.description;
    }

    void setDescription(String description) {
        this.description = description;
    }

    String getQualifiedName() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getCompilerName());
        buf.append('.');
        buf.append(this.getName());
        return buf.toString();
    }

    boolean isPath() {
        return this.isPath;
    }
}

