/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.uieditor;

import java.awt.Component;
import java.util.EventObject;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Element;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;
import oracle.jdeveloper.cmt.CmtModel;
import oracle.jdeveloper.uieditor.UIEditor;
import oracle.jdeveloper.uieditor.UIEditorCanvas;

public abstract class AbstractCanvas
extends UIEditorCanvas
implements ViewSelectionListener,
ContextMenuListener {
    public static final int X_MARGIN = 10;
    public static final int Y_MARGIN = 10;
    public static JMenuItem SERIALIZE_ITEM;
    protected static IdeAction SERIALIZE_ACTION;
    protected UIEditor editor;
    protected CmtModel model;

    protected AbstractCanvas() {
    }

    @Override
    public final UIEditor getUIEditor() {
        return this.editor;
    }

    public Controller getController() {
        return null;
    }

    public Context getContext(EventObject e) {
        return this.editor != null ? this.editor.getContext(e) : null;
    }

    public void setContext(Context context) {
        super.setContext(context);
        View view = context.getView();
        if (view instanceof UIEditor) {
            this.editor = (UIEditor)view;
        }
    }

    public void setOwner(View owner) {
        ContextMenu cMenu;
        View view = this.owner();
        if (view != null && (cMenu = view.getContextMenu()) != null) {
            cMenu.removeContextMenuListener((ContextMenuListener)this);
        }
        super.setOwner(owner);
    }

    protected Element[] getSelectionFromUI() {
        return this.editor != null ? this.editor.getSelection() : ViewSelectionEvent.EMPTY_SELECTION;
    }

    @Override
    public CmtModel getModel() {
        return this.model;
    }

    @Override
    public void setModel(CmtModel model) {
        this.model = model;
    }

    @Override
    public Component getDefaultFocusComponent() {
        return this.getGUI();
    }

    public void viewSelectionChanged(ViewSelectionEvent e) {
        this.updateSelection();
    }

    public void stateChanged(int state) {
        View view = this.owner();
        ContextMenu cMenu = view != null ? view.getContextMenu() : null;
        switch (state) {
            case 1: {
                if (this.editor != null) {
                    this.editor.removeViewSelectionListener(this);
                }
                if (cMenu == null) break;
                cMenu.removeContextMenuListener((ContextMenuListener)this);
                break;
            }
            case 2: {
                if (this.editor != null) {
                    this.editor.removeViewSelectionListener(this);
                    this.editor = null;
                }
                if (cMenu == null) break;
                cMenu.removeContextMenuListener((ContextMenuListener)this);
                break;
            }
            case 0: {
                if (this.editor != null) {
                    this.editor.addViewSelectionListener(this);
                }
                if (cMenu == null) break;
                cMenu.addContextMenuListener((ContextMenuListener)this);
                break;
            }
        }
    }

    public void close() {
        ContextMenu cMenu;
        View view = this.owner();
        ContextMenu contextMenu = cMenu = view != null ? view.getContextMenu() : null;
        if (this.editor != null) {
            this.editor.removeViewSelectionListener(this);
        }
        if (cMenu != null) {
            cMenu.removeContextMenuListener((ContextMenuListener)this);
        }
        super.close();
    }

    public void menuWillShow(ContextMenu cMenu) {
    }

    public void menuWillHide(ContextMenu cMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }
}

