/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.io.File;
import java.net.URL;
import javax.naming.Context;
import javax.naming.InitialContext;
import oracle.ide.Addin;
import oracle.ide.Ide;
import oracle.ide.cmd.AddContentCommand;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.model.Dependable;
import oracle.ide.model.Element;
import oracle.ide.model.HSAdapterDelegateMediator;
import oracle.ide.model.HashStructureNode;
import oracle.ide.model.ImageNode;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectMigrator;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.jndi.Names;
import oracle.jdeveloper.cmd.NewEmptyProjectCommand;
import oracle.jdeveloper.library.ProjectLibrary;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.model.Jpr10120to101301;
import oracle.jdeveloper.model.LibraryObserver;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.model.TechnologySpecificSupportProvider;

final class JavaEditionAddin
implements Addin {
    private static final String PROJECT_XML_ROOT_ELEMENT_NAME = "project";
    private static final String WORKSPACE_XML_ROOT_ELEMENT_NAME = "workspace";

    JavaEditionAddin() {
    }

    public void initialize() {
        this.registerProjectChangeListeners();
        this.registerJavaContentSet();
        this.registerRecognizerExtensions();
        this.registerNodeMigrators();
        PathsConfiguration.addSupportProvider((TechnologySpecificSupportProvider)new JavaCoreSupportProvider());
    }

    private void registerProjectChangeListeners() {
        Jpr10120to101301.init();
        LibraryObserver.init();
        JavaProject.init();
    }

    private void registerJavaContentSet() {
        AddContentCommand.registerPreferredContentSet(JavaSourceNode.class, (String)PathsConfiguration.JAVA_CONTENT_SET_KEY);
        NewEmptyProjectCommand.registerProjectInitializer(new NewEmptyProjectCommand.ProjectInitializer(){

            @Override
            public void initializeProject(Project newProject, Workspace workspace) {
                JavaProject javaProject = JavaProject.getInstance(newProject);
                HSAdapterDelegateMediator MEDIATOR = HSAdapterDelegateMediator.getMediator();
                if (!javaProject.containsKey(JavaProject.OUTPUT_DIRECTORY) && !MEDIATOR.needsDelegation((HashStructureNode)newProject, newProject.getProperties())) {
                    URL projectDir = URLFileSystem.getParent((URL)newProject.getURL());
                    URL outputDir = URLFactory.newDirURL((URL)projectDir, (String)"classes");
                    javaProject.setOutputDirectory(outputDir);
                }
            }
        });
    }

    private void registerRecognizerExtensions() {
        ImageNode.init();
        Object2Dom.registerNamespaceElem(Project.class, (String)XMLUtil.toNamespaceURI((String)"jproject"), (String)PROJECT_XML_ROOT_ELEMENT_NAME);
        String jprojectClass = "oracle.jdeveloper.model.JProject";
        String ideHomeDir = Ide.getProductHomeDirectory();
        Object2Dom.registerTransform((String)"oracle.jdeveloper.model.JProject", null, (String)PROJECT_XML_ROOT_ELEMENT_NAME, (URL)URLFactory.newFileURL((File)new File(ideHomeDir, "bin/jpr-902beta-to-902rc.xsl")));
        Object2Dom.registerTransform((String)"oracle.jdeveloper.model.JProject", (String)"http://xmlns.oracle.com/jdeveloper/902rc/jproject", (String)PROJECT_XML_ROOT_ELEMENT_NAME, (URL)URLFactory.newFileURL((File)new File(ideHomeDir, "bin/jpr-902rc-to-902.xsl")));
        Object2Dom.registerTransform((String)"oracle.jdeveloper.model.JProject", (String)"http://xmlns.oracle.com/jdeveloper/902/jproject", (String)PROJECT_XML_ROOT_ELEMENT_NAME, (URL)URLFactory.newFileURL((File)new File(ideHomeDir, "bin/jpr-902-to-903preview.xsl")));
        Object2Dom.registerTransform((String)"oracle.jdeveloper.model.JProject", (String)"http://xmlns.oracle.com/jdeveloper/903preview/jproject", (String)PROJECT_XML_ROOT_ELEMENT_NAME, (URL)URLFactory.newFileURL((File)new File(ideHomeDir, "bin/jpr-903preview-to-903.xsl")));
        Object2Dom.registerTransform((String)"oracle.jdeveloper.model.JProject", (String)"http://xmlns.oracle.com/jdeveloper/903/jproject", (String)PROJECT_XML_ROOT_ELEMENT_NAME, (URL)URLFactory.newFileURL((File)new File(ideHomeDir, "bin/jpr-903-to-904.xsl")));
        Object2Dom.registerTransform((String)"oracle.jdeveloper.model.JProject", (String)"http://xmlns.oracle.com/jdeveloper/904/jproject", (String)PROJECT_XML_ROOT_ELEMENT_NAME, (URL)URLFactory.newFileURL((File)new File(ideHomeDir, "bin/jpr-904-to-905.xsl")));
        Object2Dom.registerTransform((String)"oracle.jdeveloper.model.JProject", (String)"http://xmlns.oracle.com/jdeveloper/905/jproject", (String)PROJECT_XML_ROOT_ELEMENT_NAME, (URL)URLFactory.newFileURL((File)new File(ideHomeDir, "bin/jpr-905-to-9051.xsl")));
        Object2Dom.registerTransform((String)"oracle.jdeveloper.model.JProject", (String)"http://xmlns.oracle.com/jdeveloper/9051/jproject", (String)PROJECT_XML_ROOT_ELEMENT_NAME, (URL)URLFactory.newFileURL((File)new File(ideHomeDir, "bin/jpr-9051-to-10120.xsl")));
        Object2Dom.registerTransform((String)"oracle.jdeveloper.model.JProject", (String)"http://xmlns.oracle.com/jdeveloper/10120/jproject", (String)PROJECT_XML_ROOT_ELEMENT_NAME, (URL)URLFactory.newFileURL((File)new File(ideHomeDir, "bin/jpr-10120-to-10130.xsl")));
        String workspaceClass = Workspace.class.getName();
        URL initialJwsXslt = URLFactory.newFileURL((File)new File(ideHomeDir, "bin/jws-10120-to-10130.xsl"));
        Object2Dom.registerTransform((String)workspaceClass, null, (String)WORKSPACE_XML_ROOT_ELEMENT_NAME, (URL)initialJwsXslt);
        Object2Dom.registerTransform((String)workspaceClass, (String)"http://xmlns.oracle.com/jdeveloper/902rc/workspace", (String)WORKSPACE_XML_ROOT_ELEMENT_NAME, (URL)initialJwsXslt);
        Object2Dom.registerTransform((String)workspaceClass, (String)"http://xmlns.oracle.com/jdeveloper/902/workspace", (String)WORKSPACE_XML_ROOT_ELEMENT_NAME, (URL)initialJwsXslt);
        Object2Dom.registerTransform((String)workspaceClass, (String)"http://xmlns.oracle.com/jdeveloper/903preview/workspace", (String)WORKSPACE_XML_ROOT_ELEMENT_NAME, (URL)initialJwsXslt);
        Object2Dom.registerTransform((String)workspaceClass, (String)"http://xmlns.oracle.com/jdeveloper/903/workspace", (String)WORKSPACE_XML_ROOT_ELEMENT_NAME, (URL)initialJwsXslt);
        Object2Dom.registerTransform((String)workspaceClass, (String)"http://xmlns.oracle.com/jdeveloper/904/workspace", (String)WORKSPACE_XML_ROOT_ELEMENT_NAME, (URL)initialJwsXslt);
        Object2Dom.registerTransform((String)workspaceClass, (String)"http://xmlns.oracle.com/jdeveloper/905/workspace", (String)WORKSPACE_XML_ROOT_ELEMENT_NAME, (URL)initialJwsXslt);
        Object2Dom.registerTransform((String)workspaceClass, (String)"http://xmlns.oracle.com/jdeveloper/9051/workspace", (String)WORKSPACE_XML_ROOT_ELEMENT_NAME, (URL)initialJwsXslt);
        Object2Dom.registerTransform((String)workspaceClass, (String)"http://xmlns.oracle.com/jdeveloper/10120/workspace", (String)WORKSPACE_XML_ROOT_ELEMENT_NAME, (URL)initialJwsXslt);
    }

    private void registerNodeMigrators() {
        InitialContext ic = Names.newInitialContext();
        ProjectMigrator projectMigrator = (ProjectMigrator)Names.lookup((Context)ic, (String)ProjectMigrator.MIGRATOR_NAME);
        Names.bind((Context)ic, (String)"oracle.jdeveloper.model.JProject", (Object)projectMigrator);
    }

    private class JavaCoreSupportProvider
    implements TechnologySpecificSupportProvider {
        private JavaCoreSupportProvider() {
        }

        public URL getParentUrlIfEqual(Element selElement, String packageName) {
            if (selElement instanceof JavaSourceNode) {
                JavaSourceNode javaNode = (JavaSourceNode)selElement;
                String selPackage = javaNode.getPackage();
                if ((selPackage = selPackage.replace('.', '/')).equals(packageName)) {
                    return URLFileSystem.getParent((URL)javaNode.getURL());
                }
            }
            return null;
        }

        public URLPath getClassPathIfProjectLibrary(Dependable dep, boolean onlyDeployLibs) {
            if (dep instanceof ProjectLibrary) {
                return ((ProjectLibrary)dep).getClassPath(onlyDeployLibs);
            }
            return null;
        }

        public URL getProjectOutputDirectory(Project project) {
            return JavaProject.getInstance(project).getOutputDirectory();
        }
    }
}

