/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.util;

import java.util.List;
import oracle.ide.model.TextNode;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceHasName;

class SourceElementPath {
    private int _index;
    private int _offset;
    private final int _symbolKind;
    private String _name;
    private final SourceElementPath _child;

    private SourceElementPath(int index, int offset, int symbolKind, String name, SourceElementPath child) {
        this._index = index;
        this._offset = offset;
        this._symbolKind = symbolKind;
        this._name = name;
        this._child = child;
    }

    static SourceElementPath createElement(SourceElement sourceElement) {
        return SourceElementPath.createElement(sourceElement, null);
    }

    private static SourceElementPath createElement(SourceElement sourceElement, SourceElementPath childPath) {
        SourceElement parentElement = sourceElement.getParent();
        if (parentElement != null) {
            List children = parentElement.getChildren();
            int index = children.indexOf(sourceElement);
            int offset = sourceElement.getStartOffset() - parentElement.getStartOffset();
            int symbolKind = sourceElement.getSymbolKind();
            String name = null;
            if (sourceElement instanceof SourceHasName) {
                SourceHasName sourceHasName = (SourceHasName)sourceElement;
                name = sourceHasName.getName();
            }
            return SourceElementPath.createElement(parentElement, new SourceElementPath(index, offset, symbolKind, name, childPath));
        }
        return new SourceElementPath(-1, sourceElement.getStartOffset(), sourceElement.getSymbolKind(), null, childPath);
    }

    SourceElement find(final SourceFile sourceFile, TextNode node) {
        if (node == null) {
            return null;
        }
        final SourceElement[] sourceElement = new SourceElement[]{null};
        node.runUnderReadLock(new Runnable(){

            @Override
            public void run() {
                if (SourceElementPath.this._index < 0) {
                    sourceElement[0] = SourceElementPath.this._child.findImpl((SourceElement)sourceFile);
                    if (sourceElement[0] != null) {
                        SourceElementPath.this._offset = 0;
                    }
                } else {
                    sourceElement[0] = SourceElementPath.this.findImpl((SourceElement)sourceFile);
                }
            }
        });
        return sourceElement[0];
    }

    private SourceElement findImpl(SourceElement sourceElement) {
        SourceElement childAtOffset;
        SourceElement ret = null;
        List children = sourceElement.getChildren();
        boolean indexIsOk = false;
        boolean offsetIsOk = false;
        SourceElement childElement = this.searchChildByIndex(children);
        if (childElement != null) {
            indexIsOk = true;
            if (sourceElement.getStartOffset() + this._offset == childElement.getStartOffset()) {
                offsetIsOk = true;
            }
        }
        if (!(indexIsOk && offsetIsOk || (childAtOffset = this.searchChildByOffset(sourceElement, children)) == null)) {
            offsetIsOk = true;
            indexIsOk = false;
            childElement = childAtOffset;
        }
        if (childElement == null && this._child != null) {
            for (int i = 0; i < children.size(); ++i) {
                SourceElement resolved;
                SourceElement child = (SourceElement)children.get(i);
                if (!this.isRightChild(child) || (resolved = this._child.findImpl(child)) == null) continue;
                childElement = child;
                ret = resolved;
                break;
            }
        }
        if (childElement != null) {
            if (ret == null) {
                ret = this._child != null ? this._child.findImpl(childElement) : childElement;
            }
            if (ret != null) {
                if (!indexIsOk) {
                    this._index = children.indexOf(childElement);
                }
                if (!offsetIsOk) {
                    this._offset = childElement.getStartOffset() - sourceElement.getStartOffset();
                }
            }
        }
        return ret;
    }

    private SourceElement searchChildByIndex(List children) {
        SourceElement childElement;
        SourceElement ret = null;
        if (this._index < children.size() && this.isRightChild(childElement = (SourceElement)children.get(this._index))) {
            ret = childElement;
        }
        return ret;
    }

    private SourceElement searchChildByOffset(SourceElement sourceElement, List children) {
        int startOffset = sourceElement.getStartOffset();
        int searchForOffset = startOffset + this._offset;
        for (int i = 0; i < children.size(); ++i) {
            SourceElement childElement = (SourceElement)children.get(i);
            int childOffset = childElement.getStartOffset();
            if (searchForOffset != childOffset) continue;
            if (this.isRightChild(childElement)) {
                return childElement;
            }
            return null;
        }
        return null;
    }

    private boolean isRightChild(SourceElement sourceElement) {
        boolean ret = false;
        if (sourceElement != null && sourceElement.getSymbolKind() == this._symbolKind) {
            if (sourceElement instanceof SourceHasName) {
                SourceHasName sourceHasName = (SourceHasName)sourceElement;
                String name = sourceHasName.getName();
                if (this._name.equals(name)) {
                    ret = true;
                }
            } else {
                ret = true;
            }
        }
        return ret;
    }

    void updateOffsets(int offset, int count) {
        if (offset <= this._offset || this._offset < 0) {
            this._offset += count;
        } else if (this._child != null) {
            this._child.updateOffsets(offset - this._offset, count);
        }
    }

    int getOffset() {
        if (this._child == null) {
            return this._offset;
        }
        return this._offset + this._child.getOffset();
    }
}

