/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import oracle.ide.file.Path;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLPath;
import oracle.javatools.util.NullArgumentException;
import oracle.jdeveloper.java.JavaModelFactory;
import oracle.jdeveloper.java.classpath.ClasspathTreeVisitOptions;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.ArrayClassLocator;
import oracle.jdeveloper.java.locator.BaseClassLocator;
import oracle.jdeveloper.java.locator.ClassLocatorFactory;
import oracle.jdeveloper.java.locator.DuplicateLocator;
import oracle.jdeveloper.java.locator.ProjectClassLocator;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.model.JavaProject;

class DependencyProjectClassLocator
extends BaseClassLocator {
    private final Project _project;
    private final BaseClassLocator _libraryLocator;
    private final BaseClassLocator _outputLocator;
    private final BaseClassLocator _moduleConfigLocator;
    private final BaseClassLocator _sourceLocator;

    static BaseClassLocator getInstance(Workspace workspace, Project project, Map<Object, BaseClassLocator> cache) {
        if (project == null) {
            throw new NullArgumentException("null project");
        }
        try {
            return DependencyProjectClassLocator.getInstanceImpl(workspace, project, cache, false);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    static BaseClassLocator getInstanceInterruptibly(Workspace workspace, Project project, Map<Object, BaseClassLocator> cache) throws InterruptedException {
        if (project == null) {
            throw new NullArgumentException("null project");
        }
        return DependencyProjectClassLocator.getInstanceImpl(workspace, project, cache, true);
    }

    private static BaseClassLocator getInstanceImpl(Workspace workspace, Project project, Map<Object, BaseClassLocator> cache, boolean checkInterrupt) throws InterruptedException {
        BaseClassLocator cached = cache.get(project);
        if (cached != null) {
            if (cached == EMPTY_LOCATOR) {
                return DuplicateLocator.getInstance(cached, true);
            }
            return cached;
        }
        cache.put(project, EMPTY_LOCATOR);
        ClassLocatorFactory factory = JavaModelFactory.getInstance().getLocatorFactory();
        if (checkInterrupt) {
            DependencyProjectClassLocator.checkInterrupt();
        }
        ArrayList<Library> classPathLibraries = new ArrayList<Library>();
        ArrayList<Library> modulePathLibraries = new ArrayList<Library>();
        ArrayList<Library> deployments = new ArrayList<Library>();
        ArrayList<Project> projects = new ArrayList<Project>();
        ProjectClassLocator.processDependencies(project, checkInterrupt, classPathLibraries, modulePathLibraries, deployments, projects);
        List<Library> exportedLibraries = ProjectClassLocator.getLibrariesFor(project, true);
        List<Library> allModulePathLibraries = ProjectClassLocator.getModulePathLibraries(project);
        ArrayList<Library> exportedClassPathLibraries = new ArrayList<Library>();
        ArrayList<Library> exportedModulePathLibraries = new ArrayList<Library>();
        for (Library exportedLibrary : exportedLibraries) {
            if (allModulePathLibraries.contains(exportedLibrary)) {
                exportedModulePathLibraries.add(exportedLibrary);
                continue;
            }
            exportedClassPathLibraries.add(exportedLibrary);
        }
        classPathLibraries.addAll(exportedClassPathLibraries);
        Object libraryLocator = ProjectClassLocator.getLibraryLocator(workspace, classPathLibraries, checkInterrupt, cache);
        modulePathLibraries.addAll(exportedModulePathLibraries);
        if (modulePathLibraries.size() > 0) {
            BaseClassLocator modulePathLibraryLocator = ProjectClassLocator.getLibraryLocator(workspace, modulePathLibraries, checkInterrupt, cache);
            modulePathLibraryLocator.setContainsModuleClasses(true);
            libraryLocator = classPathLibraries.size() > 0 ? new ArrayClassLocator(new BaseClassLocator[]{modulePathLibraryLocator, libraryLocator}) : modulePathLibraryLocator;
        }
        if (checkInterrupt) {
            DependencyProjectClassLocator.checkInterrupt();
        }
        URL outputDirectory = JavaProject.getInstance(project).getOutputDirectory();
        BaseClassLocator outputLocator = ProjectClassLocator.getClassLocator(outputDirectory, cache, factory);
        if (checkInterrupt) {
            DependencyProjectClassLocator.checkInterrupt();
        }
        URLPath moduleConfigPath = ProjectClassLocator.getModuleConfigClassPathFor(project);
        BaseClassLocator moduleConfigLocator = ProjectClassLocator.getClassLocator(moduleConfigPath, checkInterrupt, cache, factory);
        if (checkInterrupt) {
            DependencyProjectClassLocator.checkInterrupt();
        }
        Path sourcePath = ProjectClassLocator.getSourcePath(project);
        BaseClassLocator sourceLocator = ProjectClassLocator.getSourceLocator(workspace, sourcePath, checkInterrupt, cache);
        cached = new DependencyProjectClassLocator(project, (BaseClassLocator)libraryLocator, outputLocator, moduleConfigLocator, sourceLocator);
        cache.put(project, DuplicateLocator.getInstance(cached, false));
        return cached;
    }

    private DependencyProjectClassLocator(Project project, BaseClassLocator libraryLocator, BaseClassLocator outputLocator, BaseClassLocator moduleConfigLocator, BaseClassLocator sourceLocator) {
        this._project = project;
        this._moduleConfigLocator = moduleConfigLocator;
        this._libraryLocator = libraryLocator;
        this._outputLocator = outputLocator;
        this._sourceLocator = sourceLocator;
    }

    public void getPackages(String packagePrefix, Collection<String> out) {
        this._outputLocator.getPackages(packagePrefix, out);
        this._moduleConfigLocator.getPackages(packagePrefix, out);
        this._libraryLocator.getPackages(packagePrefix, out);
        this._sourceLocator.getPackages(packagePrefix, out);
    }

    public void getPackagesInterruptibly(String packagePrefix, Collection<String> out) throws InterruptedException {
        DependencyProjectClassLocator.checkInterrupt();
        this._outputLocator.getPackagesInterruptibly(packagePrefix, out);
        DependencyProjectClassLocator.checkInterrupt();
        this._moduleConfigLocator.getPackagesInterruptibly(packagePrefix, out);
        DependencyProjectClassLocator.checkInterrupt();
        this._libraryLocator.getPackagesInterruptibly(packagePrefix, out);
        DependencyProjectClassLocator.checkInterrupt();
        this._sourceLocator.getPackagesInterruptibly(packagePrefix, out);
    }

    public void getClassesInPackage(String packagePrefix, Collection<String> out) {
        this._outputLocator.getClassesInPackage(packagePrefix, out);
        this._moduleConfigLocator.getClassesInPackage(packagePrefix, out);
        this._libraryLocator.getClassesInPackage(packagePrefix, out);
        this._sourceLocator.getClassesInPackage(packagePrefix, out);
    }

    public void getClassesInPackageInterruptibly(String packagePrefix, Collection<String> out) throws InterruptedException {
        DependencyProjectClassLocator.checkInterrupt();
        this._outputLocator.getClassesInPackageInterruptibly(packagePrefix, out);
        DependencyProjectClassLocator.checkInterrupt();
        this._moduleConfigLocator.getClassesInPackageInterruptibly(packagePrefix, out);
        DependencyProjectClassLocator.checkInterrupt();
        this._libraryLocator.getClassesInPackageInterruptibly(packagePrefix, out);
        DependencyProjectClassLocator.checkInterrupt();
        this._sourceLocator.getClassesInPackageInterruptibly(packagePrefix, out);
    }

    public void getAllClasses(Collection<String> out, ClassNameFilter filter) {
        this._outputLocator.getAllClasses(out, filter);
        this._moduleConfigLocator.getAllClasses(out, filter);
        this._libraryLocator.getAllClasses(out, filter);
        this._sourceLocator.getAllClasses(out, filter);
    }

    public void getAllClassesInterruptibly(Collection<String> out, ClassNameFilter filter) throws InterruptedException {
        DependencyProjectClassLocator.checkInterrupt();
        this._outputLocator.getAllClassesInterruptibly(out, filter);
        DependencyProjectClassLocator.checkInterrupt();
        this._moduleConfigLocator.getAllClassesInterruptibly(out, filter);
        DependencyProjectClassLocator.checkInterrupt();
        this._libraryLocator.getAllClassesInterruptibly(out, filter);
        DependencyProjectClassLocator.checkInterrupt();
        this._sourceLocator.getAllClassesInterruptibly(out, filter);
    }

    public void getAllPackages(Collection<String> out, PackageNameFilter filter) {
        this._outputLocator.getAllPackages(out, filter);
        this._moduleConfigLocator.getAllPackages(out, filter);
        this._libraryLocator.getAllPackages(out, filter);
        this._sourceLocator.getAllPackages(out, filter);
    }

    public void getAllPackagesInterruptibly(Collection<String> out, PackageNameFilter filter) throws InterruptedException {
        DependencyProjectClassLocator.checkInterrupt();
        this._outputLocator.getAllPackagesInterruptibly(out, filter);
        DependencyProjectClassLocator.checkInterrupt();
        this._moduleConfigLocator.getAllPackagesInterruptibly(out, filter);
        DependencyProjectClassLocator.checkInterrupt();
        this._libraryLocator.getAllPackagesInterruptibly(out, filter);
        DependencyProjectClassLocator.checkInterrupt();
        this._sourceLocator.getAllPackagesInterruptibly(out, filter);
    }

    public void buildIndex() {
        this._outputLocator.buildIndex();
        this._moduleConfigLocator.buildIndex();
        this._libraryLocator.buildIndex();
        this._sourceLocator.buildIndex();
    }

    public void buildIndexInterruptibly() throws InterruptedException {
        DependencyProjectClassLocator.checkInterrupt();
        this._outputLocator.buildIndexInterruptibly();
        DependencyProjectClassLocator.checkInterrupt();
        this._moduleConfigLocator.buildIndexInterruptibly();
        DependencyProjectClassLocator.checkInterrupt();
        this._libraryLocator.buildIndexInterruptibly();
        DependencyProjectClassLocator.checkInterrupt();
        this._sourceLocator.buildIndexInterruptibly();
    }

    public URL getURL(String fqClassName) {
        URL classURL = this._outputLocator.getClassURL(fqClassName);
        if (classURL == null) {
            classURL = this._moduleConfigLocator.getClassURL(fqClassName);
        }
        URL sourceURL = this._sourceLocator.getSourceURL(fqClassName);
        if (classURL != null || sourceURL != null) {
            return ProjectClassLocator.chooseURL(fqClassName, classURL, sourceURL, this._sourceLocator);
        }
        if (classURL == null) {
            classURL = this._libraryLocator.getURL(fqClassName);
        }
        return classURL;
    }

    public URL getURLInterruptibly(String fqClassName) throws InterruptedException {
        DependencyProjectClassLocator.checkInterrupt();
        URL classURL = this._outputLocator.getClassURLInterruptibly(fqClassName);
        DependencyProjectClassLocator.checkInterrupt();
        if (classURL == null) {
            classURL = this._moduleConfigLocator.getClassURLInterruptibly(fqClassName);
        }
        DependencyProjectClassLocator.checkInterrupt();
        URL sourceURL = this._sourceLocator.getSourceURLInterruptibly(fqClassName);
        if (classURL != null || sourceURL != null) {
            return ProjectClassLocator.chooseURL(fqClassName, classURL, sourceURL, this._sourceLocator);
        }
        DependencyProjectClassLocator.checkInterrupt();
        if (classURL == null) {
            classURL = this._libraryLocator.getURLInterruptibly(fqClassName);
        }
        return classURL;
    }

    public URL getSourceURL(String fqClassName) {
        URL sourceURL = this._sourceLocator.getSourceURL(fqClassName);
        if (sourceURL == null) {
            sourceURL = this._libraryLocator.getSourceURL(fqClassName);
        }
        return sourceURL;
    }

    public URL getSourceURLInterruptibly(String fqClassName) throws InterruptedException {
        DependencyProjectClassLocator.checkInterrupt();
        URL sourceURL = this._sourceLocator.getSourceURLInterruptibly(fqClassName);
        DependencyProjectClassLocator.checkInterrupt();
        if (sourceURL == null) {
            sourceURL = this._libraryLocator.getSourceURLInterruptibly(fqClassName);
        }
        return sourceURL;
    }

    public URL getClassURL(String fqClassName) {
        URL classURL = this._outputLocator.getClassURL(fqClassName);
        if (classURL == null) {
            classURL = this._moduleConfigLocator.getClassURL(fqClassName);
        }
        if (classURL == null) {
            classURL = this._libraryLocator.getClassURL(fqClassName);
        }
        return classURL;
    }

    public URL getClassURLInterruptibly(String fqClassName) throws InterruptedException {
        DependencyProjectClassLocator.checkInterrupt();
        URL classURL = this._outputLocator.getClassURLInterruptibly(fqClassName);
        DependencyProjectClassLocator.checkInterrupt();
        if (classURL == null) {
            classURL = this._moduleConfigLocator.getClassURLInterruptibly(fqClassName);
        }
        DependencyProjectClassLocator.checkInterrupt();
        if (classURL == null) {
            classURL = this._libraryLocator.getClassURLInterruptibly(fqClassName);
        }
        return classURL;
    }

    public URL getResourceURL(String resourceName) {
        URL resourceURL = this._outputLocator.getResourceURL(resourceName);
        if (resourceURL == null) {
            resourceURL = this._moduleConfigLocator.getResourceURL(resourceName);
        }
        if (resourceURL == null) {
            resourceURL = this._libraryLocator.getResourceURL(resourceName);
        }
        return resourceURL;
    }

    protected Object getClasspathTreeNode() {
        return this._project;
    }

    protected Collection<BaseClassLocator> getChildLocators(EnumSet<ClasspathTreeVisitOptions> options) {
        ArrayList<BaseClassLocator> list = new ArrayList<BaseClassLocator>(Arrays.asList(this._outputLocator, this._moduleConfigLocator, this._libraryLocator));
        return list;
    }

    protected BaseClassLocator getSourceLocator(BaseClassLocator locator) {
        if (locator == this._outputLocator || locator == this._moduleConfigLocator) {
            return this._sourceLocator;
        }
        return super.getSourceLocator(locator);
    }

    public URL getProjectSourceURL(String fqClassName) {
        return this._sourceLocator.getSourceURL(fqClassName);
    }

    public URL getProjectSourceURLInterruptibly(String fqClassName) throws InterruptedException {
        DependencyProjectClassLocator.checkInterrupt();
        return this._sourceLocator.getSourceURLInterruptibly(fqClassName);
    }

    public URL getNonProjectSourceURL(String fqClassName) {
        return this._libraryLocator.getSourceURL(fqClassName);
    }

    public URL getNonProjectSourceURLInterruptibly(String fqClassName) throws InterruptedException {
        return this._libraryLocator.getSourceURLInterruptibly(fqClassName);
    }

    public String getModuleNameOfClass(String fqClassName) {
        String moduleName = this._libraryLocator.getModuleNameOfClass(fqClassName);
        if (moduleName != null) {
            return moduleName;
        }
        return this._outputLocator.getModuleNameOfClass(fqClassName);
    }

    public String getModuleNameOfClassInterruptibly(String fqClassName) throws InterruptedException {
        String moduleName = this._libraryLocator.getModuleNameOfClassInterruptibly(fqClassName);
        if (moduleName != null) {
            return moduleName;
        }
        return this._outputLocator.getModuleNameOfClassInterruptibly(fqClassName);
    }
}

