/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import oracle.ide.model.Workspace;
import oracle.javatools.util.NullArgumentException;
import oracle.jdeveloper.java.classpath.ClasspathTreeVisitOptions;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.ArrayClassLocator;
import oracle.jdeveloper.java.locator.BaseClassLocator;
import oracle.jdeveloper.java.locator.ProjectClassLocator;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.model.ApplicationLibraries;

final class ApplicationClassLocator
extends BaseClassLocator {
    private final Workspace workspace;
    private final BaseClassLocator libraryLocator;

    static BaseClassLocator getInstance(Workspace workspace, Map<Object, BaseClassLocator> cache) {
        if (cache == null) {
            throw new NullArgumentException("null cache");
        }
        try {
            return ApplicationClassLocator.getInstanceImpl(workspace, cache, false);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    static BaseClassLocator getInstanceInterruptibly(Workspace workspace, Map<Object, BaseClassLocator> cache) throws InterruptedException {
        if (cache == null) {
            throw new NullArgumentException("null cache");
        }
        return ApplicationClassLocator.getInstanceImpl(workspace, cache, true);
    }

    private static BaseClassLocator getInstanceImpl(Workspace workspace, Map<Object, BaseClassLocator> cache, boolean checkInterrupt) throws InterruptedException {
        if (workspace == null) {
            return EMPTY_LOCATOR;
        }
        ApplicationLibraries applicationLibraries = ApplicationLibraries.getInstance((Workspace)workspace);
        ArrayList<Object> libraries = new ArrayList<Library>(applicationLibraries.getClassPathLibraryReferences());
        BaseClassLocator classPathLocator = null;
        if (!libraries.isEmpty()) {
            classPathLocator = ProjectClassLocator.getLibraryLocator(workspace, libraries, checkInterrupt, cache);
            classPathLocator = new ApplicationClassLocator(workspace, classPathLocator);
        }
        libraries = new ArrayList(applicationLibraries.getModulePathLibraryReferences());
        BaseClassLocator modulePathLocator = null;
        if (!libraries.isEmpty()) {
            modulePathLocator = ProjectClassLocator.getLibraryLocator(workspace, libraries, checkInterrupt, cache);
            modulePathLocator.setContainsModuleClasses(true);
            modulePathLocator = new ApplicationClassLocator(workspace, modulePathLocator);
        }
        if (classPathLocator != null && modulePathLocator != null) {
            return new ArrayClassLocator(new BaseClassLocator[]{classPathLocator, modulePathLocator});
        }
        if (classPathLocator != null) {
            return classPathLocator;
        }
        if (modulePathLocator != null) {
            return modulePathLocator;
        }
        return EMPTY_LOCATOR;
    }

    private ApplicationClassLocator(Workspace workspace, BaseClassLocator libraryLocator) {
        this.workspace = workspace;
        this.libraryLocator = libraryLocator;
    }

    public void getPackages(String packagePrefix, Collection<String> out) {
        this.libraryLocator.getPackages(packagePrefix, out);
    }

    public void getPackagesInterruptibly(String packagePrefix, Collection<String> out) throws InterruptedException {
        this.libraryLocator.getPackagesInterruptibly(packagePrefix, out);
    }

    public void getClassesInPackage(String packagePrefix, Collection<String> out) {
        this.libraryLocator.getClassesInPackage(packagePrefix, out);
    }

    public void getClassesInPackageInterruptibly(String packagePrefix, Collection<String> out) throws InterruptedException {
        this.libraryLocator.getClassesInPackageInterruptibly(packagePrefix, out);
    }

    public void getAllClasses(Collection<String> out, ClassNameFilter filter) {
        this.libraryLocator.getAllClasses(out, filter);
    }

    public void getAllClassesInterruptibly(Collection<String> out, ClassNameFilter filter) throws InterruptedException {
        this.libraryLocator.getAllClassesInterruptibly(out, filter);
    }

    public void getAllPackages(Collection<String> out, PackageNameFilter filter) {
        this.libraryLocator.getAllPackages(out, filter);
    }

    public void getAllPackagesInterruptibly(Collection<String> out, PackageNameFilter filter) throws InterruptedException {
        this.libraryLocator.getAllPackagesInterruptibly(out, filter);
    }

    public void buildIndex() {
        this.libraryLocator.buildIndex();
    }

    public void buildIndexInterruptibly() throws InterruptedException {
        this.libraryLocator.buildIndexInterruptibly();
    }

    public URL getURL(String fqClassName) {
        return this.libraryLocator.getURL(fqClassName);
    }

    public URL getURLInterruptibly(String fqClassName) throws InterruptedException {
        return this.libraryLocator.getURLInterruptibly(fqClassName);
    }

    public URL getSourceURL(String fqClassName) {
        return this.libraryLocator.getSourceURL(fqClassName);
    }

    public URL getSourceURLInterruptibly(String fqClassName) throws InterruptedException {
        return this.libraryLocator.getSourceURLInterruptibly(fqClassName);
    }

    public URL getClassURL(String fqClassName) {
        return this.libraryLocator.getClassURL(fqClassName);
    }

    public URL getClassURLInterruptibly(String fqClassName) throws InterruptedException {
        return this.libraryLocator.getClassURLInterruptibly(fqClassName);
    }

    public URL getResourceURL(String resourceName) {
        return this.libraryLocator.getResourceURL(resourceName);
    }

    protected Collection<BaseClassLocator> getChildLocators(EnumSet<ClasspathTreeVisitOptions> options) {
        return Collections.singletonList(this.libraryLocator);
    }

    protected Object getClasspathTreeNode() {
        return this.workspace;
    }

    public String getModuleNameOfClass(String fqClassName) {
        return this.libraryLocator.getModuleNameOfClass(fqClassName);
    }

    public String getModuleNameOfClassInterruptibly(String fqClassName) throws InterruptedException {
        return this.libraryLocator.getModuleNameOfClassInterruptibly(fqClassName);
    }
}

