/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.engine;

import java.util.HashMap;
import java.util.Map;

public class MWDatabasePlatform {
    private static Map javaTypeToJdbcTypeMap;
    private static final String DEFAULT_JDBC_TYPE_NAME = "VARCHAR";

    public static boolean javaTypeNamedIsDatabaseType(String javaClassName) {
        return MWDatabasePlatform.javaTypeToJdbcTypeMap().containsKey(javaClassName);
    }

    public static String jdbcTypeNameForJavaTypeNamed(String javaClassName) {
        String result = (String)MWDatabasePlatform.javaTypeToJdbcTypeMap().get(javaClassName);
        if (result == null) {
            result = DEFAULT_JDBC_TYPE_NAME;
        }
        return result;
    }

    private static Map javaTypeToJdbcTypeMap() {
        if (javaTypeToJdbcTypeMap == null) {
            javaTypeToJdbcTypeMap = MWDatabasePlatform.buildJavaTypeToJdbcTypeMap();
        }
        return javaTypeToJdbcTypeMap;
    }

    private static Map buildJavaTypeToJdbcTypeMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("char", "CHAR");
        result.put("java.lang.Character", "CHAR");
        result.put("java.lang.String", DEFAULT_JDBC_TYPE_NAME);
        result.put("java.lang.Number", "NUMERIC");
        result.put("java.math.BigDecimal", "NUMERIC");
        result.put("java.math.BigInteger", "NUMERIC");
        result.put("boolean", "BIT");
        result.put("java.lang.Boolean", "BIT");
        result.put("byte", "TINYINT");
        result.put("java.lang.Byte", "TINYINT");
        result.put("short", "SMALLINT");
        result.put("java.lang.Short", "SMALLINT");
        result.put("int", "INTEGER");
        result.put("java.lang.Integer", "INTEGER");
        result.put("long", "BIGINT");
        result.put("java.lang.Long", "BIGINT");
        result.put("float", "REAL");
        result.put("java.lang.Float", "REAL");
        result.put("double", "DOUBLE");
        result.put("java.lang.Double", "DOUBLE");
        result.put("java.util.Date", "DATE");
        result.put("java.sql.Date", "DATE");
        result.put("java.util.Calendar", "DATE");
        result.put("java.sql.Time", "TIME");
        result.put("java.sql.Timestamp", "TIMESTAMP");
        result.put("java.sql.Blob", "BLOB");
        result.put("java.sql.Clob", "CLOB");
        return result;
    }
}

