/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.dialogs;

import java.util.Comparator;
import javax.swing.Icon;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.icons.OracleIcons;

public final class ClassPackageListItem
extends ListDataItem {
    private final Type _type;
    private final String _name;
    private String _displayName;
    public static final ClassPackageSorter COMPARATOR = new ClassPackageSorter();

    public ClassPackageListItem(String fullyQualifiedName, Type type) {
        this._name = fullyQualifiedName;
        this._type = type;
    }

    public Icon getIcon() {
        return this._type.getIcon();
    }

    public String getDisplayText() {
        if (this._displayName == null) {
            this._displayName = this._type.getDisplayText(this._name);
        }
        return this._displayName;
    }

    public String getName() {
        return this._type.getName(this._name);
    }

    public Type getType() {
        return this._type;
    }

    public int compareTo(Object object) {
        if (object instanceof ClassPackageListItem) {
            ClassPackageListItem other = (ClassPackageListItem)((Object)object);
            if (this.getType() == other.getType()) {
                return String.CASE_INSENSITIVE_ORDER.compare(this.getDisplayText(), other.getDisplayText());
            }
            if (this.getType() == Type.PACKAGE_ITEM) {
                return 1;
            }
            if (other.getType() == Type.PACKAGE_ITEM) {
                return -1;
            }
        }
        return super.compareTo(object);
    }

    public String toString() {
        return this._name;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ClassPackageListItem)) {
            return false;
        }
        ClassPackageListItem other = (ClassPackageListItem)((Object)object);
        return this._name != null ? this._name.equals(other._name) : other._name == null;
    }

    public int hashCode() {
        int PRIME = 37;
        int result = super.hashCode();
        result = 37 * result + (this._name == null ? 0 : this._name.hashCode());
        return result;
    }

    private static class ClassPackageSorter
    implements Comparator<ClassPackageListItem> {
        private ClassPackageSorter() {
        }

        @Override
        public int compare(ClassPackageListItem item1, ClassPackageListItem item2) {
            if (item1 == null) {
                if (item2 == null) {
                    return 0;
                }
                return -1;
            }
            if (item2 == null) {
                return 1;
            }
            return item1.compareTo((Object)item2);
        }
    }

    public static enum Type {
        PACKAGE_ITEM,
        CLASS_ITEM_UNQ,
        CLASS_ITEM_FQ,
        INTERFACE_ITEM_UNQ,
        INTERFACE_ITEM_FQ;


        public Icon getIcon() {
            switch (this) {
                case PACKAGE_ITEM: {
                    return OracleIcons.getIcon((String)"package.png");
                }
                case CLASS_ITEM_UNQ: 
                case CLASS_ITEM_FQ: {
                    return OracleIcons.getIcon((String)"class.png");
                }
                case INTERFACE_ITEM_UNQ: 
                case INTERFACE_ITEM_FQ: {
                    return OracleIcons.getIcon((String)"interface.png");
                }
            }
            throw new IllegalStateException("unknown type");
        }

        public String getDisplayText(String fullyQualifiedClassName) {
            switch (this) {
                case PACKAGE_ITEM: 
                case CLASS_ITEM_FQ: 
                case INTERFACE_ITEM_FQ: {
                    return fullyQualifiedClassName;
                }
                case CLASS_ITEM_UNQ: 
                case INTERFACE_ITEM_UNQ: {
                    String classPart;
                    String packagePrefix;
                    int dotPos = fullyQualifiedClassName.lastIndexOf(46);
                    if (dotPos == -1) {
                        packagePrefix = "";
                        classPart = fullyQualifiedClassName;
                    } else {
                        packagePrefix = fullyQualifiedClassName.substring(0, dotPos);
                        classPart = fullyQualifiedClassName.substring(dotPos + 1);
                    }
                    String displayName = packagePrefix.length() > 0 ? classPart + " ( " + packagePrefix + " )" : classPart;
                    return displayName;
                }
            }
            throw new IllegalStateException("unknown type");
        }

        public String getName(String fullyQualifiedClassName) {
            switch (this) {
                case PACKAGE_ITEM: 
                case CLASS_ITEM_FQ: 
                case INTERFACE_ITEM_FQ: {
                    return fullyQualifiedClassName;
                }
                case CLASS_ITEM_UNQ: 
                case INTERFACE_ITEM_UNQ: {
                    int dotPos = fullyQualifiedClassName.lastIndexOf(46);
                    return dotPos != -1 ? fullyQualifiedClassName.substring(dotPos + 1) : fullyQualifiedClassName;
                }
            }
            throw new IllegalStateException("unknown type");
        }
    }
}

