/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder.cls;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ide.extension.ElementName;
import javax.ide.util.MetaClass;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.util.Assert;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.builder.cls.CreateClassRedirector;

final class CreateClassHook {
    private static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "create-class-hook");
    private static HashStructureHook hashStructureHook;
    private static Map<String, MetaClass<CreateClassRedirector>> registrations;

    CreateClassHook() {
    }

    static CreateClassRedirector getRegisteredRedirector(String superClassName) {
        MetaClass<CreateClassRedirector> mc;
        if (hashStructureHook == null) {
            hashStructureHook = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(NAME);
            if (hashStructureHook == null) {
                return null;
            }
            hashStructureHook.addHashStructureHookListener(new HashStructureHookListener(){

                public void elementVisited(HashStructureHookEvent e) {
                    CreateClassHook.getItemsFromHook(e.getNewElementHashStructure());
                }

                public void listenerAttached(HashStructureHookEvent e) {
                    CreateClassHook.getItemsFromHook(e.getCombinedHashStructure());
                }
            });
        }
        if ((mc = registrations.get(superClassName)) != null) {
            try {
                return (CreateClassRedirector)mc.newInstance();
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
        }
        return null;
    }

    private static void getItemsFromHook(HashStructure hs) {
        List list = hs.getAsList("create-class-redirector");
        if (list != null) {
            for (HashStructure sub : list) {
                String clsName = sub.getString("superclass");
                MetaClass mc = LazyClassAdapter.getInstance((HashStructure)sub).getMetaClass("redirector-class");
                if (clsName == null || mc == null) continue;
                registrations.put(clsName, (MetaClass<CreateClassRedirector>)mc);
            }
        }
    }

    static {
        registrations = Collections.synchronizedMap(new HashMap());
    }
}

