/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.net.DefaultNameGenerator;
import oracle.ide.net.NameGenerator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.Assert;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.builder.resource.BuilderArb;
import oracle.jdeveloper.model.PathsConfiguration;

public class SourceModel {
    private String _fileName;
    private String _directory = "";
    private URL _baseURL;
    private Project _proj;
    private boolean _allowUrlsNotInSourcePath;
    protected URL _url;

    public URL getURL() {
        URL dirURL;
        if (this._url == null && (dirURL = this.getDirectory()) != null) {
            this._url = URLFactory.newURL((URL)dirURL, (String)(this._fileName + this.getExtension()));
        }
        return this._url;
    }

    public void setURL(URL url) {
        this._url = null;
        if (url != null) {
            this.setDirectory(URLFileSystem.getParent((URL)url));
            this._url = url;
        }
    }

    public final boolean verifyPath() {
        URL url = this.getURL();
        URL parent = URLFileSystem.getParent((URL)url);
        return URLFileSystem.exists((URL)parent) || URLFileSystem.mkdirs((URL)parent);
    }

    public Node createNode() {
        Assert.precondition((this._proj != null ? 1 : 0) != 0);
        URL url = this.getURL();
        Node node = null;
        Class type = this.getNodeType();
        if (type != null) {
            node = NodeFactory.find((URL)url);
            if (node != null && !type.isInstance(node)) {
                try {
                    if (node.isDirty()) {
                        node.save();
                    }
                    if (node.isOpen()) {
                        node.close();
                    }
                    if (URLFileSystem.exists((URL)url)) {
                        URLFileSystem.delete((URL)url);
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
                NodeFactory.uncache((URL)url);
            }
            node = NodeFactory.findOrCreateOrFail(type, (URL)url);
        } else {
            node = NodeFactory.findOrCreateOrFail((URL)url);
        }
        if (node != null && !this._proj.canAdd((Element)node)) {
            String message = BuilderArb.format(145, URLFileSystem.getPlatformPathName((URL)node.getURL()), URLFileSystem.getPlatformPathName((URL)this._proj.getURL()));
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)message, null, null);
            node = null;
        }
        return node;
    }

    public final boolean checkForExistingFile() {
        URL url = this.getURL();
        Node node = NodeFactory.find((URL)url);
        return node != null && node.isOpen() || URLFileSystem.exists((URL)url);
    }

    public void generateDefaultFileName(String baseName) {
        URL dirURL = this.getDirectory();
        int startCount = this.getDefaultNameStartIndex();
        DefaultNameGenerator gen = new DefaultNameGenerator(baseName, this.getExtension(), startCount);
        this._url = URLFactory.newUniqueURL((URL)dirURL, (NameGenerator)gen);
        String fName = URLFileSystem.getFileName((URL)this._url);
        int dotPos = fName.indexOf(46);
        this._fileName = dotPos != -1 ? fName.substring(0, dotPos) : fName;
    }

    public String getFileName() {
        return this._fileName;
    }

    public void setFileName(String newFileName) {
        this._fileName = newFileName;
        this._url = null;
    }

    public final String getRelativeDirectory() {
        return this._directory;
    }

    public void setRelativeDirectory(String newDirectory) {
        if (this._baseURL == null) {
            this.updateBaseURLFromProject();
        }
        this._directory = newDirectory != null ? newDirectory : "";
        this._url = null;
    }

    public URL getDirectory() {
        return this._directory.length() == 0 ? this._baseURL : URLFactory.newDirURL((URL)this._baseURL, (String)this._directory);
    }

    protected String getDirectoryString() {
        return this._directory;
    }

    public final void setDirectory(URL url) {
        if (url != null && !URLFileSystem.isDirectoryPath((URL)url)) {
            url = URLFileSystem.getParent((URL)url);
        }
        if (url == null) {
            this.updateBaseURLFromProject();
            this._directory = "";
            this._url = null;
            return;
        }
        if (!this.isInSourcePath(url)) {
            if (this._allowUrlsNotInSourcePath) {
                this._baseURL = url;
                this._directory = "";
            } else {
                this._baseURL = null;
                this._directory = "";
            }
        }
        this._url = null;
    }

    public boolean isInSourcePath(URL url) {
        if (url == null) {
            return false;
        }
        URL[] srcPathEntries = this.getSourcePath().getEntries();
        boolean found = false;
        for (int i = 0; i < srcPathEntries.length; ++i) {
            URL pathElem = srcPathEntries[i];
            String relativePath = URLFileSystem.toRelativeSpec((URL)url, (URL)pathElem, (boolean)true);
            if (relativePath == null) continue;
            if (relativePath.endsWith("/")) {
                relativePath = relativePath.substring(0, relativePath.length() - 1);
            }
            this._baseURL = pathElem;
            this.setRelativeDirectory(relativePath);
            found = true;
            break;
        }
        return found;
    }

    public final URL getBaseURL() {
        return this._baseURL;
    }

    public final Project getProject() {
        return this._proj;
    }

    public void setProject(Project newProj) throws IllegalArgumentException {
        if (newProj == null) {
            throw new IllegalArgumentException("SourceModel: project cannot be null");
        }
        this._proj = newProj;
        this.updateBaseURLFromProject();
        this._url = null;
    }

    protected void updateBaseURLFromProject() {
        if (this._proj == null) {
            return;
        }
        this._baseURL = this.getSourcePath().getFirstEntry();
        if (this._baseURL == null) {
            this._baseURL = URLFileSystem.getParent((URL)this._proj.getURL());
        }
        Assert.check((boolean)URLFileSystem.isDirectoryPath((URL)this._baseURL));
    }

    public String getExtension() {
        return ".txt";
    }

    protected int getDefaultNameStartIndex() {
        return 1;
    }

    protected <T extends Node> Class<T> getNodeType() {
        return null;
    }

    protected URLPath getSourcePath() {
        URLPath path = PathsConfiguration.getInstance((Project)this._proj).getProjectSourcePath();
        path.add(ProjectContent.getInstance((PropertyStorage)this._proj).getAllContents().getAllRootDirs());
        return path;
    }

    protected String getContentSetKey() {
        return "oracle.ide.model.ResourcePaths/resourcesContentSet";
    }

    public void setAllowUrlsNotInSourcePath(boolean allowUrlsNotInSourcePath) {
        this._allowUrlsNotInSourcePath = allowUrlsNotInSourcePath;
    }

    public boolean getAllowUrlsNotInSourcePath() {
        return this._allowUrlsNotInSourcePath;
    }
}

