/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview.metadata;

import java.sql.Connection;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pg.rdbms.pgql.pgview.util.Pair;

public abstract class Cache<V> {
    private static final int MAX_CAPACITY = 1000;
    private final LinkedHashMap<CacheKey, Pair<V, OffsetDateTime>> cache = new LinkedHashMap<CacheKey, Pair<V, OffsetDateTime>>(1000){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > Cache.this.maxCapacity;
        }
    };
    private boolean isEnabled = true;
    private int maxCapacity = 1000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<V, OffsetDateTime> get(Connection conn, String ... keyComponents) {
        CacheKey key = new CacheKey(keyComponents);
        LinkedHashMap<CacheKey, Pair<V, OffsetDateTime>> linkedHashMap = this.cache;
        synchronized (linkedHashMap) {
            if (this.isEnabled && this.cache.containsKey(key)) {
                return this.cache.get(key);
            }
            Pair<V, OffsetDateTime> value = this.buildValue(conn, keyComponents);
            if (this.isEnabled && value != null) {
                this.cache.put(key, value);
            }
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheValue(String[] keyComponents, V value) {
        CacheKey key = new CacheKey(keyComponents);
        LinkedHashMap<CacheKey, Pair<V, OffsetDateTime>> linkedHashMap = this.cache;
        synchronized (linkedHashMap) {
            if (this.isEnabled) {
                this.cache.put(key, new Pair<V, OffsetDateTime>(value, OffsetDateTime.now()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntry(String ... keyComponents) {
        CacheKey key = new CacheKey(keyComponents);
        LinkedHashMap<CacheKey, Pair<V, OffsetDateTime>> linkedHashMap = this.cache;
        synchronized (linkedHashMap) {
            this.cache.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(String ... keyComponents) {
        CacheKey key = new CacheKey(keyComponents);
        LinkedHashMap<CacheKey, Pair<V, OffsetDateTime>> linkedHashMap = this.cache;
        synchronized (linkedHashMap) {
            if (this.isEnabled) {
                return this.cache.containsKey(key);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxCapacity(int maxCapacity) {
        if (maxCapacity < 1) {
            throw new PgqlToSqlException("Max capacity should be a positive number");
        }
        LinkedHashMap<CacheKey, Pair<V, OffsetDateTime>> linkedHashMap = this.cache;
        synchronized (linkedHashMap) {
            this.maxCapacity = maxCapacity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LinkedHashMap<CacheKey, Pair<V, OffsetDateTime>> linkedHashMap = this.cache;
        synchronized (linkedHashMap) {
            this.cache.clear();
        }
    }

    public void enable() {
        this.isEnabled = true;
    }

    public void disable() {
        this.isEnabled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OffsetDateTime getTimestampLastRefreshed(String ... keyComponents) {
        Pair<V, OffsetDateTime> pair;
        CacheKey key = new CacheKey(keyComponents);
        LinkedHashMap<CacheKey, Pair<V, OffsetDateTime>> linkedHashMap = this.cache;
        synchronized (linkedHashMap) {
            pair = this.cache.get(key);
        }
        return pair == null ? null : (OffsetDateTime)pair.second;
    }

    Pair<V, OffsetDateTime> buildValue(Connection conn, String ... valueParameters) {
        return null;
    }

    static class CacheKey {
        String[] keyComponents;

        public CacheKey(String ... keyComponents) {
            this.keyComponents = keyComponents;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey that = (CacheKey)o;
            if (this.keyComponents == null) {
                return that.keyComponents == null;
            }
            if (that.keyComponents == null) {
                return false;
            }
            if (this.keyComponents.length != that.keyComponents.length) {
                return false;
            }
            for (int i = 0; i < this.keyComponents.length; ++i) {
                if (Objects.equals(this.keyComponents[i], that.keyComponents[i])) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return Objects.hash(this.keyComponents);
        }
    }
}

