/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.pg.rdbms.pgql.DbmsUtils;
import oracle.pg.rdbms.pgql.GraphType;
import oracle.pg.rdbms.pgql.PgqlConnection;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pg.rdbms.pgql.PgqlUtils;
import oracle.pg.rdbms.pgql.pgview.GraphMetadataHandler;

public class QueryContext {
    public final PgqlConnection pgqlConn;
    String geTab;
    String gtTab;
    String vtTab;
    String vdTab;
    public String graphName;
    public String schemaName;
    public int dbVersion;
    public double opgVersion;
    public boolean projNullProps;
    public boolean useVLCol;
    public boolean useGtTab;
    public boolean useVdTab;
    public boolean useIso;
    public boolean useRW;
    public boolean useDistRW;
    public boolean allEdgeHash;
    public boolean allEdgeNL;
    public boolean allVertexHash;
    public boolean allVertexNL;
    public int maxPathLen;
    public boolean addDefaultNull;
    private int qbIdCntr;
    public boolean useExtdSize;
    public GraphType graphType;
    public boolean reversePath;
    public boolean pushSrcHops;
    public boolean pushDstHops;
    public boolean checkedDbVersion = false;
    public boolean checkedOpgVersion = false;

    private QueryContext(Connection conn, String graphName, String graphOwner, String geTab, String gtTab, String vtTab, String vdTab) {
        this(PgqlConnection.getConnection(conn));
        this.pgqlConn.setGraph(graphName);
        this.pgqlConn.setSchema(graphOwner);
        this.geTab = geTab;
        this.gtTab = gtTab;
        this.vtTab = vtTab;
        this.vdTab = vdTab;
    }

    @Deprecated
    public static QueryContext getQueryContext(Connection conn, String graphName, String graphOwner, String geTab, String gtTab, String vtTab, String vdTab) {
        return new QueryContext(conn, graphName, graphOwner, geTab, gtTab, vtTab, vdTab);
    }

    private QueryContext(PgqlConnection pgqlConn) {
        this.pgqlConn = pgqlConn;
        this.schemaName = null;
        this.graphName = null;
        this.geTab = null;
        this.gtTab = null;
        this.vtTab = null;
        this.vdTab = null;
        this.useIso = false;
        this.useRW = false;
        this.useDistRW = false;
        this.allEdgeHash = false;
        this.allEdgeNL = false;
        this.allVertexHash = false;
        this.allVertexNL = false;
        this.maxPathLen = 0;
        this.addDefaultNull = true;
        this.qbIdCntr = -1;
        this.graphType = GraphType.PG_SCHEMA;
        this.reversePath = true;
        this.pushSrcHops = true;
        this.pushDstHops = false;
    }

    public static QueryContext getQueryContext(PgqlConnection pgqlConn) {
        return new QueryContext(pgqlConn);
    }

    public String toString() {
        StringBuffer s = new StringBuffer("");
        s.append("     dbVersion=[").append(this.dbVersion).append("]\n");
        s.append("    opgVersion=[").append(this.opgVersion).append("]\n");
        s.append("    schemaName=[").append(this.schemaName).append("]\n");
        s.append("     graphName=[").append(this.graphName).append("]\n");
        s.append(" projNullProps=[").append(this.projNullProps).append("]\n");
        s.append("      useVLCol=[").append(this.useVLCol).append("]\n");
        s.append("         geTab=[").append(this.geTab).append("]\n");
        s.append("         gtTab=[").append(this.gtTab).append("]\n");
        s.append("         vtTab=[").append(this.vtTab).append("]\n");
        s.append("         vdTab=[").append(this.vdTab).append("]\n");
        s.append("      useGtTab=[").append(this.useGtTab).append("]\n");
        s.append("      useVdTab=[").append(this.useVdTab).append("]\n");
        s.append("        useIso=[").append(this.useIso).append("]\n");
        s.append("         useRW=[").append(this.useRW).append("]\n");
        s.append("     useDistRW=[").append(this.useDistRW).append("]\n");
        s.append("   allEdgeHash=[").append(this.allEdgeHash).append("]\n");
        s.append("     allEdgeNL=[").append(this.allEdgeNL).append("]\n");
        s.append(" allVertexHash=[").append(this.allVertexHash).append("]\n");
        s.append("   allVertexNL=[").append(this.allVertexNL).append("]\n");
        s.append("    maxPathLen=[").append(this.maxPathLen).append("]\n");
        s.append("addDefaultNull=[").append(this.addDefaultNull).append("]\n");
        s.append("      qbIdCntr=[").append(this.qbIdCntr).append("]\n");
        s.append("   useExtdSize=[").append(this.useExtdSize).append("]\n");
        s.append("     graphType=[").append((Object)this.graphType).append("]\n");
        s.append("   reversePath=[").append(this.reversePath).append("]\n");
        s.append("   pushSrcHops=[").append(this.pushSrcHops).append("]\n");
        s.append("   pushDstHops=[").append(this.pushDstHops).append("]\n");
        return s.toString();
    }

    public int getNextQbId() {
        ++this.qbIdCntr;
        return this.qbIdCntr;
    }

    boolean updateGraphInfo(String schemaName, String graphName, GraphType createType) {
        this.schemaName = schemaName;
        this.graphName = graphName;
        boolean pgmCreated = false;
        if (createType == null) {
            if (graphName.equals("PROPERTY_GRAPH_METADATA")) {
                try {
                    pgmCreated = GraphMetadataHandler.graphMetadataInitiator(this.pgqlConn.getJdbcConnection(), schemaName);
                    this.graphType = GraphType.PG_VIEWS;
                }
                catch (SQLException e) {
                    this.graphType = null;
                }
            } else {
                this.graphType = PgqlUtils.getGraphType(this.pgqlConn.getJdbcConnection(), schemaName, graphName);
            }
            if (this.graphType == null) {
                throw new PgqlToSqlException("Graph " + schemaName + "." + graphName + " does not exist");
            }
        } else {
            this.graphType = createType;
        }
        this.updatePGSchemaTableNames();
        return pgmCreated;
    }

    private void updatePGSchemaTableNames() {
        if (this.graphType == GraphType.PG_SCHEMA) {
            try {
                this.geTab = PgqlUtils.getEdgeTabName(this.pgqlConn.getJdbcConnection(), this.schemaName, this.graphName);
                this.gtTab = PgqlUtils.getSkeletonTabName(this.pgqlConn.getJdbcConnection(), this.schemaName, this.graphName);
                this.vtTab = PgqlUtils.getVertexTabName(this.pgqlConn.getJdbcConnection(), this.schemaName, this.graphName);
                this.vdTab = PgqlUtils.getDistinctVertexTabName(this.pgqlConn.getJdbcConnection(), this.schemaName, this.graphName);
            }
            catch (SQLException ex) {
                throw new PgqlToSqlException(ex);
            }
        } else {
            this.geTab = null;
            this.gtTab = null;
            this.vtTab = null;
            this.vdTab = null;
        }
    }

    public void checkDbVersion() {
        if (!this.checkedDbVersion) {
            this.dbVersion = DbmsUtils.getDatabaseMajorVersion(this.pgqlConn.getJdbcConnection());
            this.checkedDbVersion = true;
        }
    }

    public void checkOpgVersion() {
        if (!this.checkedOpgVersion) {
            this.opgVersion = DbmsUtils.getOpgVersion(this.pgqlConn.getJdbcConnection());
            this.checkedOpgVersion = true;
        }
    }

    public boolean sbqJoinWorks() {
        this.checkDbVersion();
        return PgqlUtils.DbFeature.SUBQUERY_PATH_EDGE_JOIN.isSupported(this.dbVersion, Double.MIN_VALUE);
    }

    public boolean isModifySupported() {
        this.checkDbVersion();
        return PgqlUtils.DbFeature.INSERT_UPDATE_DELETE.isSupported(this.dbVersion, Double.MIN_VALUE);
    }

    public boolean isShortestPathCursorSupported() {
        this.checkDbVersion();
        return PgqlUtils.DbFeature.SHORTEST_PATH_CURSOR.isSupported(this.dbVersion, Double.MIN_VALUE);
    }
}

