/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql;

import java.sql.Connection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import oracle.pg.rdbms.pgql.PgqlConnection;
import oracle.pg.rdbms.pgql.pgview.metadata.MetadataConnector;
import oracle.pg.rdbms.pgql.pgview.metadata.PgViewMetadataCache;
import oracle.pgql.lang.ir.SchemaQualifiedName;
import oracle.pgql.lang.metadata.AbstractMetadataProvider;
import oracle.pgql.lang.metadata.EdgeLabel;
import oracle.pgql.lang.metadata.GraphSchema;
import oracle.pgql.lang.metadata.Property;
import oracle.pgql.lang.metadata.VertexLabel;

public class MetadataProvider
extends AbstractMetadataProvider {
    private final PgqlConnection pgqlConn;
    private final PgViewMetadataCache pgViewMetadataCache;

    public MetadataProvider(PgqlConnection pgqlConn, PgViewMetadataCache pgViewMetadataCache) {
        this.pgqlConn = pgqlConn;
        this.pgViewMetadataCache = pgViewMetadataCache;
    }

    public Optional<GraphSchema> getGraphSchema() {
        return Optional.ofNullable(this.getGraphSchema(this.pgqlConn.getSchema(), this.pgqlConn.getGraph()));
    }

    public Optional<GraphSchema> getGraphSchema(SchemaQualifiedName graphName) {
        String schemaName = graphName.getSchemaName() == null ? this.pgqlConn.getSchema() : graphName.getSchemaName();
        return Optional.ofNullable(this.getGraphSchema(schemaName, graphName.getName()));
    }

    private GraphSchema getGraphSchema(String schemaName, String graphName) {
        if (MetadataConnector.existsPgView(this.pgqlConn.getJdbcConnection(), schemaName, graphName)) {
            MetadataConnector metadataConnector = (MetadataConnector)this.pgViewMetadataCache.getGraphMetadata((Connection)this.pgqlConn.getJdbcConnection(), (String)schemaName, (String)graphName).first;
            List vertexLabels = metadataConnector.getAllVertexLabels().stream().map(x -> new VertexLabel(x, metadataConnector.getVertexPropertiesForLabel((String)x).stream().map(p -> new Property(p, "UNKNOWN")).collect(Collectors.toList()))).collect(Collectors.toList());
            List edgeLabels = metadataConnector.getAllEdgeLabels().stream().map(x -> new EdgeLabel(x, metadataConnector.getEdgePropertiesForLabel((String)x).stream().map(p -> new Property(p, "UNKNOWN")).collect(Collectors.toList()))).collect(Collectors.toList());
            return new GraphSchema(vertexLabels, edgeLabels);
        }
        return null;
    }
}

