/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pg.rdbms.pgql.pgview.util.Pair;
import oracle.pgql.lang.ir.QueryExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindValueInfo {
    private static Logger ms_log = LoggerFactory.getLogger(BindValueInfo.class);
    private QueryExpression.ExpressionType[] bvTypeArray;
    private Object[] bvValues;
    private int[] bvListIdxs;
    private List<List<Object>> sqlBvLists;
    private List<Map<Integer, List<Integer>>> pgqlToSqlBvIdxMaps;
    private boolean bvProcessed;
    private static final int DEFAULT_BV_ARRAY_SIZE = 20;
    private static final int DEFAULT_BV_EXTENT_SIZE = 20;
    private static final String BV_ENCODE_START = " _ORABV$";
    private static final String BV_ENCODE_END = "$ORABV_ ";
    private static final String BV_ENCODE_REGEX = " _ORABV\\$\\d+\\$ORABV_ ";

    private BindValueInfo() {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Creating new BindValueInfo instance");
        }
        this.bvTypeArray = new QueryExpression.ExpressionType[20];
        this.bvValues = new Object[20];
        this.bvListIdxs = new int[20];
        this.sqlBvLists = new ArrayList<List<Object>>();
        this.sqlBvLists.add(new ArrayList());
        this.pgqlToSqlBvIdxMaps = new ArrayList<Map<Integer, List<Integer>>>();
        this.pgqlToSqlBvIdxMaps.add(new HashMap());
        this.bvProcessed = false;
    }

    public static BindValueInfo getBindValueInfo() {
        return new BindValueInfo();
    }

    public static String getBvEncoding(QueryExpression.BindVariable bv) {
        String bvStr = BV_ENCODE_START + bv.getParameterIndex() + BV_ENCODE_END;
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Returning encoding [" + bvStr + "] for " + bv.toString());
        }
        return bvStr;
    }

    public void setBoolean(int parameterIndex, boolean x) {
        String sVal = x ? "Y" : "N";
        this.setValue(parameterIndex, sVal, QueryExpression.ExpressionType.BOOLEAN);
    }

    public void setDouble(int parameterIndex, double x) {
        this.setValue(parameterIndex, x, QueryExpression.ExpressionType.DECIMAL);
    }

    public void setFloat(int parameterIndex, float x) {
        this.setValue(parameterIndex, Float.valueOf(x), QueryExpression.ExpressionType.DECIMAL);
    }

    public void setInt(int parameterIndex, int x) {
        this.setValue(parameterIndex, x, QueryExpression.ExpressionType.INTEGER);
    }

    public void setLong(int parameterIndex, long x) {
        this.setValue(parameterIndex, x, QueryExpression.ExpressionType.INTEGER);
    }

    public void setString(int parameterIndex, String x) {
        this.setValue(parameterIndex, x, QueryExpression.ExpressionType.STRING);
    }

    public Pair<Integer, List<Integer>> getBindPositions(int parameterIndex) {
        int bvListIdx = this.bvListIdxs[parameterIndex - 1];
        Map<Integer, List<Integer>> currentPgqlToSqlBvIdxMap = this.pgqlToSqlBvIdxMaps.get(bvListIdx);
        if (!currentPgqlToSqlBvIdxMap.containsKey(parameterIndex - 1)) {
            throw new PgqlToSqlException("Tried to set bind variable " + parameterIndex + " but the query only has " + currentPgqlToSqlBvIdxMap.size() + " bind variables");
        }
        return new Pair<Integer, List<Integer>>(bvListIdx, currentPgqlToSqlBvIdxMap.get(parameterIndex - 1));
    }

    public void setTimestamp(int parameterIndex, Timestamp x) {
        this.setValue(parameterIndex, x, QueryExpression.ExpressionType.TIMESTAMP);
    }

    private void setValue(int parameterIndex, Object x, QueryExpression.ExpressionType expType) {
        if (x == null) {
            throw new PgqlToSqlException("Setting parameters to null is not allowed");
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Setting value [" + x + "] for index [" + parameterIndex + "]");
        }
        this.checkExtendBvArrays(parameterIndex);
        this.bvTypeArray[parameterIndex - 1] = expType;
        this.bvValues[parameterIndex - 1] = x;
        if (this.bvProcessed) {
            this.updateBvList(parameterIndex, x);
        }
    }

    public String processBindVariables(String pgqlToSqlString, int bvListIdx) {
        Map<Integer, List<Integer>> currentPgqlToSqlBvIdxMap;
        List<Object> currentSqlBvList;
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Processing bind variables for query string [" + pgqlToSqlString + "]");
            ms_log.debug("Bind variable type array: " + this.bvTypeArray);
            ms_log.debug("Bind value array: " + this.bvValues);
        }
        Pattern p = Pattern.compile(BV_ENCODE_REGEX);
        Matcher m = p.matcher(pgqlToSqlString);
        if (bvListIdx > 0) {
            currentSqlBvList = new ArrayList();
            this.sqlBvLists.add(currentSqlBvList);
            currentPgqlToSqlBvIdxMap = new HashMap<Integer, List<Integer>>();
            this.pgqlToSqlBvIdxMaps.add(currentPgqlToSqlBvIdxMap);
        } else {
            currentSqlBvList = this.sqlBvLists.get(0);
            currentPgqlToSqlBvIdxMap = this.pgqlToSqlBvIdxMaps.get(0);
        }
        String bv = "";
        int sqlBvListIdx = 0;
        while (m.find()) {
            bv = m.group().trim();
            String bvIdx = bv.substring(7, bv.length() - 7);
            int bvIdxInt = Integer.parseInt(bvIdx);
            if (sqlBvListIdx == currentSqlBvList.size()) {
                currentSqlBvList.add(sqlBvListIdx, this.bvValues[bvIdxInt - 1]);
            } else {
                currentSqlBvList.set(sqlBvListIdx, this.bvValues[bvIdxInt - 1]);
            }
            this.bvListIdxs[bvIdxInt - 1] = bvListIdx;
            List<Integer> bvMapList = currentPgqlToSqlBvIdxMap.get(bvIdxInt - 1);
            if (bvMapList == null) {
                bvMapList = new ArrayList<Integer>();
            }
            bvMapList.add(sqlBvListIdx);
            currentPgqlToSqlBvIdxMap.put(bvIdxInt - 1, bvMapList);
            ++sqlBvListIdx;
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("SQL bind value list: " + this.sqlBvLists.toString());
            ms_log.debug("Index mapping: " + this.pgqlToSqlBvIdxMaps.toString());
        }
        this.bvProcessed = true;
        m.reset();
        String processedQuery = m.replaceAll("?");
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Returning processed query [" + processedQuery + "]");
        }
        return processedQuery;
    }

    public List<Object> getSqlBvList(int idx) {
        return this.sqlBvLists.get(idx);
    }

    public QueryExpression.ExpressionType getBindVarType(QueryExpression.BindVariable bv) throws PgqlToSqlException {
        int paramIdx = bv.getParameterIndex();
        if (this.bvTypeArray == null || this.bvTypeArray.length < paramIdx || paramIdx < 1) {
            throw new PgqlToSqlException("Bind variable " + paramIdx + " has undefined type");
        }
        QueryExpression.ExpressionType bvType = this.bvTypeArray[paramIdx - 1];
        if (bvType == null) {
            throw new PgqlToSqlException("Bind variable " + paramIdx + " has undefined type");
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Returning type [" + bvType + "] for " + bv.toString());
        }
        return bvType;
    }

    private void updateBvList(int parameterIndex, Object o) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Updating sqlBvList index [" + parameterIndex + "] with value [" + o.toString() + "]");
        }
        int bvListIdx = this.bvListIdxs[parameterIndex - 1];
        Map<Integer, List<Integer>> currentPgqlToSqlBvIdxMap = this.pgqlToSqlBvIdxMaps.get(bvListIdx);
        List<Object> currentSqlBvList = this.sqlBvLists.get(bvListIdx);
        List<Integer> posList = currentPgqlToSqlBvIdxMap.get(parameterIndex - 1);
        for (Integer i : posList) {
            int idx = i;
            currentSqlBvList.remove(idx);
            currentSqlBvList.add(idx, o);
        }
    }

    private void checkExtendBvArrays(int parameterIndex) {
        if (parameterIndex > this.bvTypeArray.length) {
            int newSize = this.bvTypeArray.length + 20;
            QueryExpression.ExpressionType[] newBvTypeArray = new QueryExpression.ExpressionType[newSize];
            System.arraycopy(this.bvTypeArray, 0, newBvTypeArray, 0, this.bvTypeArray.length);
            this.bvTypeArray = newBvTypeArray;
            Object[] newBvValues = new Object[newSize];
            System.arraycopy(this.bvValues, 0, newBvValues, 0, this.bvValues.length);
            this.bvValues = newBvValues;
            int[] newBvListIdx = new int[newSize];
            System.arraycopy(this.bvListIdxs, 0, newBvListIdx, 0, this.bvListIdxs.length);
            this.bvListIdxs = newBvListIdx;
        }
    }
}

