/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.commands;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.util.Map;
import oracle.dbtools.CpatResources;
import oracle.dbtools.commands.MigrateAdvisorOptions;
import oracle.dbtools.common.CpatArguments;
import oracle.dbtools.common.CpatModel;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.exceptions.ProcessFailedException;
import oracle.dbtools.executors.CpatExecutor;
import oracle.dbtools.executors.CpatPostProcessor;
import oracle.dbtools.extension.SQLCLService;
import oracle.dbtools.generators.CpatPreprocessor;
import oracle.dbtools.generators.HtmlReportGenerator;
import oracle.dbtools.migrateadvisor.help.Messages;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.Connected;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.CommandParserConstants;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.Help.CommandHelp;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.CommandHelpClassException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.CommandOptionsClassException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ConnectionNotValidException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ExtraParameterException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.InvalidCommandException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.MissingRequiredParameterException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ParameterFailedValidationException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.interfaces.ICommandSyntax;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.parameter.StandardParameter;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.parser.CommandParser;
import oracle.dbtools.raptor.utils.ToolLogger;
import oracle.dbtools.raptor.utils.ToolLoggerResources;
import oracle.dbtools.util.Logger;

public class MigrateAdvisorCommand
extends CommandListener
implements IHelp,
SQLCLService,
Connected,
ICommandSyntax {
    private static final String NL = "\n";
    public static ScriptRunnerContext ctx;
    private CommandHelp help;
    private CpatModel _model;
    final long start = System.currentTimeMillis();

    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public String getCommand() {
        return "migrateadvisor";
    }

    public Class<? extends CommandListener> getCommandListener() {
        return ((Object)((Object)this)).getClass();
    }

    public String getCommandLongName() {
        return "migrateadvisor";
    }

    public Map<String, Map<String, StandardParameter>> getCommandModel() {
        return MigrateAdvisorOptions.commandModel;
    }

    public String getCommandShortName() {
        return "ma";
    }

    public String getExtensionDescription() {
        return Messages.getString("EXT_DESC");
    }

    public String getExtensionName() {
        return "migrateadvisor";
    }

    public String getExtensionVersion() {
        return Messages.getString("SQLclVersion.VERSION");
    }

    public String getHelp() {
        try {
            ScriptRunnerContext theCtx = new ScriptRunnerContext();
            this.help = new CommandHelp(theCtx, MigrateAdvisorOptions.class);
            CommandParser.loadParams((String)"migrateadvisor.parms", (String)"migrateadvisor help", (ScriptRunnerContext)theCtx, MigrateAdvisorOptions.class);
            return this.help.getCommandHelp();
        }
        catch (CommandHelpClassException | CommandOptionsClassException | ConnectionNotValidException | ExtraParameterException | InvalidCommandException | MissingRequiredParameterException | ParameterFailedValidationException e) {
            return Messages.getString("HELP_ERROR");
        }
    }

    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getProperty("STRIPPED_CONTINUATION") == null) {
            cmd.setSql(ScriptUtils.checkforContinuationChars((String)cmd.getSql()));
        }
        MigrateAdvisorCommand.ctx = ctx;
        ScriptRunnerContext.Parameters parameters = ctx.getParameterInstance();
        if (!cmd.getLoweredTrimmedSQL().startsWith("migrateadvisor") && !cmd.getLoweredTrimmedSQL().startsWith("ma")) {
            return false;
        }
        try {
            this.help = new CommandHelp(ctx, MigrateAdvisorOptions.class);
            CommandParser.loadParams((String)"migrateadvisor.parms", (String)cmd.getSql(), (ScriptRunnerContext)ctx, MigrateAdvisorOptions.class);
            if (parameters.getParameterAsBoolean("migrateadvisor.parms", "debug").booleanValue()) {
                ctx.getParameterInstance().printParametersAsRow("migrateadvisor.parms");
            }
            CpatArguments args = new CpatArguments(ctx);
            this._model = new CpatModel(conn, ctx, cmd, args);
            this._model.getToolLogger().flushLog();
            String _command = parameters.getParameterAsString("migrateadvisor.parms", CommandParserConstants.COMMAND);
            boolean _help = parameters.getParameterAsBoolean("migrateadvisor.parms", CommandParserConstants.HELP);
            if (_help) {
                ctx.write(this.help.getCommandHelp());
                return true;
            }
            if (conn == null) {
                ctx.write(CpatResources.getString("CPCMPD_CONN"));
                ctx.errorLog(ctx.getSourceRef(), Messages.getString("ApexCmd.7"), cmd.getSql());
                return true;
            }
            switch (_command) {
                case "advise": {
                    this._model.isAdvise(true);
                    this.process();
                    break;
                }
                case "properties": {
                    this._model.isProperties(true);
                    this.process();
                    break;
                }
                case "version": {
                    this._model.isInfo(true);
                    this.process();
                    break;
                }
                default: {
                    this.help.getCommandHelp();
                    break;
                }
            }
        }
        catch (CommandHelpClassException | CommandOptionsClassException | ConnectionNotValidException | ExtraParameterException | InvalidCommandException | MissingRequiredParameterException | ParameterFailedValidationException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            if (parameters.getParameterAsBoolean("migrateadvisor.parms", "debug").booleanValue()) {
                e.printStackTrace(pw);
                ctx.write(pw.toString());
            }
            ctx.write(e.getLocalizedMessage() + NL);
            ctx.write(Messages.getString("FAILED_REQUEST"));
            parameters.printParametersAsTable("migrateadvisor.parms");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() {
        block12: {
            try {
                if (this._model.isVerbose() || this._model.isDebug()) {
                    this._model.getToolLogger().logToolStart(CpatResources.getString("CP"));
                }
                if (this._model.isDebug()) {
                    this._model.getToolLogger().log("debug on");
                }
                if (this._model.getConn() != null) {
                    String connName = ConnectionResolver.getConnectionName((Connection)this._model.getConn());
                    CpatPreprocessor preprocessor = new CpatPreprocessor(this._model);
                    if (preprocessor.check()) {
                        this._model.getToolLogger().flushLog();
                        CpatExecutor executor = new CpatExecutor(this._model);
                        boolean isExec = executor.exec();
                        CpatPostProcessor post = new CpatPostProcessor(this._model);
                        post.run();
                        this._model.getToolLogger().flushLog();
                        if (this._model.isDoHtml()) {
                            HtmlReportGenerator gen = new HtmlReportGenerator(this._model);
                            gen.writeReport(this._model.getHtmlReportDir());
                        }
                    }
                    break block12;
                }
                this._model.getToolLogger().logError(CpatResources.getString("CPCMPD_CONN"));
            }
            catch (Exception e) {
                if (e instanceof ProcessFailedException) {
                    Exception e1 = ((ProcessFailedException)e).getOriginalException();
                    this._model.getToolLogger().logError(e1.getLocalizedMessage());
                    break block12;
                }
                this._model.getToolLogger().logException((Throwable)e);
                Logger.warn(((Object)((Object)this)).getClass(), (Throwable)e);
            }
        }
        if (this._model.isVerbose() || this._model.isDebug()) {
            this._model.getToolLogger().logToolEnd();
        }
        if (ctx.getTiming()) {
            this._model.getToolLogger().log(ToolLoggerResources.format((String)"TIMINGELAPSEDTOTAL", (Object[])new Object[]{ToolLogger.getElapsedTime((long)this.start)}));
        }
        this._model.getToolLogger().flushLog();
    }

    public boolean isSqlPlus() {
        return false;
    }

    public boolean needsConnection() {
        return true;
    }
}

