/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.client;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.TreeSet;
import oracle.spatial.rdf.client.CompiledSPARQL;
import oracle.spatial.rdf.client.RDFModelMetadata;
import oracle.spatial.rdf.client.SPARQLFeatureConfig;
import oracle.spatial.rdf.server.LogUtils;
import oracle.spatial.rdf.server.OraBindValueInfo;
import oracle.spatial.rdf.server.OracleDatabaseVersion;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.RDFLogger;
import oracle.spatial.rdf.server.SPARQLEngine;
import oracle.spatial.rdf.server.SPMComponents;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.TranslateEngine;
import oracle.spatial.rdf.server.URIset;
import oracle.spatial.rdf.server.UpdateEngine;
import oracle.spatial.rdf.server.parser.sparql.ParseException;

public final class SPARQLClientUtils {
    private static final String NULL_MODEL_MSG = "Model names parameter is null.";
    private static final String NULL_SPARQL_MSG = "SPARQL string is null or empty.";
    private static final String MODEL_NOT_EXIST_MSG = "Unable to retrieve model.";
    private static final String CLASS_LOG_PFX = "oracle.spatial.rdf.client.SPARQLClientUtils: ";
    private static final String DEFAULT_RULES_INDEX_STATUS = "INVALID";
    private static final String UNABLE_TO_READ_ERR = "Unable to read column %s from table %s.%s";
    private static final String REPLACE_SQL_RES_WORDS_FLAG = "REPLACE_SQL_RES_WORDS=T";
    private static final String INS_BATCH_SIZE = "INS_BATCH_SIZE";

    public static RDFModelMetadata populateRDFModelMetadata(Connection connection, String string, String string2, String string3) throws SQLException, RDFException {
        return SPARQLClientUtils.populateRDFModelMetadata(connection, string, string2, string3, null);
    }

    public static RDFModelMetadata populateRDFModelMetadata(Connection connection, String string, String string2, String string3, RDFLogger rDFLogger) throws SQLException, RDFException {
        String string4 = SPARQLClientUtils.getCurrentSchema(connection, rDFLogger);
        String string5 = SPARQLClientUtils.getCurrentUser(connection, rDFLogger);
        String string6 = QueryUtils.simpleSQLName((String)string.toUpperCase().trim(), (int)25);
        String string7 = QueryUtils.getNetworkOwnerOrMdsys((String)string2);
        String string8 = QueryUtils.getNetworkNameOrEmptyString((String)string3);
        String string9 = QueryUtils.getNetworkNamePfx((String)string8);
        String string10 = QueryUtils.validateAndGetPfxForRdfObjName((String)string2, (String)string3);
        long[] lArray = new long[1];
        String[] stringArray = new String[1];
        String[] stringArray2 = new String[1];
        String[] stringArray3 = new String[1];
        String[] stringArray4 = new String[1];
        String[] stringArray5 = new String[1];
        String[] stringArray6 = new String[1];
        boolean[] blArray = new boolean[1];
        SPARQLClientUtils.getRowSourceInfo(connection, string6, lArray, stringArray, stringArray2, stringArray3, stringArray4, stringArray5, stringArray6, blArray, string7, string8, rDFLogger);
        boolean bl = QueryUtils.matViewsPresentForModel((Connection)connection, (String)stringArray6[0], (String[])new String[]{string6}, (String)string7, (String)string8);
        String string11 = QueryUtils.getNetworkStorageForm((Connection)connection, (String)string10);
        String string12 = SPARQLClientUtils.getNetTablespace(connection, string7, string8, rDFLogger);
        boolean bl2 = true;
        String string13 = QueryUtils.getSvpTabPrefix((String)string6, (String)string8);
        String string14 = QueryUtils.getMvpTabPrefix((String)string6, (String)string8);
        String string15 = QueryUtils.getPcnTabPrefix((String)string6, (String)string8);
        Map map = QueryUtils.getSPMTabsInfo((Connection)connection, (String)string7, (String)string13, (String)string14, (String)string15);
        boolean[] blArray2 = new boolean[1];
        long[] lArray2 = new long[1];
        String[] stringArray7 = new String[1];
        String[] stringArray8 = new String[1];
        String[] stringArray9 = new String[1];
        long[] lArray3 = new long[2];
        String[] stringArray10 = new String[3];
        QueryUtils.getNetworkSpatialInfo((Connection)connection, (boolean[])blArray2, (long[])lArray2, (String[])stringArray7, (String[])stringArray8, (String[])stringArray9, (boolean)false, (String)string7, (String)string8);
        boolean[] blArray3 = new boolean[1];
        boolean[] blArray4 = new boolean[1];
        QueryUtils.getSdoRdfPPFuncInfo((Connection)connection, (boolean[])blArray3, (boolean[])blArray4);
        RDFModelMetadata rDFModelMetadata = new RDFModelMetadata();
        rDFModelMetadata.currSchema = string4;
        rDFModelMetadata.currUser = string5;
        rDFModelMetadata.networkOwner = string7;
        rDFModelMetadata.networkName = string8;
        rDFModelMetadata.networkStorageForm = string11;
        rDFModelMetadata.networkTablespace = string12;
        rDFModelMetadata.orderColsPopulated = bl2;
        rDFModelMetadata.srid = lArray2[0];
        rDFModelMetadata.hasMatSpaIdx = blArray2[0];
        rDFModelMetadata.geoColumn = stringArray7[0];
        rDFModelMetadata.geoTolerance = stringArray8[0];
        rDFModelMetadata.geoDimension = stringArray9[0];
        rDFModelMetadata.modelName = string6;
        rDFModelMetadata.modelId = lArray[0];
        rDFModelMetadata.modelOwner = stringArray[0];
        rDFModelMetadata.modelType = stringArray2[0];
        rDFModelMetadata.appTabName = stringArray3[0];
        rDFModelMetadata.tripleColName = stringArray4[0];
        rDFModelMetadata.usesIMVC = blArray[0];
        rDFModelMetadata.usesMV = bl;
        rDFModelMetadata.spmTabColMap = map;
        rDFModelMetadata.uniqueViewName = stringArray5[0];
        rDFModelMetadata.dupViewName = stringArray6[0];
        rDFModelMetadata.sdoRdfPPExists = blArray3[0];
        rDFModelMetadata.sdoRdfPPRangeEnabled = blArray4[0];
        LogUtils.debug((String)("oracle.spatial.rdf.client.SPARQLClientUtils: \nReturning RDFModelMetadata:\n" + rDFModelMetadata.toString()), (RDFLogger)rDFLogger);
        return rDFModelMetadata;
    }

    public static CompiledSPARQL compileSPARQL(Connection connection, String string, String string2, String string3, String[] stringArray, String[] stringArray2, String string4, String string5, RDFLogger rDFLogger) throws SQLException, RDFException {
        return SPARQLClientUtils.compileSPARQL(connection, string, string2, string3, stringArray, stringArray2, string4, string5, rDFLogger, null);
    }

    public static CompiledSPARQL compileSPARQL(Connection connection, String string, String string2, String string3, String[] stringArray, String[] stringArray2, String string4, String string5, RDFLogger rDFLogger, SPARQLFeatureConfig sPARQLFeatureConfig) throws SQLException, RDFException {
        RDFModelMetadata rDFModelMetadata = SPARQLClientUtils.populateRDFModelMetadata(connection, string2, string4, string5, rDFLogger);
        return SPARQLClientUtils.compileSPARQL(string, rDFModelMetadata, string3, stringArray, stringArray2, rDFLogger, sPARQLFeatureConfig);
    }

    public static CompiledSPARQL compileSPARQL(String string, RDFModelMetadata rDFModelMetadata, String string2, String[] stringArray, String[] stringArray2, RDFLogger rDFLogger) throws SQLException, RDFException {
        return SPARQLClientUtils.compileSPARQL(string, rDFModelMetadata, string2, stringArray, stringArray2, rDFLogger, null);
    }

    public static CompiledSPARQL compileSPARQL(String string, RDFModelMetadata rDFModelMetadata, String string2, String[] stringArray, String[] stringArray2, RDFLogger rDFLogger, SPARQLFeatureConfig sPARQLFeatureConfig) throws SQLException, RDFException {
        return new CompiledSPARQL(string, rDFModelMetadata, string2, stringArray, stringArray2, rDFLogger, sPARQLFeatureConfig);
    }

    public static String sparqlToSql(Connection connection, String string, String string2, String string3, String[] stringArray, String[] stringArray2, Map<String, String> map, String string4, String string5) throws SQLException, RDFException, ParseException {
        return SPARQLClientUtils.sparqlToSql(connection, string, string2, string3, stringArray, stringArray2, map, string4, string5, null);
    }

    public static String sparqlToSql(Connection connection, String string, String string2, String string3, String[] stringArray, String[] stringArray2, Map<String, String> map, String string4, String string5, RDFLogger rDFLogger) throws SQLException, RDFException, ParseException {
        return SPARQLClientUtils.sparqlToSql(connection, string, string2, string3, stringArray, stringArray2, map, string4, string5, rDFLogger, null);
    }

    public static String sparqlToSql(Connection connection, String string, String string2, String string3, String[] stringArray, String[] stringArray2, Map<String, String> map, String string4, String string5, RDFLogger rDFLogger, SPARQLFeatureConfig sPARQLFeatureConfig) throws SQLException, RDFException, ParseException {
        RDFModelMetadata rDFModelMetadata = SPARQLClientUtils.populateRDFModelMetadata(connection, string2, string4, string5, rDFLogger);
        return SPARQLClientUtils.sparqlToSql(connection, string, rDFModelMetadata, string3, stringArray, stringArray2, map, rDFLogger, sPARQLFeatureConfig);
    }

    public static String sparqlToSql(Connection connection, String string, RDFModelMetadata rDFModelMetadata, String string2, String[] stringArray, String[] stringArray2, Map<String, String> map, RDFLogger rDFLogger) throws SQLException, RDFException, ParseException {
        return SPARQLClientUtils.sparqlToSql(connection, string, rDFModelMetadata, string2, stringArray, stringArray2, map, rDFLogger, null);
    }

    public static String sparqlToSql(Connection connection, String string, RDFModelMetadata rDFModelMetadata, String string2, String[] stringArray, String[] stringArray2, Map<String, String> map, RDFLogger rDFLogger, SPARQLFeatureConfig sPARQLFeatureConfig) throws SQLException, RDFException, ParseException {
        return SPARQLClientUtils.sparqlToSql(connection, string, rDFModelMetadata, string2, stringArray, stringArray2, map, null, rDFLogger, sPARQLFeatureConfig, null);
    }

    static String sparqlToSql(Connection connection, String string, RDFModelMetadata rDFModelMetadata, String string2, String[] stringArray, String[] stringArray2, Map<String, String> map, SPMComponents sPMComponents, RDFLogger rDFLogger, SPARQLFeatureConfig sPARQLFeatureConfig, OraBindValueInfo oraBindValueInfo) throws SQLException, RDFException, ParseException {
        String string3 = rDFModelMetadata.networkOwner;
        String string4 = rDFModelMetadata.networkName;
        String string5 = "";
        if (string2 != null && !string2.trim().isEmpty()) {
            string5 = " " + string2.trim() + " ";
        }
        if (map != null && !string5.contains(REPLACE_SQL_RES_WORDS_FLAG)) {
            string5 = string5 + " REPLACE_SQL_RES_WORDS=T ";
        }
        if (sPARQLFeatureConfig == null) {
            sPARQLFeatureConfig = SPARQLFeatureConfig.getDefaultConfig();
        }
        StringBuffer stringBuffer = new StringBuffer().append("\n").append("----------------- sparqlToSql ----------------\n").append("query=[" + string + "]\n").append("model=[" + rDFModelMetadata.modelName + "]\n").append("options=[" + string5 + "]\n").append("defaultUris=").append(Arrays.toString(stringArray)).append("\n").append("ngUris=[").append(Arrays.toString(stringArray2)).append("\n").append("sfConfig=[").append("\n").append(sPARQLFeatureConfig.toString()).append("\n]\n").append("networkOwner=[").append(string3).append("]\n").append("networkName=[").append(string4).append("]\n").append("----------------------------------------------\n");
        LogUtils.debug((String)(CLASS_LOG_PFX + stringBuffer.toString()), (RDFLogger)rDFLogger);
        int n = 5;
        TranslateEngine translateEngine = new TranslateEngine(n, connection);
        translateEngine.setOptions(string5);
        String string6 = DEFAULT_RULES_INDEX_STATUS;
        String string7 = rDFModelMetadata.modelName;
        long l = rDFModelMetadata.modelId;
        String string8 = rDFModelMetadata.modelOwner;
        String string9 = rDFModelMetadata.modelType;
        String string10 = rDFModelMetadata.appTabName;
        String string11 = rDFModelMetadata.tripleColName;
        String string12 = rDFModelMetadata.uniqueViewName;
        String string13 = rDFModelMetadata.dupViewName;
        boolean bl = rDFModelMetadata.usesIMVC;
        String string14 = "";
        if (string5 != null) {
            string14 = string5.toUpperCase();
        }
        String string15 = SPARQLClientUtils.getVmViewName(rDFModelMetadata, string14);
        int n2 = 0;
        int[] nArray = new int[]{0};
        if (string9.equals("D") && !string14.contains("RDB2RDF_METADATA=T")) {
            n2 = 1;
            nArray[0] = 1;
        }
        HashMap hashMap = SPARQLEngine.setupNamespaceMap();
        long[][] lArrayArray = new long[1][];
        long[][] lArrayArray2 = new long[1][];
        String string16 = SPARQLClientUtils.addPfxForRdfObjName("RDF_VALUE$", string3, string4);
        SPARQLClientUtils.populateGraphIds(connection, string, translateEngine, hashMap, stringArray, stringArray2, string16, lArrayArray, lArrayArray2);
        long[] lArray = lArrayArray[0];
        long[] lArray2 = lArrayArray2[0];
        int[] nArray2 = null;
        String[] stringArray3 = new String[]{string7};
        String string17 = null;
        long l2 = 0L;
        long[] lArray3 = new long[]{};
        Object[] objectArray = new String[]{};
        String[][] stringArray4 = new String[1][];
        int[] nArray3 = new int[1];
        ArrayList arrayList = new ArrayList();
        String[] stringArray5 = new String[1];
        String string18 = "\nCalling translateQueryPattern:\n            plist=" + Arrays.toString(nArray2) + "\n            query=[" + string + "]\n precompIndexName=[" + string17 + "]\n     precompIdxID=[" + l2 + "]\n        idxStatus=[" + string6 + "]\n            dGIDs=" + Arrays.toString(lArray) + "\n            nGIDs=" + Arrays.toString(lArray2) + "\n            dMIDs=" + Arrays.toString(lArray3) + "\n          dModels=" + Arrays.toString(objectArray) + "\n       vmViewName=[" + string15 + "]\n      model_types=" + Arrays.toString(nArray) + "\n     isRdfVWModel=[" + n2 + "]";
        LogUtils.debug((String)(CLASS_LOG_PFX + string18), (RDFLogger)rDFLogger);
        SQLGenContext sQLGenContext = SPARQLClientUtils.buildSqlGenCtxFromRDFMdata(rDFModelMetadata);
        SPARQLClientUtils.setEnabledFeaturesInCtx(sPARQLFeatureConfig, sQLGenContext);
        sQLGenContext.bvInfo = oraBindValueInfo;
        String string19 = translateEngine.translateQueryPattern(nArray2, string, stringArray3, string17, l2, string6, lArray, lArray2, lArray3, (String[])objectArray, hashMap, string15, stringArray4, nArray3, arrayList, stringArray5, nArray, n2, map, sPMComponents, sQLGenContext, string3, string4);
        return string19;
    }

    public static boolean executeSparqlUpdate(Connection connection, String string, String string2, String string3, String string4, String string5, String string6, String string7) throws SQLException, RDFException, ParseException {
        return SPARQLClientUtils.executeSparqlUpdate(connection, string, string2, string3, string4, string5, string6, string7, null);
    }

    public static boolean executeSparqlUpdate(Connection connection, String string, String string2, String string3, String string4, String string5, String string6, String string7, RDFLogger rDFLogger) throws SQLException, RDFException, ParseException {
        return SPARQLClientUtils.executeSparqlUpdate(connection, string, string2, string3, string4, string5, string6, string7, rDFLogger, null);
    }

    public static boolean executeSparqlUpdate(Connection connection, String string, String string2, String string3, String string4, String string5, String string6, String string7, RDFLogger rDFLogger, Observable observable) throws SQLException, RDFException, ParseException {
        RDFModelMetadata rDFModelMetadata = SPARQLClientUtils.populateRDFModelMetadata(connection, string2, string6, string7, rDFLogger);
        RDFModelMetadata rDFModelMetadata2 = null;
        if (string3 != null) {
            rDFModelMetadata2 = SPARQLClientUtils.populateRDFModelMetadata(connection, string3, string6, string7, rDFLogger);
        }
        return SPARQLClientUtils.executeSparqlUpdate(connection, string, rDFModelMetadata, rDFModelMetadata2, string4, string5, rDFLogger, observable);
    }

    public static boolean executeSparqlUpdate(Connection connection, String string, RDFModelMetadata rDFModelMetadata, RDFModelMetadata rDFModelMetadata2, String string2, String string3, RDFLogger rDFLogger) throws SQLException, RDFException, ParseException {
        return SPARQLClientUtils.executeSparqlUpdate(connection, string, rDFModelMetadata, rDFModelMetadata2, string2, string3, rDFLogger, null);
    }

    public static boolean executeSparqlUpdate(Connection connection, String string, RDFModelMetadata rDFModelMetadata, RDFModelMetadata rDFModelMetadata2, String string2, String string3, RDFLogger rDFLogger, Observable observable) throws SQLException, RDFException, ParseException {
        if (rDFModelMetadata == null || rDFModelMetadata.modelName == null) {
            throw new RDFException(NULL_MODEL_MSG);
        }
        if (string == null) {
            throw new RDFException(NULL_SPARQL_MSG);
        }
        String string4 = rDFModelMetadata.networkOwner;
        String string5 = rDFModelMetadata.networkName;
        long l = System.currentTimeMillis();
        LogUtils.debug((String)("oracle.spatial.rdf.client.SPARQLClientUtils: SPARQL update params: network owner [" + string4 + "], network name [" + string5 + "], model [" + rDFModelMetadata.modelName + "]"), (RDFLogger)rDFLogger);
        LogUtils.debug((String)("oracle.spatial.rdf.client.SPARQLClientUtils: SPARQL update: " + string), (RDFLogger)rDFLogger);
        String string6 = rDFModelMetadata.modelName;
        RDFModelMetadata rDFModelMetadata3 = rDFModelMetadata;
        if (rDFModelMetadata2 != null) {
            rDFModelMetadata3 = rDFModelMetadata2;
        }
        String string7 = rDFModelMetadata3.modelName;
        LogUtils.debug((String)"oracle.spatial.rdf.client.SPARQLClientUtils: getting row source info for apply model", (RDFLogger)rDFLogger);
        long l2 = rDFModelMetadata.modelId;
        String string8 = rDFModelMetadata.modelOwner;
        String string9 = rDFModelMetadata.modelType;
        String string10 = rDFModelMetadata.appTabName;
        String string11 = rDFModelMetadata.tripleColName;
        String string12 = rDFModelMetadata.uniqueViewName;
        String string13 = rDFModelMetadata.dupViewName;
        boolean bl = rDFModelMetadata.usesIMVC;
        long l3 = rDFModelMetadata3.modelId;
        String string14 = rDFModelMetadata3.modelOwner;
        String string15 = rDFModelMetadata3.modelType;
        String string16 = rDFModelMetadata3.appTabName;
        String string17 = rDFModelMetadata3.tripleColName;
        String string18 = rDFModelMetadata3.uniqueViewName;
        String string19 = rDFModelMetadata3.dupViewName;
        boolean bl2 = rDFModelMetadata3.usesIMVC;
        String string20 = "";
        if (string2 != null) {
            string20 = " " + string2.toUpperCase() + " ";
        }
        if (!string20.contains(REPLACE_SQL_RES_WORDS_FLAG)) {
            string20 = string20 + " REPLACE_SQL_RES_WORDS=T ";
        }
        String string21 = "";
        if (string3 != null) {
            string21 = string3;
        }
        String string22 = SPARQLClientUtils.getVmViewName(rDFModelMetadata3, string20);
        int n = 0;
        if (string15.equals("D") && !string20.contains("RDB2RDF_METADATA=T")) {
            n = 1;
        }
        String string23 = rDFModelMetadata.networkTablespace;
        String string24 = rDFModelMetadata.currSchema;
        String string25 = rDFModelMetadata.currUser;
        long l4 = System.currentTimeMillis();
        LogUtils.debug((String)("oracle.spatial.rdf.client.SPARQLClientUtils: time to get metadata information (ms): " + (l4 - l)), (RDFLogger)rDFLogger);
        SQLGenContext sQLGenContext = SPARQLClientUtils.buildSqlGenCtxFromRDFMdata(rDFModelMetadata3);
        UpdateEngine updateEngine = new UpdateEngine(connection, string6, l2, string8, string10, string11, new String[]{string7}, null, 0L, DEFAULT_RULES_INDEX_STATUS, string22, n, string20, string21, string24, string25, string23, 0, true, sQLGenContext, observable, string4, string5);
        long l5 = System.currentTimeMillis();
        LogUtils.debug((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Time to initialize update engine (ms): " + (l5 - l4)), (RDFLogger)rDFLogger);
        updateEngine.doUpdate(string);
        long l6 = System.currentTimeMillis();
        LogUtils.debug((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Time to execute SPARQL update (ms): " + (l6 - l5)), (RDFLogger)rDFLogger);
        LogUtils.debug((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Total time for SPARQL update (ms): " + (l6 - l)), (RDFLogger)rDFLogger);
        return true;
    }

    private static String getVmViewName(RDFModelMetadata rDFModelMetadata, String string) throws SQLException {
        String string2 = null;
        if (rDFModelMetadata.modelType.equals("V")) {
            string2 = string.contains("ALLOW_DUP=T") ? rDFModelMetadata.networkOwner + "." + QueryUtils.simpleSQLName((String)rDFModelMetadata.dupViewName, (int)128) : rDFModelMetadata.networkOwner + "." + QueryUtils.simpleSQLName((String)rDFModelMetadata.uniqueViewName, (int)128);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getRowSourceInfo(Connection connection, String string, long[] lArray, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, String[] stringArray6, boolean[] blArray, String string2, String string3, RDFLogger rDFLogger) throws SQLException, RDFException {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            String string4 = SPARQLClientUtils.addPfxForRdfObjName("RDF_MODEL$", string2, string3);
            String string5 = SPARQLClientUtils.addPfxForRdfObjName("SEM_VMODEL_INFO", string2, string3);
            OracleDatabaseVersion oracleDatabaseVersion = QueryUtils.getDatabaseVersion((Connection)connection);
            String string6 = "";
            if (oracleDatabaseVersion.isCompatible(OracleDatabaseVersion.V_18c)) {
                string6 = ", m.inmemory ";
            }
            String string7 = "SELECT m.model_id, m.owner, m.model_type, m.table_name, m.column_name, v.unique_view_name, v.duplicate_view_name " + string6 + "FROM " + string4 + " m, " + string5 + " v WHERE m.model_name = v.virtual_model_name(+) AND m.model_name = ?";
            statement = connection.prepareStatement(string7);
            statement.setString(1, string);
            LogUtils.debug((String)("oracle.spatial.rdf.client.SPARQLClientUtils: RowSourceInfo SQL: " + string7), (RDFLogger)rDFLogger);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                lArray[0] = resultSet.getLong(1);
                stringArray[0] = resultSet.getString(2);
                stringArray2[0] = resultSet.getString(3);
                stringArray3[0] = resultSet.getString(4);
                stringArray4[0] = resultSet.getString(5);
                stringArray5[0] = resultSet.getString(6);
                stringArray6[0] = resultSet.getString(7);
                blArray[0] = false;
                if (oracleDatabaseVersion.isCompatible(OracleDatabaseVersion.V_18c)) {
                    blArray[0] = "T".equals(resultSet.getString(8));
                }
            } else {
                LogUtils.error((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Unable to find model: " + string), (RDFLogger)rDFLogger);
                throw new RDFException(MODEL_NOT_EXIST_MSG);
            }
            String string8 = "\n---------------- Row Source Info -----------------\n   modelName=[" + string + "]\n     modelId=[" + lArray[0] + "]\n  modelOwner=[" + stringArray[0] + "]\n   modelType=[" + stringArray2[0] + "]\n   tableName=[" + stringArray3[0] + "]\n  columnName=[" + stringArray4[0] + "]\n    usesIMVC=[" + blArray[0] + "]\nvmUniqueView=[" + stringArray5[0] + "]\n   vmDupView=[" + stringArray6[0] + "]\n--------------------------------------------------";
            LogUtils.debug((String)(CLASS_LOG_PFX + string8), (RDFLogger)rDFLogger);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing rs:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing ps:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
            }
        }
    }

    private static void populateGraphIds(Connection connection, String string, TranslateEngine translateEngine, HashMap hashMap, String[] stringArray, String[] stringArray2, String string2, long[][] lArray, long[][] lArray2) throws SQLException, RDFException, ParseException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add("<" + stringArray[i] + ">");
            }
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (stringArray2 != null) {
            for (int i = 0; i < stringArray2.length; ++i) {
                arrayList2.add("<" + stringArray2[i] + ">");
            }
        }
        translateEngine.getSources(string, hashMap, arrayList, arrayList2);
        URIset uRIset = new URIset();
        for (String string3 : arrayList) {
            uRIset.put(string3.substring(1, string3.length() - 1));
        }
        for (String string3 : arrayList2) {
            uRIset.put(string3.substring(1, string3.length() - 1));
        }
        uRIset.resolve(connection, string2);
        Object object = new long[arrayList.size()];
        int n = 0;
        for (String object2 : arrayList) {
            String string3 = uRIset.get(object2.substring(1, object2.length() - 1));
            object[n] = string3 != null ? (Object)Long.parseLong(string3) : (Object)0L;
            ++n;
        }
        Object object3 = new long[arrayList2.size()];
        n = 0;
        for (String string3 : arrayList2) {
            String string4 = uRIset.get(string3.substring(1, string3.length() - 1));
            object3[n] = string4 != null ? (Object)Long.parseLong(string4) : (Object)0L;
            ++n;
        }
        lArray[0] = (long[])object;
        lArray2[0] = (long[])object3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getCurrentSchema(Connection connection, RDFLogger rDFLogger) throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        String string = null;
        try {
            String string2 = "select sys_context('userenv','current_schema') from sys.dual";
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            if (resultSet.next()) {
                string = resultSet.getString(1);
            }
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing rs:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing stmt:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getCurrentUser(Connection connection, RDFLogger rDFLogger) throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        String string = null;
        try {
            String string2 = "select sys_context('userenv','current_user') from sys.dual";
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            if (resultSet.next()) {
                string = resultSet.getString(1);
            }
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing rs:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing stmt:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getNetTablespace(Connection connection, String string, String string2, RDFLogger rDFLogger) throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string3 = null;
        String string4 = QueryUtils.getNetworkNamePfx((String)string2) + "RDF_VALUE$";
        String string5 = QueryUtils.getNetworkOwnerOrMdsys((String)string);
        try {
            String string6 = "select /*+ result_cache dynamic_sampling(0) parallel(1) */ tablespace_name from sys.all_tables where table_name=? and owner=?";
            preparedStatement = connection.prepareStatement(string6);
            preparedStatement.setString(1, string4);
            preparedStatement.setString(2, QueryUtils.checkRemoveEnclosingQuotes((String)string5));
            resultSet = preparedStatement.executeQuery();
            String string7 = null;
            if (resultSet.next()) {
                string7 = resultSet.getString(1);
            }
            string3 = QueryUtils.enquoteNameSQLName(string7);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing rs:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
            }
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException sQLException) {
                LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing ps:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
            }
        }
        return string3;
    }

    static String addPfxForRdfObjName(String string, String string2, String string3) throws SQLException {
        String string4 = QueryUtils.validateAndGetPfxForRdfObjName((String)string2, (String)string3);
        return string4 + QueryUtils.simpleSQLName((String)string, (int)30);
    }

    private static SQLGenContext buildSqlGenCtxFromRDFMdata(RDFModelMetadata rDFModelMetadata) {
        SQLGenContext sQLGenContext = null;
        if (rDFModelMetadata != null) {
            sQLGenContext = new SQLGenContext();
            sQLGenContext.clnNetworkOwner = rDFModelMetadata.networkOwner;
            sQLGenContext.clnNetworkName = rDFModelMetadata.networkName;
            sQLGenContext.networkStorageForm = rDFModelMetadata.networkStorageForm;
            sQLGenContext.orderColsPopulated = rDFModelMetadata.orderColsPopulated;
            sQLGenContext.srid = rDFModelMetadata.srid;
            sQLGenContext.matSpaIdx = rDFModelMetadata.hasMatSpaIdx;
            sQLGenContext.geoColumn = rDFModelMetadata.geoColumn;
            sQLGenContext.geoTolerance = rDFModelMetadata.geoTolerance;
            sQLGenContext.geoDimension = rDFModelMetadata.geoDimension;
            if (rDFModelMetadata.usesIMVC || rDFModelMetadata.usesMV) {
                sQLGenContext.contextFlags |= 8;
            }
            sQLGenContext.spmTabColMap = rDFModelMetadata.spmTabColMap;
            sQLGenContext.lateralPPOptEnabled = rDFModelMetadata.sdoRdfPPExists;
            sQLGenContext.lateralPPRangeOptEnabled = rDFModelMetadata.sdoRdfPPRangeEnabled;
            sQLGenContext.setModelMetadataInited(true);
        }
        return sQLGenContext;
    }

    private static void setEnabledFeaturesInCtx(SPARQLFeatureConfig sPARQLFeatureConfig, SQLGenContext sQLGenContext) {
        sQLGenContext.udfEnabled = sPARQLFeatureConfig.udfEnabled;
        sQLGenContext.overloadedServiceEnabled = sPARQLFeatureConfig.overloadedServiceEnabled;
    }

    public static void analyzeSPARQLWorkloadForSPM(Connection connection, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, RDFLogger rDFLogger) throws SQLException, RDFException, ParseException {
        Object object;
        Object object22;
        Object object3;
        Object object4;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Object var14_14 = null;
        String string11 = null;
        String string12 = null;
        String string13 = null;
        String string14 = null;
        String string15 = null;
        String string16 = null;
        string11 = QueryUtils.validateSQLName((String)string, (boolean)false, (int)128);
        string12 = QueryUtils.validateSQLName((String)string2, (boolean)false, (int)128);
        string13 = QueryUtils.validateSQLName((String)string3, (boolean)false, (int)128);
        string14 = QueryUtils.validateSQLName((String)string4, (boolean)false, (int)128);
        string15 = QueryUtils.validateSQLName((String)string5, (boolean)false, (int)128);
        string16 = QueryUtils.validateSQLName((String)string6, (boolean)true, (int)124);
        String string17 = "SELECT " + string13 + " FROM " + string11 + "." + string12;
        SPMComponents sPMComponents = new SPMComponents();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        RDFModelMetadata rDFModelMetadata = SPARQLClientUtils.populateRDFModelMetadata(connection, string7, string9, string10, rDFLogger);
        try {
            preparedStatement = connection.prepareStatement(string17);
            resultSet = preparedStatement.executeQuery();
            int n = 1;
            while (resultSet.next()) {
                object4 = resultSet.getString(1);
                try {
                    object3 = SPARQLClientUtils.sparqlToSql(connection, (String)object4, rDFModelMetadata, string8, new String[0], new String[0], hashMap, sPMComponents, rDFLogger, null, null);
                }
                catch (RDFException rDFException) {
                    String string18 = "Error with query number " + n + "\nQuery: " + (String)object4 + "\nError: " + ((Object)((Object)rDFException)).getClass().toString() + ": " + rDFException.getMessage();
                    throw new RDFException(string18, (Throwable)rDFException);
                }
                ++n;
                LogUtils.debug((String)("oracle.spatial.rdf.client.SPARQLClientUtils: SPARQL:" + (String)object4), (RDFLogger)rDFLogger);
                LogUtils.debug((String)("oracle.spatial.rdf.client.SPARQLClientUtils: svpClusters:" + sPMComponents.getSvpClusters()), (RDFLogger)rDFLogger);
            }
        }
        catch (SQLException sQLException) {
            String string19 = String.format(UNABLE_TO_READ_ERR, string13, string11, string12);
            throw new RDFException(string19, (Throwable)sQLException);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing rs:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
            }
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException sQLException) {
                LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing ps:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
            }
        }
        String string20 = "SELECT PRED_NAME FROM " + string14 + "." + string15 + " WHERE max_cnt > 1";
        object4 = new HashSet();
        try {
            preparedStatement = connection.prepareStatement(string20);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object3 = resultSet.getString(1);
                object4.add(object3);
                LogUtils.debug((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Pred with max_cnt > 1:" + (String)object3), (RDFLogger)rDFLogger);
            }
        }
        catch (SQLException sQLException) {
            String string21 = String.format(UNABLE_TO_READ_ERR, "PRED_NAME", string14, string15);
            throw new RDFException(string21, (Throwable)sQLException);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing rs:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
            }
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException sQLException) {
                LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing ps:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
            }
        }
        object3 = new HashMap();
        for (Object object22 : sPMComponents.getSvpClusters()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator iterator = object22.iterator();
            while (iterator.hasNext()) {
                String string22 = (String)iterator.next();
                if (object4.contains(string22)) continue;
                arrayList.add(string22);
            }
            int n = arrayList.size();
            if (n <= 1) continue;
            object = new ArrayList();
            long l = (long)Math.pow(2.0, n);
            for (long i = 0L; i < l; ++i) {
                int n2;
                TreeSet treeSet = new TreeSet();
                for (n2 = 0; n2 < n; ++n2) {
                    if ((i & 1L << n2) <= 0L) continue;
                    treeSet.add(arrayList.get(n2));
                }
                if (treeSet.size() <= 1) continue;
                if (!((HashMap)object3).containsKey(treeSet)) {
                    ((HashMap)object3).put(treeSet, 1);
                    continue;
                }
                n2 = (Integer)((HashMap)object3).get(treeSet);
                ((HashMap)object3).put(treeSet, n2 + 1);
            }
        }
        LogUtils.debug((String)("oracle.spatial.rdf.client.SPARQLClientUtils: svpClusters updated:" + sPMComponents.getSvpClusters()), (RDFLogger)rDFLogger);
        LogUtils.debug((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Count Clusters:" + object3), (RDFLogger)rDFLogger);
        int n = 500;
        for (String string23 : string8.split(" ")) {
            if (!string23.contains(INS_BATCH_SIZE)) continue;
            object = string23.split("=")[1];
            try {
                n = Integer.parseInt((String)object);
                break;
            }
            catch (NumberFormatException numberFormatException) {
                String string24 = "Invalid INS_BATCH_SIZE option value: " + (String)object;
                throw new RDFException(string24, (Throwable)numberFormatException);
            }
        }
        SPARQLClientUtils.populateResultsTable(connection, string16, (HashMap<? extends Collection<String>, Integer>)object3, "SVP", n, rDFLogger);
        object22 = new HashMap();
        for (List list : sPMComponents.getPcnSequences()) {
            if (!((HashMap)object22).containsKey(list)) {
                ((HashMap)object22).put(list, 1);
                continue;
            }
            int n3 = (Integer)((HashMap)object22).get(list);
            ((HashMap)object22).put(list, n3 + 1);
        }
        LogUtils.debug((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Count Sequences:" + object22), (RDFLogger)rDFLogger);
        SPARQLClientUtils.populateResultsTable(connection, string16, (HashMap<? extends Collection<String>, Integer>)object22, "PCN", n, rDFLogger);
    }

    private static void populateResultsTable(Connection connection, String string, HashMap<? extends Collection<String>, Integer> hashMap, String string2, int n, RDFLogger rDFLogger) throws SQLException, RDFException, ParseException {
        Statement statement = null;
        Statement statement2 = null;
        String string3 = string2.equals("SVP") ? "SVP" : "PCN";
        String string4 = string + "_" + string3;
        String string5 = string2.equals("SVP") ? "svp_cluster" : "pcn_sequence";
        String string6 = "CREATE TABLE " + string4 + "(" + string5 + " varchar2(4000), occ_count number)";
        try {
            statement = connection.createStatement();
            statement.executeUpdate(string6);
            String string7 = "INSERT INTO " + string4 + " VALUES (?, ?)";
            LogUtils.debug((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Insert statement:" + string7), (RDFLogger)rDFLogger);
            statement2 = connection.prepareStatement(string7);
            int n2 = hashMap.size();
            Iterator<Map.Entry<? extends Collection<String>, Integer>> iterator = hashMap.entrySet().iterator();
            int n3 = 0;
            while (iterator.hasNext()) {
                Map.Entry<? extends Collection<String>, Integer> entry = iterator.next();
                int n4 = entry.getValue();
                String string8 = String.join((CharSequence)",", (Iterable<? extends CharSequence>)entry.getKey());
                statement2.setString(1, string8);
                statement2.setInt(2, n4);
                statement2.addBatch();
                if (n3 != 0 && n3 % n == 0 || n3 == n2 - 1) {
                    statement2.executeBatch();
                }
                ++n3;
            }
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == 955) {
                String string9 = string4 + " already exists. Drop this table or use a different name.";
                throw new RDFException(string9, (Throwable)sQLException);
            }
            throw sQLException;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing stmt:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
            }
            try {
                if (statement2 != null) {
                    statement2.close();
                }
            }
            catch (SQLException sQLException) {
                LogUtils.warn((String)("oracle.spatial.rdf.client.SPARQLClientUtils: Exception found closing ps:" + sQLException.getMessage()), (RDFLogger)rDFLogger);
            }
        }
    }
}

