/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.client;

import java.util.regex.Pattern;
import oracle.spatial.rdf.client.InvalidResourceException;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.RDFException;

public final class SPARQLAssert {
    private static final String IRI_REF = "<[^<>\"\\{\\}\\|\\^`\\\\\\x00-\\x20]*>";
    private static final Pattern IRI_PATTERN = Pattern.compile("^<[^<>\"\\{\\}\\|\\^`\\\\\\x00-\\x20]*>$");
    private static final String PN_CHARS_BASE = "[a-zA-Z\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{EFFFF}]";
    private static final String PN_CHARS_U = "[a-zA-Z\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{EFFFF}]|[_]";
    private static final String PN_CHARS = "[a-zA-Z\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{EFFFF}]|[_]|[-]|[0-9\\u00B7\\u0300-\\u036F\\u203F-\\u2040]";
    private static final Pattern BNODE_PATTERN = Pattern.compile("^_:[[a-zA-Z\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{EFFFF}]|[_]|[0-9]](?:(?:[a-zA-Z\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{EFFFF}]|[_]|[-]|[0-9\\u00B7\\u0300-\\u036F\\u203F-\\u2040]|[\\.])*[[a-zA-Z\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{EFFFF}]|[_]|[-]|[0-9\\u00B7\\u0300-\\u036F\\u203F-\\u2040]])?$");
    private static final String ECHAR = "(?:\\\\[tbnrf\\\\\"'])";
    private static final String HEX = "[0-9A-Za-z]";
    private static final String ESC_UNICODE = "(?:\\\\u[0-9A-Za-z][0-9A-Za-z][0-9A-Za-z][0-9A-Za-z])";
    private static final String ESC_UNICODE_LONG = "(?:\\\\U[0-9A-Za-z][0-9A-Za-z][0-9A-Za-z][0-9A-Za-z][0-9A-Za-z][0-9A-Za-z][0-9A-Za-z][0-9A-Za-z])";
    private static final String LANGTAG = "@[a-zA-Z]+(:?-[a-zA-Z0-9]+)*";
    private static final String PLAIN_LIT = "\"(?:[^\\x22\\x5C\\x0A\\x0D]|(?:\\\\[tbnrf\\\\\"'])|(?:\\\\u[0-9A-Za-z][0-9A-Za-z][0-9A-Za-z][0-9A-Za-z])|(?:\\\\U[0-9A-Za-z][0-9A-Za-z][0-9A-Za-z][0-9A-Za-z][0-9A-Za-z][0-9A-Za-z][0-9A-Za-z][0-9A-Za-z]))*\"";
    private static final Pattern PLAIN_LIT_PATTERN = Pattern.compile("^\"(?:[^\\x22\\x5C\\x0A\\x0D]|(?:\\\\[tbnrf\\\\\"'])|(?:\\\\u[0-9A-Za-z][0-9A-Za-z][0-9A-Za-z][0-9A-Za-z])|(?:\\\\U[0-9A-Za-z][0-9A-Za-z][0-9A-Za-z][0-9A-Za-z][0-9A-Za-z][0-9A-Za-z][0-9A-Za-z][0-9A-Za-z]))*\"$");
    private static final Pattern LIT_PATTERN = Pattern.compile("^\"(?:[^\\x22\\x5C\\x0A\\x0D]|(?:\\\\[tbnrf\\\\\"'])|(?:\\\\u[0-9A-Za-z][0-9A-Za-z][0-9A-Za-z][0-9A-Za-z])|(?:\\\\U[0-9A-Za-z][0-9A-Za-z][0-9A-Za-z][0-9A-Za-z][0-9A-Za-z][0-9A-Za-z][0-9A-Za-z][0-9A-Za-z]))*\"(:?(:?@[a-zA-Z]+(:?-[a-zA-Z0-9]+)*)|(?:\\^\\^<[^<>\"\\{\\}\\|\\^`\\\\\\x00-\\x20]*>))?$");

    public static String iri(String string) throws InvalidResourceException {
        String string2 = null;
        if (!IRI_PATTERN.matcher(string).matches()) {
            throw new InvalidResourceException("Invalid IRI: " + string);
        }
        string2 = string;
        return string2;
    }

    public static String bNode(String string) throws InvalidResourceException {
        String string2 = null;
        if (!BNODE_PATTERN.matcher(string).matches()) {
            throw new InvalidResourceException("Invalid bNode: " + string);
        }
        string2 = string;
        return string2;
    }

    public static String rdfLiteral(String string) throws InvalidResourceException {
        String string2 = null;
        if (!LIT_PATTERN.matcher(string).matches()) {
            throw new InvalidResourceException("Invalid RDF literal: " + string);
        }
        string2 = string;
        return string2;
    }

    public static String enquoteRDFLiteral(String string) throws InvalidResourceException {
        String string2 = string;
        try {
            string2 = QueryUtils.unescapeUnicode((String)string2);
            string2 = QueryUtils.escapeSpecialChars((String)string2);
            string2 = "\"" + string2 + "\"";
        }
        catch (RDFException rDFException) {
            throw new InvalidResourceException(rDFException.getMessage());
        }
        return SPARQLAssert.rdfLiteral(string2);
    }
}

