/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.client;

import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.spatial.rdf.client.RDFModelMetadata;
import oracle.spatial.rdf.client.SPARQLClientUtils;
import oracle.spatial.rdf.client.SPARQLFeatureConfig;
import oracle.spatial.rdf.server.LogUtils;
import oracle.spatial.rdf.server.OraBindValueInfo;
import oracle.spatial.rdf.server.OraBindValueProcessor;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.RDFLogger;
import oracle.spatial.rdf.server.parser.sparql.ParseException;

public class CompiledSPARQL {
    private static final String CLASS_LOG_PFX = "oracle.spatial.rdf.client.CompiledSPARQL: ";
    RDFModelMetadata modelMdata;
    RDFLogger logger;
    SPARQLFeatureConfig sfConfig;
    String sparql;
    String options;
    String[] defaultUris;
    String[] ngUris;
    OraBindValueProcessor bindValueProc;
    String rdfValueTabName;
    String sqlTranslation;
    Map<String, String> varToResWordMap;

    CompiledSPARQL(String string, RDFModelMetadata rDFModelMetadata, String string2, String[] stringArray, String[] stringArray2, RDFLogger rDFLogger, SPARQLFeatureConfig sPARQLFeatureConfig) throws SQLException {
        this.modelMdata = rDFModelMetadata;
        this.sparql = string;
        this.options = string2;
        this.defaultUris = stringArray;
        this.ngUris = stringArray2;
        this.logger = rDFLogger;
        this.sfConfig = sPARQLFeatureConfig;
        this.varToResWordMap = new HashMap<String, String>();
        this.rdfValueTabName = SPARQLClientUtils.addPfxForRdfObjName("RDF_VALUE$", this.modelMdata.networkOwner, this.modelMdata.networkName);
        LogUtils.debug((String)("oracle.spatial.rdf.client.CompiledSPARQL: rdfValueTabName set in constructor [" + this.rdfValueTabName + "]"), (RDFLogger)rDFLogger);
        this.bindValueProc = new OraBindValueProcessor();
    }

    public String getSqlTranslation() {
        return this.sqlTranslation;
    }

    public String getSparql() {
        return this.sparql;
    }

    public String getOptions() {
        return this.options;
    }

    public SPARQLFeatureConfig getSPARQLFeatureConfig() {
        return this.sfConfig;
    }

    public OraBindValueInfo newBindValueInfo() {
        return new OraBindValueInfo(this.modelMdata.networkStorageForm, this.modelMdata.modelType, this.modelMdata.usesIMVC);
    }

    public void translateQuery(Connection connection, Map<String, String> map) throws SQLException, RDFException, ParseException {
        this.translateQuery(connection, this.newBindValueInfo(), map);
    }

    public synchronized void translateQuery(Connection connection, OraBindValueInfo oraBindValueInfo, Map<String, String> map) throws SQLException, RDFException, ParseException {
        if (this.sqlTranslation == null) {
            LogUtils.debug((String)"oracle.spatial.rdf.client.CompiledSPARQL:  translating query", (RDFLogger)this.logger);
            String string = this.options;
            this.bindValueProc.setBvTypeInfo(oraBindValueInfo);
            String string2 = SPARQLClientUtils.sparqlToSql(connection, this.sparql, this.modelMdata, string, this.defaultUris, this.ngUris, map, null, this.logger, this.sfConfig, oraBindValueInfo);
            LogUtils.debug((String)("oracle.spatial.rdf.client.CompiledSPARQL:  translated query: " + string2), (RDFLogger)this.logger);
            LogUtils.debug((String)"oracle.spatial.rdf.client.CompiledSPARQL:  processing encoded bind vars", (RDFLogger)this.logger);
            string2 = this.bindValueProc.processEncodedBindVars(string2);
            LogUtils.debug((String)("oracle.spatial.rdf.client.CompiledSPARQL:  OraBindValueProcessor: " + this.bindValueProc.toString()), (RDFLogger)this.logger);
            LogUtils.debug((String)("oracle.spatial.rdf.client.CompiledSPARQL:  updated translated query: " + string2), (RDFLogger)this.logger);
            this.sqlTranslation = string2;
            if (map != null) {
                this.varToResWordMap.clear();
                this.varToResWordMap.putAll(map);
                LogUtils.debug((String)("oracle.spatial.rdf.client.CompiledSPARQL:  saving reserved word mappings: " + this.varToResWordMap.toString()), (RDFLogger)this.logger);
            }
        }
    }

    public PreparedStatement generatePreparedStmt(Connection connection, Map<String, String> map) throws SQLException, RDFException, ParseException {
        return this.generatePreparedStmt(connection, this.newBindValueInfo(), map);
    }

    public PreparedStatement generatePreparedStmt(Connection connection, OraBindValueInfo oraBindValueInfo, Map<String, String> map) throws SQLException, RDFException, ParseException {
        PreparedStatement preparedStatement = null;
        if (this.sqlTranslation == null) {
            LogUtils.debug((String)"oracle.spatial.rdf.client.CompiledSPARQL:  sqlTranslation is NULL ... translating query", (RDFLogger)this.logger);
            this.translateQuery(connection, oraBindValueInfo, map);
        }
        if (map != null) {
            LogUtils.debug((String)"oracle.spatial.rdf.client.CompiledSPARQL:  populating input reserved word map with saved mappings", (RDFLogger)this.logger);
            map.putAll(this.varToResWordMap);
        }
        LogUtils.debug((String)"oracle.spatial.rdf.client.CompiledSPARQL:  creating JDBC PreparedStatement", (RDFLogger)this.logger);
        preparedStatement = connection.prepareStatement(this.sqlTranslation);
        LogUtils.debug((String)"oracle.spatial.rdf.client.CompiledSPARQL:  returning SQL PreparedStatement ", (RDFLogger)this.logger);
        return preparedStatement;
    }

    public void setBindValsInPreparedStmt(Connection connection, PreparedStatement preparedStatement, OraBindValueInfo oraBindValueInfo, List<Clob> list) throws SQLException, RDFException {
        this.bindValueProc.validateBindValueInfo(oraBindValueInfo);
        LogUtils.debug((String)"oracle.spatial.rdf.client.CompiledSPARQL:  resolving value_ids ...", (RDFLogger)this.logger);
        oraBindValueInfo.resolveValueIds(connection, this.rdfValueTabName);
        LogUtils.debug((String)"oracle.spatial.rdf.client.CompiledSPARQL:  ... finished resolving value_ids", (RDFLogger)this.logger);
        LogUtils.debug((String)("oracle.spatial.rdf.client.CompiledSPARQL:  setting SQL bind values " + this.bindValueProc.toString()), (RDFLogger)this.logger);
        this.bindValueProc.setSQLBindVals(connection, preparedStatement, oraBindValueInfo, list);
    }
}

