/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.bookmarks;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import oracle.ide.bookmarks.Bookmark;
import oracle.ide.bookmarks.BookmarkEvent;
import oracle.ide.bookmarks.BookmarkManager;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.bookmarks.Bookmarks;
import oracle.ide.ceditor.bookmarks.CodeEditorBookmark;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.language.AbstractLanguageSupport;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.OffsetDescriptionProvider;

final class BookmarkDescriptionUpdater {
    private DocumentL documentL = new DocumentL();
    private Map<CodeEditor, Integer> editorChangeIdMap = new HashMap<CodeEditor, Integer>();

    BookmarkDescriptionUpdater() {
        EditorManager.getEditorManager().addEditorListener(new EditorListener(){

            public void editorOpened(Editor editor) {
                if (editor instanceof CodeEditor) {
                    CodeEditor codeEditor = (CodeEditor)editor;
                    codeEditor.getFocusedEditorPane().getDocument().addDocumentListener(BookmarkDescriptionUpdater.this.documentL);
                    BookmarkDescriptionUpdater.this.editorChangeIdMap.put(codeEditor, BookmarkDescriptionUpdater.this.getChangeId(codeEditor));
                }
            }

            public void editorClosed(Editor editor) {
                if (editor instanceof CodeEditor) {
                    CodeEditor codeEditor = (CodeEditor)editor;
                    if (codeEditor.getFocusedEditorPane() != null && codeEditor.getFocusedEditorPane().getDocument() != null) {
                        codeEditor.getFocusedEditorPane().getDocument().removeDocumentListener(BookmarkDescriptionUpdater.this.documentL);
                    }
                    BookmarkDescriptionUpdater.this.editorChangeIdMap.remove(codeEditor);
                }
            }

            public void editorActivated(Editor editor) {
            }

            public void editorDeactivated(Editor editor) {
            }
        });
    }

    private int getChangeId(CodeEditor codeEditor) {
        Document document = codeEditor.getFocusedEditorPane().getDocument();
        if (document instanceof BasicDocument) {
            int changeId = ((BasicDocument)document).getTextBuffer().getChangeId();
            return changeId;
        }
        return -1;
    }

    private void updateBookmarks() {
        for (CodeEditor editor : this.getCodeEditors()) {
            BasicEditorPane editorPane = editor.getFocusedEditorPane();
            if (editorPane == null) continue;
            Document document = editorPane.getDocument();
            int changeId = this.getChangeId(editor);
            Integer prevChangeId = this.editorChangeIdMap.get(editor);
            if (prevChangeId == null || changeId == prevChangeId) continue;
            for (Bookmark bookmark : BookmarkManager.getBookmarkManager().getAllBookmarks()) {
                if (!(bookmark instanceof CodeEditorBookmark)) continue;
                CodeEditorBookmark editorBookmark = (CodeEditorBookmark)bookmark;
                if (!editor.getContext().getNode().getURL().equals(editorBookmark.getURL())) continue;
                BookmarkDescriptionUpdater.updateDescription(document, editorBookmark);
            }
            this.editorChangeIdMap.put(editor, changeId);
        }
    }

    static void updateDescription(Document document, CodeEditorBookmark bookmark) {
        BasicDocument bDoc;
        LanguageSupport ls;
        if (document instanceof BasicDocument && (ls = (bDoc = (BasicDocument)document).getLanguageSupport()) instanceof AbstractLanguageSupport) {
            OffsetDescriptionProvider odp = ((AbstractLanguageSupport)ls).getOffsetDescriptionProvider();
            int line = bookmark.getLine();
            if (line >= 0 && line < bDoc.getLineCount()) {
                int offset = Math.max(bDoc.getLineStartOffset(line), bDoc.getLineEndOffset(line) - 1);
                if (odp != null) {
                    String extraDescription = odp.getDescription(bDoc.getTextBuffer(), offset);
                    if (extraDescription == null) {
                        bookmark.setDescription(Bookmarks.format("BOOKMARK_DESCRIPTION_FORMAT_BASIC", URLFileSystem.getFileName((URL)bookmark.getURL()), bookmark.getLine()));
                    } else {
                        bookmark.setDescription(Bookmarks.format("BOOKMARK_DESCRIPTION_FORMAT_EXTRA", URLFileSystem.getFileName((URL)bookmark.getURL()), bookmark.getLine(), extraDescription));
                    }
                    BookmarkManager.getBookmarkManager().fireBookmarkEvent(new BookmarkEvent(BookmarkEvent.Type.UPDATE, (Bookmark)bookmark));
                }
            }
        }
    }

    private List<CodeEditor> getCodeEditors() {
        ArrayList<CodeEditor> editors = new ArrayList<CodeEditor>();
        for (Editor editor : EditorManager.getEditorManager().getAllEditors()) {
            if (!(editor instanceof CodeEditor)) continue;
            editors.add((CodeEditor)editor);
        }
        return editors;
    }

    private class DocumentL
    implements DocumentListener,
    ActionListener {
        private Timer timer = new Timer(1000, this);

        private DocumentL() {
            this.timer.setRepeats(false);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.scheduleUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.scheduleUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.scheduleUpdate();
        }

        private void scheduleUpdate() {
            this.timer.restart();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BookmarkDescriptionUpdater.this.updateBookmarks();
        }
    }
}

