/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.bookmarks;

import java.util.Collection;
import java.util.Collections;
import oracle.ide.Addin;
import oracle.ide.bookmarks.Bookmark;
import oracle.ide.bookmarks.BookmarkManager;
import oracle.ide.ceditor.bookmarks.BookmarkDescriptionUpdater;
import oracle.ide.ceditor.bookmarks.BookmarkOptions;
import oracle.ide.ceditor.bookmarks.BookmarkTracker;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;

final class BookmarkAddin
implements Addin {
    BookmarkAddin() {
    }

    public void initialize() {
        this.loadBookmarks();
        BookmarkTracker.initialize();
        new BookmarkDescriptionUpdater();
        ExitCommand.addShutdownHook((ShutdownHook)new ShutdownHook(){

            public boolean canShutdown() {
                return true;
            }

            public void shutdown() {
                BookmarkAddin.this.saveBookmarks();
            }
        });
    }

    private void loadBookmarks() {
        BookmarkOptions codeEditorOptions = BookmarkOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        for (Bookmark bookmark : codeEditorOptions.getPersistedBookmarks()) {
            BookmarkManager.getBookmarkManager().addBookmark(bookmark);
        }
    }

    private void saveBookmarks() {
        oracle.ide.bookmarks.BookmarkOptions generalOptions = oracle.ide.bookmarks.BookmarkOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        BookmarkOptions codeEditorOptions = BookmarkOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        Collection<Object> bookmarks = Collections.emptyList();
        if (!generalOptions.getDiscardOnExit()) {
            bookmarks = BookmarkManager.getBookmarkManager().getAllBookmarks();
        }
        codeEditorOptions.setPersistedBookmarks(bookmarks);
    }
}

