/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.differ;

import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import oracle.xml.differ.BlankDiffTreeNode;
import oracle.xml.differ.DeletedDiffTreeNode;
import oracle.xml.differ.DiffStyledDocument;
import oracle.xml.differ.DiffTreeNode;
import oracle.xml.differ.ModifiedDiffTreeNode;
import oracle.xml.differ.NewDiffTreeNode;
import oracle.xml.differ.SameDiffTreeNode;
import oracle.xml.differ.XMLTokenizer;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

class DiffXmlTokenizer
extends XMLTokenizer {
    protected DiffStyledDocument diffXmlHandler;
    protected int currentDiffNodeType = 0;
    private int MODIFIED = 10;
    private int NEW = 20;
    private int SAME = 30;
    private int DELETED = 40;
    private int BLANK = 50;

    public void tokenize(DiffTreeNode diffTreeNode) {
        this.init(diffTreeNode);
        this.traverseTree(diffTreeNode);
    }

    private void init(DiffTreeNode diffTreeNode) {
        this.currentTreeTraversalDepth = 0;
        this.currentOffset = 0;
        this.currentXMLToken = "";
        this.currentXMLDocumentPosition = 0;
        this.currentXMLTokenType = 0;
    }

    private void traverseTree(DiffTreeNode diffTreeNode) {
        if (diffTreeNode instanceof ModifiedDiffTreeNode) {
            this.currentDiffNodeType = this.MODIFIED;
        } else if (diffTreeNode instanceof DeletedDiffTreeNode) {
            this.currentDiffNodeType = this.DELETED;
        } else if (diffTreeNode instanceof NewDiffTreeNode) {
            this.currentDiffNodeType = this.NEW;
        } else if (diffTreeNode instanceof BlankDiffTreeNode) {
            this.currentDiffNodeType = this.BLANK;
        } else if (diffTreeNode instanceof SameDiffTreeNode) {
            this.currentDiffNodeType = this.SAME;
        }
        switch (diffTreeNode.getNodeObject().getNodeType()) {
            case 9: {
                this.handleDocument(diffTreeNode);
                return;
            }
            case 1: {
                this.handleElement(diffTreeNode);
                return;
            }
            case 3: {
                this.handleText((Text)diffTreeNode.getNodeObject());
                return;
            }
            case 4: {
                this.handleText((Text)diffTreeNode.getNodeObject());
                return;
            }
            case 7: {
                this.handlePI((ProcessingInstruction)diffTreeNode.getNodeObject());
                return;
            }
            case 8: {
                this.handleComment((Comment)diffTreeNode.getNodeObject());
                return;
            }
            case 2: {
                this.handleAttribute((Attr)diffTreeNode.getNodeObject());
                return;
            }
            case 10: {
                this.handleDTD((DocumentType)diffTreeNode.getNodeObject());
                return;
            }
        }
    }

    private void handleDocument(DiffTreeNode diffTreeNode) {
        this.setCurrentNode(diffTreeNode.getNodeObject());
        this.setCurrentXMLDocumentPosition(1);
        if (diffTreeNode.getChildCount() > 0) {
            ++this.currentTreeTraversalDepth;
            this.setCurrentXMLDocumentPosition(19);
            Enumeration<TreeNode> enumeration = diffTreeNode.children();
            while (enumeration.hasMoreElements()) {
                this.traverseTree((DiffTreeNode)enumeration.nextElement());
            }
            --this.currentTreeTraversalDepth;
            this.setCurrentXMLDocumentPosition(20);
        }
        this.setCurrentNode(diffTreeNode.getNodeObject());
        this.setCurrentXMLDocumentPosition(2);
    }

    private void handleElement(DiffTreeNode diffTreeNode) {
        int n;
        int n2 = 0;
        int n3 = this.currentDiffNodeType;
        Element element = (Element)diffTreeNode.getNodeObject();
        this.setCurrentNode(element);
        this.setCurrentXMLDocumentPosition(3);
        this.setCurrentXMLToken(this.getTab() + "<", 12);
        this.setCurrentXMLToken(element.getTagName(), 1);
        if (diffTreeNode.getAttrNum() > 0) {
            this.setCurrentXMLDocumentPosition(17);
            n2 = diffTreeNode.getAttrNum();
            for (n = 0; n < n2; ++n) {
                this.traverseTree((DiffTreeNode)diffTreeNode.getChildAt(n));
            }
            this.setCurrentXMLDocumentPosition(18);
        }
        this.currentDiffNodeType = n3;
        this.setCurrentNode(element);
        this.setCurrentXMLToken(">", 12);
        if (diffTreeNode.getChildCount() > n2) {
            ++this.currentTreeTraversalDepth;
            this.setCurrentXMLDocumentPosition(19);
            n = diffTreeNode.getChildCount();
            for (int i = n2; i < n; ++i) {
                this.traverseTree((DiffTreeNode)diffTreeNode.getChildAt(i));
            }
            --this.currentTreeTraversalDepth;
            this.setCurrentXMLDocumentPosition(20);
        }
        this.currentDiffNodeType = n3;
        this.setCurrentNode(element);
        this.setCurrentXMLToken(this.getTab() + "</", 12);
        this.setCurrentXMLToken(element.getTagName(), 2);
        this.setCurrentXMLToken(">", 12);
        this.setCurrentXMLDocumentPosition(4);
    }

    @Override
    protected void setCurrentXMLToken(String string, int n) {
        this.currentXMLToken = string;
        this.currentXMLTokenType = n;
        this.currentOffset += string.length();
        if (this.diffXmlHandler != null) {
            this.diffXmlHandler.handleXMLToken(this.currentXMLToken, this.currentXMLTokenType, this.currentOffset, this.currentDiffNodeType);
        }
    }

    public void setXMLHandler(DiffStyledDocument diffStyledDocument) {
        this.tokenHandler = diffStyledDocument;
        this.diffXmlHandler = diffStyledDocument;
    }
}

