/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dbcart.tools;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.common.ddl.TargetFormat;
import oracle.dbtools.dbcart.DbCartAddinArb;
import oracle.dbtools.dbcart.DbCartUtil;
import oracle.dbtools.dbcart.DbCartXMLUtil;
import oracle.dbtools.dbcart.tools.DbCartTool;
import oracle.dbtools.extract.ExtractReconciler;
import oracle.dbtools.extract.models.ExtractObject;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.dbdiff.DBDiffApi;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class DbCartOpenTool
extends DbCartTool {
    public static final String TYPE = "Open";
    public static int ACTION = Ide.findOrCreateCmdID((String)"cart_open");
    private static final Logger LOGGER = Logger.getLogger(DBDiffApi.class.getName());
    private final FileNameExtensionFilter _filter = new FileNameExtensionFilter(DbCartAddinArb.getString("SAVED_CART"), "sdcart", "xml");
    private final JLabel _openIn = new JLabel(DbCartAddinArb.getString("OPEN_IN"));
    private URLFileChooser.URLFileChooserPanel _chooser;
    private ButtonGroup _cartGroup = new ButtonGroup();
    private JRadioButton _newCart = new JRadioButton();
    private JRadioButton _selectedCart = new JRadioButton();
    private JCheckBox _removeObjects = new JCheckBox();
    private JEWTDialog _actionDialog;
    private File _file;

    public DbCartOpenTool() {
        super(TYPE, 0);
    }

    public DbCartOpenTool(String string, int n) {
        super(string, n);
    }

    @Override
    public IdeAction getAction() {
        if (this._action == null) {
            this._action = IdeAction.get((int)ACTION, null, (String)DbCartAddinArb.getString("CART_OPEN_LABEL"), null, null, (Icon)OracleIcons.getIcon((String)"open.png"), null, (boolean)true);
            this._action.addController((Controller)this);
            this.setEnabled(true);
        }
        return this._action;
    }

    @Override
    public void toolWillEnable() {
        this.setEnabled(true);
    }

    @Override
    public void setEnabled(boolean bl) {
        this._isEnabled = true;
        this._action.setEnabled(true);
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == ACTION) {
            this.showDialog();
            return true;
        }
        return false;
    }

    public void showDialog() {
        String string = DbCartAddinArb.getString("OPEN_CART_DIALOG_TITLE");
        JPanel jPanel = new JPanel(new GridBagLayout());
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_opencartobjects_html");
        TargetFormat targetFormat = new TargetFormat(1, 3);
        targetFormat.setSaveAsType(0);
        this._chooser = URLFileChooser.createURLFileChooserPanel((int)0, (String)DbCartAddinArb.getString("OPEN_CART_FILE"));
        this._chooser.setCurrentDirectory(new File(targetFormat.getDefaultDirectory()));
        this._chooser.setFileFilter((FileFilter)this._filter);
        jPanel.add((Component)this._chooser, LayoutControl.GBC.gbc((int)0, (int)0, (int)0, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this._cartGroup.add(this._newCart);
        this._cartGroup.add(this._selectedCart);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(DbCartAddinArb.getString("OPEN_IN"));
        Insets insets = new Insets(6, 0, 0, 0);
        Insets insets2 = new Insets(6, 16, 0, 0);
        ResourceUtils.resButton((AbstractButton)this._newCart, (String)DbCartAddinArb.getString("NEW_CART"));
        ResourceUtils.resButton((AbstractButton)this._selectedCart, (String)DbCartAddinArb.format("SELECTED_CART", DbCartUtil.getTabPageName()));
        ResourceUtils.resButton((AbstractButton)this._removeObjects, (String)DbCartAddinArb.getString("REMOVE_OBJECTS"));
        this._selectedCart.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl;
                boolean bl2 = bl = itemEvent.getStateChange() == 1;
                if (bl) {
                    DbCartOpenTool.this._removeObjects.setEnabled(true);
                } else {
                    DbCartOpenTool.this._removeObjects.setEnabled(false);
                }
            }
        });
        this._newCart.setSelected(true);
        this._removeObjects.setEnabled(false);
        jPanel2.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.7, 0.0, 18, 0, insets, 0, 0));
        jPanel2.add((Component)this._newCart, new GridBagConstraints(0, 1, 1, 1, 0.7, 0.0, 18, 0, insets, 0, 0));
        jPanel2.add((Component)this._selectedCart, new GridBagConstraints(0, 2, 1, 1, 0.7, 0.0, 18, 0, insets, 0, 0));
        jPanel2.add((Component)this._removeObjects, new GridBagConstraints(0, 3, 1, 1, 0.7, 0.0, 18, 0, insets2, 0, 0));
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        jPanel.setBackground(UIManager.getColor("EWTDialog.background"));
        this._actionDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, null, (String)string, (int)14);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = false;
                if (actionEvent.getActionCommand().equalsIgnoreCase("apply")) {
                    DbCartOpenTool.this._file = DbCartOpenTool.this._chooser.getSelectedFile();
                    if (DbCartOpenTool.this._file == null || !DbCartOpenTool.this._file.isFile()) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)DbCartAddinArb.getString("OPEN_CART_INSTRUCTIONS"), (String)DbCartAddinArb.getString("CART_OPEN_ERROR_LABEL"), (String)"DBCART_FILE_ERROR");
                        bl = true;
                    } else {
                        if (DbCartOpenTool.this._newCart.isSelected()) {
                            DbCartUtil.getPanel().addTab();
                        } else if (DbCartOpenTool.this._removeObjects.isSelected()) {
                            DbCartUtil.getTableModel().removeAll();
                        }
                        final DbCartTask dbCartTask = new DbCartTask(DbCartOpenTool.this._file, DbCartOpenTool.this._chooser.getEncoding(), DbCartUtil.getReconciler());
                        dbCartTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, raptorTaskEvent.getTaskDescriptor().getName() + " " + raptorTaskEvent.getTaskDescriptor().getMessage());
                            }

                            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                                try {
                                    boolean bl = (Boolean)dbCartTask.getResult();
                                    if (!bl) {
                                        SwingUtilities.invokeLater(new Runnable(){

                                            @Override
                                            public void run() {
                                                MessageDialog.information((Component)Ide.getMainWindow(), (Object)DbCartAddinArb.getString("NOT_EXISTS_ERROR"), (String)DbCartAddinArb.getString("CART_REFRESH_LABEL"), (String)"DBCART_EXISTS_WARNING");
                                            }
                                        });
                                    }
                                }
                                catch (InterruptedException interruptedException) {
                                }
                                catch (ExecutionException executionException) {
                                    LOGGER.log(Level.WARNING, executionException.getStackTrace()[0].toString(), executionException);
                                }
                            }
                        });
                        RaptorTaskManager.getInstance().addTask((RaptorTask)dbCartTask);
                        DbCartUtil.getTableModel().setSaveAs(DbCartOpenTool.this._file.getPath());
                        DbCartUtil.getTableModel().setSaveAsEncoding(DbCartOpenTool.this._chooser.getEncoding());
                        DbCartUtil.setTabPageName(DbCartUtil.getTableModel().getSaveAsTabName());
                    }
                }
                if (!bl) {
                    DbCartOpenTool.this._actionDialog.setVisible(false);
                    DbCartOpenTool.this._actionDialog.dispose();
                }
            }
        };
        this._actionDialog.addActionListener(actionListener);
        Dimension dimension = jPanel.getPreferredSize();
        int n = (int)dimension.getHeight() + 100;
        int n2 = (int)dimension.getWidth() + 200;
        this._actionDialog.setMinimumSize(n2, n);
        WizardLauncher.runDialog((JDialog)this._actionDialog);
    }

    @Override
    public void openConfigOptions() {
    }

    @Override
    public void saveConfigOptions() {
    }

    private class DbCartTask
    extends RaptorTask<Boolean> {
        protected File _file;
        protected String _encoding;
        boolean _allExists;
        protected ExtractReconciler _reconciler;

        public DbCartTask(File file, String string, ExtractReconciler extractReconciler) {
            super(DbCartAddinArb.getString("CART_OPEN_LABEL"), false, IRaptorTaskRunMode.MODAL_OPTIONAL);
            this._file = file;
            this._encoding = string;
            this._reconciler = extractReconciler;
        }

        protected Boolean doWork() {
            block4: {
                DbCartXMLUtil dbCartXMLUtil = new DbCartXMLUtil();
                dbCartXMLUtil.setImport(true);
                try {
                    FileInputStream fileInputStream = new FileInputStream(this._file);
                    List<ExtractObject> list = dbCartXMLUtil.parseXML(fileInputStream, true);
                    ((InputStream)fileInputStream).close();
                    ArrayList<ExtractObject> arrayList = new ArrayList<ExtractObject>();
                    for (ExtractObject extractObject : list) {
                        if (!extractObject.isPreSelected() || !extractObject.isExistsSource()) continue;
                        arrayList.add(extractObject);
                    }
                    this._allExists = this._reconciler.reconcileExistence(arrayList, this.getRaptorTaskProgressUpdater());
                    SwingUtilities.invokeLater(() -> DbCartUtil.getTableModel().addRows(list));
                }
                catch (ExecutionException executionException) {
                }
                catch (Exception exception) {
                    Throwable throwable = exception.getCause();
                    if (throwable instanceof CancellationException) break block4;
                    LOGGER.log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
                }
            }
            return this._allExists;
        }
    }
}

