/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dbcart;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.common.ddl.DDLFormat;
import oracle.dbtools.common.ddl.TargetFormat;
import oracle.dbtools.common.utils.BasicDBObject;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.datatools.BaseDataFormat;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.dbcart.resources.DbCartResources;
import oracle.dbtools.extract.models.ExtractDataFormat;
import oracle.dbtools.extract.models.ExtractObject;
import oracle.dbtools.http.SessionInfo;
import oracle.dbtools.importer.ImportResources;
import oracle.dbtools.importer.core.ImportDataFormat;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.importer.core.ImportProperties;
import oracle.dbtools.importer.core.ImportXMLUtil;
import oracle.dbtools.importer.readers.IDataReadable;
import oracle.dbtools.raptor.cloud.connection.CConnections;
import oracle.dbtools.raptor.data.ui.DataPreviewGizmo;
import oracle.dbtools.raptor.sftp.SftpUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;

public class DbCartDeployCloudUtil {
    public static DDLFormat getDDLFormat() {
        DDLFormat dDLFormat = new DDLFormat(3);
        dDLFormat.setShowDDLOptionsEnabled(true);
        dDLFormat.setShowDep(false);
        dDLFormat.setShowAlter(false);
        dDLFormat.setShowSegments(false);
        dDLFormat.setShowPartitioning(false);
        dDLFormat.setShowTablespace(false);
        dDLFormat.setShowConstraint(true);
        dDLFormat.setShowRefConstraint(true);
        dDLFormat.setShowTrigger(true);
        dDLFormat.setConstraint(true);
        dDLFormat.setRefConstraint(true);
        dDLFormat.setSchema(false);
        dDLFormat.setSegments(false);
        dDLFormat.setPartitioning(false);
        dDLFormat.setTablespace(false);
        dDLFormat.setDrop(false);
        dDLFormat.setCascade(false);
        return dDLFormat;
    }

    public static ExtractDataFormat getDataFormat() {
        ExtractDataFormat extractDataFormat = new ExtractDataFormat(BaseDataFormat.CART, "LOADER".toLowerCase());
        extractDataFormat.isSeparateDataFile(true);
        extractDataFormat.isEnclosureRightDouble(true);
        return extractDataFormat;
    }

    public static TargetFormat getTargetFormat(boolean bl) {
        TargetFormat targetFormat = null;
        if (!bl) {
            targetFormat = new TargetFormat(1, 5);
            targetFormat.isCompressed(true);
            targetFormat.setSaveAsType(1);
            targetFormat.setSaveAs(targetFormat.getDefaultSaveAs());
            targetFormat.isGenScript(true);
            targetFormat.isSftp(true);
        } else {
            targetFormat = new TargetFormat(1, 6);
            targetFormat.isCompressed(true);
            targetFormat.setSaveAsType(1);
            targetFormat.setSaveAs(targetFormat.getDefaultSaveAs());
            targetFormat.isGenScript(false);
            targetFormat.isSftp(false);
        }
        targetFormat.isDeployCloud(true);
        targetFormat.setShowEncoding(false);
        targetFormat.setShowCompression(false);
        targetFormat.setShowSaveAsType(false);
        targetFormat.setEncoding("UTF8");
        targetFormat.isOpenTarget(false);
        targetFormat.isExcutableControlFile(false);
        return targetFormat;
    }

    public static Boolean isValidString(String string) {
        for (char c : string.toCharArray()) {
            if (!DbCartDeployCloudUtil.isUnsafe(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isUnsafe(char c) {
        if (c > '\u0080' || c < ' ') {
            return true;
        }
        return " %$&+,/:;=?@<>#%*`[]{}|\"\\".indexOf(c) >= 0;
    }

    public static String validateForDeploy(List<ExtractObject> list) {
        List<ExtractObject> list2 = DbCartDeployCloudUtil.validateConns(list);
        List<ExtractObject> list3 = DbCartDeployCloudUtil.validateTypes(list);
        List<ExtractObject> list4 = DbCartDeployCloudUtil.validateObjects(list);
        StringBuffer stringBuffer = new StringBuffer();
        for (Object object : list) {
            String string = DbCartDeployCloudUtil.validateFileObject(object);
            if (string == null) continue;
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        if (!(list2.isEmpty() && list3.isEmpty() && list4.isEmpty() && stringBuffer.length() <= 0)) {
            Object object;
            StringBuilder stringBuilder = new StringBuilder();
            object = "";
            stringBuilder.append(DbCartResources.getString("UNABLE_TO_DEPLOY_OBJECTS_TO_CLOUD") + "\n");
            if (!list2.isEmpty()) {
                stringBuilder.append(DbCartResources.getString("BAD_CONN_TEXT") + "\n");
                for (ExtractObject extractObject : list2) {
                    stringBuilder.append((String)object + extractObject.getDBObject().getSchemaName() + "." + extractObject.getDBObject().getObjectName());
                    object = ", ";
                }
                stringBuilder.append("\n");
            }
            if (!list3.isEmpty()) {
                object = "";
                stringBuilder.append(DbCartResources.getString("BAD_TYPE_TEXT") + "\n");
                for (ExtractObject extractObject : list3) {
                    stringBuilder.append((String)object + extractObject.getDBObject().getSchemaName() + "." + extractObject.getDBObject().getObjectName());
                    object = ", ";
                }
                stringBuilder.append("\n");
            }
            if (!list4.isEmpty()) {
                object = "";
                stringBuilder.append(DbCartResources.getString("BAD_COLUMN_TEXT") + "\n");
                for (ExtractObject extractObject : list4) {
                    stringBuilder.append((String)object + extractObject.getDBObject().getSchemaName() + "." + extractObject.getDBObject().getObjectName());
                    object = ", ";
                }
                stringBuilder.append("\n");
            }
            if (stringBuffer.length() > 0) {
                stringBuilder.append(stringBuffer.toString());
                stringBuilder.append("\n");
            }
            if (stringBuilder.length() > 0) {
                return stringBuilder.toString();
            }
        }
        return null;
    }

    public static List<ExtractObject> validateConns(List<ExtractObject> list) {
        ArrayList<ExtractObject> arrayList = new ArrayList<ExtractObject>();
        for (ExtractObject extractObject : list) {
            if (!extractObject.isTypeDBO() || Connections.getInstance().isOracle(extractObject.getDBObject().getConnection())) continue;
            arrayList.add(extractObject);
            extractObject.isPreSelected(false);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ExtractObject> validateTypes(List<ExtractObject> list) {
        ArrayList<ExtractObject> arrayList = new ArrayList<ExtractObject>();
        ResultSet resultSet = null;
        String string = "select count(*) from all_external_tables where table_name = :TNAME and OWNER = :OWNER";
        for (ExtractObject extractObject : list) {
            if (!extractObject.isTypeDBO()) continue;
            BasicDBObject basicDBObject = extractObject.getDBObject();
            Connection connection = basicDBObject.getConnection();
            String string2 = basicDBObject.getObjectType();
            if (string2.equals("DATABASE LINK") || string2.equals("DIRECTORY") || string2.equals("MATERIALIZED VIEW") || string2.equals("MATERIALIZED VIEW LOG") || string2.equals("SYNONYM")) {
                arrayList.add(extractObject);
                extractObject.isPreSelected(false);
                continue;
            }
            if (!Connections.getInstance().isOracle(connection) || !string2.equals("TABLE")) continue;
            try {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("TNAME", basicDBObject.getObjectName());
                hashMap.put("OWNER", basicDBObject.getSchemaName());
                if (!Connections.getInstance().lock(connection)) continue;
                try {
                    resultSet = DBUtil.getInstance((Connection)connection).executeQuery(string, hashMap);
                    while (resultSet.next()) {
                        int n = resultSet.getInt(1);
                        if (n <= 0) continue;
                        arrayList.add(extractObject);
                        extractObject.isPreSelected(false);
                    }
                }
                finally {
                    Connections.getInstance().unlock(connection);
                }
            }
            catch (SQLException sQLException) {
                ExceptionHandler.handleException((Throwable)sQLException);
            }
            finally {
                DBUtil.closeResultSet(resultSet);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ExtractObject> validateObjects(List<ExtractObject> list) {
        ArrayList<ExtractObject> arrayList = new ArrayList<ExtractObject>();
        ResultSet resultSet = null;
        String string = "select count(*) from all_tab_cols where table_name = :TNAME and OWNER = :OWNER and (data_type = 'SDO_GEOMETRY' or data_type = 'LONG' or data_type = 'LONG RAW' or data_type = 'BFILE')";
        for (ExtractObject extractObject : list) {
            if (!extractObject.isTypeDBO()) continue;
            BasicDBObject basicDBObject = extractObject.getDBObject();
            Connection connection = basicDBObject.getConnection();
            if (!Connections.getInstance().isOracle(connection) || !basicDBObject.getObjectType().equals("TABLE")) continue;
            try {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("TNAME", basicDBObject.getObjectName());
                hashMap.put("OWNER", basicDBObject.getSchemaName());
                if (!Connections.getInstance().lock(connection)) continue;
                try {
                    resultSet = DBUtil.getInstance((Connection)connection).executeQuery(string, hashMap);
                    while (resultSet.next()) {
                        int n = resultSet.getInt(1);
                        if (n <= 0) continue;
                        arrayList.add(extractObject);
                        extractObject.isPreSelected(false);
                    }
                }
                finally {
                    Connections.getInstance().unlock(connection);
                }
            }
            catch (SQLException sQLException) {
                ExceptionHandler.handleException((Throwable)sQLException);
            }
            finally {
                DBUtil.closeResultSet(resultSet);
            }
        }
        return arrayList;
    }

    public static String validateFileObject(ExtractObject extractObject) {
        ArrayList arrayList = new ArrayList();
        if (extractObject.isTypeDataFile()) {
            Object object;
            File file = new File(extractObject.getConfigUrl().getPath());
            ExitCode exitCode = ExitCode.EXIT_SUCCESS;
            ImportXMLUtil importXMLUtil = new ImportXMLUtil();
            importXMLUtil.setImport(Boolean.valueOf(true));
            try {
                object = new FileInputStream(file);
                importXMLUtil.parseXML((InputStream)object, true);
                ((InputStream)object).close();
            }
            catch (Exception exception) {
                return ImportResources.getString((String)"CONFIG_OPEN_ERROR20") + " " + exception.getMessage();
            }
            exitCode = importXMLUtil.reconcileConfig(file.getName(), extractObject.getUrl().toString(), true, true);
            object = "";
            switch (exitCode) {
                case EXIT_SUCCESS: 
                case EXIT_WARNING: {
                    break;
                }
                case EXIT_ERROR: {
                    String string = exitCode.getSeverity() == ExitCode.EXIT_WARNING.getSeverity() ? ImportResources.getString((String)"EXIT_WARNING_LABEL") : ImportResources.getString((String)"EXIT_ERROR_LABEL");
                    String string2 = ImportResources.format((String)"CONFIG_OPEN_ERROR22", (Object[])new Object[]{string}) + "\n" + ImportResources.format((String)"CONFIG_OPEN_ERROR14", (Object[])new Object[]{extractObject.getUrl()}) + "\n" + exitCode.getMessage().toString();
                    return string2;
                }
                default: {
                    String string = ImportResources.getString((String)"EXIT_SEVERE_LABEL");
                    String string3 = ImportResources.format((String)"CONFIG_OPEN_ERROR22", (Object[])new Object[]{string}) + "\n" + ImportResources.getString((String)"CONFIG_OPEN_ERROR23") + "\n" + exitCode.getMessage().toString();
                    return string3;
                }
            }
            ImportProperties importProperties = new ImportProperties();
            importProperties.put(ImportKeys.DBOBJECT, (Object)((BasicDBObject)importXMLUtil.getPropertyValueObject(ImportKeys.DBOBJECT)));
            boolean bl = importXMLUtil.getPropertyValueBoolean(ImportKeys.IS_SOURCE_OSS);
            importProperties.put(ImportKeys.IS_SOURCE_OSS, (Object)bl);
            if (bl) {
                importProperties.put(ImportKeys.OSS_PATH, (Object)((String)importXMLUtil.getPropertyValueObject(ImportKeys.OSS_PATH)));
                importProperties.put(ImportKeys.OSS_CREDENTIAL, (Object)((String)importXMLUtil.getPropertyValueObject(ImportKeys.OSS_CREDENTIAL)));
            } else {
                importProperties.put(ImportKeys.FILE_PATH, (Object)((String)importXMLUtil.getPropertyValueObject(ImportKeys.FILE_PATH)));
            }
            LoadFile loadFile = (LoadFile)importXMLUtil.getPropertyValueObject(ImportKeys.LOAD_FILE);
            importProperties.put(ImportKeys.LOAD_FILE, (Object)loadFile);
            importProperties.put(ImportKeys.TABLE, (Object)((GenericTable)importXMLUtil.getPropertyValueObject(ImportKeys.TABLE)));
            importProperties.put(ImportKeys.TABLE_NAME, (Object)importXMLUtil.getPropertyValue(ImportKeys.TABLE_NAME));
            ImportDataFormat importDataFormat = (ImportDataFormat)importXMLUtil.getPropertyValueObject(ImportKeys.IMPORT_DATA_FORMAT);
            importProperties.put(ImportKeys.IMPORT_DATA_FORMAT, (Object)importDataFormat);
            importProperties.put(ImportKeys.PAGEID, (Object)importDataFormat.getPageId());
            IDataReadable iDataReadable = importXMLUtil.getDataReader();
            DataPreviewGizmo dataPreviewGizmo = new DataPreviewGizmo(iDataReadable);
            dataPreviewGizmo = new DataPreviewGizmo(iDataReadable);
            dataPreviewGizmo.setDataFormat(importDataFormat);
            dataPreviewGizmo.initTable();
            iDataReadable.showPreviewMessages(false);
            dataPreviewGizmo.populateDataTable();
            iDataReadable.showPreviewMessages(true);
            importProperties.put(ImportKeys.GIZMO, (Object)dataPreviewGizmo);
            importProperties.put(ImportKeys.LOAD_METHOD, (Object)importXMLUtil.getPropertyValueInt(ImportKeys.LOAD_METHOD));
            importProperties.put(ImportKeys.STAGING_TABLE_NAME, (Object)importXMLUtil.getPropertyValue(ImportKeys.STAGING_TABLE_NAME));
            importProperties.put(ImportKeys.DROP_STAGING_TABLE, (Object)importXMLUtil.getPropertyValueBoolean(ImportKeys.DROP_STAGING_TABLE));
            importProperties.put(ImportKeys.IS_EXISTING_TABLE, (Object)importXMLUtil.getPropertyValueBoolean(ImportKeys.IS_EXISTING_TABLE));
            importProperties.put(ImportKeys.TABLE_NAME, (Object)importXMLUtil.getPropertyValue(ImportKeys.TABLE_NAME));
            importProperties.put(ImportKeys.USE_LOAD_LIMIT, (Object)importXMLUtil.getPropertyValueBoolean(ImportKeys.USE_LOAD_LIMIT));
            importProperties.put(ImportKeys.LOAD_LIMIT, (Object)importXMLUtil.getPropertyValueInt(ImportKeys.LOAD_LIMIT));
            importProperties.put(ImportKeys.SEND_TO_WORKSHEET, (Object)importXMLUtil.getPropertyValueBoolean(ImportKeys.SEND_TO_WORKSHEET));
            importProperties.put(ImportKeys.FILE_COLUMNS, importXMLUtil.getPropertyValueObject(ImportKeys.FILE_COLUMNS));
            importProperties.put(ImportKeys.SELECTED_COLUMNS, importXMLUtil.getPropertyValueObject(ImportKeys.SELECTED_COLUMNS));
            importProperties.put(ImportKeys.SELECTABLE_COLUMNS, importXMLUtil.getPropertyValueObject(ImportKeys.SELECTABLE_COLUMNS));
            importProperties.put(ImportKeys.MATCH_BY_TYPE, (Object)importXMLUtil.getPropertyValueInt(ImportKeys.MATCH_BY_TYPE));
            int n = (Integer)importProperties.get(ImportKeys.LOAD_METHOD);
            importProperties.put(ImportKeys.CONVERSION_ERRORS, (Object)importXMLUtil.getPropertyValueInt(ImportKeys.CONVERSION_ERRORS));
            importProperties.put(ImportKeys.DATE_MASK_DATE, (Object)importXMLUtil.getPropertyValue(ImportKeys.DATE_MASK_DATE));
            importProperties.put(ImportKeys.DATE_MASK_TIMESTAMP, (Object)importXMLUtil.getPropertyValue(ImportKeys.DATE_MASK_TIMESTAMP));
            importProperties.put(ImportKeys.DATE_MASK_TIMESTAMPTZ, (Object)importXMLUtil.getPropertyValue(ImportKeys.DATE_MASK_TIMESTAMPTZ));
            importProperties.put(ImportKeys.DATE_MASK_TIMESTAMPLTZ, (Object)importXMLUtil.getPropertyValue(ImportKeys.DATE_MASK_TIMESTAMPLTZ));
            importProperties.put(ImportKeys.IS_BLANK_COLS, (Object)importXMLUtil.getPropertyValueBoolean(ImportKeys.IS_BLANK_COLS));
            importProperties.put(ImportKeys.IS_TRUNCATE_COLS, (Object)importXMLUtil.getPropertyValueBoolean(ImportKeys.IS_TRUNCATE_COLS));
            importProperties.put(ImportKeys.MISSING_FIELDS, (Object)importXMLUtil.getPropertyValueInt(ImportKeys.MISSING_FIELDS));
            importProperties.put(ImportKeys.NULL_ROWS, (Object)importXMLUtil.getPropertyValueInt(ImportKeys.NULL_ROWS));
            importProperties.put(ImportKeys.USE_REJECT_LIMIT, (Object)importXMLUtil.getPropertyValueBoolean(ImportKeys.USE_REJECT_LIMIT));
            importProperties.put(ImportKeys.REJECT_LIMIT, (Object)importXMLUtil.getPropertyValueInt(ImportKeys.REJECT_LIMIT));
            importProperties.put(ImportKeys.TRIM, (Object)importXMLUtil.getPropertyValueInt(ImportKeys.TRIM));
            importProperties.put(ImportKeys.IS_COPY_LOG, (Object)importXMLUtil.getPropertyValueBoolean(ImportKeys.IS_COPY_LOG));
            importProperties.put(ImportKeys.IS_COPY_BAD, (Object)importXMLUtil.getPropertyValueBoolean(ImportKeys.IS_COPY_BAD));
            importProperties.put(ImportKeys.IS_DROP_BAD_AND_LOG, (Object)importXMLUtil.getPropertyValueBoolean(ImportKeys.IS_DROP_BAD_AND_LOG));
            importProperties.put(ImportKeys.USE_VALIDATE, (Object)importXMLUtil.getPropertyValueBoolean(ImportKeys.USE_VALIDATE));
            importProperties.put(ImportKeys.VALIDATE_LIMIT, (Object)importXMLUtil.getPropertyValueInt(ImportKeys.VALIDATE_LIMIT));
            if (n == 2 || n == 3) {
                importProperties.put(ImportKeys.DIRPATH, (Object)importXMLUtil.getPropertyValue(ImportKeys.DIRPATH));
                importProperties.put(ImportKeys.ORADIRNAME, (Object)importXMLUtil.getPropertyValue(ImportKeys.ORADIRNAME));
                importProperties.put(ImportKeys.USEBADFILE, (Object)importXMLUtil.getPropertyValueBoolean(ImportKeys.USEBADFILE));
                importProperties.put(ImportKeys.ORABADDIRNAME, (Object)importXMLUtil.getPropertyValue(ImportKeys.ORABADDIRNAME));
                importProperties.put(ImportKeys.USELOGFILE, (Object)importXMLUtil.getPropertyValueBoolean(ImportKeys.USELOGFILE));
                importProperties.put(ImportKeys.ORALOGDIRNAME, (Object)importXMLUtil.getPropertyValue(ImportKeys.ORALOGDIRNAME));
                importProperties.put(ImportKeys.USEDISCARDFILE, (Object)importXMLUtil.getPropertyValueBoolean(ImportKeys.USEDISCARDFILE));
                importProperties.put(ImportKeys.ORADISCARDDIRNAME, (Object)importXMLUtil.getPropertyValue(ImportKeys.ORADISCARDDIRNAME));
            } else if (n == 4) {
                importProperties.put(ImportKeys.BADDIRNAME, (Object)importXMLUtil.getPropertyValue(ImportKeys.BADDIRNAME));
                importProperties.put(ImportKeys.LOGDIRNAME, (Object)importXMLUtil.getPropertyValue(ImportKeys.LOGDIRNAME));
                importProperties.put(ImportKeys.USEGENDIR, (Object)importXMLUtil.getPropertyValueBoolean(ImportKeys.USEGENDIR));
                importProperties.put(ImportKeys.GENDIR, (Object)importXMLUtil.getPropertyValue(ImportKeys.GENDIR));
                importProperties.put(ImportKeys.FILEOUTNEWLINE, (Object)importXMLUtil.getPropertyValue(ImportKeys.FILEOUTNEWLINE));
            }
            importProperties.put(ImportKeys.CHARNUMCHARACTERS, (Object)importXMLUtil.getPropertyValue(ImportKeys.CHARNUMCHARACTERS));
            importProperties.put(ImportKeys.IS_GENERATE_CHARSET, (Object)importXMLUtil.getPropertyValueBoolean(ImportKeys.IS_GENERATE_CHARSET));
            importProperties.put(ImportKeys.CHARSETVAL, (Object)importXMLUtil.getPropertyValue(ImportKeys.CHARSETVAL));
            extractObject.setImportProperties(importProperties);
            return null;
        }
        return null;
    }

    public static String validateTitle(String string) {
        if (string == null || string.equals("")) {
            return DbCartResources.getString("NULL_TITLE_MESSAGE");
        }
        if (!DbCartDeployCloudUtil.isValidString(string).booleanValue()) {
            return DbCartResources.getString("BAD_TITLE_MESSAGE");
        }
        return null;
    }

    public static String validateCloudConn(String string) {
        if (string == null || string.length() == 0) {
            return DbCartResources.getString("XML_CONN_ERROR_MESSAGE2");
        }
        try {
            Connections.getInstance().getConnection(string, true);
        }
        catch (Exception exception) {
            return DbCartResources.format("XML_CONN_ERROR_MESSAGE1", string);
        }
        return null;
    }

    public static boolean isPdbCloud(String string) {
        if (string != null) {
            return Connections.getInstance().isOracle(string);
        }
        return false;
    }

    public static boolean isPdbCloud(Connection connection) {
        if (connection != null) {
            return Connections.getInstance().isOracle(connection);
        }
        return false;
    }

    public static SessionInfo.SftpInfo getSftpInfo(String string) {
        CConnections cConnections;
        SessionInfo sessionInfo;
        SessionInfo.SftpInfo sftpInfo = null;
        if (SftpUtil.isSchemaServiceConnection((String)string) && (sessionInfo = (cConnections = CConnections.getInstance()).getConnectionInfo(string)) != null) {
            sftpInfo = sessionInfo.getSftpInfo();
        }
        return sftpInfo;
    }

    public static SessionInfo.OssInfo getOssInfo(String string) {
        return SftpUtil.getOssInfo((String)string);
    }

    public static String getTempName(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yymmdd_HHmmssssss");
        StringBuilder stringBuilder = new StringBuilder(simpleDateFormat.format(new Date()));
        return string + "_" + stringBuilder;
    }
}

