/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dbcart;

import java.net.URL;
import oracle.dbtools.common.config.IEnvironmentConfig;
import oracle.dbtools.common.ddl.TargetFormat;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.dbcart.resources.DbCartResources;
import oracle.dbtools.export.service.ExportParms;
import oracle.dbtools.export.service.ExportService;
import oracle.dbtools.raptor.export.service.ExportLauncherSD;
import oracle.dbtools.raptor.export.service.ExportToolRunModeSD;
import oracle.dbtools.raptor.extract.ExtractLogger;
import oracle.dbtools.raptor.extract.ExtractMessagePage;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.oviewer.base.AsynchronousViewerRunner;
import oracle.dbtools.raptor.utils.IProcessMonitor;
import oracle.dbtools.raptor.utils.IToolRunMode;
import oracle.dbtools.raptor.utils.ToolLogger;

public class DbCartDeployCloudLauncher
extends ExportLauncherSD {
    public static final int METHOD_AUTO = 0;
    public static final int METHOD_CLOUD_LOAD = 1;
    public static final int METHOD_INSERT = 2;
    public static final int INSERT_LIMIT = 10000;
    private ExportParms _eParms;

    protected boolean isDeployPdbCloud() {
        return true;
    }

    protected String getELoggerName() {
        return DbCartResources.getString("DEPLOY_CLOUD_TOOL");
    }

    public ExitCode start(ExportParms exportParms) {
        try {
            this._eParms = exportParms;
            ExportToolRunModeSD exportToolRunModeSD = new ExportToolRunModeSD();
            exportToolRunModeSD.setRunMode(IToolRunMode.RunMode.GUI);
            exportToolRunModeSD.setParms((Object)exportParms);
            exportToolRunModeSD.setLineTerminator(this.getLineTerminator());
            exportToolRunModeSD.isShowELog(this._eParms.getTargetFormat() == null || !this._eParms.getTargetFormat().isDeployCloud());
            exportToolRunModeSD.setEncoding(IEnvironmentConfig.Storage.getInstance().getString("ENV_ENCODING"));
            URL uRL = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)exportParms.getDestConnName(), null, (String)exportParms.getDestSchema(), (String)"sd_deploy");
            URL uRL2 = DBURLFormatHelper.getURL((URL)uRL, (String)exportParms.getName());
            exportToolRunModeSD.setProcessMonitor((IProcessMonitor)new AsynchronousViewerRunner(uRL2, true));
            this._eParms.setToolRunMode((IToolRunMode)exportToolRunModeSD);
            ExitCode exitCode = this.start(exportParms, (IToolRunMode)exportToolRunModeSD);
            ExportService exportService = this.getService();
            this.getRunMode().setToolName(exportService.getToolName());
            TargetFormat targetFormat = exportParms.getTargetFormat();
            this.getRunMode().setToolLogger((ToolLogger)(this.getRunMode().isShowELog() ? new ExtractLogger(ExtractMessagePage.EXTRACT_VIEW_ID) : new ExtractLogger(exportService.getToolName(), targetFormat.getEncoding())));
            exportService.initELogger();
            return exitCode;
        }
        catch (Exception exception) {
            ExitCode exitCode = ExitCode.EXIT_SEVERE;
            exitCode.setMessage(exitCode.getMessage() + " " + exception.toString());
            return ExitCode.EXIT_SEVERE;
        }
    }
}

