/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dbcart;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.ddl.DDLTypes;
import oracle.dbtools.dbcart.DbCartAddinArb;
import oracle.dbtools.dbcart.DbCartUtil;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.model.Node;

public class DbCartAddAction
extends AbstractMenuAction {
    public static final String CART_ADD_NAME = "CART_ADD";
    public static final int CART_ADD_ACTION = Ide.findOrCreateCmdID((String)"CART_ADD");

    public void launch() {
        DDLTypes dDLTypes = new DDLTypes();
        dDLTypes.setApex(true);
        dDLTypes.setApexPage(false);
        dDLTypes.setShowApex(true);
        dDLTypes.setShowApexPage(false);
        for (DBObject dBObject : this.getList(this.getContext())) {
            String string = dBObject.getObjectType();
            if (dDLTypes.isSupportedType(string)) {
                DbCartUtil.getTableModel().addRow(dBObject, dBObject.getConnectionName());
                continue;
            }
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, DbCartAddinArb.format("DROP_TYPE_ERROR", string, DBURLFormatHelper.getName((URL)dBObject.getURL())));
        }
    }

    public boolean isEnabled(Context context) {
        return DbCartUtil.getTableModel() == null ? false : this.getDBObject().isActionAllowed();
    }

    private List<DBObject> getList(Context context) {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        Element[] elementArray = context.getSelection();
        if (elementArray.length == 0) {
            DBObject dBObject = this.getDBObject();
            if (dBObject != null) {
                arrayList.add(dBObject);
            }
        } else {
            for (Element element : elementArray) {
                arrayList.add(this.getDBObject((Node)element));
            }
        }
        return arrayList;
    }

    private DBObject getDBObject(Node node) {
        if (node instanceof ObjectNode && ((ObjectNode)node).getObjectType().equals("MATERIALIZED VIEW LOG")) {
            ObjectNode objectNode = (ObjectNode)node;
            URL uRL = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)objectNode.getConnectionName(), null, (String)objectNode.getSchemaName(), (String)objectNode.getObjectType());
            URL uRL2 = DBURLFormatHelper.getURL((URL)uRL, (String)objectNode.getShortLabel());
            return new DBObject(uRL2);
        }
        return new DBObject((Element)node);
    }
}

