/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.jdbc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.raptor.connections.CDComponentView;
import oracle.dbtools.raptor.conntypes.RaptorClassLoader;
import oracle.dbtools.thirdparty.jdbc.DMJDBCConnectionPanel;
import oracle.dbtools.thirdparty.jdbc.JDBCMessages;
import oracle.ide.natives.NativeHandler;

public class DMJDBCBasicPanel
extends JPanel
implements CDComponentView {
    public static final String DB_TYPE_CLASS_REFTYPE_STRING = "DB_TYPE";
    public static final String[] DB_TYPES = new String[]{null, "Oracle", "SQL Server", "DB2/390", "DB2/UDB"};
    private static final long serialVersionUID = -3381627083207173706L;
    private JPanel m_ContainterPanel;
    private JPanel m_ThirdPartyDrvPanel;
    private JLabel m_lblJdbcUrl;
    private JTextField m_txtJdbcUrl;
    private JLabel m_lblDrvClassName;
    private JTextField m_txtDrvClassName;
    private final NativeHandler m_NativeHandler = new NativeHandler();
    private JPanel m_DBTypePanel;
    private JLabel m_lblDBType;
    private JComboBox m_cbDBType;
    private DMJDBCConnectionPanel m_connPanel;

    public DMJDBCBasicPanel(DMJDBCConnectionPanel panel) {
        this.m_connPanel = panel;
        try {
            this.m_NativeHandler.initialize();
            this.setLayout(new BorderLayout());
            this.m_ThirdPartyDrvPanel = new JPanel();
            this.m_ContainterPanel = new JPanel(new BorderLayout());
            this.m_lblJdbcUrl = new JLabel(JDBCMessages.getString("JDBC_URL"));
            this.m_txtJdbcUrl = new JTextField();
            this.m_lblDrvClassName = new JLabel(JDBCMessages.getString("DRV_CLASS"));
            this.m_txtDrvClassName = new JTextField();
            this.m_DBTypePanel = new JPanel(new FlowLayout(0));
            this.m_lblDBType = new JLabel(JDBCMessages.getString(DB_TYPE_CLASS_REFTYPE_STRING));
            this.m_cbDBType = new JComboBox<String>(DB_TYPES);
            this.m_cbDBType.setSelectedIndex(0);
            this.m_DBTypePanel.add((Component)this.m_lblDBType, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.m_DBTypePanel.add((Component)this.m_cbDBType, new GridBagConstraints(1, 0, 0, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.m_ThirdPartyDrvPanel.setLayout(new GridBagLayout());
            this.m_ThirdPartyDrvPanel.add((Component)this.m_lblJdbcUrl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.m_ThirdPartyDrvPanel.add((Component)this.m_txtJdbcUrl, new GridBagConstraints(1, 0, 0, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.m_ThirdPartyDrvPanel.add((Component)this.m_lblDrvClassName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.m_ThirdPartyDrvPanel.add((Component)this.m_txtDrvClassName, new GridBagConstraints(1, 1, 0, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.m_ContainterPanel.add((Component)new JPanel(), "North");
            this.m_ContainterPanel.add((Component)this.m_ThirdPartyDrvPanel, "Center");
            JPanel pnMain = new JPanel(new BorderLayout());
            pnMain.add((Component)this.m_ContainterPanel, "Center");
            this.add((Component)pnMain, "North");
            this.add((Component)this.m_DBTypePanel, "Center");
        }
        catch (Exception e) {
            Logger.getLogger(DMJDBCBasicPanel.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    public void clear() {
        this.m_connPanel.clear();
    }

    public void generateProperties(Properties cd) {
        String dbType;
        String drvClass = this.m_txtDrvClassName.getText();
        String jdbcUrl = this.m_txtJdbcUrl.getText();
        if (drvClass != null && drvClass.trim().length() > 0) {
            cd.setProperty("driver", drvClass);
        }
        if (jdbcUrl != null && jdbcUrl.trim().length() > 0) {
            cd.setProperty("customUrl", jdbcUrl);
        }
        if ((dbType = (String)this.m_cbDBType.getSelectedItem()) == null) {
            cd.remove(DB_TYPE_CLASS_REFTYPE_STRING);
        } else {
            cd.setProperty(DB_TYPE_CLASS_REFTYPE_STRING, dbType);
        }
    }

    public void setDefaultPrompts() {
    }

    public void setDBType(String dbType) {
        if (dbType == null) {
            this.m_cbDBType.setSelectedIndex(0);
        } else {
            for (int i = 0; i < DB_TYPES.length; ++i) {
                String type = DB_TYPES[i];
                if (!dbType.equalsIgnoreCase(type)) continue;
                this.m_cbDBType.setSelectedIndex(i);
                return;
            }
        }
    }

    public String getDriverClass() {
        return RaptorClassLoader.class.getName();
    }

    public void setDriverClass(String drvCls) {
        this.m_txtDrvClassName.setText(drvCls != null ? drvCls : "");
    }

    public String getThirdPartyJdbcUrl() {
        String retVal = this.m_txtJdbcUrl.getText();
        retVal = retVal != null ? retVal.trim() : retVal;
        return retVal;
    }

    public void setThirdPartyJdbcUrl(String url) {
        this.m_txtJdbcUrl.setText(url != null ? url : "");
    }

    public void updatePrompts(Properties cd) {
        String urlString = cd.getProperty("customUrl");
        String drvClass = "";
        String customUrl = "";
        drvClass = cd.getProperty("driver");
        customUrl = urlString;
        this.setDriverClass(drvClass);
        this.setThirdPartyJdbcUrl(customUrl);
    }
}

