/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.tests;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBMExtractionController;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.GenerationHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;
import oracle.dbtools.crest.swingui.wizards.metadata.oracle.DBMExtractionWizardOracle;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.jdbc.OracleDriver;

public class Test_AppViewSQLDev {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws SQLException {
        ApplicationView app = ApplicationView.getInstance();
        Design des = new Design(app);
        RelationalDesign relModel = des.addRelationalDesign();
        RDBMSSite site = des.getRDBMSSiteSet().get(StorageDesignOraclev11g.RDBMS_TYPE);
        relModel.setSelectedRDBMSSite(site);
        des.setRelationalDesign(relModel);
        StorageDesign sd = relModel.getStorageDesign();
        try {
            des.setPropagatePKChahges(false);
            des.setDisableTreeUpdate(true);
            app.setImporting(true);
            ApplicationView.canLogging = false;
            DriverManager.registerDriver((Driver)new OracleDriver());
            Connection conn = DriverManager.getConnection("jdbc:oracle:thin:@localhost:1521:fdb11r21", "system", "system");
            DBMExtractionController controller = new DBMExtractionController(relModel.getAppView());
            AbstractDBMExtractionHandler extrh = controller.getDBMExtractionHandler(1);
            GenerationHandler handler = controller.getGenerationnHandler(1, sd);
            System.out.println("Start schema tables - " + System.currentTimeMillis());
            ArrayList<DBObject> list = new ArrayList<DBObject>();
            DBObject dbo2 = new DBObject(true, "SH");
            list.add(dbo2);
            ArrayList<DBObject> objects = new ArrayList<DBObject>();
            try {
                objects.add(new DBObject(true, "PURCHASEORDER", "TABLE", "OE"));
                objects.add(new DBObject(true, "CUSTOMERS", "TABLE", "OE"));
                objects.add(new DBObject(true, "V_COUNTRIES", "VIEW", "HR"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (objects != null) {
                for (DBObject dbo2 : objects) {
                    dbo2.setSelected(true);
                }
            }
            TimeLog.log("Start import of tables");
            ImportLogger importLog = new ImportLogger();
            try {
                handler.generateDesign(conn, objects, importLog, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            TimeLog.log("Ebd import of tables");
            DDLFileMaker fm = new DDLFileMaker(des, relModel);
            fm.setStorageDesign(sd);
            fm.clearContent();
            ProgressDialog.NullProgressDialog np = new ProgressDialog.NullProgressDialog(app, " ", 0, 0);
            fm.generateDDLContent(np);
            String content = fm.getContent();
            TimeLog.log("End DDL generation of tables");
            System.out.println(content);
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBMExtractionWizardOracle.clearInstance();
            app.setImporting(false);
            des.setPropagatePKChahges(true);
            des.setDisableTreeUpdate(false);
            ApplicationView.canLogging = true;
        }
    }
}

