/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.print;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.text.NumberFormatter;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.print.PaperSizes;
import oracle.dbtools.crest.util.print.PrinterName;

public class PageSetupDialog
extends JDialog
implements ActionListener {
    private static final String KEY_ESCAPE = "ESCAPE";
    private Dimension defaultLabelSize = new Dimension(50, 20);
    private Dimension defaultCBSize = new Dimension(300, 20);
    private Dimension defaultMarginFieldSize = new Dimension(60, 20);
    private JButton bnOK;
    private JButton bnCancel;
    private JComboBox cbServices;
    private JComboBox cbMediaSizes;
    private JRadioButton rbPortrait;
    private JRadioButton rbLandscape;
    private JFormattedTextField dfLeft;
    private JFormattedTextField dfRight;
    private JFormattedTextField dfTop;
    private JFormattedTextField dfBottom;
    private boolean result = false;
    private PrintRequestAttributeSet attributes;
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PageSetupDialog.this.result = false;
            PageSetupDialog.this.dispose();
        }
    };

    private PageSetupDialog(Frame frame, PrintRequestAttributeSet attributes) {
        super(frame);
        this.attributes = attributes;
        this.setTitle(Messages.getString("PageSetupDialog.PageSetup"));
        this.setDefaultCloseOperation(2);
        this.getContentPane().add((Component)this.initMainPanel(), "Center");
        this.getContentPane().add((Component)this.initBottomPanel(), "South");
        int condition = 2;
        JComponent c = (JComponent)this.getContentPane();
        c.getInputMap(condition).put(KeyStroke.getKeyStroke(KEY_ESCAPE), KEY_ESCAPE);
        c.getActionMap().put(KEY_ESCAPE, this.escapeAction);
        this.setPreferredSize(new Dimension(400, 260));
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.setResizable(false);
        this.setModal(true);
        this.updatePrintServices();
        this.initAttributes();
    }

    public static boolean pageSetup(PrintRequestAttributeSet attributes) {
        PageSetupDialog dialog = new PageSetupDialog((Frame)ApplicationView.getInstance().getFrame(), attributes);
        dialog.setVisible(true);
        return dialog.getResult();
    }

    public boolean getResult() {
        return this.result;
    }

    public static void centerOnScreen(Component window) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension mySize = window.getSize();
        Point newLocation = new Point((screenSize.width - mySize.width) / 2, (screenSize.height - mySize.height) / 2);
        window.setLocation(newLocation);
    }

    protected JPanel initMainPanel() {
        JPanel pnMain = new JPanel();
        JPanel jpanel = new JPanel(new BorderLayout());
        JPanel pnGrid = new JPanel(new GridLayout(0, 1));
        JPanel pnServices = new JPanel(new BorderLayout());
        pnServices.setBorder(BorderFactory.createTitledBorder(Messages.getString("PageSetupDialog.PrintService")));
        JLabel lbName = new JLabel(Messages.getString("PageSetupDialog.Name"));
        lbName.setPreferredSize(this.defaultLabelSize);
        this.cbServices = new JComboBox();
        this.cbServices.setPreferredSize(this.defaultCBSize);
        this.cbServices.setRenderer(new PrintServiceRenderer());
        this.cbServices.setMaximumRowCount(20);
        this.cbServices.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PageSetupDialog.this.updatePaperSizes();
            }
        });
        JPanel pnRow1 = new JPanel(new FlowLayout(0));
        pnRow1.add(lbName);
        pnRow1.add(this.cbServices);
        pnServices.add((Component)pnRow1, "Center");
        JPanel pnPaper = new JPanel(new BorderLayout());
        pnPaper.setBorder(BorderFactory.createTitledBorder(Messages.getString("PageSetupDialog.Paper")));
        JLabel lbSize = new JLabel(Messages.getString("PageSetupDialog.Size"));
        lbSize.setPreferredSize(this.defaultLabelSize);
        this.cbMediaSizes = new JComboBox();
        this.cbMediaSizes.setPreferredSize(this.defaultCBSize);
        this.cbMediaSizes.setMaximumRowCount(20);
        this.cbMediaSizes.setRenderer(new MediaSizeRenderer());
        JPanel pnRow2 = new JPanel(new FlowLayout(0));
        pnRow2.add(lbSize);
        pnRow2.add(this.cbMediaSizes);
        pnPaper.add((Component)pnRow2, "Center");
        pnGrid.add(pnServices);
        pnGrid.add(pnPaper);
        jpanel.add((Component)pnGrid, "North");
        JPanel pnOptions = new JPanel(new BorderLayout());
        JPanel pnOrientation = new JPanel(new GridLayout(0, 1));
        pnOrientation.setBorder(BorderFactory.createTitledBorder(Messages.getString("PageSetupDialog.Orientation")));
        this.rbPortrait = new JRadioButton(Messages.getString("PageSetupDialog.Portrait"));
        this.rbPortrait.addActionListener(this);
        this.rbLandscape = new JRadioButton(Messages.getString("PageSetupDialog.Landscape"));
        this.rbLandscape.addActionListener(this);
        ButtonGroup group = new ButtonGroup();
        group.add(this.rbPortrait);
        group.add(this.rbLandscape);
        this.rbPortrait.setSelected(true);
        pnOrientation.add(this.rbPortrait);
        pnOrientation.add(this.rbLandscape);
        pnOptions.add((Component)pnOrientation, "West");
        JPanel pnMargins = new JPanel(new GridLayout(2, 2));
        pnMargins.setBorder(BorderFactory.createTitledBorder(Messages.getString("PageSetupDialog.Margins")));
        DecimalFormat format = new DecimalFormat("##.##");
        format.setMaximumIntegerDigits(2);
        format.setMinimumFractionDigits(1);
        format.setMaximumFractionDigits(2);
        format.setMinimumIntegerDigits(1);
        format.setParseIntegerOnly(false);
        format.setDecimalSeparatorAlwaysShown(true);
        NumberFormatter nf = new NumberFormatter(format);
        nf.setMinimum(new Float(0.0f));
        nf.setMaximum(new Float(999.0f));
        nf.setAllowsInvalid(true);
        nf.setCommitsOnValidEdit(true);
        this.dfLeft = new JFormattedTextField(nf);
        pnMargins.add(this.createMarginPanel(Messages.getString("PageSetupDialog.Left"), this.dfLeft));
        this.dfRight = new JFormattedTextField(nf);
        pnMargins.add(this.createMarginPanel(Messages.getString("PageSetupDialog.Right"), this.dfRight));
        this.dfTop = new JFormattedTextField(nf);
        pnMargins.add(this.createMarginPanel(Messages.getString("PageSetupDialog.Top"), this.dfTop));
        this.dfBottom = new JFormattedTextField(nf);
        pnMargins.add(this.createMarginPanel(Messages.getString("PageSetupDialog.Bottom"), this.dfBottom));
        pnOptions.add((Component)pnMargins, "Center");
        jpanel.add((Component)new JPanel(), "Center");
        jpanel.add((Component)pnOptions, "South");
        pnMain.add(jpanel);
        return pnMain;
    }

    private JPanel createMarginPanel(String name, JTextField tf) {
        JPanel jpanel = new JPanel();
        JLabel label = new JLabel(name);
        label.setPreferredSize(this.defaultMarginFieldSize);
        tf.setPreferredSize(this.defaultMarginFieldSize);
        jpanel.add((Component)label, "West");
        jpanel.add((Component)tf, "Center");
        return jpanel;
    }

    protected JPanel initBottomPanel() {
        JPanel jpanel = new JPanel(new FlowLayout(2));
        this.bnOK = new JButton(Messages.getString("PageSetupDialog.OK"));
        this.bnOK.setMnemonic(79);
        this.bnOK.addActionListener(new OKAction());
        this.bnCancel = new JButton(Messages.getString("PageSetupDialog.Cancel"));
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        jpanel.add(this.bnOK);
        jpanel.add(this.bnCancel);
        this.getRootPane().setDefaultButton(this.bnOK);
        return jpanel;
    }

    private void updatePrintServices() {
        try {
            PrintService[] printServices = PrintServiceLookup.lookupPrintServices(null, null);
            HashMap<String, PrintService> map = new HashMap<String, PrintService>();
            ArrayList<String> list = new ArrayList<String>();
            for (PrintService printer : printServices) {
                map.put(printer.getName(), printer);
                list.add(printer.getName());
            }
            Collections.sort(list);
            Iterator it = list.iterator();
            while (it.hasNext()) {
                this.cbServices.addItem(map.get(it.next()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updatePaperSizes() {
        try {
            this.cbMediaSizes.removeAllItems();
            HashMap<String, Media> map = new HashMap<String, Media>();
            ArrayList<String> list = new ArrayList<String>();
            PrintService printer = (PrintService)this.cbServices.getSelectedItem();
            Media[] objs = (Media[])printer.getSupportedAttributeValues(Media.class, null, null);
            if (objs != null) {
                for (Media media : objs) {
                    if (!(media instanceof MediaSizeName) || MediaSize.getMediaSizeForName((MediaSizeName)media) == null) continue;
                    map.put(PaperSizes.getMediaName(media.toString()), media);
                    list.add(PaperSizes.getMediaName(media.toString()));
                }
                Collections.sort(list);
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    this.cbMediaSizes.addItem(map.get(it.next()));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initAttributes() {
        if (this.attributes != null) {
            MediaPrintableArea mpa;
            OrientationRequested orientation;
            PrinterName printerName = (PrinterName)this.attributes.get(PrinterName.class);
            if (printerName != null) {
                HashAttributeSet aset = new HashAttributeSet();
                aset.add(new javax.print.attribute.standard.PrinterName(printerName.getPrinterName(), null));
                PrintService[] services = PrintServiceLookup.lookupPrintServices(null, aset);
                if (services.length > 0) {
                    PrintService printer = services[0];
                    this.cbServices.setSelectedItem(printer);
                } else {
                    this.selectDefaultPrinter();
                }
            } else {
                this.selectDefaultPrinter();
            }
            Media media = (Media)this.attributes.get(Media.class);
            if (media != null && media instanceof MediaSizeName) {
                Media obj;
                int i;
                int count = this.cbMediaSizes.getItemCount();
                boolean found = false;
                for (i = 0; i < count; ++i) {
                    obj = (Media)this.cbMediaSizes.getItemAt(i);
                    if (media != obj) continue;
                    this.cbMediaSizes.setSelectedIndex(i);
                    found = true;
                    break;
                }
                if (!found) {
                    for (i = 0; i < count; ++i) {
                        obj = (Media)this.cbMediaSizes.getItemAt(i);
                        if (!media.toString().equalsIgnoreCase(obj.toString())) continue;
                        this.cbMediaSizes.setSelectedIndex(i);
                        break;
                    }
                }
            }
            if ((orientation = (OrientationRequested)this.attributes.get(OrientationRequested.class)) != null) {
                if (orientation == OrientationRequested.LANDSCAPE) {
                    this.rbLandscape.setSelected(true);
                } else {
                    this.rbPortrait.setSelected(true);
                }
            }
            if ((mpa = (MediaPrintableArea)this.attributes.get(MediaPrintableArea.class)) != null) {
                float lm = mpa.getX(25400);
                float tm = mpa.getY(25400);
                float rm = mpa.getWidth(25400);
                float bm = mpa.getHeight(25400);
                if (media != null && media instanceof MediaSizeName) {
                    MediaSize size = MediaSize.getMediaSizeForName((MediaSizeName)media);
                    if (size != null) {
                        float w = size.getX(25400);
                        float h = size.getY(25400);
                        rm = w - lm - rm;
                        bm = h - tm - bm;
                    } else {
                        rm = 0.0f;
                        bm = 0.0f;
                    }
                } else {
                    rm = 0.0f;
                    bm = 0.0f;
                }
                if (lm < 0.0f) {
                    lm = 0.0f;
                }
                if (tm < 0.0f) {
                    tm = 0.0f;
                }
                if (rm < 0.0f) {
                    rm = 0.0f;
                }
                if (bm < 0.0f) {
                    bm = 0.0f;
                }
                if (this.rbLandscape.isSelected()) {
                    float tmp = rm;
                    rm = bm;
                    bm = lm;
                    lm = tm;
                    tm = tmp;
                }
                this.dfLeft.setValue(new Float(lm));
                this.dfRight.setValue(new Float(rm));
                this.dfTop.setValue(new Float(tm));
                this.dfBottom.setValue(new Float(bm));
            }
        }
    }

    private void selectDefaultPrinter() {
        PrintService service = PrintServiceLookup.lookupDefaultPrintService();
        if (service != null) {
            this.cbServices.setSelectedItem(service);
        }
    }

    private void updateAttributes() {
        try {
            if (this.attributes == null) {
                this.attributes = new HashPrintRequestAttributeSet();
            }
            PrintService ps = (PrintService)this.cbServices.getSelectedItem();
            this.attributes.add(new PrinterName(ps.getName()));
            this.attributes.add((Media)this.cbMediaSizes.getSelectedItem());
            OrientationRequested orientation = this.rbPortrait.isSelected() ? OrientationRequested.PORTRAIT : OrientationRequested.LANDSCAPE;
            this.attributes.add(orientation);
            MediaSize mediaSize = MediaSize.getMediaSizeForName((MediaSizeName)this.cbMediaSizes.getSelectedItem());
            Float lmObj = (Float)this.dfLeft.getValue();
            Float rmObj = (Float)this.dfRight.getValue();
            Float tmObj = (Float)this.dfTop.getValue();
            Float bmObj = (Float)this.dfBottom.getValue();
            float lm = lmObj.floatValue();
            float rm = rmObj.floatValue();
            float tm = tmObj.floatValue();
            float bm = bmObj.floatValue();
            if (lm < 0.0f) {
                lm = 0.0f;
            }
            if (tm < 0.0f) {
                tm = 0.0f;
            }
            if (rm < 0.0f) {
                rm = 0.0f;
            }
            if (bm < 0.0f) {
                bm = 0.0f;
            }
            if (this.rbLandscape.isSelected()) {
                float tmp = lm;
                lm = bm;
                bm = rm;
                rm = tm;
                tm = tmp;
            }
            float wid = mediaSize.getX(25400);
            float hgt = mediaSize.getY(25400);
            float paw = wid - lm - rm;
            float pah = hgt - tm - bm;
            this.attributes.add(new MediaPrintableArea(lm, tm, paw, pah, 25400));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Float lmObj = (Float)this.dfLeft.getValue();
        Float rmObj = (Float)this.dfRight.getValue();
        Float tmObj = (Float)this.dfTop.getValue();
        Float bmObj = (Float)this.dfBottom.getValue();
        float lm = lmObj.floatValue();
        float rm = rmObj.floatValue();
        float tm = tmObj.floatValue();
        float bm = bmObj.floatValue();
        if (this.rbPortrait.isSelected()) {
            float tmp = rm;
            rm = bm;
            bm = lm;
            lm = tm;
            tm = tmp;
        } else {
            float tmp = lm;
            lm = bm;
            bm = rm;
            rm = tm;
            tm = tmp;
        }
        this.dfLeft.setValue(new Float(lm));
        this.dfRight.setValue(new Float(rm));
        this.dfTop.setValue(new Float(tm));
        this.dfBottom.setValue(new Float(bm));
    }

    class MediaSizeRenderer
    extends JLabel
    implements ListCellRenderer {
        public MediaSizeRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value != null) {
                MediaSizeName media = (MediaSizeName)value;
                this.setText(PaperSizes.getMediaName(media.toString()));
            }
            return this;
        }
    }

    class PrintServiceRenderer
    extends JLabel
    implements ListCellRenderer {
        public PrintServiceRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value != null) {
                PrintService ps = (PrintService)value;
                this.setText(ps.getName());
            }
            return this;
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PageSetupDialog.this.result = false;
            PageSetupDialog.this.dispose();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PageSetupDialog.this.updateAttributes();
            PageSetupDialog.this.result = true;
            PageSetupDialog.this.dispose();
        }
    }
}

