/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.options.format;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;

public abstract class DefaultFontAndColor
implements EditableFonts {
    public static final String FC_ENTITY = "Entity";
    public static final String FC_LOGICAL_VIEW = "Logical View";
    public static final String FC_TABLE = "Table";
    public static final String FC_RELATIONAL_VIEW = "Relational View";
    public static final String FC_STRUCTURED_TYPE = "Structured Type";
    public static final String FC_CUBE = "Cube";
    public static final String FC_DIMENSION = "Dimension";
    public static final String FC_LEVEL = "Level";
    public static final String FC_PROCESS = "Process";
    public static final String FC_AGENT = "External Agent";
    public static final String FC_INFO_STORE = "Information Store";
    public static final String FC_PD_CLASS = "Predefined Class";
    public static final String FC_IN_OUT_PARAMS = "In-Out Parameters";
    public static final String FC_TRANSFORMATION = "Transformation";
    public static final String FC_NOTE = "Note";
    public static final String FC_LABEL = "Label";
    public static final String FC_RELATIONSHIP_ATTRIBUTES = "Relationship Attributes";
    public static final String FC_LEGEND = "Legend";
    public static final String FC_CLASSIFICATION_TYPE = "Classification Type";
    public static final List modifiedObjects = new ArrayList();
    private Color backgroundColor = null;
    private Color foregroundColor = null;
    private String className;
    protected List editableFonts;
    private boolean noBackgroundColor = false;
    private boolean noForegroundColor = false;

    protected abstract void initEditableFonts();

    public abstract DefaultFontAndColor copy();

    public DefaultFontAndColor(String className, Color backgroundColor, Color foregroundColor) {
        this.className = className;
        this.backgroundColor = backgroundColor;
        this.foregroundColor = foregroundColor;
        this.initEditableFonts();
    }

    public List getEditableFonts() {
        return this.editableFonts;
    }

    public FontObject getFontObject(String type) {
        for (FontObject next : this.editableFonts) {
            if (!type.equalsIgnoreCase(next.getType())) continue;
            return next;
        }
        return null;
    }

    public FontObject getFontObjectByID(String id) {
        for (FontObject next : this.editableFonts) {
            if (!id.equalsIgnoreCase(next.getTypeID())) continue;
            return next;
        }
        return null;
    }

    public void resetFontsAndColors(boolean useDefault) {
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(Color foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    public String getClassName() {
        return this.className;
    }

    public static void clearModified() {
        modifiedObjects.clear();
    }

    public static boolean isModified(String classsName) {
        return modifiedObjects.contains(classsName);
    }

    public static void setModified(String className) {
        if (!modifiedObjects.contains(className)) {
            modifiedObjects.add(className);
        }
    }

    @Override
    public String getFCObjectType() {
        return this.className;
    }

    public boolean getNoBackgroundColor() {
        return this.noBackgroundColor;
    }

    public void setNoBackgroundColor(boolean noBackgroundColor) {
        this.noBackgroundColor = noBackgroundColor;
    }

    public boolean getNoForegroundColor() {
        return this.noForegroundColor;
    }

    public void setNoForegroundColor(boolean noForegroundColor) {
        this.noForegroundColor = noForegroundColor;
    }
}

