/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.gui.swing;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Context;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.dialogs.URLChooserShortcut;
import oracle.ide.dialogs.URLChooserShortcutProvider;
import oracle.ide.layout.URL2String;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.icons.OracleIcons;

public class URLChooserShortcuts
implements URLChooserShortcutProvider {
    private static List<URLChooserShortcut> s_shortcuts = null;
    private static final Logger LOGGER = new Logger(URLChooserShortcuts.class);

    private static boolean isValidURL(URL url) {
        return URLFileSystem.exists((URL)url) && URLFileSystem.isDirectory((URL)url) && !URLFileSystem.isHidden((URL)url);
    }

    private static void addIfExists(URL url, String name, Collection<URLChooserShortcut> list, Icon icon) {
        if (URLChooserShortcuts.isValidURL(url)) {
            boolean notFound = true;
            for (URLChooserShortcut shortcut : list) {
                if (!url.equals(shortcut.url())) continue;
                notFound = false;
                break;
            }
            if (notFound) {
                if (icon == null) {
                    list.add(new URLChooserShortcut(OracleIcons.getIcon((String)"folder.png"), name, url));
                } else {
                    list.add(new URLChooserShortcut(icon, name, url));
                }
            }
        }
    }

    public Collection<URLChooserShortcut> createShortcuts(Context context) {
        FileOpenHistory.getInstance().setHistoryCount(5);
        if (s_shortcuts == null) {
            s_shortcuts = new ArrayList<URLChooserShortcut>();
        }
        String[] h = FileOpenHistory.getInstance().getFileHistory();
        for (int i = h.length - 1; i >= 0; --i) {
            try {
                String path = h[i];
                URL url = URL2String.toURL((String)path);
                File f = new File(url.toURI());
                if (!URLFileSystem.exists((URL)url)) continue;
                if (f.isFile()) {
                    f = f.getParentFile();
                    url = f.toURI().toURL();
                }
                URLChooserShortcuts.addIfExists(url, URLFileSystem.getName((URL)url), s_shortcuts, null);
                continue;
            }
            catch (Exception e) {
                LOGGER.error("URLChooserShortcuts.createShortcuts() Error when adding user history directories ", e);
            }
        }
        return s_shortcuts;
    }
}

