/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.exceptions;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.crest.exports.ddl.DDLException;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DDLExceptionList {
    private static final String EXCEPTIONS_FILE_NAME = "ddlexceptions.xml";
    private static final String DDLEXCEPTION_ELEMENT = "ddlexception";
    private static final String DDLEXCEPTIONS_NUMBER = "ddlexception";
    private static final String DDLEXCEPTIONS_DESCRIPTION = "number";
    private static final String DDLEXCEPTIONS_SELECTED = "selected";
    private List<DDLException> ddlExceptions = new ArrayList<DDLException>();
    private static final Logger LOGGER = new Logger(DDLExceptionList.class);

    public List<DDLException> getDDLExceptions() {
        return this.ddlExceptions;
    }

    public boolean addDDLException(DDLException ddlException) {
        if (!this.containsDDLException(ddlException)) {
            return this.ddlExceptions.add(ddlException);
        }
        return false;
    }

    public void removeDDLException(DDLException ddlException) {
        this.ddlExceptions.remove(ddlException);
    }

    public boolean containsDDLException(DDLException ddlException) {
        for (DDLException next : this.ddlExceptions) {
            if (ddlException.getNumber() != next.getNumber()) continue;
            return true;
        }
        return false;
    }

    public void clearDDLExceptionsList() {
        this.ddlExceptions.clear();
    }

    public void init() {
        block5: {
            try {
                File file = new File(EXCEPTIONS_FILE_NAME);
                if (!file.exists()) break block5;
                FileInputStream fis = new FileInputStream(file);
                InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
                InputSource inputSource = new InputSource(isr);
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                Document doc = builder.parse(inputSource);
                NodeList list = doc.getElementsByTagName("ddlexception");
                int listLength = list.getLength();
                for (int i = 0; i < listLength; ++i) {
                    Element element = (Element)list.item(i);
                    int number = 0;
                    try {
                        number = Integer.parseInt(element.getAttribute("ddlexception"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    String description = StringUtilities.decodeAttributeValue(element.getAttribute(DDLEXCEPTIONS_DESCRIPTION));
                    boolean selected = Boolean.valueOf(element.getAttribute(DDLEXCEPTIONS_SELECTED));
                    DDLException ddlException = new DDLException(number, description);
                    ddlException.setSelected(selected);
                    this.addDDLException(ddlException);
                }
            }
            catch (Exception e) {
                LOGGER.error("Unable to initialize DDL Exceptions: ", e);
            }
        }
    }
}

