/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.dmweb;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.ByteArrayInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.swing.Icon;
import oracle.dbtools.crest.model.ClassificationType;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.Legend;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.ImpliedForeignKey;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TVNote;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.editor.viewbuilder.SQLNameHelper;
import oracle.dbtools.crest.swingui.logical.DPVLogical;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.util.dmweb.DiagramProcessor;
import oracle.dbtools.crest.util.dmweb.DiagramToJSON;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;
import oracle.dbtools.crest.util.options.format.DefaultLineWidthAndColor;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.javatools.codeex.Base64;
import oracle.jdbc.OracleDriver;

public class DiagramToSVG {
    public static final Color DEFAULT_FOREGROUND = Color.BLACK;
    public static final Color DEFAULT_BACKGROUND = new Color(255, 255, 180);
    public static final Color DEFAULT_DATATYPE_COLOR = new Color(0, 128, 0);
    public static final Color DEFAULT_ALLOW_NULL_COLOR = Color.RED;
    public static Font DIALOG_FONT = new Font("Dialog", 0, 10);
    public static final String NOT_NULL = "*";
    public static final int TYPE_LEFT = 2;
    protected static final Icon KEY_ICON = GUIConfiguration.getInstance().getIcon("KEY_ICON");
    private static final String LB_DIAGRAM = "Diagram:";
    private static final String LB_AUTHOR = "Author:";
    private static final String LB_CREATED_ON = "Created on:";
    private static final String LB_MODIFIED_ON = "Modified on:";
    public static final String LB_CHANGED_BY = "Modified by:";
    private static final String LB_DESIGN = "Design:";
    private static final String LB_MODEL = "Model:";
    public static float OPACITY_ICON = 1.0f;
    protected static final Icon PKEY_ICON = GUIConfiguration.getInstance().getIcon("PKEY_ICON");
    protected static final Icon FK_ICON = GUIConfiguration.getInstance().getIcon("FKEY_SMALL_ICON");
    public static final int ROW_SPACING = 3;
    public static final int MORE_ARROW_PADDING = 4;
    public static final int MORE_ARROW_WIDTH = 8;
    public static final int MORE_ARROW_HEIGHT = 8;
    private static final int LEFT_SIDE = 0;
    private static final int TOP_SIDE = 1;
    private static final int RIGHT_SIDE = 2;
    private static final int BOTTOM_SIDE = 3;
    public static final int COLUMN_LEFT = 25;
    public static String PK_PATH = "<path d=\"M418.119,331.046c4.094,4.374,7.766,8.186,10.996,11.416c3.237,3.238,6.714,6.376,10.427,9.422   c3.71,3.042,6.427,4.568,8.135,4.568c3.241,0,9.517-4.661,18.843-13.99c9.328-9.321,13.989-15.604,13.989-18.842   c0-1.523-2.714-5.421-8.138-11.704c-5.421-6.276-12.364-13.702-20.838-22.271c-8.473-8.565-16.703-16.744-24.694-24.55   c-8.001-7.81-15.8-15.373-23.417-22.703c-7.611-7.327-11.992-11.56-13.135-12.703c-1.902-1.902-4.093-2.853-6.563-2.853   c-3.237,0-9.521,4.661-18.843,13.988c-9.328,9.322-13.989,15.605-13.989,18.843c0,1.711,1.522,4.421,4.568,8.138   c3.046,3.71,6.188,7.187,9.421,10.424c3.23,3.23,7.047,6.899,11.42,10.992c4.377,4.093,6.848,6.423,7.423,6.995l-27.408,27.404   L254.954,222.268c24.94-33.498,37.408-68.236,37.408-104.211c0-31.024-9.761-56.293-29.263-75.801   c-19.512-19.511-44.778-29.265-75.805-29.265c-30.454,0-60.244,9.042-89.363,27.119c-29.121,18.083-52.727,41.686-70.808,70.808   C9.042,140.038,0,169.828,0,200.28c0,31.029,9.753,56.286,29.265,75.803c19.511,19.517,44.777,29.27,75.801,29.27   c35.976,0,70.71-12.467,104.212-37.407l191.574,191.579c5.332,5.328,11.796,7.994,19.417,7.994c7.991,0,15.704-3.72,23.12-11.14   c7.426-7.426,11.143-15.129,11.143-23.127c0-7.617-2.666-14.092-7.994-19.417l-62.811-62.811l27.405-27.404   C411.699,324.195,414.033,326.666,418.119,331.046z M221.556,161.458c-10.656,10.657-23.601,15.987-38.828,15.987   c-7.996,0-15.896-1.812-23.7-5.43c3.617,7.808,5.426,15.706,5.426,23.7c0,15.229-5.327,28.171-15.987,38.828   c-10.66,10.655-23.606,15.986-38.831,15.986c-15.227,0-28.168-5.325-38.828-15.986c-10.657-10.657-15.987-23.599-15.987-38.828   c0-15.227,5.327-28.171,15.987-38.828C81.464,146.23,94.409,140.9,109.636,140.9c7.992,0,15.893,1.809,23.695,5.424   c-3.616-7.804-5.424-15.706-5.424-23.699c0-15.227,5.327-28.171,15.987-38.828c10.66-10.657,23.604-15.987,38.831-15.987   c15.227,0,28.171,5.327,38.828,15.987c10.657,10.66,15.987,23.601,15.987,38.828C237.539,137.852,232.209,150.797,221.556,161.458z   \" fill=\"#ff8345\"/>";
    public static String FK_PATH = "<path d=\"M40.332,31.592c-2.377,0-4.515,1-6.033,2.598l-17.737-8.686c0.061-0.406,0.103-0.82,0.103-1.246    c0-0.414-0.04-0.818-0.098-1.215l17.711-8.589c1.519,1.609,3.666,2.619,6.054,2.619c4.603,0,8.333-3.731,8.333-8.333    c0-4.603-3.73-8.333-8.333-8.333s-8.333,3.73-8.333,8.333c0,0.414,0.04,0.817,0.098,1.215l-17.709,8.589    c-1.519-1.609-3.666-2.619-6.054-2.619C3.73,15.925,0,19.656,0,24.258c0,4.603,3.73,8.333,8.333,8.333    c2.377,0,4.515-1,6.033-2.596l17.736,8.685c-0.062,0.406-0.104,0.82-0.104,1.245c0,4.604,3.73,8.333,8.333,8.333    s8.333-3.729,8.333-8.333C48.665,35.322,44.935,31.592,40.332,31.592z\" fill=\"#13bf3b\"/>";
    public static String UK_PATH = "\t<polygon points=\"236.99,11.41 0,246.348 236.99,478.678 236.99,350.609 129.864,245 236.99,139.391  \" fill=\"#0064fb\"/>\n<polygon points=\"253.01,478.59 490,243.651 253.01,11.322 253.01,139.391 360.136,245 253.01,350.609  \" fill=\"#0064fb\"/>";
    public static String LINK_PATH = "<path fill=\"black\" d=\"M660.224 422.656c6.976 16.192-0.512 35.008-16.768 42.048-16.128 6.976-34.944-0.448-41.984-16.768-8.448-19.776-20.736-37.696-36.224-53.248-64.64-64.64-177.344-64.64-241.92 0l-145.216 145.28c-66.688 66.688-66.688 175.232 0 241.984 66.688 66.688 175.104 66.752 241.92 0l92.8-92.864c12.48-12.48 32.768-12.48 45.248 0s12.48 32.768 0 45.248l-92.8 92.864c-91.648 91.648-240.832 91.52-332.416 0-91.712-91.648-91.712-240.832 0-332.48l145.216-145.28c44.352-44.416 103.424-68.864 166.272-68.864s121.792 24.448 166.208 68.864c21.248 21.312 38.016 45.952 49.664 73.216zM891.136 401.344l-145.216 145.216c-88.768 88.832-243.712 88.832-332.416 0-21.312-21.312-38.080-45.952-49.728-73.216-7.040-16.256 0.448-35.072 16.704-42.048 16.064-6.784 35.008 0.512 41.984 16.768 8.512 19.776 20.8 37.696 36.288 53.248 64.64 64.64 177.344 64.64 241.92 0l145.216-145.216c66.688-66.688 66.688-175.232 0-241.984-66.752-66.624-175.168-66.688-241.92 0l-92.8 92.864c-12.48 12.48-32.768 12.48-45.248 0s-12.48-32.768 0-45.248l92.8-92.864c45.824-45.824 105.984-68.736 166.208-68.736s120.448 22.912 166.272 68.736c91.584 91.648 91.584 240.768-0.064 332.48z\" />";
    static String FK_SYM_OPEN_SVG = "<svg id=\"fk_sym\" viewBox=\"0 0 48.665 48.665\" style=\"enable-background:new 0 0 48.665 48.665;\" >";
    public static String FK_SYM_SVG = FK_SYM_OPEN_SVG + "\n<g>\n" + FK_PATH + "\n</g>\n</svg>";
    public static Color FK_SYM_COLOR = new Color(19, 192, 159);
    static String PK_SYM_OPEN_SVG = "<svg id=\"pk_sym\" viewBox=\"0 0 480.509 480.509\" style=\"enable-background:new 0 0 480.509 480.509;\" >";
    public static String PK_SYM_SVG = PK_SYM_OPEN_SVG + "\n<g>\n" + PK_PATH + "\n</g>\n</svg>";
    public static Color PK_SYM_COLOR = new Color(255, 131, 69);
    static String UK_SYM_OPEN_SVG = "<svg id=\"uk_sym\" viewBox=\"0 0 490 490\" style=\"enable-background:new 0 0 490 490;\" >";
    public static String UK_SYM_SVG = UK_SYM_OPEN_SVG + "\n<g>\n" + UK_PATH + "\n</g>\n</svg>";
    public static Color UK_SYM_COLOR = new Color(0, 100, 251);
    static String LINK_SYM_OPEN_SVG = "<svg id=\"link_sym\" viewBox=\"0 0 1000 900\" style=\"enable-background:new 0 0 1000 900;\" >";
    public static String LINK_SYM_SVG = LINK_SYM_OPEN_SVG + "\n<g>\n" + LINK_PATH + "\n</g>\n</svg>";
    public static Color LINK_SYM_COLOR = Color.BLACK;
    public static final String ALLOW_NULL = "";
    public static String SHAPE_TYPE_TABLE = "table";
    public static String SHAPE_TYPE_VIEW = "view";
    public static String SHAPE_TYPE_NOTE = "note";
    public static final int TITLE_PADDING = 3;
    public static String THUMBNAIL_TEST = "<figure>\n  <figcaption>25x25</figcaption>\n  <div>\n    <svg viewBox=\"0 0 def_width def_height\" width=\"25\" height=\"25\">\n      <use xlink:href=\"#diagramxxxid\"/>\n    </svg>\n  </div>\n</figure>\n<figure>\n  <figcaption>50x25</figcaption>\n  <div>\n    <svg viewBox=\"0 0 def_width def_height\" width=\"50\" height=\"25\">\n      <use xlink:href=\"#diagramxxxid\"/>\n    </svg>\n  </div>\n</figure>\n<figure>\n  <figcaption>50x50</figcaption>\n  <div>\n    <svg viewBox=\"0 0 def_width def_height\" width=\"50\" height=\"50\">\n      <use xlink:href=\"#diagramxxxid\"/>\n    </svg>\n  </div>\n</figure>\n<figure>\n  <figcaption>100x50</figcaption>\n  <div>\n    <svg viewBox=\"0 0 def_width def_height\" width=\"100\" height=\"50\">\n      <use xlink:href=\"#diagramxxxid\"/>\n    </svg>\n  </div>\n</figure>\n<figure>\n  <figcaption>100x100</figcaption>\n  <div>\n    <svg viewBox=\"0 0 def_width def_height\" width=\"100\" height=\"100\">\n      <use xlink:href=\"#diagramxxxid\"/>\n    </svg>\n  </div>\n</figure>\n<figure>\n  <figcaption>200x100</figcaption>\n  <div>\n    <svg viewBox=\"0 0 def_width def_height\" width=\"200\" height=\"100\">\n      <use xlink:href=\"#diagramxxxid\"/>\n    </svg>\n  </div>\n</figure>\n<figure>\n  <figcaption>200x200</figcaption>\n  <div>\n    <svg viewBox=\"0 0 def_width def_height\" width=\"200\" height=\"200\">\n      <use xlink:href=\"#diagramxxxid\"/>\n    </svg>\n  </div>\n</figure>\n<figure>\n  <figcaption>Real Size</figcaption>\n  <div>\n    <svg viewBox=\"0 0 def_width def_height\" width=\"def_width\" height=\"def_height\">\n      <use xlink:href=\"#diagramxxxid\"/>\n    </svg>\n  </div>\n</figure>";
    protected transient Color defaultForeground;
    protected transient Color defaultBackground;
    protected transient Color bordercolor;
    protected transient Color datatypeColor;
    protected transient Color allowNullColor;
    protected transient Color typeColor;
    Table table;
    TopView tv;
    Writer sb;
    DesignPartView dpv;
    Graphics2D g;
    public static final int ARROW_NONE = 0;
    public static final int ARROW_CLASSIC = 1;
    public static final int ARROW_TECHNICAL = 2;
    public static final int ARROW_SIMPLE = 4;
    public static final int ARROW_CIRCLE = 5;
    public static final int ARROW_LINE = 7;
    public static final int ARROW_DOUBLELINE = 8;
    public static final int ARROW_DIAMOND = 9;
    public static final int STYLE_ORTHOGONAL = 11;
    public static final int STYLE_BEZIER = 12;
    public static final int STYLE_SPLINE = 13;
    public static final int ARROW_TECHNICAL_IDENT = 14;
    public static final int ARROW_CIRCLE_IDENT = 15;
    public static final int ARROW_TRIANGLE = 16;
    public static final int ARROW_TRIANGLE_IDENT = 17;
    public static final int ARROW_LINE_CIRCLE = 18;
    public static final int ARROW_TRIANGLE_CIRCLE = 19;
    public static final int ARROW_TRIANGLE_CIRCLE_NO_FILL = 20;
    public static final int ARROW_TRIANGLE_CROSS = 21;
    public static final int ARROW_LINE_CROSS = 22;
    public static final int ARROW_LINE_CIRCLE_NO_FILL = 23;

    /*
     * WARNING - void declaration
     */
    public static void generateTableView(AbstractView table, TopView tv, Writer sb, Graphics2D g, boolean createLinks, String id_suffix) {
        Iterator it;
        DesignPartView dpv = tv.getDesignPartView();
        Color bgcol = DiagramToSVG.getBackgroundColor(table, tv);
        Color fgcol = DiagramToSVG.getTableForegroundColor(table, tv);
        Color bcol = DiagramToSVG.getBorderColor(table, tv);
        int borderWidth = 1;
        Rectangle bounds = null;
        bounds = tv.getCellView() != null ? tv.getCellView().getBounds().getBounds() : tv.getBounds();
        int titlePosition = 20;
        int yCursor = 0;
        int xCursor = 0;
        int width = bounds.width;
        int height = bounds.height;
        TopView efo = tv;
        Object longName = null;
        if (tv != null) {
            longName = tv.toString();
            if (tv.getDesignPartView().showSchemaName() && table.getSchemaObject() != null) {
                longName = table.getSchemaObject().getName() + "." + (String)longName;
            }
        }
        if (table.isBST()) {
            longName = (String)longName + " (" + table.getBasedOnStructuredType().getName() + ")";
        }
        String cid = DiagramToSVG.getClipPathID(tv, id_suffix);
        DiagramToSVG.addShape(bgcol, bcol, bounds, sb, cid);
        DiagramToSVG.addRect(fgcol, width, height, 20, 20, sb);
        Font titleFont = DiagramToSVG.getTitleFont(table, tv);
        Font keyFont = DiagramToSVG.getFont(table, tv, EditableFonts.FO_KEY);
        FontMetrics fm = g.getFontMetrics(titleFont);
        int colTextHeight = fm.getHeight();
        yCursor = Math.max(colTextHeight, titleFont.getSize());
        xCursor = (width - fm.stringWidth((String)longName)) / 2;
        if (xCursor < titlePosition) {
            xCursor = titlePosition;
        }
        Color tcolor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_TITLE);
        String[] wrappedTitle = DiagramToSVG.wrapText((String)longName, DiagramToSVG.getMaxChars((String)longName, fm, width - titlePosition - 5));
        for (int t = 0; t < wrappedTitle.length; ++t) {
            String text = wrappedTitle[t];
            if (t == 0) {
                String id = table.getShortObjectID() + id_suffix;
                DiagramToSVG.addText(text, xCursor, yCursor, tcolor, sb, titleFont, createLinks, table.getShortObjectID(), id, table.isDeprecated());
            } else {
                DiagramToSVG.addText(text, xCursor, yCursor, tcolor, sb, titleFont, table.isDeprecated());
            }
            yCursor += colTextHeight;
        }
        yCursor -= colTextHeight;
        int iconXPos = 2;
        if (table.isRemoteObject()) {
            DiagramToSVG.addUseOfDef("link_sym", iconXPos, colTextHeight / 2, 8, 8, sb);
        }
        DiagramToSVG.addLine(0, yCursor += 3 + borderWidth, width - 2, yCursor, fgcol, sb);
        ContainedObject[] elements = table.getElements();
        String longestName = DesignPartView.getLongestName(elements, dpv.isExpandComplexTypes());
        Font colFont = DiagramToSVG.getFont(table, tv, EditableFonts.FO_ELEMENT);
        fm = g.getFontMetrics(colFont);
        int nameSize = fm.stringWidth(longestName);
        int nnPos = fm.stringWidth("KW");
        int namePos = 3 + fm.stringWidth("KWN");
        int dtPos = 20 + namePos + nameSize;
        Color nnColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_NOT_NULL);
        Color pkColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_PK);
        Color ukColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_UK);
        Color fkColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_FK);
        Color dtColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_DATATYPE);
        Color elemColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_ELEMENT);
        Color keyColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_KEY);
        colTextHeight = fm.getHeight();
        if (table.isBST() && table.getTypeSubstitution() != null) {
            StructuredType st = table.getBasedOnStructuredType();
            if (st != null) {
                TypeElement[] elems = st.getElements();
                longestName = DesignPartView.getLongestTypeName(elems);
                colTextHeight = fm.getMaxAscent() - fm.getMaxDescent() + 3;
                for (int i = 0; i < elems.length; ++i) {
                    TypeElement elm = elems[i];
                    DiagramToSVG.addText(elm.getName(), 25, yCursor += fm.getHeight(), elemColor, sb, colFont);
                    int n = fm.stringWidth(longestName) + 50;
                    DiagramToSVG.addText(elm.getDataType(), n, yCursor, dtColor, sb, colFont);
                }
            }
        } else {
            for (int i = 0; i < elements.length; ++i) {
                void var45_58;
                boolean partOfFK;
                ContainedObjectWithDomain element = (ContainedObjectWithDomain)elements[i];
                if (efo.getHiddenElements().contains(element) || element.isOid() || dpv.showKeyElements() && !element.isPKElement() && !element.isFKElement() && !element.isUnique()) continue;
                int anLeft = nnPos;
                String text = element.getNullsAllowed() ? ALLOW_NULL : NOT_NULL;
                DiagramToSVG.addText(text, anLeft, yCursor += fm.getHeight(), nnColor, sb, colFont);
                String string = " ";
                Color color = elemColor;
                boolean bl = partOfFK = table instanceof FKContainer && element.isPartOfUnresolvedFK(table);
                if (element.isPKElement()) {
                    String string2 = "P";
                    color = pkColor;
                    if (element.isFKElement() || partOfFK) {
                        String string3 = string2.concat("F");
                    }
                } else if (element.isUnique()) {
                    String string4 = "U";
                    color = ukColor;
                    if (element.isFKElement() || partOfFK) {
                        String string5 = string4.concat("F");
                    }
                } else if (element.isFKElement() || partOfFK) {
                    String string6 = "F";
                    color = fkColor;
                }
                if (!" ".equals(var45_58)) {
                    DiagramToSVG.addText((String)var45_58, 2, yCursor, color, sb, colFont);
                }
                anLeft = namePos;
                if (element.isDeprecated()) {
                    // empty if block
                }
                DiagramToSVG.addText(element.getName(), anLeft, yCursor, elemColor, sb, colFont);
                if (dpv.showAllDetails() || dpv.showDatatype()) {
                    anLeft = dtPos;
                    DiagramToSVG.addText(DiagramToSVG.getDataType(element, table), anLeft, yCursor, dtColor, sb, colFont);
                }
                if (dpv.showComments()) {
                    // empty if block
                }
                if (yCursor > height) {
                    int right = width - 4;
                    int left = right - 8;
                    int center = right - 4;
                    int bottom = height - 4;
                    int top = bottom - 8;
                    int[] xPts = new int[]{center, left, right};
                    int[] yPts = new int[]{bottom, top, top};
                    DiagramToSVG.addPolygon(fgcol, xPts, yPts, 1, sb, true);
                    break;
                }
                if ((!dpv.isExpandComplexTypes() || element.getUse() != 3) && dpv.isExpandComplexTypes() && element.getUse() != 4) continue;
            }
        }
        if (dpv.showAllDetails() || dpv.showKeys()) {
            List keys = DiagramToSVG.getKeys(table.getKeys());
            it = null;
            if (keys.size() > 0) {
                if (dpv.showAllDetails() || dpv.showElements()) {
                    yCursor += 6;
                    for (KeyObject key : keys) {
                        if (efo.getHiddenElements().contains(key)) continue;
                        DiagramToSVG.addLine(0, yCursor, width - 2, yCursor, bcol, sb);
                        break;
                    }
                }
                for (KeyObject key : keys) {
                    if (!key.isPK() && !key.isUnique() || efo.getHiddenElements().contains(key)) continue;
                    if (key.isPK()) {
                        // empty if block
                    }
                    fm = g.getFontMetrics(keyFont);
                    yCursor += fm.getHeight();
                    Object keyName = key.getName();
                    if (dpv.showAllDetails() || dpv.showKeyAndIndexColumns()) {
                        Index ind;
                        ContainedObject[] containedObjectArray = key.getElements();
                        keyName = (String)keyName + " (";
                        String expr = null;
                        if (key instanceof Index && ALLOW_NULL.equals(expr = (ind = (Index)key).getIndexExpression())) {
                            expr = null;
                        }
                        if (expr == null) {
                            for (int j = 0; j < containedObjectArray.length; ++j) {
                                ContainedObject column = containedObjectArray[j];
                                String colName = column.getName();
                                if (j > 0) {
                                    keyName = (String)keyName + ", ";
                                }
                                keyName = (String)keyName + colName;
                            }
                        } else {
                            keyName = (String)keyName + expr;
                        }
                        keyName = (String)keyName + ")";
                    }
                    if (key.isDeprecated()) {
                        // empty if block
                    }
                    int n = nnPos;
                    DiagramToSVG.addText((String)keyName, n, yCursor, keyColor, sb, keyFont);
                    if (yCursor <= height) continue;
                    int right = width - 4;
                    int left = right - 8;
                    int center = right - 4;
                    int bottom = height - 4;
                    int top = bottom - 8;
                    int[] xPts = new int[]{center, left, right};
                    int[] yPts = new int[]{bottom, top, top};
                    DiagramToSVG.addPolygon(fgcol, xPts, yPts, 1, sb, true);
                    break;
                }
            }
        }
        if (dpv instanceof DPVRelational && (dpv.showAllDetails() || dpv.showFKeys())) {
            List fKeys = DiagramToSVG.getFKeys(table.getKeys());
            it = null;
            if (fKeys.size() > 0) {
                if (dpv.showAllDetails() || dpv.showElements()) {
                    yCursor += 6;
                    for (KeyObject key : fKeys) {
                        if (efo.getHiddenElements().contains(key)) continue;
                        DiagramToSVG.addLine(0, yCursor, width - 2, yCursor, bcol, sb);
                        break;
                    }
                }
                for (KeyObject key : fKeys) {
                    if (efo.getHiddenElements().contains(key)) continue;
                    int LEFT = 4;
                    fm = g.getFontMetrics(keyFont);
                    int n = -fm.getHeight() / 2;
                    DiagramToSVG.addUseOfDef("fk_sym", LEFT, (yCursor += fm.getHeight()) + n, 8, 8, sb);
                    Object keyName = key.getName();
                    if (dpv.showAllDetails() || dpv.showKeyAndIndexColumns()) {
                        Index ind;
                        ContainedObject[] columns = key.getElements();
                        keyName = (String)keyName + " (";
                        String expr = null;
                        if (key instanceof Index && ALLOW_NULL.equals(expr = (ind = (Index)key).getIndexExpression())) {
                            expr = null;
                        }
                        if (expr == null) {
                            for (int j = 0; j < columns.length; ++j) {
                                ContainedObject column = columns[j];
                                String colName = column.getName();
                                if (j > 0) {
                                    keyName = (String)keyName + ", ";
                                }
                                keyName = (String)keyName + colName;
                            }
                        } else {
                            keyName = (String)keyName + expr;
                        }
                        keyName = (String)keyName + ")";
                    }
                    if (key.isDeprecated()) {
                        // empty if block
                    }
                    int xname = nnPos;
                    FKIndexAssociation fk = key.getFKAssociation();
                    if (fk != null) {
                        FKContainer rcont = fk.getRemoteTable();
                        String rname = null;
                        if (rcont != null) {
                            rname = rcont.getShortObjectID();
                        } else {
                            rname = fk.getReferredTableID();
                            if (rname != null && !rname.isEmpty()) {
                                rname = ModelIDObject.getShortID(rname);
                            }
                        }
                        DiagramToSVG.addText((String)keyName, xname, yCursor, keyColor, sb, keyFont, true, rname, null);
                    } else {
                        DiagramToSVG.addText((String)keyName, xname, yCursor, keyColor, sb, keyFont);
                    }
                    if (yCursor <= height) continue;
                    int right = width - 4;
                    int left = right - 8;
                    int center = right - 4;
                    int bottom = height - 4;
                    int top = bottom - 8;
                    int[] xPts = new int[]{center, left, right};
                    int[] yPts = new int[]{bottom, top, top};
                    DiagramToSVG.addPolygon(fgcol, xPts, yPts, 1, sb, true);
                    break;
                }
            }
        }
        int COLUMN_LEFT = 10;
        if (dpv.showAllDetails()) {
            List<SQLNameHelper> usedContainers = null;
            if (!table.isIncorrectSQL() && !table.getUsedTablesAndViews().isEmpty()) {
                usedContainers = table.getUsedTablesAndViews();
                if (usedContainers.size() > 0) {
                    int p = colTextHeight / 5;
                    DiagramToSVG.addLine(0, yCursor += 3 + borderWidth + p, width - 2, yCursor, fgcol, sb);
                    fm = g.getFontMetrics(colFont);
                    for (SQLNameHelper sQLNameHelper : usedContainers) {
                        yCursor += 3 + fm.getMaxAscent();
                        String name = sQLNameHelper.getFullName();
                        if (sQLNameHelper.isDeprecated()) {
                            // empty if block
                        }
                        DiagramToSVG.addText(name, COLUMN_LEFT, yCursor, elemColor, sb, colFont, createLinks, name, null);
                    }
                }
            } else {
                usedContainers = table.getUsedContainers();
                if (usedContainers.size() > 0) {
                    int p = colTextHeight / 5;
                    DiagramToSVG.addLine(0, yCursor += 3 + borderWidth + p, width - 2, yCursor, fgcol, sb);
                    for (AbstractView.ContainerHolder containerHolder : usedContainers) {
                        yCursor += 3 + fm.getMaxAscent();
                        String name = containerHolder.getContainer().getLongName();
                        if (containerHolder.getContainer().isDeprecated()) {
                            // empty if block
                        }
                        DiagramToSVG.addText(name, COLUMN_LEFT, yCursor, elemColor, sb, colFont, createLinks, name, null);
                    }
                }
            }
        }
        try {
            sb.write("\n</g>");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int paintStructuredType(DesignPartView dpv, ContainerObject container, Writer sb, Graphics g, StructuredType st, int level, int yCursor, Color fgcol, Color elemColor, Color nnColor, int dtPos, String rdbms, Font colFont, Color dtColor) {
        FontMetrics fm = g.getFontMetrics(colFont);
        int nnPos = fm.stringWidth("KW");
        if (dpv.showAllDetails() || dpv.showDatatype()) {
            // empty if block
        }
        if (dpv != null) {
            TypeElement[] elements = st.getElements();
            for (int i = 0; i < elements.length; ++i) {
                TypeElement te;
                CollectionType ct;
                ContainedObject co;
                TypeElement elm = elements[i];
                yCursor += fm.getHeight();
                boolean mand = elm.isMandatory();
                if (!mand && container != null && (co = container.getNestedElementByStructAttributeID(elm.getObjectID())) != null) {
                    mand = co.isMandatory();
                }
                if (mand) {
                    DiagramToSVG.addText(NOT_NULL, nnPos, yCursor, nnColor, sb, colFont);
                }
                if (StructuredType.UNIONTYPE.equalsIgnoreCase(st.getHiveType())) {
                    DiagramToSVG.addText(">" + elm.getName(), 25 + 12 * level, yCursor, elemColor, sb, colFont);
                } else {
                    DiagramToSVG.addText(elm.getName(), 25 + 12 * level, yCursor, elemColor, sb, colFont);
                }
                if (dpv.showAllDetails() || dpv.showDatatype()) {
                    DiagramToSVG.addText(elm.getDataType(rdbms), dtPos, yCursor, fgcol, sb, colFont);
                }
                if (elm.getType() instanceof StructuredType && !elm.isReference()) {
                    StructuredType st2 = (StructuredType)elm.getType();
                    if (st2 == null) continue;
                    yCursor = DiagramToSVG.paintStructuredType(dpv, container, sb, g, st2, level + 1, yCursor, fgcol, elemColor, nnColor, dtPos, rdbms, colFont, dtColor);
                    continue;
                }
                if (!(elm.getType() instanceof CollectionType) || elm.isReference() || (ct = (CollectionType)elm.getType()) == null || !((te = ct.getElementType()).getType() instanceof StructuredType) || te.isReference()) continue;
                yCursor = DiagramToSVG.paintStructuredType(dpv, container, sb, g, (StructuredType)te.getType(), level + 1, yCursor, fgcol, elemColor, nnColor, dtPos, rdbms, colFont, dtColor);
            }
        }
        return yCursor;
    }

    public static void generateNote(Note note, TopView tv, Writer sb, Graphics2D g, boolean createLinks, String id_suffix) {
        Color bgcol = DiagramToSVG.getBackgroundColor(note, tv);
        Color bcol = DiagramToSVG.getBorderColor(note, tv);
        Rectangle bounds = null;
        bounds = tv.getCellView() != null ? tv.getCellView().getBounds().getBounds() : tv.getBounds();
        int yCursor = 0;
        int xCursor = 0;
        int lineWidt = 1;
        int width = bounds.width;
        int height = bounds.height;
        String text = note.getText();
        String lt = "\r\n";
        if (text.indexOf(lt) == -1 && text.indexOf(lt = System.getProperty("line.separator")) == -1) {
            lt = "\n";
        }
        String cid = DiagramToSVG.getClipPathID(tv, id_suffix);
        DiagramToSVG.addShape(bgcol, bcol, bounds, sb, cid);
        Font titleFont = DiagramToSVG.getTitleFont(note, tv);
        FontMetrics fm = g.getFontMetrics(titleFont);
        int colTextHeight = fm.getHeight();
        yCursor = Math.max(colTextHeight, titleFont.getSize());
        xCursor = 2;
        Color tcolor = DiagramToSVG.getColor(note, tv, EditableFonts.FO_TITLE);
        DiagramToSVG.addPath(DiagramToSVG.getPointsForNote(width, height), false, bcol, true, lineWidt, sb);
        String[] splitText = DiagramToSVG.wrapText(text, DiagramToSVG.getMaxChars(text, fm, width - 10));
        for (int t = 0; t < splitText.length; ++t) {
            String text1 = splitText[t];
            text1 = text1.replaceAll(lt + lt, lt + " " + lt);
            String[] wrt = text1.split(lt);
            for (int k = 0; k < wrt.length; ++k) {
                DiagramToSVG.addText(wrt[k], xCursor, yCursor, tcolor, sb, titleFont);
                yCursor += colTextHeight;
            }
        }
        try {
            sb.write("\n</g>");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static List getPointsForNote(int width, int height) {
        int dx = width / 8;
        int dy = height / 6;
        int xt = width - dx;
        ArrayList<Point> list = new ArrayList<Point>();
        list.add(new Point(xt, 0));
        list.add(new Point(width, dy));
        list.add(new Point(width, height));
        list.add(new Point(0, height));
        list.add(new Point(0, 0));
        list.add(new Point(xt, 0));
        list.add(new Point(xt, dy));
        list.add(new Point(width, dy));
        return list;
    }

    public static void generateLegend(Legend legend, TopView tv, Writer sb, Graphics2D g, boolean createLinks, String id_suffix) {
        Font font;
        String propName;
        Color bgcol = DiagramToSVG.getBackgroundColor(legend, tv);
        Color fgcol = DiagramToSVG.getForegroundColor(legend, tv);
        Color bcol = DiagramToSVG.getBorderColor(legend, tv);
        int borderWidth = 1;
        Rectangle bounds = null;
        bounds = tv.getCellView() != null ? tv.getCellView().getBounds().getBounds() : tv.getBounds();
        Dimension dim = legend.getSize(tv);
        int titlePosition = 20;
        int yCursor = 0;
        int xCursor = 0;
        int width = dim.width;
        int height = dim.height;
        String title = "LEGEND";
        TopView efo = tv;
        Font diagramFont = efo.getFontObject(EditableFonts.FO_DIAGRAM).getFont();
        float fontSize = diagramFont.getSize2D();
        String longName = tv.toString();
        String cid = DiagramToSVG.getClipPathID(tv, id_suffix);
        DiagramToSVG.addShape(bgcol, bcol, bounds, sb, cid);
        DiagramToSVG.addRect(fgcol, width, height, sb);
        Font titleFont = DiagramToSVG.getTitleFont(legend, tv);
        FontMetrics fm = g.getFontMetrics(titleFont);
        int colTextHeight = fm.getHeight();
        yCursor = Math.max(colTextHeight, titleFont.getSize());
        xCursor = (width - fm.stringWidth(longName)) / 2;
        if (xCursor < titlePosition) {
            xCursor = titlePosition;
        }
        FontObject fob = efo.getFontObject(EditableFonts.FO_DIAGRAM);
        Color dColor = fob.getColor();
        fm = g.getFontMetrics(diagramFont);
        yCursor = colTextHeight = fm.getMaxAscent() + fm.getMaxDescent();
        xCursor = (width - fm.stringWidth(title)) / 2;
        if (xCursor < titlePosition) {
            xCursor = titlePosition;
        }
        int space = colTextHeight / 3;
        int labelOffset = 10;
        int w = colTextHeight * 2;
        int valueOffset = fm.stringWidth(LB_CHANGED_BY) + w;
        Iterator it = legend.getDesignPartView().getPropertyNames();
        while (it.hasNext()) {
            propName = (String)it.next();
            int propLength = fm.stringWidth(propName) + w;
            valueOffset = Math.max(valueOffset, propLength);
        }
        DiagramToSVG.addText(LB_DIAGRAM, labelOffset, ++yCursor, dColor, sb, diagramFont);
        DiagramToSVG.addText(legend.getDiagramName(), valueOffset, yCursor, dColor, sb, diagramFont);
        if (legend.showAuthor()) {
            DiagramToSVG.addLine(0, yCursor += space + borderWidth, width - 2, yCursor, fgcol, sb);
            fob = efo.getFontObject(EditableFonts.FO_AUTHOR);
            fob = efo.getFontObject(EditableFonts.FO_AUTHOR);
            font = fob.getFont().deriveFont(fontSize);
            DiagramToSVG.addText(LB_AUTHOR, labelOffset, yCursor += colTextHeight, fob.getColor(), sb, font);
            DiagramToSVG.addText(legend.getDiagramAuthor(), valueOffset, yCursor, fob.getColor(), sb, font);
        }
        if (legend.showCreatedOn()) {
            DiagramToSVG.addLine(0, yCursor += space + borderWidth, width - 2, yCursor, fgcol, sb);
            fob = efo.getFontObject(EditableFonts.FO_CREATED_ON);
            font = fob.getFont().deriveFont(fontSize);
            DiagramToSVG.addText(LB_CREATED_ON, labelOffset, yCursor += colTextHeight, fob.getColor(), sb, font);
            DiagramToSVG.addText(legend.getTimeCreated(), valueOffset, yCursor, fob.getColor(), sb, font);
        }
        if (legend.showModifiedOn()) {
            DiagramToSVG.addLine(0, yCursor += space + borderWidth, width - 2, yCursor, fgcol, sb);
            fob = efo.getFontObject(EditableFonts.FO_MODIFIED_ON);
            font = fob.getFont().deriveFont(fontSize);
            DiagramToSVG.addText(LB_MODIFIED_ON, labelOffset, yCursor += colTextHeight, fob.getColor(), sb, font);
            DiagramToSVG.addText(legend.getTimeChanged(), valueOffset, yCursor, fob.getColor(), sb, font);
        }
        if (legend.showChangedBy()) {
            DiagramToSVG.addLine(0, yCursor += space + borderWidth, width - 2, yCursor, fgcol, sb);
            fob = efo.getFontObject(EditableFonts.FO_MODIFIED_BY);
            font = fob.getFont().deriveFont(fontSize);
            DiagramToSVG.addText(LB_CHANGED_BY, labelOffset, yCursor += colTextHeight, fob.getColor(), sb, font);
            DiagramToSVG.addText(legend.getModifiedBy(), valueOffset, yCursor, fob.getColor(), sb, font);
        }
        if (legend.showDesignName()) {
            DiagramToSVG.addLine(0, yCursor += space + borderWidth, width - 2, yCursor, fgcol, sb);
            fob = efo.getFontObject(EditableFonts.FO_DESIGN);
            font = fob.getFont().deriveFont(fontSize);
            DiagramToSVG.addText(LB_DESIGN, labelOffset, yCursor += colTextHeight, fob.getColor(), sb, font);
            DiagramToSVG.addText(legend.getDesignName(), valueOffset, yCursor, fob.getColor(), sb, font);
        }
        if (legend.showModelName()) {
            DiagramToSVG.addLine(0, yCursor += space + borderWidth, width - 2, yCursor, fgcol, sb);
            fob = efo.getFontObject(EditableFonts.FO_MODEL);
            font = fob.getFont().deriveFont(fontSize);
            DiagramToSVG.addText(LB_MODEL, labelOffset, yCursor += colTextHeight, fob.getColor(), sb, font);
            DiagramToSVG.addText(legend.getModelName(), valueOffset, yCursor, fob.getColor(), sb, font);
        }
        it = legend.getDesignPartView().getPropertyNames();
        while (it.hasNext()) {
            propName = (String)it.next();
            String value = legend.getDesignPartView().getProperty(propName);
            DiagramToSVG.addLine(0, yCursor += space + borderWidth, width - 2, yCursor, fgcol, sb);
            fob = efo.getFontObject(EditableFonts.FO_USER_DEFINED_PROPS);
            Font font2 = fob.getFont().deriveFont(fontSize);
            DiagramToSVG.addText(propName, labelOffset, yCursor += colTextHeight, fob.getColor(), sb, font2);
            DiagramToSVG.addText(value, valueOffset, yCursor, fob.getColor(), sb, font2);
        }
        try {
            sb.write("\n</g>");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void generateEntityBarkerNotation(ContainerWithKeyObject table, TopView tv, Writer sb, Graphics2D g, boolean createLinks, String id_suffix) {
        String text;
        DesignPartView dpv = tv.getDesignPartView();
        Color bgcol = DiagramToSVG.getBackgroundColor(table, tv);
        Color fgcol = DiagramToSVG.getTableForegroundColor(table, tv);
        Color bcol = DiagramToSVG.getBorderColor(table, tv);
        int borderWidth = 1;
        Rectangle bounds = null;
        bounds = tv.getCellView() != null ? tv.getCellView().getBounds().getBounds() : tv.getBounds();
        int titlePosition = 20;
        int yCursor = 0;
        int xCursor = 0;
        int width = bounds.width;
        int height = bounds.height;
        TopView efo = tv;
        Object longName = table.getLongName();
        if (tv != null) {
            longName = tv.toString();
            if (tv.getDesignPartView().showSchemaName() && table.getSchemaObject() != null) {
                longName = table.getSchemaObject().getName() + "." + (String)longName;
            }
        }
        if (table.isBST()) {
            longName = (String)longName + " (" + table.getBasedOnStructuredType().getName() + ")";
        }
        String cid = DiagramToSVG.getClipPathID(tv, id_suffix);
        DiagramToSVG.addShape(bgcol, bcol, bounds, sb, cid);
        DiagramToSVG.addRect(fgcol, width, height, 20, 20, sb);
        Font titleFont = DiagramToSVG.getTitleFont(table, tv);
        FontMetrics fm = g.getFontMetrics(titleFont);
        int colTextHeight = fm.getHeight();
        yCursor = Math.max(colTextHeight, titleFont.getSize());
        xCursor = (width - fm.stringWidth((String)longName)) / 2;
        if (xCursor < titlePosition) {
            xCursor = titlePosition;
        }
        Color tcolor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_TITLE);
        String[] wrappedTitle = DiagramToSVG.wrapText((String)longName, DiagramToSVG.getMaxChars((String)longName, fm, width - titlePosition - 5));
        for (int t = 0; t < wrappedTitle.length; ++t) {
            String text2 = wrappedTitle[t];
            if (t == 0) {
                String id = table.getShortObjectID() + id_suffix;
                DiagramToSVG.addText(text2, xCursor, yCursor, tcolor, sb, titleFont, createLinks, table.getShortObjectID(), id, table.isDeprecated());
            } else {
                DiagramToSVG.addText(text2, xCursor, yCursor, tcolor, sb, titleFont, table.isDeprecated());
            }
            yCursor += colTextHeight;
        }
        if (efo.getHiddenElements().size() > 0) {
            int right = width - 4;
            int left = right - 8;
            int center = right - 4;
            int[] xPts = new int[]{center, left, right};
            int[] yPts = new int[]{2, 10, 10};
            DiagramToSVG.addPolygon(fgcol, xPts, yPts, 1, sb, true);
        }
        yCursor -= colTextHeight;
        int iconXPos = 2;
        if (table.isRemoteObject()) {
            DiagramToSVG.addUseOfDef("link_sym", iconXPos, colTextHeight / 2, 8, 8, sb);
        }
        yCursor += 3 + borderWidth;
        ContainedObject[] elements = table.getElements();
        String longestName = DesignPartView.getLongestName(elements, dpv.isExpandComplexTypes());
        Font colFont = DiagramToSVG.getFont(table, tv, EditableFonts.FO_ELEMENT);
        Font comFont = DiagramToSVG.getFont(table, tv, EditableFonts.FO_COMMENTS);
        fm = g.getFontMetrics(colFont);
        int nameSize = fm.stringWidth(longestName);
        int nnPos = fm.stringWidth("KW");
        int namePos = 3 + fm.stringWidth("KWN");
        int cPos = 20 + namePos + nameSize;
        Color nnColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_NOT_NULL);
        Color pkColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_PK);
        Color ukColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_UK);
        Color fkColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_FK);
        Color dtColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_DATATYPE);
        Color comColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_COMMENTS);
        Color elemColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_ELEMENT);
        colTextHeight = fm.getHeight();
        if (!dpv.isShowNamesOnly()) {
            if (dpv.isShowClassificationTypes() && table instanceof ContainerWithKeyObject) {
                ContainerWithKeyObject cwk = table;
                String clname = ALLOW_NULL;
                ClassificationType ct = cwk.getClassificationType();
                if (ct != null) {
                    clname = ct.getTypeName();
                }
                Object clnames = ALLOW_NULL;
                List<String> list = cwk.getAdd_ClassificationTypeNames();
                for (int k = 0; k < list.size(); ++k) {
                    clnames = k > 0 ? (String)clnames + ", " + list.get(k) : list.get(0);
                }
                if (!ALLOW_NULL.equals(clname) || !ALLOW_NULL.equals(clnames)) {
                    Object types = !ALLOW_NULL.equals(clname) ? clname + " / " : "- / ";
                    types = !ALLOW_NULL.equals(clnames) ? (String)types + (String)clnames : (String)types + "-";
                    xCursor = (width - fm.stringWidth((String)types)) / 2;
                    if (xCursor < titlePosition) {
                        xCursor = titlePosition;
                    }
                    DiagramToSVG.addText((String)types, xCursor, yCursor += colTextHeight, tcolor, sb, titleFont);
                    DiagramToSVG.addLine(0, yCursor += 3 + borderWidth, width - 2, yCursor, fgcol, sb);
                }
            }
            if (table.isBST() && table.getTypeSubstitution() != null) {
                StructuredType st = table.getBasedOnStructuredType();
                if (st != null) {
                    TypeElement[] elems = st.getElements();
                    longestName = DesignPartView.getLongestTypeName(elems);
                    colTextHeight = fm.getMaxAscent() - fm.getMaxDescent() + 3;
                    for (int i = 0; i < elems.length; ++i) {
                        TypeElement elm = elems[i];
                        DiagramToSVG.addText(elm.getName(), 25, yCursor += fm.getHeight(), elemColor, sb, colFont, elm.isDeprecated());
                        fm = g.getFontMetrics();
                        int anLeft = fm.stringWidth(longestName) + 50;
                        DiagramToSVG.addText(elm.getDataType(), anLeft, yCursor, dtColor, sb, colFont);
                    }
                }
            } else {
                for (int i = 0; i < elements.length; ++i) {
                    String com;
                    ContainedObjectWithDomain element = (ContainedObjectWithDomain)elements[i];
                    if (efo.getHiddenElements().contains(element) || element.isOid() || element.isFKElement() || dpv.showKeyElements() && !element.isPKElement() && !element.isFKElement() && !element.isUnique()) continue;
                    int anLeft = nnPos;
                    text = element.getNullsAllowed() ? "o" : NOT_NULL;
                    DiagramToSVG.addText(text, anLeft, yCursor += fm.getHeight(), nnColor, sb, colFont);
                    String type = " ";
                    Color color = elemColor;
                    if (element.isPKElement()) {
                        type = "P";
                        color = pkColor;
                        if (element.isFKElement()) {
                            type = type.concat("F");
                        }
                    } else if (element.isUnique()) {
                        type = "U";
                        color = ukColor;
                        if (element.isFKElement()) {
                            type = type.concat("F");
                        }
                    } else if (element.isFKElement()) {
                        type = "F";
                        color = fkColor;
                    }
                    if (!" ".equals(type)) {
                        DiagramToSVG.addText(type, 2, yCursor, color, sb, colFont);
                    }
                    anLeft = namePos;
                    if (element.isDeprecated()) {
                        // empty if block
                    }
                    DiagramToSVG.addText(element.getName(), anLeft, yCursor, elemColor, sb, colFont, element.isDeprecated());
                    if (dpv.showComments() && !(com = element.getCommentInRDBMS()).isEmpty()) {
                        anLeft = cPos;
                        DiagramToSVG.addText(com, anLeft, yCursor, comColor, sb, colFont);
                    }
                    if (yCursor <= height) continue;
                    int right = width - 4;
                    int left = right - 8;
                    int center = right - 4;
                    int bottom = height - 4;
                    int top = bottom - 8;
                    int[] xPts = new int[]{center, left, right};
                    int[] yPts = new int[]{bottom, top, top};
                    DiagramToSVG.addPolygon(fgcol, xPts, yPts, 1, sb, true);
                    break;
                }
            }
        }
        String comments = table.getCommentInRDBMS().trim();
        if (dpv.showComments() && !ALLOW_NULL.equalsIgnoreCase(comments)) {
            DiagramToSVG.addLine(0, yCursor += 6, width - 2, yCursor, comColor, sb);
            fm = g.getFontMetrics(comFont);
            yCursor += fm.getHeight();
            String[] wrappedComments = DiagramToSVG.wrapText(comments, DiagramToSVG.getMaxChars(comments, fm, width - fm.stringWidth("WWW")));
            for (int t = 0; t < wrappedComments.length; ++t) {
                text = wrappedComments[t];
                g.drawString(text, 5, yCursor);
                DiagramToSVG.addText(text, 5, yCursor, comColor, sb, comFont);
                yCursor += fm.getHeight();
            }
        }
        try {
            sb.write("\n</g>");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static Color getLabelBackgroundColor(Label label, TopView tv) {
        if (tv.useDefaultColor() || tv.getBackgroundColor() == null) {
            DefaultFontAndColor dfc = null;
            dfc = label.isRelationshipAttributesLabel() ? label.getDesign().getDesignLevelSettings().getDefaultFCObject("Relationship Attributes") : label.getDesign().getDesignLevelSettings().getDefaultFCObject("Label");
            if (dfc != null) {
                boolean noBackgroundColor = dfc.getNoBackgroundColor();
                if (noBackgroundColor) {
                    return null;
                }
                return dfc.getBackgroundColor();
            }
            return Color.WHITE;
        }
        if (label.isRelationshipAttributesLabel()) {
            return tv.getBackgroundColor();
        }
        boolean noBackgroundColor = tv.getNoBackgroundColor();
        if (noBackgroundColor) {
            return null;
        }
        return tv.getBackgroundColor();
    }

    static Color getLabelForegroundColorColor(Label label, TopView tv) {
        if (tv.useDefaultColor() || tv.getForegroundColor() == null) {
            DefaultFontAndColor dfc = null;
            dfc = label.isRelationshipAttributesLabel() ? label.getDesign().getDesignLevelSettings().getDefaultFCObject("Relationship Attributes") : label.getDesign().getDesignLevelSettings().getDefaultFCObject("Label");
            if (dfc != null) {
                boolean noBackgroundColor = dfc.getNoForegroundColor();
                if (noBackgroundColor) {
                    return null;
                }
                return dfc.getForegroundColor();
            }
            return Color.WHITE;
        }
        if (label.isRelationshipAttributesLabel()) {
            return tv.getForegroundColor();
        }
        boolean noBackgroundColor = tv.getNoBackgroundColor();
        if (noBackgroundColor) {
            return null;
        }
        return tv.getForegroundColor();
    }

    private static Color getLabelTextColor(Label label, TopView tv) {
        if (tv != null) {
            FontObject fob = tv.getFontObject(EditableFonts.FO_TEXT);
            if (tv.useDefaultColor() || fob == null) {
                DefaultFontAndColor dfc = label.getDesign().getDesignLevelSettings().getDefaultFCObject(label.getClass().getSimpleName());
                if (dfc == null) {
                    dfc = label.getDesign().getDesignLevelSettings().getDefaultFCObject("Label");
                }
                if (dfc != null) {
                    return dfc.getFontObject(EditableFonts.FO_TEXT).getColor();
                }
                return DEFAULT_FOREGROUND;
            }
            return fob.getColor();
        }
        return DEFAULT_FOREGROUND;
    }

    public static void generateLabel(Label label, TopView tv, Rectangle2D bounds, Writer sb, Graphics2D g, String id_suffix) {
        Color fgcol;
        Color bgcol = DiagramToSVG.getLabelBackgroundColor(label, tv);
        Color bcol = fgcol = DiagramToSVG.getLabelForegroundColorColor(label, tv);
        int yCursor = (int)bounds.getY();
        int xCursor = (int)bounds.getX();
        int width = (int)bounds.getWidth();
        Font txtFont = DiagramToSVG.getFont(label, tv, EditableFonts.FO_TEXT);
        Color txtColor = DiagramToSVG.getLabelTextColor(label, tv);
        FontMetrics fm = g.getFontMetrics(txtFont);
        int colTextHeight = fm.getHeight();
        yCursor = yCursor + colTextHeight - 2;
        ++xCursor;
        String cid = DiagramToSVG.getClipPathID(tv, id_suffix);
        DiagramToSVG.addLabelShape(bgcol, bcol, bounds, sb, cid);
        if (!label.isRelationshipAttributesLabel()) {
            String txt = " " + label.getText();
            String[] wrappedTitle = DiagramToSVG.wrapText(txt, DiagramToSVG.getMaxChars(txt, fm, width - 1));
            for (int t = 0; t < wrappedTitle.length; ++t) {
                String text = wrappedTitle[t];
                if (t == 0) {
                    if (wrappedTitle.length > 1) {
                        yCursor += colTextHeight;
                        text = StringUtilities.ltrim(text);
                    }
                    DiagramToSVG.addText(text, xCursor, yCursor, txtColor, sb, txtFont, false, null, null, false);
                } else {
                    DiagramToSVG.addText(text, xCursor, yCursor, txtColor, sb, txtFont, false);
                }
                yCursor += colTextHeight;
            }
        }
        try {
            sb.write("\n</g>");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String getLongestName(Collection elements) {
        String name = ALLOW_NULL;
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            String n = ((DesignObject)it.next()).getName();
            if (n.length() <= name.length()) continue;
            name = n;
        }
        return name;
    }

    public static void generateRelationAttributeLabel(Label label, TopView tv, TVConnector tvc, Rectangle bounds, Writer sb, Graphics2D g, String id_suffix) {
        Color fgcol;
        DesignPartView dpv = tv.getDesignPartView();
        Color bgcol = DiagramToSVG.getLabelBackgroundColor(label, tv);
        Color bcol = fgcol = DiagramToSVG.getLabelForegroundColorColor(label, tv);
        int yCursor = 5;
        int xCursor = (int)bounds.getX();
        int width = (int)bounds.getWidth();
        int height = (int)bounds.getHeight();
        Font txtFont = DiagramToSVG.getFont(label, tv, EditableFonts.FO_ATTRIBUTE);
        Color nnColor = DiagramToSVG.getColor(label, tv, EditableFonts.FO_NOT_NULL);
        Color txtColor = DiagramToSVG.getLabelTextColor(label, tv);
        FontMetrics fm = g.getFontMetrics(txtFont);
        int namePos = 3 + fm.stringWidth("KWN");
        Color dtColor = DiagramToSVG.getColor(label, tv, EditableFonts.FO_DATATYPE);
        ++xCursor;
        String cid = DiagramToSVG.getClipPathID(tvc, id_suffix) + "_C";
        if (label.isRelationshipAttributesLabel()) {
            int notation = dpv.getNotation();
            DiagramToSVG.addShape(bgcol, bcol, bounds, sb, cid);
            if (notation == 1) {
                DiagramToSVG.addRect(fgcol, width, height, 20, 20, sb);
            } else {
                DiagramToSVG.addRect(fgcol, width, height, sb);
            }
            String ALLOW_NULL = ALLOW_NULL;
            if (notation == 1) {
                ALLOW_NULL = "o";
            }
            Collection attributes = ((TVRelation)label.getTVConnector()).getRelationshipAttributes();
            String longestName = DiagramToSVG.getLongestName(attributes);
            int nameSize = fm.stringWidth(longestName);
            int dtPos = 20 + namePos + nameSize;
            if (attributes != null) {
                for (ContainedObjectWithDomain element : attributes) {
                    int anLeft = fm.stringWidth("A");
                    String nntext = element.getNullsAllowed() ? ALLOW_NULL : NOT_NULL;
                    DiagramToSVG.addText(nntext, anLeft, yCursor += 3 + fm.getMaxAscent(), nnColor, sb, txtFont);
                    DiagramToSVG.addText(element.getName(), anLeft += fm.stringWidth(NOT_NULL) + 3, yCursor, txtColor, sb, txtFont, element.isDeprecated());
                    if (notation == 1) continue;
                    anLeft = dtPos;
                    DiagramToSVG.addText(DiagramToSVG.getDataType(element, element.getContainer()), anLeft, yCursor, dtColor, sb, txtFont);
                }
            }
            try {
                sb.write("\n</g>");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static Point2D getPoint(TVConnector tv, int i) {
        EdgeView edgeView = null;
        if (tv != null) {
            DefaultEdge edge;
            edgeView = (EdgeView)tv.getCellView();
            if (edgeView != null && (edge = (DefaultEdge)edgeView.getCell()) != null) {
                edgeView = (EdgeView)edge.getCellView();
            }
            if (edgeView != null) {
                return edgeView.getPoint(i);
            }
        }
        return (Point2D)tv.getActualPoints().get(i);
    }

    static int getPointsCount(TVConnector tv) {
        EdgeView edgeView = null;
        if (tv != null) {
            DefaultEdge edge;
            edgeView = (EdgeView)tv.getCellView();
            if (edgeView != null && (edge = (DefaultEdge)edgeView.getCell()) != null) {
                edgeView = (EdgeView)edge.getCellView();
            }
            if (edgeView != null) {
                return edgeView.getPointCount();
            }
        }
        return tv.getActualPoints().size();
    }

    private static void generateFKArc(Iterator it, TopView view, Writer sb, Graphics g, boolean reverseArc) {
        try {
            DesignPartView dpv = view.getDesignPartView();
            Dimension dim = view.getSize();
            int width = dim.width;
            int height = dim.height;
            Point location = view.getLocation();
            Color color = Color.BLACK;
            Rectangle bounds = new Rectangle(location.x + 3, location.y + 3, width - 7, height - 7);
            if (view != null) {
                sb.write("\n<g fill=\"none\" stroke=\"rgb(0,0,0)\" transform=\"translate(" + location.getX() + "," + location.getY() + ")\" >");
                ArrayList<Point2D> points = new ArrayList<Point2D>();
                while (it.hasNext()) {
                    Point2D p2;
                    DesignObject fkey = (DesignObject)it.next();
                    TVConnector tv = (TVConnector)fkey.getFirstViewForDPV(dpv);
                    if (tv == null || tv.getActualPoints().size() <= 0) continue;
                    Point2D p1 = DiagramToSVG.getPoint(tv, 0);
                    int j = DiagramToSVG.getPointsCount(tv);
                    if (tv.isSelfReference() && !reverseArc) {
                        p1 = DiagramToSVG.getPoint(tv, j - 1);
                        p2 = DiagramToSVG.getPoint(tv, j - 2);
                    } else if (bounds.contains(p1)) {
                        p2 = DiagramToSVG.getPoint(tv, 1);
                    } else {
                        p1 = DiagramToSVG.getPoint(tv, j - 1);
                        p2 = DiagramToSVG.getPoint(tv, j - 2);
                    }
                    Point2D p = DiagramToSVG.getRelationPoint(bounds, p1, p2);
                    if (p == null && j > 2) {
                        if (bounds.contains(DiagramToSVG.getPoint(tv, 0))) {
                            p1 = DiagramToSVG.getPoint(tv, 1);
                            p2 = DiagramToSVG.getPoint(tv, 2);
                        } else {
                            p1 = DiagramToSVG.getPoint(tv, j - 2);
                            p2 = DiagramToSVG.getPoint(tv, j - 3);
                        }
                        p = DiagramToSVG.getRelationPoint(bounds, p1, p2);
                    }
                    if (p == null) continue;
                    points.add(p);
                    double x = 0.0;
                    double y = 0.0;
                    x = p.getX() - (double)location.x - 2.0;
                    y = p.getY() - (double)location.y - 2.0;
                    DiagramToSVG.addCircle(color, 1, sb, 5, true, String.valueOf(x + 1.0), String.valueOf(y + 1.0), 2);
                }
                if (points.size() > 1) {
                    DiagramToSVG.drawArc(view, (Graphics2D)g, sb, points, bounds);
                }
                sb.write("\n</g>");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Line2D getFirstAndLastPoints(List points, Rectangle bounds) {
        TreeMap<Double, Point2D.Double> map = new TreeMap<Double, Point2D.Double>();
        for (Point2D.Double p : points) {
            double degree = DiagramToSVG.getDegree(p, bounds);
            map.put(new Double(degree), p);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        Iterator<Object> it = map.keySet().iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        int f = 0;
        int l = list.size() - 1;
        Double fd = (Double)list.get(f);
        Double ld = (Double)list.get(l);
        double d1 = fd;
        double d2 = ld;
        int w = 361;
        while (d2 - d1 > 180.0) {
            ++l;
            if (++f >= list.size()) {
                f = 0;
                --w;
            }
            if (l >= list.size()) {
                l = 0;
            }
            fd = (Double)list.get(f);
            ld = (Double)list.get(l);
            d1 = fd;
            if (!(d1 > (d2 = ld.doubleValue()))) continue;
            d2 += (double)w;
        }
        Point2D first = (Point2D)map.get(fd);
        Point2D last = (Point2D)map.get(ld);
        return new Line2D.Float(first, last);
    }

    private static double getDegree(Point2D p, Rectangle bounds) {
        double dx = p.getX() - bounds.getCenterX();
        double dy = p.getY() - bounds.getCenterY();
        double alpha = Math.atan2(dy, dx);
        double d = Math.toDegrees(alpha);
        if (d < 0.0) {
            return d + 360.0;
        }
        return d;
    }

    static void path_lineTo(Writer sb, float x, float y) {
        try {
            sb.write(" L" + x + " " + y);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void path_curveTo(Writer sb, float x1, float y1, float x2, float y2, float x3, float y3) {
        try {
            sb.write(" C " + x1 + " " + y1 + " " + x2 + " " + y2 + " " + x3 + " " + y3);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void path_moveTo(Writer sb, float x, float y) {
        try {
            sb.write(" M" + x + " " + y);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void drawArc(TopView view, Graphics2D g2, Writer sb, List points, Rectangle bounds) {
        Point location = view.getLocation();
        GeneralPath path = new GeneralPath();
        Rectangle r = view.getBounds();
        Line2D line = DiagramToSVG.getFirstAndLastPoints(points, r);
        Point2D first = line.getP1();
        Point2D last = line.getP2();
        float p1x = (float)first.getX() - (float)location.x;
        float p1y = (float)first.getY() - (float)location.y;
        float pnx = (float)last.getX() - (float)location.x;
        float pny = (float)last.getY() - (float)location.y;
        int angleSize = 14;
        int arcSize = 10;
        float x = bounds.width + 3;
        float y = bounds.height + 3;
        try {
            sb.write("\n<path d=\"");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int p1Side = DiagramToSVG.getPointSide(bounds, first);
        int pnSide = DiagramToSVG.getPointSide(bounds, last);
        if (p1Side == 2) {
            DiagramToSVG.path_moveTo(sb, p1x - (float)arcSize, p1y - (float)(arcSize * 2));
            DiagramToSVG.path_curveTo(sb, p1x - (float)arcSize, p1y - (float)(arcSize * 2), p1x, p1y - (float)(arcSize * 2), p1x, p1y - (float)arcSize);
            if (p1Side == pnSide) {
                DiagramToSVG.path_lineTo(sb, pnx, pny + (float)arcSize);
                DiagramToSVG.path_curveTo(sb, pnx, pny + (float)arcSize, pnx, pny + (float)(arcSize * 2), pnx - (float)arcSize, pny + (float)(arcSize * 2));
            } else {
                DiagramToSVG.path_lineTo(sb, p1x, y - (float)angleSize);
                DiagramToSVG.path_curveTo(sb, p1x, y - (float)angleSize, p1x, y, p1x - (float)angleSize, y);
                if (pnSide == 3) {
                    DiagramToSVG.path_lineTo(sb, pnx - (float)arcSize, pny);
                    DiagramToSVG.path_curveTo(sb, pnx - (float)arcSize, pny, pnx - (float)(arcSize * 2), pny, pnx - (float)(arcSize * 2), pny - (float)arcSize);
                } else if (pnSide == 0) {
                    DiagramToSVG.path_lineTo(sb, pnx + (float)angleSize, y);
                    DiagramToSVG.path_curveTo(sb, angleSize, y, pnx, y, pnx, y - (float)angleSize);
                    DiagramToSVG.path_lineTo(sb, pnx, pny - (float)arcSize);
                    DiagramToSVG.path_curveTo(sb, pnx, pny - (float)arcSize, pnx, pny - (float)(arcSize * 2), pnx + (float)arcSize, pny - (float)(arcSize * 2));
                } else {
                    DiagramToSVG.path_lineTo(sb, 3 + angleSize, y);
                    DiagramToSVG.path_curveTo(sb, 3 + angleSize, y, 3.0f, y, 3.0f, y - (float)angleSize);
                    DiagramToSVG.path_lineTo(sb, 3.0f, 3 + angleSize);
                    DiagramToSVG.path_curveTo(sb, 3.0f, 3 + angleSize, 3.0f, 3.0f, 3 + angleSize, 3.0f);
                    DiagramToSVG.path_lineTo(sb, pnx + (float)arcSize, pny);
                    DiagramToSVG.path_curveTo(sb, pnx + (float)arcSize, pny, pnx + (float)(arcSize * 2), pny, pnx + (float)(arcSize * 2), pny + (float)arcSize);
                }
            }
        } else if (p1Side == 3) {
            DiagramToSVG.path_moveTo(sb, p1x + (float)(arcSize * 2), p1y - (float)arcSize);
            DiagramToSVG.path_curveTo(sb, p1x + (float)(arcSize * 2), p1y - (float)arcSize, p1x + (float)(arcSize * 2), p1y, p1x + (float)arcSize, p1y);
            if (p1Side == pnSide) {
                DiagramToSVG.path_lineTo(sb, pnx - (float)arcSize, pny);
                DiagramToSVG.path_curveTo(sb, pnx - (float)arcSize, pny, pnx - (float)(arcSize * 2), pny, pnx - (float)(arcSize * 2), pny - (float)arcSize);
            } else {
                DiagramToSVG.path_lineTo(sb, angleSize + 3, y);
                DiagramToSVG.path_curveTo(sb, angleSize + 3, y, 3.0f, y, 3.0f, y - (float)angleSize);
                if (pnSide == 0) {
                    DiagramToSVG.path_lineTo(sb, pnx, pny - (float)arcSize);
                    DiagramToSVG.path_curveTo(sb, pnx, pny - (float)arcSize, pnx, pny - (float)(arcSize * 2), pnx + (float)arcSize, pny - (float)(arcSize * 2));
                } else if (pnSide == 1) {
                    DiagramToSVG.path_lineTo(sb, 3.0f, pny + (float)angleSize);
                    DiagramToSVG.path_curveTo(sb, 3.0f, pny + (float)angleSize, 3.0f, 3.0f, 3 + angleSize, 3.0f);
                    DiagramToSVG.path_lineTo(sb, pnx + (float)arcSize, pny);
                    DiagramToSVG.path_curveTo(sb, pnx + (float)arcSize, pny, pnx + (float)(arcSize * 2), pny, pnx + (float)(arcSize * 2), pny + (float)arcSize);
                } else {
                    DiagramToSVG.path_lineTo(sb, 3.0f, 3 + angleSize);
                    DiagramToSVG.path_curveTo(sb, 3.0f, 3 + angleSize, 3.0f, 3.0f, 3 + angleSize, 3.0f);
                    DiagramToSVG.path_lineTo(sb, x - (float)angleSize, 3.0f);
                    DiagramToSVG.path_curveTo(sb, x - (float)angleSize, 3.0f, x, 3.0f, x, 3 + angleSize);
                    DiagramToSVG.path_lineTo(sb, pnx, pny + (float)arcSize);
                    DiagramToSVG.path_curveTo(sb, pnx, pny + (float)arcSize, pnx, pny + (float)(arcSize * 2), pnx - (float)arcSize, pny + (float)(arcSize * 2));
                }
            }
        } else if (p1Side == 0) {
            DiagramToSVG.path_moveTo(sb, p1x + (float)arcSize, p1y + (float)(arcSize * 2));
            DiagramToSVG.path_curveTo(sb, p1x + (float)arcSize, p1y + (float)(arcSize * 2), p1x, p1y + (float)(arcSize * 2), p1x, p1y + (float)arcSize);
            if (p1Side == pnSide) {
                DiagramToSVG.path_lineTo(sb, pnx, pny - (float)arcSize);
                DiagramToSVG.path_curveTo(sb, pnx, pny - (float)arcSize, pnx, pny - (float)(arcSize * 2), pnx + (float)arcSize, pny - (float)(arcSize * 2));
            } else {
                DiagramToSVG.path_lineTo(sb, 3.0f, angleSize);
                DiagramToSVG.path_curveTo(sb, 3.0f, angleSize, 3.0f, 3.0f, 3 + angleSize, 3.0f);
                if (pnSide == 1) {
                    DiagramToSVG.path_lineTo(sb, pnx + (float)arcSize, pny);
                    DiagramToSVG.path_curveTo(sb, pnx + (float)arcSize, pny, pnx + (float)(arcSize * 2), pny, pnx + (float)(arcSize * 2), pny + (float)arcSize);
                } else if (pnSide == 2) {
                    DiagramToSVG.path_lineTo(sb, x - (float)angleSize, 3.0f);
                    DiagramToSVG.path_curveTo(sb, x - (float)angleSize, 3.0f, x, 3.0f, x, 3 + angleSize);
                    DiagramToSVG.path_lineTo(sb, pnx, pny + (float)arcSize);
                    DiagramToSVG.path_curveTo(sb, pnx, pny + (float)arcSize, pnx, pny + (float)(arcSize * 2), pnx - (float)arcSize, pny + (float)(arcSize * 2));
                } else {
                    DiagramToSVG.path_lineTo(sb, x - (float)angleSize, 3.0f);
                    DiagramToSVG.path_curveTo(sb, x - (float)angleSize, 3.0f, x, 3.0f, x, 3 + angleSize);
                    DiagramToSVG.path_lineTo(sb, x, y - (float)angleSize);
                    DiagramToSVG.path_curveTo(sb, x, y - (float)angleSize, x, y, x - (float)angleSize, y);
                    DiagramToSVG.path_lineTo(sb, pnx - (float)arcSize, pny);
                    DiagramToSVG.path_curveTo(sb, pnx - (float)arcSize, pny, pnx - (float)(arcSize * 2), pny, pnx - (float)(arcSize * 2), pny - (float)arcSize);
                }
            }
        } else {
            DiagramToSVG.path_moveTo(sb, p1x - (float)(arcSize * 2), 3 + arcSize);
            DiagramToSVG.path_curveTo(sb, p1x - (float)(arcSize * 2), 3 + arcSize, p1x - (float)(arcSize * 2), 3.0f, p1x - (float)arcSize, 3.0f);
            if (p1Side == pnSide) {
                DiagramToSVG.path_lineTo(sb, pnx + (float)arcSize, pny);
                DiagramToSVG.path_curveTo(sb, pnx + (float)arcSize, pny, pnx + (float)(arcSize * 2), pny, pnx + (float)(arcSize * 2), pny + (float)arcSize);
            } else {
                DiagramToSVG.path_lineTo(sb, x - (float)angleSize, 3.0f);
                DiagramToSVG.path_curveTo(sb, x - (float)angleSize, 3.0f, x, 3.0f, x, 3 + angleSize);
                if (pnSide == 2) {
                    DiagramToSVG.path_lineTo(sb, pnx, pny + (float)arcSize);
                    DiagramToSVG.path_curveTo(sb, pnx, pny + (float)arcSize, pnx, pny + (float)(arcSize * 2), pnx - (float)arcSize, pny + (float)(arcSize * 2));
                } else if (pnSide == 3) {
                    DiagramToSVG.path_lineTo(sb, x, y - (float)angleSize);
                    DiagramToSVG.path_curveTo(sb, x, y - (float)angleSize, x, y, x - (float)angleSize, y);
                    DiagramToSVG.path_lineTo(sb, pnx - (float)arcSize, pny);
                    DiagramToSVG.path_curveTo(sb, pnx - (float)arcSize, pny, pnx - (float)(arcSize * 2), pny, pnx - (float)(arcSize * 2), pny - (float)arcSize);
                } else {
                    DiagramToSVG.path_lineTo(sb, x, y - (float)angleSize);
                    DiagramToSVG.path_curveTo(sb, x, y - (float)angleSize, x, y, x - (float)angleSize, y);
                    DiagramToSVG.path_lineTo(sb, 3 + angleSize, y);
                    DiagramToSVG.path_curveTo(sb, 3 + angleSize, y, 3.0f, y, 3.0f, y - (float)angleSize);
                    DiagramToSVG.path_lineTo(sb, pnx, pny - (float)arcSize);
                    DiagramToSVG.path_curveTo(sb, pnx, pny - (float)arcSize, pnx, pny - (float)(arcSize * 2), pnx + (float)arcSize, pny - (float)(arcSize * 2));
                }
            }
        }
        try {
            sb.write("\"/>");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static int getPointSide(Rectangle bounds, Point2D p) {
        double t;
        double pi;
        double x = bounds.getX();
        double y = bounds.getY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        double xCenter = x + width / 2.0;
        double yCenter = y + height / 2.0;
        double dx = p.getX() - xCenter;
        double dy = p.getY() - yCenter;
        double alpha = Math.atan2(dy, dx);
        if (alpha < -(pi = Math.PI) + (t = Math.atan2(height, width)) || alpha > pi - t) {
            return 0;
        }
        if (alpha < -t) {
            return 1;
        }
        if (alpha < t) {
            return 2;
        }
        return 3;
    }

    public static Point2D getRelationPoint(Rectangle bounds, Point2D p1, Point2D p2) {
        double sy;
        Line2D.Double relationLine;
        double x = bounds.getX();
        double y = bounds.getY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        Line2D.Double line = new Line2D.Double(x, y, x, y + height);
        if (!(line.intersectsLine(relationLine = new Line2D.Double(p1, p2)) || (line = new Line2D.Double(x, y, x + width, y)).intersectsLine(relationLine) || (line = new Line2D.Double(x + width, y, x + width, y + height)).intersectsLine(relationLine) || (line = new Line2D.Double(x, y + height, x + width, y + height)).intersectsLine(relationLine))) {
            return null;
        }
        double px = line.getX1();
        double py = line.getY1();
        double rx = line.getX2() - px;
        double ry = line.getY2() - py;
        double qx = relationLine.getX1();
        double qy = relationLine.getY1();
        double sx = relationLine.getX2() - qx;
        double det = sx * ry - (sy = relationLine.getY2() - qy) * rx;
        if (det == 0.0) {
            return null;
        }
        double z = (sx * (qy - py) + sy * (px - qx)) / det;
        if (z == 0.0 || z == 1.0) {
            return null;
        }
        return new Point2D.Double(px + z * rx, py + z * ry);
    }

    public static void generateTable(ContainerWithKeyObject table, TopView tv, Writer sb, Graphics2D g, boolean createLinks, String id_suffix) {
        String text;
        DesignPartView dpv = tv.getDesignPartView();
        Color bgcol = DiagramToSVG.getBackgroundColor(table, tv);
        Color fgcol = DiagramToSVG.getTableForegroundColor(table, tv);
        Color bcol = DiagramToSVG.getBorderColor(table, tv);
        int borderWidth = 1;
        Rectangle bounds = null;
        bounds = tv.getCellView() != null ? tv.getCellView().getBounds().getBounds() : tv.getBounds();
        int titlePosition = 20;
        int yCursor = 0;
        int xCursor = 0;
        int tsize = 10;
        int csize = 10;
        boolean lineWidt = true;
        boolean textWidth = true;
        int width = bounds.width;
        int height = bounds.height;
        TopView efo = tv;
        Object longName = table.getLongName();
        if (tv != null) {
            longName = tv.toString();
            if (tv.getDesignPartView().showSchemaName() && table.getSchemaObject() != null) {
                longName = table.getSchemaObject().getName() + "." + (String)longName;
            }
        }
        if (table.isBST()) {
            longName = (String)longName + " (" + table.getBasedOnStructuredType().getName() + ")";
        }
        String cid = DiagramToSVG.getClipPathID(tv, id_suffix);
        DiagramToSVG.addShape(bgcol, bcol, bounds, sb, cid);
        DiagramToSVG.addRect(fgcol, width, height, sb);
        Font titleFont = DiagramToSVG.getTitleFont(table, tv);
        Font keyFont = DiagramToSVG.getFont(table, tv, EditableFonts.FO_KEY);
        FontMetrics fm = g.getFontMetrics(titleFont);
        int colTextHeight = fm.getHeight();
        int classTypePos = yCursor = Math.max(colTextHeight, titleFont.getSize());
        xCursor = (width - fm.stringWidth((String)longName)) / 2;
        if (xCursor < titlePosition) {
            xCursor = titlePosition;
        }
        Color tcolor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_TITLE);
        String[] wrappedTitle = DiagramToSVG.wrapText((String)longName, DiagramToSVG.getMaxChars((String)longName, fm, width - titlePosition - 5));
        for (int t = 0; t < wrappedTitle.length; ++t) {
            String text2 = wrappedTitle[t];
            if (t == 0) {
                String id = table.getShortObjectID() + id_suffix;
                DiagramToSVG.addText(text2, xCursor, yCursor, tcolor, sb, titleFont, createLinks, table.getShortObjectID(), id, table.isDeprecated());
            } else {
                DiagramToSVG.addText(text2, xCursor, yCursor, tcolor, sb, titleFont, table.isDeprecated());
            }
            yCursor += colTextHeight;
        }
        if (efo.getHiddenElements().size() > 0) {
            int right = width - 4;
            int left = right - 8;
            int center = right - 4;
            int[] xPts = new int[]{center, left, right};
            int[] yPts = new int[]{2, 10, 10};
            DiagramToSVG.addPolygon(fgcol, xPts, yPts, 1, sb, true);
        }
        yCursor -= colTextHeight;
        int iconXPos = 2;
        if (table.isRemoteObject()) {
            DiagramToSVG.addUseOfDef("link_sym", iconXPos, colTextHeight / 2, 8, 8, sb);
        }
        yCursor += 3 + borderWidth;
        ContainedObject[] elements = table.getElements();
        String longestName = DesignPartView.getLongestName(elements, dpv.isExpandComplexTypes());
        String longestDTName = DesignPartView.getLongestDTName(elements, table, dpv.isExpandComplexTypes());
        Font colFont = DiagramToSVG.getFont(table, tv, EditableFonts.FO_ELEMENT);
        Font comFont = DiagramToSVG.getFont(table, tv, EditableFonts.FO_COMMENTS);
        float fontSize = colFont.getSize2D();
        fm = g.getFontMetrics(colFont);
        int nameSize = fm.stringWidth(longestName);
        int dtNameSize = fm.stringWidth(longestDTName);
        int nnPos = fm.stringWidth("KW");
        int namePos = 3 + fm.stringWidth("KWN");
        int dtPos = 20 + namePos + nameSize;
        int cPos = 20 + namePos + nameSize;
        if (dpv.showAllDetails() || dpv.showDatatype()) {
            cPos = 20 + dtPos + dtNameSize;
        }
        Color nnColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_NOT_NULL);
        Color pkColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_PK);
        Color ukColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_UK);
        Color fkColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_FK);
        Color dtColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_DATATYPE);
        Color comColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_COMMENTS);
        Color elemColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_ELEMENT);
        Color keyColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_KEY);
        colTextHeight = fm.getHeight();
        if (!dpv.isShowNamesOnly()) {
            int[] yPts;
            int[] xPts;
            Icon icon;
            int xname;
            String colName;
            int keyIconYOffset;
            int LEFT;
            Iterator it;
            List keys;
            DiagramToSVG.addLine(0, yCursor, width - 2, yCursor, fgcol, sb);
            if (dpv.isShowClassificationTypes() && table instanceof ContainerWithKeyObject) {
                ContainerWithKeyObject cwk = table;
                String clname = ALLOW_NULL;
                ClassificationType ct = cwk.getClassificationType();
                if (ct != null) {
                    clname = ct.getTypeName();
                }
                Object clnames = ALLOW_NULL;
                List<String> list = cwk.getAdd_ClassificationTypeNames();
                for (int k = 0; k < list.size(); ++k) {
                    clnames = k > 0 ? (String)clnames + ", " + list.get(k) : list.get(0);
                }
                if (!ALLOW_NULL.equals(clname) || !ALLOW_NULL.equals(clnames)) {
                    Object types = !ALLOW_NULL.equals(clname) ? clname + " / " : "- / ";
                    types = !ALLOW_NULL.equals(clnames) ? (String)types + (String)clnames : (String)types + "-";
                    xCursor = (width - fm.stringWidth((String)types)) / 2;
                    if (xCursor < titlePosition) {
                        xCursor = titlePosition;
                    }
                    DiagramToSVG.addText((String)types, xCursor, yCursor += colTextHeight, tcolor, sb, titleFont);
                    DiagramToSVG.addLine(0, yCursor += 3 + borderWidth, width - 2, yCursor, fgcol, sb);
                }
            }
            if (table.isBST() && table.getTypeSubstitution() != null) {
                StructuredType st = table.getBasedOnStructuredType();
                if (st != null) {
                    TypeElement[] elems = st.getElements();
                    longestName = DesignPartView.getLongestTypeName(elems);
                    colTextHeight = fm.getMaxAscent() - fm.getMaxDescent() + 3;
                    for (int i = 0; i < elems.length; ++i) {
                        TypeElement elm = elems[i];
                        DiagramToSVG.addText(elm.getName(), 25, yCursor += fm.getHeight(), elemColor, sb, colFont, elm.isDeprecated());
                        fm = g.getFontMetrics();
                        int anLeft = fm.stringWidth(longestName) + 50;
                        DiagramToSVG.addText(elm.getDataType(), anLeft, yCursor, dtColor, sb, colFont);
                    }
                }
            } else {
                for (int i = 0; i < elements.length; ++i) {
                    TypeElement te;
                    CollectionType ct;
                    String com;
                    boolean partOfFK;
                    ContainedObjectWithDomain element = (ContainedObjectWithDomain)elements[i];
                    if (efo.getHiddenElements().contains(element) || element.isOid() || dpv.showKeyElements() && !element.isPKElement() && !element.isFKElement() && !element.isUnique()) continue;
                    int anLeft = nnPos;
                    text = element.getNullsAllowed() ? ALLOW_NULL : NOT_NULL;
                    DiagramToSVG.addText(text, anLeft, yCursor += fm.getHeight(), nnColor, sb, colFont);
                    String type = " ";
                    Color color = elemColor;
                    boolean bl = partOfFK = table instanceof FKContainer && element.isPartOfUnresolvedFK((FKContainer)table);
                    if (element.isPKElement()) {
                        type = "P";
                        color = pkColor;
                        if (element.isFKElement() || partOfFK) {
                            type = type.concat("F");
                        }
                    } else if (element.isUnique()) {
                        type = "U";
                        color = ukColor;
                        if (element.isFKElement() || partOfFK) {
                            type = type.concat("F");
                        }
                    } else if (element.isFKElement() || partOfFK) {
                        type = "F";
                        color = fkColor;
                    }
                    if (!" ".equals(type)) {
                        DiagramToSVG.addText(type, 2, yCursor, color, sb, colFont);
                    }
                    anLeft = namePos;
                    if (element.isDeprecated()) {
                        // empty if block
                    }
                    DiagramToSVG.addText(element.getName(), anLeft, yCursor, elemColor, sb, colFont, element.isDeprecated());
                    if (dpv.showAllDetails() || dpv.showDatatype()) {
                        anLeft = dtPos;
                        DiagramToSVG.addText(DiagramToSVG.getDataType(element, table), anLeft, yCursor, dtColor, sb, colFont);
                    }
                    if (dpv.showComments() && !(com = element.getCommentInRDBMS()).isEmpty()) {
                        anLeft = cPos;
                        DiagramToSVG.addText(com, anLeft, yCursor, comColor, sb, colFont);
                    }
                    if (yCursor > height) {
                        int right = width - 4;
                        int left = right - 8;
                        int center = right - 4;
                        int bottom = height - 4;
                        int top = bottom - 8;
                        int[] xPts2 = new int[]{center, left, right};
                        int[] yPts2 = new int[]{bottom, top, top};
                        DiagramToSVG.addPolygon(fgcol, xPts2, yPts2, 1, sb, true);
                        break;
                    }
                    if (dpv.isExpandComplexTypes() && element.getUse() == 3) {
                        StructuredType st = element.getStructuredType();
                        if (st == null) continue;
                        yCursor = DiagramToSVG.paintStructuredType(dpv, table, sb, g, st, 1, yCursor, fgcol, elemColor, nnColor, dtPos, table.getSelectedRDBMSType().toString(), colFont, dtColor);
                        continue;
                    }
                    if (!dpv.isExpandComplexTypes() || element.getUse() != 4 || (ct = element.getCollectionType()) == null || !((te = ct.getElementType()).getType() instanceof StructuredType) || te.isReference()) continue;
                    yCursor = DiagramToSVG.paintStructuredType(dpv, table, sb, g, (StructuredType)te.getType(), 1, yCursor, fgcol, elemColor, nnColor, dtPos, table.getSelectedRDBMSType().toString(), colFont, dtColor);
                }
            }
            List<DesignPartView.Prop> props = Collections.EMPTY_LIST;
            if (dpv != null && dpv.isShowDynamicProperties()) {
                props = DesignPartView.getVisibleProperties(table);
            }
            if (props.size() > 0) {
                DiagramToSVG.addLine(0, yCursor += 6, width - 2, yCursor, fgcol, sb);
                Color prColor = elemColor;
                for (DesignPartView.Prop pr : props) {
                    if (pr.color != null) {
                        prColor = pr.color;
                    }
                    DiagramToSVG.addText(pr.name + " - " + pr.value, 6, yCursor += fm.getHeight(), prColor, sb, colFont);
                }
            }
            if (dpv.showAllDetails() || dpv.showKeys()) {
                keys = DiagramToSVG.getKeys(table.getKeys());
                it = null;
                if (keys.size() > 0) {
                    if (dpv.showAllDetails() || dpv.showElements() || dpv.showKeyElements()) {
                        yCursor += 6;
                        for (KeyObject key : keys) {
                            if (efo.getHiddenElements().contains(key)) continue;
                            DiagramToSVG.addLine(0, yCursor, width - 2, yCursor, bcol, sb);
                            break;
                        }
                    }
                    for (KeyObject key : keys) {
                        if (!key.isPK() && !key.isUnique() || efo.getHiddenElements().contains(key) || !key.isPK() && !key.isUnique()) continue;
                        LEFT = 4;
                        if (key.isPK()) {
                            // empty if block
                        }
                        fm = g.getFontMetrics(keyFont);
                        yCursor += fm.getHeight();
                        keyIconYOffset = -fm.getHeight() / 2;
                        if (key.isPK()) {
                            DiagramToSVG.addUseOfDef("pk_sym", LEFT, yCursor + keyIconYOffset, 8, 8, sb);
                        } else {
                            DiagramToSVG.addUseOfDef("uk_sym", LEFT, yCursor + keyIconYOffset, 8, 8, sb);
                        }
                        Object keyName = key.getName();
                        if (dpv.showAllDetails() || dpv.showKeyAndIndexColumns()) {
                            Index ind;
                            ContainedObject[] columns = key.getElements();
                            keyName = (String)keyName + " (";
                            String expr = null;
                            if (key instanceof Index && ALLOW_NULL.equals(expr = (ind = (Index)key).getIndexExpression())) {
                                expr = null;
                            }
                            if (expr == null) {
                                for (int j = 0; j < columns.length; ++j) {
                                    ContainedObject column = columns[j];
                                    colName = column.getName();
                                    if (j > 0) {
                                        keyName = (String)keyName + ", ";
                                    }
                                    keyName = (String)keyName + colName;
                                }
                            } else {
                                keyName = (String)keyName + expr;
                            }
                            keyName = (String)keyName + ")";
                        }
                        if (key.isDeprecated()) {
                            // empty if block
                        }
                        xname = nnPos;
                        DiagramToSVG.addText((String)keyName, xname, yCursor, keyColor, sb, keyFont, key.isDeprecated());
                        if (yCursor <= height) continue;
                        int right = width - 4;
                        int left = right - 8;
                        int center = right - 4;
                        int bottom = height - 4;
                        int top = bottom - 8;
                        int[] xPts3 = new int[]{center, left, right};
                        int[] yPts3 = new int[]{bottom, top, top};
                        DiagramToSVG.addPolygon(fgcol, xPts3, yPts3, 1, sb, true);
                        break;
                    }
                }
            }
            if (dpv instanceof DPVRelational && (dpv.showAllDetails() || dpv.showFKeys())) {
                List fKeys = DiagramToSVG.getFKeys(table.getKeys());
                it = null;
                if (fKeys.size() > 0) {
                    if (dpv.showAllDetails() || dpv.showElements() || dpv.showKeyElements()) {
                        yCursor += 6;
                        for (KeyObject key : fKeys) {
                            if (efo.getHiddenElements().contains(key)) continue;
                            DiagramToSVG.addLine(0, yCursor, width - 2, yCursor, bcol, sb);
                            break;
                        }
                    }
                    for (KeyObject key : fKeys) {
                        if (efo.getHiddenElements().contains(key)) continue;
                        icon = PKEY_ICON;
                        LEFT = 4;
                        fm = g.getFontMetrics(keyFont);
                        keyIconYOffset = -fm.getHeight() / 2;
                        DiagramToSVG.addUseOfDef("fk_sym", LEFT, (yCursor += fm.getHeight()) + keyIconYOffset, 8, 8, sb);
                        Object keyName = key.getName();
                        if (dpv.showAllDetails() || dpv.showKeyAndIndexColumns()) {
                            Index ind;
                            ContainedObject[] columns = key.getElements();
                            keyName = (String)keyName + " (";
                            String expr = null;
                            if (key instanceof Index && ALLOW_NULL.equals(expr = (ind = (Index)key).getIndexExpression())) {
                                expr = null;
                            }
                            if (expr == null) {
                                for (int j = 0; j < columns.length; ++j) {
                                    ContainedObject column = columns[j];
                                    colName = column.getName();
                                    if (j > 0) {
                                        keyName = (String)keyName + ", ";
                                    }
                                    keyName = (String)keyName + colName;
                                }
                            } else {
                                keyName = (String)keyName + expr;
                            }
                            keyName = (String)keyName + ")";
                        }
                        if (key.isDeprecated()) {
                            // empty if block
                        }
                        xname = nnPos;
                        FKIndexAssociation fk = key.getFKAssociation();
                        if (fk != null) {
                            FKContainer rcont = fk.getRemoteTable();
                            String rname = null;
                            rname = rcont != null ? rcont.getShortObjectID() : fk.getReferredTableLongName();
                            DiagramToSVG.addText((String)keyName, xname, yCursor, keyColor, sb, keyFont, true, rname, null, fk.isDeprecated());
                        } else {
                            DiagramToSVG.addText((String)keyName, xname, yCursor, keyColor, sb, keyFont, false);
                        }
                        if (yCursor <= height) continue;
                        int right = width - 4;
                        int left = right - 8;
                        int center = right - 4;
                        int bottom = height - 4;
                        int top = bottom - 8;
                        xPts = new int[]{center, left, right};
                        yPts = new int[]{bottom, top, top};
                        DiagramToSVG.addPolygon(fgcol, xPts, yPts, 1, sb, true);
                        break;
                    }
                }
            }
            if (dpv instanceof DPVRelational && (dpv.showAllDetails() || dpv.showIndexes()) && (keys = DiagramToSVG.getIndexes(table.getKeys())).size() > 0) {
                if (dpv.showAllDetails() || dpv.showElements() || dpv.showKeys()) {
                    for (KeyObject key : keys) {
                        if (efo.getHiddenElements().contains(key)) continue;
                        DiagramToSVG.addLine(0, yCursor += 6, width - 2, yCursor, bcol, sb);
                        break;
                    }
                }
                for (KeyObject key : keys) {
                    Index ind;
                    if (efo.getHiddenElements().contains(key)) continue;
                    LEFT = 4;
                    icon = KEY_ICON;
                    fm = g.getFontMetrics(keyFont);
                    yCursor += fm.getHeight();
                    keyIconYOffset = -fm.getHeight() / 2;
                    Object keyName = key.getName();
                    if ((dpv.showAllDetails() || dpv.showKeyAndIndexColumns()) && (dpv.showAllDetails() || dpv.showKeyAndIndexColumns())) {
                        Index ind2;
                        ContainedObject[] columns = key.getElements();
                        keyName = (String)keyName + " (";
                        String expr = null;
                        if (key instanceof Index && ALLOW_NULL.equals(expr = (ind2 = (Index)key).getIndexExpression())) {
                            expr = null;
                        }
                        if (expr == null) {
                            for (int j = 0; j < columns.length; ++j) {
                                ContainedObject column = columns[j];
                                colName = column.getName();
                                if (j > 0) {
                                    keyName = (String)keyName + ", ";
                                }
                                keyName = (String)keyName + colName;
                            }
                        } else {
                            keyName = (String)keyName + expr;
                        }
                        keyName = (String)keyName + ")";
                    }
                    if (key.isDeprecated()) {
                        // empty if block
                    }
                    String type = " ";
                    if (key instanceof Index && "Unique Plain Index".equalsIgnoreCase((ind = (Index)key).getIndexState())) {
                        type = "U";
                    }
                    if (!" ".equals(type)) {
                        DiagramToSVG.addText(type, 2, yCursor, keyColor, sb, keyFont);
                    }
                    int xname2 = nnPos;
                    DiagramToSVG.addText((String)keyName, xname2, yCursor, keyColor, sb, keyFont, key.isDeprecated());
                    if (yCursor <= height) continue;
                    int right = width - 4;
                    int left = right - 8;
                    int center = right - 4;
                    int bottom = height - 4;
                    int top = bottom - 8;
                    xPts = new int[]{center, left, right};
                    yPts = new int[]{bottom, top, top};
                    DiagramToSVG.addPolygon(fgcol, xPts, yPts, 1, sb, true);
                    break;
                }
            }
        }
        String comments = table.getCommentInRDBMS().trim();
        if (dpv.showComments() && !ALLOW_NULL.equalsIgnoreCase(comments)) {
            DiagramToSVG.addLine(0, yCursor += 6, width - 2, yCursor, comColor, sb);
            fm = g.getFontMetrics(comFont);
            yCursor += fm.getHeight();
            String[] wrappedComments = DiagramToSVG.wrapText(comments, DiagramToSVG.getMaxChars(comments, fm, width - fm.stringWidth("WWW")));
            for (int t = 0; t < wrappedComments.length; ++t) {
                text = wrappedComments[t];
                g.drawString(text, 5, yCursor);
                DiagramToSVG.addText(text, 5, yCursor, comColor, sb, comFont);
                yCursor += fm.getHeight();
            }
        }
        try {
            sb.write("\n</g>");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void addLabelShape(Color bgcol, Color bordercol, Rectangle2D bounds, Writer sb, String clipID) {
        try {
            sb.write("\n<g >");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addShape(Color bgcol, Color bordercol, Rectangle bounds, Writer sb, String clipID) {
        try {
            float bgopacity = (float)bgcol.getAlpha() / 255.0f;
            float fgopacity = (float)bordercol.getAlpha() / 255.0f;
            sb.write("\n<g ");
            String col = "\"rgb(" + bgcol.getRed() + "," + bgcol.getGreen() + "," + bgcol.getBlue() + ")\"";
            String bordcol = DiagramToSVG.getColor(bordercol);
            sb.write(" fill=" + col + " stroke=" + bordcol + " fill-opacity=\"" + bgopacity + "\" stroke-opacity=\"" + fgopacity + "\"");
            String tr = " transform=\"translate(" + bounds.x + "," + bounds.y + ")\" >";
            if (clipID != null) {
                tr = " clip-path=\"url(#" + clipID + ")\"" + tr;
            }
            sb.write(tr);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addRect(Color fgcol, int width, int height, Writer sb) {
        DiagramToSVG.addRect(fgcol, width, height, 0, 0, sb);
    }

    public static void addRect(Color fgcol, int width, int height, int rx, int ry, Writer sb) {
        try {
            String out = "\n<rect x=\"0\" y=\"0\" width=\"" + (width - 1) + "\" height=\"" + (height - 1) + "\"";
            if (rx != 0 || ry != 0) {
                out = out + " rx=\"" + rx + "\" ry=\"" + ry + "\"";
            }
            out = out + " />";
            sb.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Color getBackgroundColor(DesignObject container, TopView tv) {
        if (tv != null) {
            return DiagramToSVG.getBackgroundColor(container, tv, tv.useDefaultColor());
        }
        return DEFAULT_BACKGROUND;
    }

    public static Color getBackgroundColor(DesignObject container, TopView tv, boolean useDefaultColor) {
        if (tv != null) {
            if (useDefaultColor || tv.getBackgroundColor() == null) {
                ClassificationType cf = DiagramToSVG.getClassificationType(container);
                if (cf != null) {
                    return cf.getTypeColor();
                }
                String type = "Table";
                if (container instanceof TableView) {
                    type = "Relational View";
                } else if (container instanceof EntityView) {
                    type = "Logical View";
                } else if (container instanceof Entity) {
                    type = "Entity";
                } else if (container instanceof Legend) {
                    type = "Legend";
                } else if (container instanceof Note) {
                    type = "Note";
                }
                DefaultFontAndColor dfc = container.getDesign().getDesignLevelSettings().getDefaultFCObject(type);
                if (dfc != null) {
                    return dfc.getBackgroundColor();
                }
            } else {
                return tv.getBackgroundColor();
            }
        }
        return DEFAULT_BACKGROUND;
    }

    public static Color getBackgroundColor(String type, TopView tv) {
        if (tv != null) {
            return DiagramToSVG.getBackgroundColor(type, tv, tv.useDefaultColor());
        }
        return DEFAULT_BACKGROUND;
    }

    public static Color getBackgroundColor(String type, TopView tv, boolean useDefaultColor) {
        if (tv != null) {
            if (useDefaultColor || tv.getBackgroundColor() == null) {
                DefaultFontAndColor dfc = tv.getDesign().getDesignLevelSettings().getDefaultFCObject(type);
                if (dfc != null) {
                    return dfc.getBackgroundColor();
                }
            } else {
                return tv.getBackgroundColor();
            }
        }
        return DEFAULT_BACKGROUND;
    }

    public static Color getForegroundColor(String type, TopView tv) {
        if (tv != null) {
            if (tv.useDefaultColor() || tv.getForegroundColor() == null) {
                DefaultFontAndColor dfc = tv.getDesign().getDesignLevelSettings().getDefaultFCObject(type);
                if (dfc != null) {
                    return dfc.getForegroundColor();
                }
                return DEFAULT_FOREGROUND;
            }
            return tv.getForegroundColor();
        }
        return DEFAULT_FOREGROUND;
    }

    private static ClassificationType getClassificationType(DesignObject container) {
        if (container instanceof ContainerWithKeyObject) {
            return container.getDesign().getDesignLevelSettings().getClassificationTypeByID(((ContainerWithKeyObject)container).getTypeID());
        }
        return null;
    }

    public static Color getTableForegroundColor(ContainerObject container, TopView tv) {
        if (tv != null) {
            if (tv.useDefaultColor() || tv.getForegroundColor() == null) {
                ClassificationType cf = DiagramToSVG.getClassificationType(container);
                if (cf != null) {
                    return cf.getForegroundColor();
                }
                String type = "Table";
                if (container instanceof TableView) {
                    type = "Relational View";
                } else if (container instanceof EntityView) {
                    type = "Logical View";
                } else if (container instanceof Entity) {
                    type = "Entity";
                }
                DefaultFontAndColor dfc = container.getDesign().getDesignLevelSettings().getDefaultFCObject(type);
                if (dfc != null) {
                    return dfc.getForegroundColor();
                }
                return DEFAULT_FOREGROUND;
            }
            return tv.getForegroundColor();
        }
        return DEFAULT_FOREGROUND;
    }

    public static Color getForegroundColor(DesignObject container, TopView tv) {
        if (tv != null) {
            if (tv.useDefaultColor() || tv.getForegroundColor() == null) {
                ClassificationType cf;
                if (container instanceof ContainerObject && (cf = DiagramToSVG.getClassificationType((ContainerObject)container)) != null) {
                    return cf.getForegroundColor();
                }
                String type = "Table";
                if (container instanceof TableView) {
                    type = "Relational View";
                } else if (container instanceof EntityView) {
                    type = "Logical View";
                } else if (container instanceof Entity) {
                    type = "Entity";
                } else if (container instanceof Legend) {
                    type = "Legend";
                } else if (container instanceof Note) {
                    type = "Note";
                }
                DefaultFontAndColor dfc = container.getDesign().getDesignLevelSettings().getDefaultFCObject(type);
                if (dfc != null) {
                    return dfc.getForegroundColor();
                }
                return DEFAULT_FOREGROUND;
            }
            return tv.getForegroundColor();
        }
        return DEFAULT_FOREGROUND;
    }

    public static Color getLineColor(DesignObject container, TopView tv) {
        if (tv != null) {
            if (tv.useDefaultColor() || tv.getDefaultLineColor() == null) {
                DefaultLineWidthAndColor dfc = container.getDesign().getDesignLevelSettings().getDefaultLWCObject(container.getClass().getSimpleName());
                if (dfc == null) {
                    dfc = container instanceof TypeSubstitution ? container.getDesign().getDesignLevelSettings().getDefaultLWCObject("Type Substitution") : (container instanceof ImpliedForeignKey ? container.getDesign().getDesignLevelSettings().getDefaultLWCObject("Implied Foreign Key") : container.getDesign().getDesignLevelSettings().getDefaultLWCObject("Relational Foreign Key"));
                }
                if (dfc != null) {
                    return dfc.getColor();
                }
                return DEFAULT_FOREGROUND;
            }
            return tv.getBackgroundColor();
        }
        return DEFAULT_FOREGROUND;
    }

    public static Font getFont(DesignObject container, TopView tv, String type) {
        if (tv != null) {
            FontObject fo;
            ClassificationType cf;
            if (tv.useDefaultColor() && (cf = DiagramToSVG.getClassificationType(container)) != null && (fo = cf.getDefaultFCObject().getFontObject(type)) != null) {
                return cf.getDefaultFCObject().getFontObject(type).getFont();
            }
            FontObject fo2 = tv.getFontObject(type);
            if (fo2 != null) {
                return fo2.getFont();
            }
        }
        return DiagramToSVG.getObjectFont(container, type);
    }

    public static Font getTitleFont(DesignObject container, TopView tv) {
        return DiagramToSVG.getFont(container, tv, EditableFonts.FO_TITLE);
    }

    public static Font getObjectFont(DesignObject obj, String type) {
        FontObject fo;
        DefaultFontAndColor dfc;
        if (obj instanceof EditableFonts && (dfc = obj.getDesign().getDesignLevelSettings().getDefaultFCObject(((EditableFonts)((Object)obj)).getFCObjectType())) != null && (fo = dfc.getFontObject(type)) != null) {
            return fo.getFont();
        }
        return DIALOG_FONT;
    }

    protected static Color getColor(DesignObject container, TopView tv, String type) {
        if (tv != null) {
            FontObject fo;
            ClassificationType cf;
            if (tv.useDefaultColor() && container instanceof ContainerObject && (cf = DiagramToSVG.getClassificationType((ContainerObject)container)) != null && (fo = cf.getDefaultFCObject().getFontObject(type)) != null) {
                return fo.getColor();
            }
            FontObject fo2 = tv.getFontObject(type);
            if (fo2 != null) {
                return fo2.getColor();
            }
        }
        return DiagramToSVG.getObjectColor(container, type);
    }

    public static Color getObjectColor(DesignObject obj, String type) {
        FontObject fo;
        DefaultFontAndColor dfc;
        if (obj instanceof EditableFonts && (dfc = obj.getDesign().getDesignLevelSettings().getDefaultFCObject(((EditableFonts)((Object)obj)).getFCObjectType())) != null && (fo = dfc.getFontObject(type)) != null) {
            return fo.getColor();
        }
        return Color.BLACK;
    }

    public static int getMaxChars(String text, FontMetrics fm, int length) {
        for (int i = 0; i < text.length(); ++i) {
            String subStr = text.substring(0, i);
            int s1 = fm.stringWidth(subStr);
            if (s1 <= length) continue;
            return i;
        }
        return text.length();
    }

    public static String[] wrapText(String text, int length) {
        if (length > 0) {
            Pattern wrapRE = Pattern.compile("([\\S\\S&&[^\\p{Punct}]]{" + length + ",}|.{1," + length + "})(\\p{Punct}+|\\s+|$)");
            LinkedList<String> list = new LinkedList<String>();
            Matcher m = wrapRE.matcher(text);
            while (m.find()) {
                list.add(m.group());
            }
            return list.toArray(new String[list.size()]);
        }
        return new String[]{text};
    }

    private static void addText(String text, int x, int y, Color fgcol, Writer sb, Font font, boolean deprecated) {
        DiagramToSVG.addText(text, x, y, fgcol, sb, font, false, null, null, deprecated);
    }

    private static void addText(String text, int x, int y, Color fgcol, Writer sb, Font font) {
        DiagramToSVG.addText(text, x, y, fgcol, sb, font, false, null, null, false);
    }

    private static void addText(String text, int x, int y, Color fgcol, Writer sb, Font font, boolean createLinks, String idInReport, String id) {
        DiagramToSVG.addText(text, x, y, fgcol, sb, font, createLinks, idInReport, id, false);
    }

    private static void addText(String text, int x, int y, Color fgcol, Writer sb, Font font, boolean createLinks, String idInReport, String id, boolean deprecated) {
        try {
            String depr = ALLOW_NULL;
            if (deprecated) {
                depr = " text-decoration=\"line-through\"";
            }
            Object sfont = ALLOW_NULL;
            if (font.isItalic()) {
                sfont = " font-style=\"italic\" ";
            }
            if (font.isBold()) {
                sfont = (String)sfont + " font-weight=\"bold\" ";
            }
            float fillopacity = (float)fgcol.getAlpha() / 255.0f;
            int size = font.getSize();
            String col = "\"rgb(" + fgcol.getRed() + "," + fgcol.getGreen() + "," + fgcol.getBlue() + ")\"";
            if (createLinks && idInReport != null) {
                sb.write("<a xlink:href=\"#" + URLEncoder.encode(idInReport, "UTF-8").replace("+", "%20") + "\" >");
            }
            String ntext = StringUtilities.encodeAttributeValue(text);
            if (id != null) {
                sb.write("\n<text" + depr + " id=\"" + id + "\" x=\"" + x + "\" y=\"" + y + "\" fill=" + col + (String)sfont + " fill-opacity=\"" + fillopacity + "\" font-size=\"" + size + "\" stroke=\"none\">\n" + ntext + "\n</text>");
            } else {
                sb.write("\n<text" + depr + " x=\"" + x + "\" y=\"" + y + "\" fill=" + col + (String)sfont + " fill-opacity=\"" + fillopacity + "\" font-size=\"" + size + "\" stroke=\"none\">\n" + ntext + "\n</text>");
            }
            if (createLinks && idInReport != null) {
                sb.write("</a>");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void addLine(int x1, int y1, int x2, int y2, Color fgcol, Writer sb) {
        try {
            String col = "\"rgb(" + fgcol.getRed() + "," + fgcol.getGreen() + "," + fgcol.getBlue() + ")\"";
            sb.write("\n<line x1=\"" + x1 + "\" y1=\"" + y1 + "\" x2=\"" + x2 + "\" y2=\"" + y2 + "\" fill=\"none\" stroke=" + col + "/>");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Color getBorderColor(DesignObject container, TopView tv) {
        return DiagramToSVG.getForegroundColor(container, tv);
    }

    protected static String getDataType(ContainedObjectWithDomain element, ContainerObject container) {
        if (container instanceof Table) {
            String formulaDesc = element.getFormulaDesc();
            if (formulaDesc != null && formulaDesc.length() > 0 && ("Derived".equalsIgnoreCase(element.getSourceType()) || "Aggregate".equalsIgnoreCase(element.getSourceType()) || element instanceof Column && ((Column)element).isComputed().booleanValue())) {
                return formulaDesc;
            }
            if (element instanceof Attribute) {
                return ((Attribute)element).getLogicalRepresentationName();
            }
            if (element.isReference() && element.getDataType() instanceof StructuredType) {
                return "REF " + element.getDataType().toString();
            }
        }
        if (element instanceof ColumnView && !ALLOW_NULL.equalsIgnoreCase(element.getStructAttributeID())) {
            return ((ColumnView)element).getDataTypeString();
        }
        Datatype datatype = element.getDataType();
        if (datatype instanceof DistinctType && element instanceof Column) {
            String rdbmsName = element.getSelectedRDBMSType().toString();
            if (rdbmsName.startsWith("DB2")) {
                return datatype.getName();
            }
            datatype = element.getDataType(rdbmsName);
        }
        if (datatype != null) {
            return datatype.toString();
        }
        return ALLOW_NULL;
    }

    protected static List getKeys(KeyObject[] keys) {
        ArrayList<KeyObject> list = new ArrayList<KeyObject>();
        for (int i = 0; i < keys.length; ++i) {
            if (!keys[i].isPK() && !keys[i].isUnique()) continue;
            list.add(keys[i]);
        }
        return list;
    }

    protected static List getIndexes(KeyObject[] keys) {
        ArrayList<KeyObject> list = new ArrayList<KeyObject>();
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i].isFK() || keys[i].isPK() || keys[i].isUnique()) continue;
            list.add(keys[i]);
        }
        return list;
    }

    protected static List getFKeys(KeyObject[] keys) {
        ArrayList<KeyObject> list = new ArrayList<KeyObject>();
        for (int i = 0; i < keys.length; ++i) {
            if (!keys[i].isFK()) continue;
            list.add(keys[i]);
        }
        return list;
    }

    public static void dpv_ToSVG(DesignPartView dpv, Writer sb, String id_suffix) {
        boolean first;
        DesignPart rd = dpv.getDesignPart();
        DiagramToSVG.initNumIDs(dpv.getDesignPart());
        Rectangle2D dim = dpv.getTopViewsBounds();
        DiagramToSVG.addSVGOpenTag(sb, (int)(dim.getWidth() + dim.getX()), (int)(dim.getHeight() + dim.getY()));
        DiagramToSVG.addDefs(sb, dpv, id_suffix);
        DiagramToSVG.processTVConnectors(dpv, sb, true, id_suffix);
        boolean bl = first = !DiagramToSVG.processT_V_shapes(dpv, sb, true, id_suffix);
        if (dpv instanceof DPVLogical) {
            DiagramToSVG.processConnectedToHierarchies((DPVLogical)dpv, sb, first, id_suffix);
        }
        DiagramToSVG.processArcs(dpv, sb);
        try {
            sb.write("\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DiagramToSVG.addSVGCloseTag(sb);
    }

    public static void diagramToSVG(DesignPartView dpv, String fpath) {
        try {
            DiagramToSVG.initNumIDs(dpv.getDesignPart());
            FileWriter fw = new FileWriter(fpath);
            fw.write("<html>");
            DiagramToSVG.dpv_ToSVG(dpv, fw, ALLOW_NULL);
            fw.write("\n</html>");
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void diagramToSVG(DesignPartView dpv, Writer fw) {
        try {
            fw.write("<html>");
            DiagramToSVG.dpv_ToSVG(dpv, fw, ALLOW_NULL);
            fw.write("</html>");
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void processArcs(DesignPartView dpv, Writer sb) {
        block7: {
            Graphics2D graphics;
            block6: {
                graphics = (Graphics2D)DesignPartView.getOfflineGraphics();
                if (!(dpv instanceof DPVRelational)) break block6;
                RelationalDesign rd = (RelationalDesign)dpv.getDesignPart();
                Iterator it = rd.getArcSet().iterator();
                while (it.hasNext()) {
                    FKArc arc = (FKArc)it.next();
                    TopView tv = arc.getFirstViewForDPV(dpv);
                    if (tv == null) continue;
                    try {
                        DiagramToSVG.generateFKArc(arc.getFkeys().iterator(), tv, sb, graphics, arc.isReverse());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                break block7;
            }
            if (!(dpv instanceof DPVLogical)) break block7;
            LogicalDesign rd = (LogicalDesign)dpv.getDesignPart();
            Iterator it = rd.getArcSet().iterator();
            while (it.hasNext()) {
                Arc arc = (Arc)it.next();
                TopView tv = arc.getFirstViewForDPV(dpv);
                if (tv == null) continue;
                try {
                    DiagramToSVG.generateFKArc(arc.getRelations().iterator(), tv, sb, graphics, false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String getSVGForDiagram(DesignPartView dpv, boolean createLinks, String id_suffix) {
        boolean first;
        DiagramToSVG.initNumIDs(dpv.getDesignPart());
        StringWriter sw = new StringWriter();
        Rectangle2D dim = dpv.getTopViewsBounds();
        DiagramToSVG.addSVGOpenTag(sw, (int)(dim.getWidth() + dim.getX()), (int)(dim.getHeight() + dim.getY()));
        DiagramToSVG.addDefs(sw, dpv, id_suffix);
        DiagramToSVG.processTVConnectors(dpv, sw, true, id_suffix);
        boolean bl = first = !DiagramToSVG.processT_V_shapes(dpv, sw, createLinks, id_suffix);
        if (dpv instanceof DPVLogical) {
            DiagramToSVG.processConnectedToHierarchies((DPVLogical)dpv, sw, first, id_suffix);
        }
        DiagramToSVG.processArcs(dpv, sw);
        try {
            sw.write("\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DiagramToSVG.addSVGCloseTag(sw);
        return sw.toString();
    }

    public static String getSVGThumbnailFromModel(DiagramThumbnailModel dm, String id, Rectangle2D dim) {
        return DiagramToSVG.getSVGThumbnailFromModel(dm, id, dim, true);
    }

    public static String getSVGThumbnailFromModel(DiagramThumbnailModel dm, String id, Rectangle2D dim, boolean asSymbol) {
        StringWriter sw = new StringWriter();
        dm.setClipID();
        Rectangle2D r = dm.getBounds();
        if (r != null) {
            dim.setRect(r.getX(), r.getY(), r.getWidth(), r.getHeight());
        }
        int dx = 0;
        int dy = 0;
        boolean move = true;
        dx = 5 - (int)dim.getX();
        dy = 5 - (int)dim.getY();
        if (move) {
            dm.move(dx, dy);
        }
        if (asSymbol) {
            DiagramToSVG.addSVGAndSymbolOpenTags(id, (int)(dim.getWidth() + 5.0), (int)(dim.getHeight() + 5.0), sw);
        } else {
            DiagramToSVG.addSVGOpenTags(id, (int)(dim.getWidth() + 5.0), (int)(dim.getHeight() + 5.0), sw);
        }
        DiagramToSVG.addThumbnailDefs(sw, dm);
        DiagramToSVG.processLines(dm, sw);
        boolean first = !DiagramToSVG.processShapes(dm, sw);
        try {
            sw.write("\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (asSymbol) {
            DiagramToSVG.addSymbolCloseTag(sw);
        }
        DiagramToSVG.addSVGCloseTag(sw);
        return sw.toString();
    }

    public static boolean processT_V_shapes(DesignPartView dpv, Writer sb, boolean createLinks, String id_suffix) {
        boolean processed = false;
        boolean first = true;
        Graphics2D graphics = (Graphics2D)DesignPartView.getOfflineGraphics();
        try {
            ContainerObject co;
            ContainerWithKeyObject table;
            TopView tv;
            boolean lfirst;
            Iterator it = null;
            if (dpv instanceof DPVRelational) {
                it = ((DPVRelational)dpv).getTVTables().iterator();
            } else if (dpv instanceof DPVLogical) {
                it = ((DPVLogical)dpv).getTVEntities().iterator();
            }
            while (it.hasNext()) {
                lfirst = true;
                tv = (TopView)it.next();
                table = null;
                co = (ContainerObject)tv.getModel();
                table = (ContainerWithKeyObject)co;
                if (dpv instanceof DPVLogical && dpv.getNotation() == 1) {
                    DiagramToSVG.generateEntityBarkerNotation(table, tv, sb, graphics, createLinks, id_suffix);
                } else {
                    DiagramToSVG.generateTable(table, tv, sb, graphics, createLinks, id_suffix);
                }
                processed = true;
            }
            if (dpv instanceof DPVRelational) {
                it = ((DPVRelational)dpv).getTVViews().iterator();
            } else if (dpv instanceof DPVLogical) {
                it = ((DPVLogical)dpv).getTVViews().iterator();
            }
            while (it.hasNext()) {
                lfirst = true;
                tv = (TopView)it.next();
                table = null;
                co = (ContainerObject)tv.getModel();
                table = (AbstractView)co;
                DiagramToSVG.generateTableView((AbstractView)table, tv, sb, graphics, createLinks, id_suffix);
                processed = true;
            }
            it = dpv.getTopviewsList().iterator();
            while (it.hasNext()) {
                lfirst = true;
                tv = (TopView)it.next();
                if (!(tv instanceof TVNote)) continue;
                DiagramToSVG.generateNote((Note)tv.getModel(), tv, sb, graphics, createLinks, id_suffix);
            }
            Legend legend = dpv.getLegend();
            if (legend != null && legend.isVisible()) {
                tv = legend.getTopView();
                DiagramToSVG.generateLegend(legend, tv, sb, graphics, createLinks, id_suffix);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return processed;
    }

    public static boolean canGenerateForDiagram(DesignPartView dpv) {
        return dpv instanceof DPVRelational || dpv instanceof DPVLogical;
    }

    static void processRelationLabels(DesignPartView dpv, TVConnector tv, Writer sb, Graphics2D g, String id_suffix) {
        Rectangle2D r;
        TopView tvl;
        Label label;
        try {
            if (dpv.showRelAttributes() && (label = tv.getCenterLabel()) != null && label.isRelationshipAttributesLabel() && (tvl = label.getFirstViewForDPV(dpv)) != null) {
                r = tv.getLabelBoundsFor(1);
                if (tvl.getCellView() != null) {
                    r = tvl.getCellView().getBounds().getBounds();
                }
                DiagramToSVG.generateRelationAttributeLabel(label, tvl, tv, r, sb, g, id_suffix);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (dpv.showLabels() && (label = tv.getSourceLabel()) != null && (tvl = label.getFirstViewForDPV(dpv)) != null) {
                r = tv.getLabelBoundsFor(0);
                if (tvl.getCellView() != null) {
                    r = tvl.getCellView().getBounds();
                }
                DiagramToSVG.generateLabel(label, tvl, r, sb, g, id_suffix);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (dpv.showLabels() && (label = tv.getTargetLabel()) != null && (tvl = label.getFirstViewForDPV(dpv)) != null) {
                r = tv.getLabelBoundsFor(2);
                if (tvl.getCellView() != null) {
                    r = tvl.getCellView().getBounds();
                }
                DiagramToSVG.generateLabel(label, tvl, r, sb, g, id_suffix);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean processTVConnectors(DesignPartView dpv, Writer sb, boolean first, String id_suffix) {
        boolean processed = false;
        try {
            Graphics2D g = (Graphics2D)DesignPartView.getOfflineGraphics();
            for (TVConnector tv : dpv.getTVConnectors()) {
                ConnectionInterface ci = (ConnectionInterface)((Object)tv.getModel());
                DesignObject so = ci.getSourceObject();
                DesignObject to = ci.getTargetObject();
                if (so == null || to == null) continue;
                DesignObject co = tv.getModel();
                if (co instanceof FKIndexAssociation && tv.getActualPoints().size() > 0) {
                    DiagramToSVG.generateFK((FKIndexAssociation)co, tv, sb, g);
                    try {
                        Label label;
                        TopView tvl;
                        if (!dpv.showLabels() || (tvl = (label = tv.getCenterLabel()).getFirstViewForDPV(dpv)) == null) continue;
                        Rectangle2D r = tv.getLabelBoundsFor(1);
                        if (tvl.getCellView() != null) {
                            r = tvl.getCellView().getBounds();
                        }
                        DiagramToSVG.generateLabel(label, tvl, r, sb, g, id_suffix);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (co instanceof ImpliedForeignKey && tv.getActualPoints().size() > 0) {
                    DiagramToSVG.generateImpliedFK((ImpliedForeignKey)co, tv, sb, g);
                    continue;
                }
                if (co instanceof Relation && tv.getActualPoints().size() > 0) {
                    Relation cr = (Relation)tv.getModel();
                    if (cr.getSourceEntity().isHierarchicalEntityType() || cr.getTargetEntity().isHierarchicalEntityType() || tv.getActualPoints().size() <= 0) continue;
                    DiagramToSVG.generateRelationShip((Relation)co, tv, sb, g);
                    DiagramToSVG.processRelationLabels(dpv, tv, sb, g, id_suffix);
                    continue;
                }
                if (!(co instanceof TypeSubstitution)) continue;
                DiagramToSVG.generateTypeSubstitution((TypeSubstitution)co, tv, sb, g);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return processed;
    }

    public static boolean processConnectedToHierarchies(DPVLogical dpv, Writer sb, boolean first, String id_suffix) {
        boolean processed = false;
        try {
            Graphics2D g = (Graphics2D)DesignPartView.getOfflineGraphics();
            for (TVConnector tv : dpv.getTVConnectors()) {
                Relation co;
                ConnectionInterface ci = (ConnectionInterface)((Object)tv.getModel());
                DesignObject so = ci.getSourceObject();
                DesignObject to = ci.getTargetObject();
                if (so == null || to == null || !(co = (Relation)tv.getModel()).getSourceEntity().isHierarchicalEntityType() && !co.getTargetEntity().isHierarchicalEntityType()) continue;
                if (tv.getActualPoints().size() > 0) {
                    DiagramToSVG.generateRelationShip(co, tv, sb, g);
                }
                DiagramToSVG.processRelationLabels(dpv, tv, sb, g, id_suffix);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return processed;
    }

    public static boolean processShapes(DiagramThumbnailModel dm, Writer sb) {
        boolean processed = false;
        boolean first = true;
        Graphics2D graphics = (Graphics2D)DesignPartView.getOfflineGraphics();
        try {
            Iterator<Shape> it = dm.shapes.iterator();
            while (it.hasNext()) {
                boolean lfirst = true;
                Shape tv = it.next();
                DiagramToSVG.generateShape(tv, sb, graphics);
                processed = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return processed;
    }

    public static boolean processLines(DiagramThumbnailModel dm, Writer sb) {
        boolean processed = false;
        try {
            Graphics2D g = (Graphics2D)DesignPartView.getOfflineGraphics();
            Iterator<Line> it = dm.lines.iterator();
            while (it.hasNext()) {
                boolean lfirst = true;
                Line line = it.next();
                DiagramToSVG.generateLine(line, sb);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return processed;
    }

    public static void generateFK(FKIndexAssociation fk, TVConnector tv, Writer sb, Graphics2D g) {
        DesignPartView dpv = tv.getDesignPartView();
        Color fgcol = DiagramToSVG.getLineColor(fk, tv);
        int width = tv.getLineWidth();
        DiagramToSVG.addSVGstartForLine(sb);
        int borderWidth = 1;
        List list = tv.getActualPoints();
        DiagramToSVG.addPath(list, !fk.isMandatory(), fgcol, width, sb);
        DiagramToSVG.addLineBegin(list, fgcol, borderWidth, sb);
        int type = DiagramToSVG.getLineEndType(fk);
        int s = list.size();
        Point2D src = (Point2D)list.get(s - 2);
        Point2D dst = (Point2D)list.get(s - 1);
        DiagramToSVG.addLineEnd(list, fgcol, width, sb, type, fk.isTransferable(), !fk.isMandatory(), src, dst);
        DiagramToSVG.addSVGElementCloseTag(sb);
    }

    public static void generateImpliedFK(ImpliedForeignKey fk, TVConnector tv, Writer sb, Graphics2D g) {
        DesignPartView dpv = tv.getDesignPartView();
        Color fgcol = DiagramToSVG.getLineColor(fk, tv);
        int width = tv.getLineWidth();
        DiagramToSVG.addSVGstartForLine(sb);
        int borderWidth = 1;
        List list = tv.getActualPoints();
        DiagramToSVG.addPath(list, true, fgcol, width, sb, "2,6");
        DiagramToSVG.addLineBegin(list, fgcol, borderWidth, sb);
        int type = 17;
        int s = list.size();
        Point2D src = (Point2D)list.get(s - 2);
        Point2D dst = (Point2D)list.get(s - 1);
        DiagramToSVG.addLineEnd(list, fgcol, width, sb, type, true, false, src, dst);
        DiagramToSVG.addSVGElementCloseTag(sb);
    }

    public static void generateRelationShip(Relation rel, TVConnector tv, Writer sb, Graphics2D g) {
        DesignPartView dpv = tv.getDesignPartView();
        int not = dpv.getNotation();
        Color fgcol = DiagramToSVG.getLineColor(rel, tv);
        int width = tv.getLineWidth();
        DiagramToSVG.addSVGstartForLine(sb);
        int borderWidth = 1;
        List list = tv.getActualPoints();
        if (not == 1) {
            if (rel.isOptionalSource() && rel.isOptionalTarget()) {
                DiagramToSVG.addPath(list, true, fgcol, width, sb);
            } else if (!rel.isOptionalSource() && !rel.isOptionalTarget()) {
                DiagramToSVG.addPath(list, false, fgcol, width, sb);
            } else {
                List nlist = DiagramToSVG.getDashedPoints(list, rel.isOptionalSource(), rel.isOptionalTarget());
                DiagramToSVG.addPath(nlist, true, fgcol, width, sb);
                nlist = DiagramToSVG.getNonDashedPoints(list, rel.isOptionalSource(), rel.isOptionalTarget());
                DiagramToSVG.addPath(nlist, false, fgcol, width, sb);
            }
        } else if (not == 2) {
            DiagramToSVG.addPath(list, !rel.isIdentifying(), fgcol, width, sb);
        } else {
            DiagramToSVG.addPath(list, false, fgcol, width, sb);
        }
        int s = list.size();
        Relation.RelationEndsDescription rd = rel.getRelationEndsDescription(not);
        Point2D src = (Point2D)list.get(1);
        Point2D dst = (Point2D)list.get(0);
        DiagramToSVG.addLineEnd(list, fgcol, borderWidth, sb, rd.beginType, rd.beginTransferable, rd.beginOptional, src, dst);
        src = (Point2D)list.get(s - 2);
        dst = (Point2D)list.get(s - 1);
        DiagramToSVG.addLineEnd(list, fgcol, width, sb, rd.endType, rd.endTransferable, rd.endOptional, src, dst);
        DiagramToSVG.addSVGElementCloseTag(sb);
    }

    private static List getDashedPoints(List points, boolean sourceOptional, boolean targetOptional) {
        ArrayList<Point2D> list = new ArrayList<Point2D>();
        int size = points.size();
        if (sourceOptional) {
            if (size == 2) {
                Point2D p0 = (Point2D)points.get(0);
                Point2D p1 = (Point2D)points.get(1);
                double x1 = p1.getX() - p0.getX();
                double y1 = p1.getY() - p0.getY();
                x1 = p0.getX() + x1 / 2.0;
                y1 = p0.getY() + y1 / 2.0;
                list.add(p0);
                list.add(new Point2D.Double(x1, y1));
            } else if (size > 2) {
                list.add((Point2D)points.get(0));
                list.add((Point2D)points.get(1));
            }
        } else if (targetOptional) {
            if (size == 2) {
                Point2D p0 = (Point2D)points.get(0);
                Point2D p1 = (Point2D)points.get(1);
                double x1 = p1.getX() - p0.getX();
                double y1 = p1.getY() - p0.getY();
                x1 = p0.getX() + x1 / 2.0;
                y1 = p0.getY() + y1 / 2.0;
                list.add(p1);
                list.add(new Point2D.Double(x1, y1));
            } else if (size > 2) {
                list.add((Point2D)points.get(size - 2));
                list.add((Point2D)points.get(size - 1));
            }
        }
        return list;
    }

    private static List getNonDashedPoints(List points, boolean sourceOptional, boolean targetOptional) {
        ArrayList<Point2D> list;
        block8: {
            int size;
            block6: {
                block7: {
                    list = new ArrayList<Point2D>();
                    size = points.size();
                    if (!sourceOptional) break block6;
                    if (size != 2) break block7;
                    Point2D p0 = (Point2D)points.get(0);
                    Point2D p1 = (Point2D)points.get(1);
                    double x1 = p1.getX() - p0.getX();
                    double y1 = p1.getY() - p0.getY();
                    x1 = p0.getX() + x1 / 2.0;
                    y1 = p0.getY() + y1 / 2.0;
                    list.add(p1);
                    list.add(new Point2D.Double(x1, y1));
                    break block8;
                }
                if (size <= 2) break block8;
                for (int i = 1; i < size; ++i) {
                    list.add((Point2D)points.get(i));
                }
                break block8;
            }
            if (targetOptional) {
                if (size == 2) {
                    Point2D p0 = (Point2D)points.get(0);
                    Point2D p1 = (Point2D)points.get(1);
                    double x1 = p1.getX() - p0.getX();
                    double y1 = p1.getY() - p0.getY();
                    x1 = p0.getX() + x1 / 2.0;
                    y1 = p0.getY() + y1 / 2.0;
                    list.add(p0);
                    list.add(new Point2D.Double(x1, y1));
                } else if (size > 2) {
                    for (int i = 0; i < size - 1; ++i) {
                        list.add((Point2D)points.get(i));
                    }
                }
            }
        }
        return list;
    }

    public static void generateTypeSubstitution(TypeSubstitution fk, TVConnector tv, Writer sb, Graphics2D g) {
        DesignPartView dpv = tv.getDesignPartView();
        Color fgcol = DiagramToSVG.getLineColor(fk, tv);
        int width = tv.getLineWidth();
        DiagramToSVG.addSVGstartForLine(sb);
        List list = tv.getActualPoints();
        int s = list.size();
        Point2D srci = (Point2D)list.get(s - 2);
        Point2D dsti = (Point2D)list.get(s - 1);
        int borderWidth = 1;
        int size = 4;
        Point src = new Point((int)srci.getX(), (int)srci.getY());
        Point dst = new Point((int)dsti.getX(), (int)dsti.getY());
        int d = (int)Math.max(1.0, dst.distance(src));
        double ax = -((double)size * (((Point2D)dst).getX() - ((Point2D)src).getX()) / (double)d);
        double ay = -((double)size * (((Point2D)dst).getY() - ((Point2D)src).getY()) / (double)d);
        String cx = String.valueOf((float)(((Point2D)dst).getX() + ax / 2.0 - (double)(size / 2)));
        String cy = String.valueOf((float)(((Point2D)dst).getY() + ay / 2.0 - (double)(size / 2)));
        ((Point2D)dst).setLocation(dsti.getX() + ax, dsti.getY() + ay);
        list.set(s - 1, dst);
        DiagramToSVG.addPath(list, false, fgcol, width, sb);
        DiagramToSVG.addLineBegin(list, fgcol, borderWidth, sb, false);
        int type = 5;
        DiagramToSVG.addCircle(fgcol, width, sb, type, false, cx, cy, size);
        DiagramToSVG.addSVGElementCloseTag(sb);
    }

    public static void generateLine(Line line, Writer sb) {
        Color fgcol = line.fgCol;
        int width = line.width;
        DiagramToSVG.addSVGstartForLine(sb);
        int borderWidth = 1;
        List<Point2D> list = line.points;
        DiagramToSVG.addPath(list, line.dashed, fgcol, width, sb, line.dashArray);
        DiagramToSVG.addLineBegin(list, fgcol, borderWidth, sb);
        DiagramToSVG.addSVGElementCloseTag(sb);
    }

    public static void addNote(Color fgcol, int w, int h, Writer sb) {
        try {
            int f = w / 6;
            String out = "\n<polygon points=\"" + (w - f) + " 0," + (w - f) + " " + f + "," + w + " " + f + " " + w + " " + h + ",0 " + h + ",0 0," + (w - f) + " 0," + w + " " + f + "\"/>";
            sb.write(out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void addShape(Color bgcol, Color bordercol, Rectangle bounds, Writer sb, String clipID, float opacity, float line_opacity) {
        try {
            sb.write("\n<g ");
            String col = "\"rgb(" + bgcol.getRed() + "," + bgcol.getGreen() + "," + bgcol.getBlue() + ")\"";
            String bordcol = DiagramToSVG.getColor(bordercol);
            opacity = (float)bgcol.getAlpha() / 255.0f;
            line_opacity = (float)bordercol.getAlpha() / 255.0f;
            sb.write(" fill=" + col + " fill-opacity=\"" + opacity + "\" stroke=" + bordcol);
            String tr = " transform=\"translate(" + bounds.x + "," + bounds.y + ")\" stroke-opacity=\"" + line_opacity + "\" >";
            if (clipID != null) {
                tr = " clip-path=\"url(#" + clipID + ")\"" + tr;
            }
            sb.write(tr);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void generateShape(Shape shape, Writer sb, Graphics2D g) {
        int colTextHeight;
        Color bgcol = shape.bgCol;
        Color fgcol = shape.fgCol;
        Color bcol = shape.fgCol;
        float bgopacity = (float)bgcol.getAlpha() / 255.0f;
        float fgopacity = (float)fgcol.getAlpha() / 255.0f;
        int borderWidth = 1;
        Rectangle bounds = null;
        bounds = shape.bounds;
        int titlePosition = 20;
        int yCursor = 0;
        int xCursor = 0;
        int tsize = 10;
        int csize = 10;
        boolean lineWidt = true;
        boolean textWidth = true;
        int width = bounds.width;
        int height = bounds.height;
        Object longName = ALLOW_NULL;
        longName = shape.schema != null ? shape.schema + "." + shape.name : shape.name;
        if (longName == null) {
            longName = ALLOW_NULL;
        }
        if (shape.vnum > 0) {
            longName = (String)longName + ":" + shape.vnum;
        }
        String cid = DiagramToSVG.getClipPathID(shape);
        DiagramToSVG.addShape(bgcol, bcol, bounds, sb, cid, bgopacity, fgopacity);
        if (SHAPE_TYPE_NOTE.equalsIgnoreCase(shape.type)) {
            DiagramToSVG.addNote(fgcol, width - 1, height - 1, sb);
        } else if (!SHAPE_TYPE_VIEW.equalsIgnoreCase(shape.type)) {
            DiagramToSVG.addRect(fgcol, width, height, sb);
        } else {
            DiagramToSVG.addRect(fgcol, width, height, 20, 20, sb);
        }
        if (shape.type == SHAPE_TYPE_NOTE) {
            String lt;
            String text;
            Color tcolor = shape.textColor;
            if (tcolor == null) {
                tcolor = Color.BLACK;
            }
            if ((text = shape.text).indexOf(lt = "\r\n") == -1 && text.indexOf(lt = System.getProperty("line.separator")) == -1) {
                lt = "\n";
            }
            xCursor = 1;
            float fsize = shape.textFontSize;
            Font titleFont = DIALOG_FONT.deriveFont(fsize);
            FontMetrics fm = g.getFontMetrics(titleFont);
            colTextHeight = fm.getHeight();
            yCursor = (int)(fsize + 2.0f);
            String[] splitText = DiagramToSVG.wrapText(text, DiagramToSVG.getMaxChars(text, fm, width - 6 - 5));
            for (int t = 0; t < splitText.length; ++t) {
                String text1 = splitText[t];
                text1 = text1.replaceAll(lt + lt, lt + " " + lt);
                String[] wrt = text1.split(lt);
                for (int k = 0; k < wrt.length; ++k) {
                    DiagramToSVG.addText(wrt[k], xCursor, yCursor, tcolor, sb, titleFont);
                    yCursor += colTextHeight;
                }
            }
        }
        if (shape.type != SHAPE_TYPE_NOTE) {
            Font titleFont = DIALOG_FONT;
            Font keyFont = DIALOG_FONT;
            FontMetrics fm = g.getFontMetrics(titleFont);
            colTextHeight = fm.getHeight();
            int classTypePos = yCursor = Math.max(colTextHeight, titleFont.getSize());
            xCursor = (width - fm.stringWidth((String)longName)) / 2;
            if (xCursor < titlePosition) {
                xCursor = titlePosition;
            }
            Color tcolor = Color.black;
            String[] wrappedTitle = DiagramToSVG.wrapText((String)longName, DiagramToSVG.getMaxChars((String)longName, fm, width - titlePosition - 5));
            for (int t = 0; t < wrappedTitle.length; ++t) {
                String text = wrappedTitle[t];
                DiagramToSVG.addText(text, xCursor, yCursor, tcolor, sb, titleFont);
                g.drawString(text, xCursor, yCursor);
                yCursor += colTextHeight;
            }
            yCursor -= colTextHeight;
            DiagramToSVG.addLine(0, yCursor += 3 + borderWidth, width - 2, yCursor, fgcol, sb);
        }
        try {
            sb.write("\n</g>");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void addLineBegin(List points, Color col, int width, Writer sb) {
        DiagramToSVG.addLineBegin(points, col, width, sb, true);
    }

    private static void addLineBegin(List points, Color col, int width, Writer sb, boolean fil) {
        DiagramToSVG.addLineBegin(points, col, width, sb, fil, true, 2);
    }

    private static void addLineBegin(List points, Color col, int width, Writer sb, boolean fil, boolean transferable, int endType) {
        float opacity = (float)col.getAlpha() / 255.0f;
        Point2D src = (Point2D)points.get(1);
        Point2D dst = (Point2D)points.get(0);
        String path = DiagramToSVG.createEndPath(6, endType, src, dst, transferable);
        String cols = DiagramToSVG.getColor(col);
        String out = fil ? "\n<polygon stroke=" + cols + " stroke-dasharray=\"none\" points=\"" + path + "\" fill=" + cols + " stroke-width=\"" + width + "\" stroke-opacity=\"" + opacity + "\"  />" : "\n<polygon stroke=" + cols + " stroke-dasharray=\"none\" points=\"" + path + "\" fill=\"none\" stroke-width=\"" + width + "\" stroke-opacity=\"" + opacity + "\"  />";
        try {
            sb.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void addLineEnd(List points, Color col, int width, Writer sb, int type, boolean transferable, boolean optional, Point2D src, Point2D dst) {
        float opacity = (float)col.getAlpha() / 255.0f;
        if (type == 14 || type == 2) {
            String path = DiagramToSVG.createEndPath(8, 2, src, dst, transferable);
            String cols = DiagramToSVG.getColor(col);
            Object out = ALLOW_NULL;
            out = optional ? "\n<polygon stroke-dasharray=\"none\" points=\"" + path + "\" stroke=" + cols + " fill=\"white\" stroke-width=\"" + width + "\" stroke-opacity=\"" + opacity + "\"  />" : "\n<polygon stroke-dasharray=\"none\" points=\"" + path + "\" stroke=" + cols + " fill=" + cols + " stroke-width=\"" + width + "\" stroke-opacity=\"" + opacity + "\"  />";
            if (type == 14 && !(path = DiagramToSVG.getIdentityLinedPath(6, type, src, dst, transferable)).isEmpty()) {
                out = (String)out + "\n<path stroke-dasharray=\"none\" d=\"" + path + "\" fill=\"white\" stroke-width=\"" + width + "\" stroke-opacity=\"" + opacity + "\" stroke=" + cols + " />";
            }
            try {
                sb.write((String)out);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (type == 17 || type == 7 || type == 8 || type == 21 || type == 20 || type == 16 || type == 18 || type == 19 || type == 5 || type == 15) {
            String rest;
            int size = 6;
            String path = DiagramToSVG.createEndPath(size, type, src, dst, transferable);
            String[] parts = path.split("---");
            path = parts[0];
            String cols = DiagramToSVG.getColor(col);
            Object out = ALLOW_NULL;
            if (!path.isEmpty()) {
                out = "\n<path stroke-dasharray=\"none\" d=\"" + path + "\" fill=\"white\" stroke-width=\"" + width + "\" stroke-opacity=\"" + opacity + "\" stroke=" + cols + " />";
            }
            if (parts.length > 1 && !(rest = parts[1]).isEmpty()) {
                if (type == 20) {
                    out = (String)out + "\n<circle " + rest + " fill=\"none\" stroke-width=\"" + width + "\" stroke-opacity=\"" + opacity + "\" stroke=" + cols + " />";
                }
                if (type == 5 || type == 18 || type == 19 || type == 15) {
                    out = optional ? (String)out + "\n<circle " + rest + " fill=\"white\" stroke-width=\"" + width + "\" stroke-opacity=\"" + opacity + "\" stroke=" + cols + " />" : (String)out + "\n<circle " + rest + " fill=" + cols + " stroke-width=\"" + width + "\" stroke-opacity=\"" + opacity + "\" stroke=" + cols + " />";
                }
            }
            try {
                sb.write((String)out);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void addCircle(Color col, int width, Writer sb, int type, boolean fil, String cx, String cy, int size) {
        if (type == 5) {
            String cols = DiagramToSVG.getColor(col);
            String out = fil ? "\n<circle stroke-dasharray=\"none\" cx=\"" + cx + "\" cy=\"" + cy + "\" stroke=" + cols + " r=\"" + size + "\" fill=" + cols + " stroke-width=\"" + width + "\" />" : "\n<circle stroke-dasharray=\"none\" cx=\"" + cx + "\" cy=\"" + cy + "\" stroke=" + cols + " r=\"" + size + "\" fill=\"none\" stroke-width=\"" + width + "\" />";
            try {
                sb.write(out);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void addPolygon(Color col, int[] xPts, int[] yPts, int width, Writer sb, boolean fil) {
        String cols = DiagramToSVG.getColor(col);
        Object points = ALLOW_NULL;
        for (int i = 0; i < xPts.length; ++i) {
            points = i == 0 ? xPts[i] + "," + yPts[i] : (String)points + " " + xPts[i] + "," + yPts[i];
        }
        String out = fil ? "\n<polygon points=\"" + (String)points + "\" stroke-dasharray=\"none\" stroke=" + cols + " fill=" + cols + " stroke-width=\"" + width + "\" />" : "\n<polygon points=\"" + (String)points + "\" stroke-dasharray=\"none\" stroke=" + cols + "  fill=\"none\" stroke-width=\"" + width + "\" />";
        try {
            sb.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void addRectangle(Color col, Color filColor, int x, int y, int lineWidth, int width, int height, Writer sb) {
        String out;
        if (filColor != null) {
            String fcols = DiagramToSVG.getColor(filColor);
            if (col != null) {
                String cols = DiagramToSVG.getColor(col);
                out = "\n<rect x=\"" + x + "\" y=\"" + y + "\" width=\"" + width + "\" height=\"" + height + "\" stroke-dasharray=\"none\" stroke=" + cols + " fill=" + fcols + " stroke-width=\"" + lineWidth + "\" />";
            } else {
                out = "\n<rect x=\"" + x + "\" y=\"" + y + "\" width=\"" + width + "\" height=\"" + height + "\" stroke-dasharray=\"none\" stroke=\"none\" fill=" + fcols + " stroke-width=\"" + lineWidth + "\" />";
            }
        } else {
            String cols = DiagramToSVG.getColor(col);
            out = "\n<rect x=\"" + x + "\" y=\"" + y + "\" width=\"" + width + "\" height=\"" + height + "\" stroke-dasharray=\"none\" stroke=" + cols + "  fill=\"none\" stroke-width=\"" + lineWidth + "\" />";
        }
        try {
            sb.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String getIdentityLinedPath(int size, int style, Point2D srci, Point2D dsti, boolean transferable) {
        Object res = ALLOW_NULL;
        Point src = new Point((int)srci.getX(), (int)srci.getY());
        Point dst = new Point((int)dsti.getX(), (int)dsti.getY());
        if (((Point2D)src).getX() == ((Point2D)dst).getX() - 1.0 || ((Point2D)src).getX() == ((Point2D)dst).getX() + 1.0) {
            ((Point2D)dst).setLocation(((Point2D)src).getX(), ((Point2D)dst).getY());
        }
        if (((Point2D)src).getY() == ((Point2D)dst).getY() - 1.0 || ((Point2D)src).getY() == ((Point2D)dst).getY() + 1.0) {
            ((Point2D)dst).setLocation(((Point2D)dst).getX(), ((Point2D)src).getY());
        }
        int d = (int)Math.max(1.0, dst.distance(src));
        int ax = (int)(-((double)size * (((Point2D)dst).getX() - ((Point2D)src).getX()) / (double)d));
        int ay = (int)(-((double)size * (((Point2D)dst).getY() - ((Point2D)src).getY()) / (double)d));
        float offset = 2.1f;
        if (style == 17) {
            res = (String)res + " M" + (((Point2D)dst).getX() + (double)((float)ax * offset) + (double)ay) + " " + (((Point2D)dst).getY() + (double)((float)ay * offset) - (double)ax);
            res = (String)res + " L" + (((Point2D)dst).getX() + (double)((float)ax * offset) - (double)ay) + " " + (((Point2D)dst).getY() + (double)((float)ay * offset) + (double)ax);
        } else if (style == 14) {
            offset = 1.9f;
            res = (String)res + " M" + (((Point2D)dst).getX() + (double)((float)ax * offset) + (double)ay) + " " + (((Point2D)dst).getY() + (double)((float)ay * offset) - (double)ax);
            res = (String)res + " L" + (((Point2D)dst).getX() + (double)((float)ax * offset) - (double)ay) + " " + (((Point2D)dst).getY() + (double)((float)ay * offset) + (double)ax);
        }
        return res;
    }

    private static String createEndPath(int size, int style, Point2D srci, Point2D dsti, boolean transferable) {
        Object res = ALLOW_NULL;
        Point src = new Point((int)srci.getX(), (int)srci.getY());
        Point dst = new Point((int)dsti.getX(), (int)dsti.getY());
        if (((Point2D)src).getX() == ((Point2D)dst).getX() - 1.0 || ((Point2D)src).getX() == ((Point2D)dst).getX() + 1.0) {
            ((Point2D)dst).setLocation(((Point2D)src).getX(), ((Point2D)dst).getY());
        }
        if (((Point2D)src).getY() == ((Point2D)dst).getY() - 1.0 || ((Point2D)src).getY() == ((Point2D)dst).getY() + 1.0) {
            ((Point2D)dst).setLocation(((Point2D)dst).getX(), ((Point2D)src).getY());
        }
        int d = (int)Math.max(1.0, dst.distance(src));
        int ax = (int)(-((double)size * (((Point2D)dst).getX() - ((Point2D)src).getX()) / (double)d));
        int ay = (int)(-((double)size * (((Point2D)dst).getY() - ((Point2D)src).getY()) / (double)d));
        if (style == 2 || style == 1) {
            res = (int)((Point2D)dst).getX() + " " + (int)((Point2D)dst).getY();
            res = (String)res + " " + (int)(((Point2D)dst).getX() + (double)ax + (double)(ay / 2)) + " " + (int)(((Point2D)dst).getY() + (double)ay - (double)(ax / 2));
            Point2D last = (Point2D)dst.clone();
            ((Point2D)dst).setLocation((int)(((Point2D)dst).getX() + (double)ax), (int)(((Point2D)dst).getY() + (double)ay));
            res = (String)res + " " + (int)(last.getX() + (double)ax - (double)(ay / 2)) + " " + (int)(last.getY() + (double)ay + (double)(ax / 2));
        } else if (style == 14) {
            GeneralPath path = new GeneralPath(1, 4);
            res = "M" + (float)(((Point2D)dst).getX() + (double)ax * 1.5 + (double)(ay / 2)) + " " + (float)(((Point2D)dst).getY() + (double)ay * 1.5 - (double)(ax / 2));
            path.moveTo((float)(((Point2D)dst).getX() + (double)ax * 1.5 + (double)(ay / 2)), (float)(((Point2D)dst).getY() + (double)ay * 1.5 - (double)(ax / 2)));
            path.lineTo((float)(((Point2D)dst).getX() + (double)ax * 1.5 - (double)(ay / 2)), (float)(((Point2D)dst).getY() + (double)ay * 1.5 + (double)(ax / 2)));
            Polygon poly = new Polygon();
            poly.addPoint((int)((Point2D)dst).getX(), (int)((Point2D)dst).getY());
            poly.addPoint((int)(((Point2D)dst).getX() + (double)ax + (double)(ay / 2)), (int)(((Point2D)dst).getY() + (double)ay - (double)(ax / 2)));
            Point2D last = (Point2D)dst.clone();
            ((Point2D)dst).setLocation((int)(((Point2D)dst).getX() + (double)ax), (int)(((Point2D)dst).getY() + (double)ay));
            poly.addPoint((int)(last.getX() + (double)ax - (double)(ay / 2)), (int)(last.getY() + (double)ay + (double)(ax / 2)));
            path.append(poly, false);
        } else if (style == 16 || style == 17) {
            res = "M" + (((Point2D)dst).getX() + (double)ay) + " " + (((Point2D)dst).getY() - (double)ax);
            res = (String)res + " L" + (((Point2D)dst).getX() + (double)(ax * 2)) + " " + (((Point2D)dst).getY() + (double)(ay * 2));
            res = (String)res + " L" + (((Point2D)dst).getX() - (double)ay) + " " + (((Point2D)dst).getY() + (double)ax);
            float offset = 2.1f;
            if (style == 17) {
                res = (String)res + " M" + (((Point2D)dst).getX() + (double)((float)ax * offset) + (double)ay) + " " + (((Point2D)dst).getY() + (double)((float)ay * offset) - (double)ax);
                res = (String)res + " L" + (((Point2D)dst).getX() + (double)((float)ax * offset) - (double)ay) + " " + (((Point2D)dst).getY() + (double)((float)ay * offset) + (double)ax);
            }
            if (!transferable) {
                offset = 3.0f;
                res = (String)res + " M" + (((Point2D)dst).getX() + (double)((float)ax * offset)) + " " + ((Point2D)dst).getY();
                res = (String)res + " L" + (((Point2D)dst).getX() + (double)((float)ax * offset)) + " " + (((Point2D)dst).getY() + (double)((float)ay * offset));
                ((Point2D)dst).setLocation(((Point2D)dst).getX() + (double)((float)ax * offset), ((Point2D)dst).getY() + (double)((float)ay * offset));
                float xs = (float)((Point2D)dst).getX();
                float ys = (float)((Point2D)dst).getY();
                res = (String)res + " M" + xs + " " + ys;
                res = (String)res + " L" + (((Point2D)dst).getX() + (double)ax + (double)ay / 1.5) + " " + (((Point2D)dst).getY() + (double)ay - (double)ax / 1.5);
                Point2D last = (Point2D)dst.clone();
                ((Point2D)dst).setLocation(((Point2D)dst).getX() + (double)(ax * 2), ((Point2D)dst).getY() + (double)(ay * 2));
                res = (String)res + " L" + ((Point2D)dst).getX() + " " + ((Point2D)dst).getY();
                res = (String)res + " L" + (last.getX() + (double)ax - (double)ay / 1.5) + " " + (last.getY() + (double)ay + (double)ax / 1.5);
                res = (String)res + " L" + xs + " " + ys;
            }
        } else if (style == 21) {
            res = " M" + (((Point2D)dst).getX() + (double)ay) + " " + (((Point2D)dst).getY() - (double)ax);
            res = (String)res + " L" + (((Point2D)dst).getX() + (double)(ax * 2)) + " " + (((Point2D)dst).getY() + (double)(ay * 2));
            res = (String)res + " L" + (((Point2D)dst).getX() - (double)ay) + " " + (((Point2D)dst).getY() + (double)ax);
            res = (String)res + " M" + (((Point2D)dst).getX() + (double)ax * 2.5 + (double)ay / 1.5) + " " + (((Point2D)dst).getY() + (double)ay * 2.5 - (double)ax / 1.5);
            res = (String)res + " L" + (((Point2D)dst).getX() + (double)ax * 3.5 - (double)ay / 1.5) + " " + (((Point2D)dst).getY() + (double)ay * 3.5 + (double)ax / 1.5);
            res = (String)res + " M" + (((Point2D)dst).getX() + (double)ax * 3.5 + (double)ay / 1.5) + " " + (((Point2D)dst).getY() + (double)ay * 3.5 - (double)ax / 1.5);
            res = (String)res + " L" + (((Point2D)dst).getX() + (double)ax * 2.5 - (double)ay / 1.5) + " " + (((Point2D)dst).getY() + (double)ay * 2.5 + (double)ax / 1.5);
            float offset = 2.1f;
            if (style == 17) {
                res = (String)res + " M" + (((Point2D)dst).getX() + (double)((float)ax * offset) + (double)ay) + " " + (((Point2D)dst).getY() + (double)((float)ay * offset) - (double)ax);
                res = (String)res + " L" + (((Point2D)dst).getX() + (double)((float)ax * offset) - (double)ay) + " " + (((Point2D)dst).getY() + (double)((float)ay * offset) + (double)ax);
            }
            if (!transferable) {
                offset = 3.0f;
                res = (String)res + " M" + (((Point2D)dst).getX() + (double)((float)ax * offset)) + " " + ((Point2D)dst).getY();
                res = (String)res + " L" + (((Point2D)dst).getX() + (double)((float)ax * offset)) + " " + (((Point2D)dst).getY() + (double)((float)ay * offset));
                ((Point2D)dst).setLocation(((Point2D)dst).getX() + (double)((float)ax * offset), ((Point2D)dst).getY() + (double)((float)ay * offset));
                float xs = (float)((Point2D)dst).getX();
                float ys = (float)((Point2D)dst).getY();
                res = (String)res + " M" + xs + " " + ys;
                res = (String)res + " L" + (((Point2D)dst).getX() + (double)ax + (double)ay / 1.5) + " " + (((Point2D)dst).getY() + (double)ay - (double)ax / 1.5);
                Point2D last = (Point2D)dst.clone();
                ((Point2D)dst).setLocation(((Point2D)dst).getX() + (double)(ax * 2), ((Point2D)dst).getY() + (double)(ay * 2));
                res = (String)res + " L" + ((Point2D)dst).getX() + " " + ((Point2D)dst).getY();
                res = (String)res + " L" + (last.getX() + (double)ax - (double)ay / 1.5) + " " + (last.getY() + (double)ay + (double)ax / 1.5);
                res = (String)res + " L" + xs + " " + ys;
            }
        } else if (style == 20 || style == 19) {
            res = " M" + (((Point2D)dst).getX() + (double)ay) + " " + (((Point2D)dst).getY() - (double)ax);
            res = (String)res + " L" + (((Point2D)dst).getX() + (double)(ax * 2)) + " " + (((Point2D)dst).getY() + (double)(ay * 2));
            res = (String)res + " L" + (((Point2D)dst).getX() - (double)ay) + " " + (((Point2D)dst).getY() + (double)ax);
            float wh = (float)((double)size * 0.9);
            res = (String)res + "--- cx=\"" + (((Point2D)dst).getX() + (double)ax * 3.5) + "\" cy=\"" + (((Point2D)dst).getY() + (double)ay * 3.5) + "\" r=\"" + wh + "\"";
        } else if (style == 5) {
            float wh = (float)((double)size * 0.7);
            res = (String)res + "--- cx=\"" + (((Point2D)dst).getX() + (double)(ax / 2)) + "\" cy=\"" + (((Point2D)dst).getY() + (double)(ay / 2)) + "\" r=\"" + wh + "\"";
        } else if (style == 7 || style == 8 || style == 0 || style == 18) {
            if (style != 0) {
                res = "M" + (((Point2D)dst).getX() + (double)ax + (double)ay) + " " + (((Point2D)dst).getY() + (double)ay - (double)ax);
                res = (String)res + " L" + (((Point2D)dst).getX() + (double)ax - (double)ay) + " " + (((Point2D)dst).getY() + (double)ay + (double)ax);
            }
            float offset = 2.1f;
            if (style == 18) {
                float wh = (float)((double)size * 0.9);
                res = (String)res + "--- cx=\"" + (((Point2D)dst).getX() + (double)((float)ax * offset)) + "\" cy=\"" + (((Point2D)dst).getY() + (double)((float)ay * offset)) + "\" r=\"" + wh + "\"";
            }
            offset = 1.9f;
            if (style == 8) {
                res = (String)res + " M" + (((Point2D)dst).getX() + (double)((float)ax * offset) + (double)ay) + " " + (((Point2D)dst).getY() + (double)((float)ay * offset) - (double)ax);
                res = (String)res + " L" + (((Point2D)dst).getX() + (double)((float)ax * offset) - (double)ay) + " " + (((Point2D)dst).getY() + (double)((float)ay * offset) + (double)ax);
            }
        } else if (style == 15) {
            float offset = 1.9f;
            res = (String)res + " M" + (((Point2D)dst).getX() + (double)((float)ax * offset) + (double)ay / 1.5) + " " + (((Point2D)dst).getY() + (double)((float)ay * offset) - (double)ax / 1.5);
            res = (String)res + " L" + (((Point2D)dst).getX() + (double)((float)ax * offset) - (double)ay / 1.5) + " " + (((Point2D)dst).getY() + (double)((float)ay * offset) + (double)ax / 1.5);
            float wh = (float)((double)size * 0.7);
            res = (String)res + "--- cx=\"" + (((Point2D)dst).getX() + (double)(ax / 2)) + "\" cy=\"" + (((Point2D)dst).getY() + (double)(ay / 2)) + "\" r=\"" + wh + "\"";
        }
        return res;
    }

    private int getPahType(int style) {
        return 1;
    }

    private static int getLineEndType(FKIndexAssociation fk) {
        boolean isOneToOneMandatory = fk.isOneToOne();
        int lend = 2;
        lend = isOneToOneMandatory ? ("CASCADE".equalsIgnoreCase(fk.getDeleteRule()) ? 22 : ("RESTRICT".equalsIgnoreCase(fk.getDeleteRule()) ? 8 : ("SET NULL".equalsIgnoreCase(fk.getDeleteRule()) ? 23 : 8))) : ("CASCADE".equalsIgnoreCase(fk.getDeleteRule()) ? 21 : ("RESTRICT".equalsIgnoreCase(fk.getDeleteRule()) ? 17 : ("SET NULL".equalsIgnoreCase(fk.getDeleteRule()) ? 20 : 17)));
        return lend;
    }

    private static int getLineEndType(Relation fk) {
        boolean isOneToOneMandatory = fk.isOneToOne();
        int lend = 2;
        lend = isOneToOneMandatory ? ("CASCADE".equalsIgnoreCase(fk.getDeleteRule()) ? 22 : ("RESTRICT".equalsIgnoreCase(fk.getDeleteRule()) ? 8 : ("SET NULL".equalsIgnoreCase(fk.getDeleteRule()) ? 23 : 8))) : ("CASCADE".equalsIgnoreCase(fk.getDeleteRule()) ? 21 : ("RESTRICT".equalsIgnoreCase(fk.getDeleteRule()) ? 17 : ("SET NULL".equalsIgnoreCase(fk.getDeleteRule()) ? 20 : 17)));
        return lend;
    }

    private static void addPath(List points, boolean dashed, Color col, int width, Writer sb) {
        DiagramToSVG.addPath(points, dashed, col, width, sb, "8,8");
    }

    private static void addPath(List points, boolean dashed, Color col, int width, Writer sb, String dashArray) {
        String d = null;
        float opacity = (float)col.getAlpha() / 255.0f;
        for (int i = 0; i < points.size(); ++i) {
            Point2D p = (Point2D)points.get(i);
            d = i == 0 ? "M" + (int)p.getX() + " " + (int)p.getY() : d + " L" + (int)p.getX() + " " + (int)p.getY();
        }
        Object dash = ALLOW_NULL;
        if (dashed) {
            dash = " stroke-dasharray=\"" + dashArray + "\"";
        }
        dash = (String)dash + " stroke-width=\"" + width + "\"";
        String scol = DiagramToSVG.getColor(col);
        String path = "\n<path stroke=" + scol + " fill=\"none\" stroke-opacity=\"" + opacity + "\" " + (String)dash + " d=\"" + d + "\" />";
        try {
            sb.write(path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void addPath(List points, boolean dashed, Color col, boolean fill, int width, Writer sb) {
        DiagramToSVG.addPath(points, dashed, col, fill, width, sb, "8,8");
    }

    private static void addPath(List points, boolean dashed, Color col, boolean fill, int width, Writer sb, String dashArray) {
        String d = null;
        for (int i = 0; i < points.size(); ++i) {
            Point2D p = (Point2D)points.get(i);
            d = i == 0 ? "M" + (int)p.getX() + " " + (int)p.getY() : d + " L" + (int)p.getX() + " " + (int)p.getY();
        }
        Object dash = ALLOW_NULL;
        if (dashed) {
            dash = " stroke-dasharray=\"" + dashArray + "\"";
        }
        dash = (String)dash + " stroke-width=\"" + width + "\"";
        String scol = DiagramToSVG.getColor(col);
        Object path = ALLOW_NULL;
        path = fill ? "\n<path stroke=" + scol + (String)dash + " d=\"" + d + "\" />" : "\n<path stroke=" + scol + " fill=\"none\" " + (String)dash + " d=\"" + d + "\" />";
        try {
            sb.write((String)path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String getColor(Color bgcol) {
        String col = "\"rgb(" + bgcol.getRed() + "," + bgcol.getGreen() + "," + bgcol.getBlue() + ")\"";
        return col;
    }

    private static void addSVGstartForLine(Writer sb) {
        try {
            sb.write("\n<g stroke-linecap=\"butt\" >");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void addSVGElementCloseTag(Writer sb) {
        try {
            sb.write("\n</g>");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void addSVGOpenTag(Writer sb, int width, int height) {
        try {
            sb.write("\n<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" version=\"1.1\"  width=\"" + width + "\" height=\"" + height + "\">");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void addSVGAndSymbolOpenTags(String id, int width, int height, Writer sb) {
        try {
            sb.write("\n<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" version=\"1.1\" width=\"0\" height=\"0\">");
            sb.write("\n<symbol id=\"" + id + "\" viewBox=\"0 0 " + width + " " + height + "\">");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void addSVGOpenTags(String id, int width, int height, Writer sb) {
        try {
            sb.write("\n<svg id=\"" + id + "\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" version=\"1.1\" width=\"" + width + "\" height=\"" + height + "\">");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void addSVGCloseTag(Writer sb) {
        try {
            sb.write("\n</svg>");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void addSymbolCloseTag(Writer sb) {
        try {
            sb.write("\n</symbol>");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void addDefs(Writer sb, DesignPartView dpv, String id_suffix) {
        try {
            sb.write("\n<defs id=\"dmw_defs\" >");
            sb.write("\n" + FK_SYM_SVG);
            sb.write("\n" + PK_SYM_SVG);
            sb.write("\n" + UK_SYM_SVG);
            sb.write("\n" + LINK_SYM_SVG);
            DiagramToSVG.addClipPathDefs(sb, dpv, id_suffix);
            sb.write("\n</defs>");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void addClipPathDefs(Writer sb, DiagramThumbnailModel dm) {
        try {
            for (Shape tv : dm.shapes) {
                Rectangle r = tv.bounds;
                if (r == null) continue;
                String id = DiagramToSVG.getClipPathID(tv);
                sb.write("\n<clipPath clipPathUnits=\"userSpaceOnUse\" id=\"" + id + "\">");
                sb.write("\n<rect x=\"0\" y=\"0\" width=\"" + r.width + "\" height=\"" + r.height + "\" />");
                sb.write("\n</clipPath>");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void addThumbnailDefs(Writer sb, DiagramThumbnailModel dm) {
        try {
            sb.write("\n<defs id=\"dmw_defs\" >");
            DiagramToSVG.addClipPathDefs(sb, dm);
            sb.write("\n</defs>");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void addClipPathDefs(Writer sb, DesignPartView dpv, String id_suffix) {
        try {
            for (TopView tv : dpv.getTVShapes()) {
                Rectangle bounds = null;
                bounds = tv.getCellView() != null ? tv.getCellView().getBounds().getBounds() : tv.getBounds();
                String id = DiagramToSVG.getClipPathID(tv, id_suffix);
                sb.write("\n<clipPath clipPathUnits=\"userSpaceOnUse\" id=\"" + id + "\">");
                sb.write("\n<rect x=\"0\" y=\"0\" width=\"" + bounds.width + "\" height=\"" + bounds.height + "\" />");
                sb.write("\n</clipPath>");
            }
            if (dpv instanceof DPVLogical && dpv.showRelAttributes()) {
                for (TVConnector tvc : dpv.getTVConnectors()) {
                    TopView tv;
                    Label label = tvc.getCenterLabel();
                    if (label == null || (tv = label.getFirstViewForDPV(dpv)) == null) continue;
                    Rectangle bounds = null;
                    bounds = tv.getCellView() != null ? tv.getCellView().getBounds().getBounds() : tvc.getLabelBoundsFor(1);
                    String id = DiagramToSVG.getClipPathID(tvc, id_suffix) + "_C";
                    sb.write("\n<clipPath clipPathUnits=\"userSpaceOnUse\" id=\"" + id + "\">");
                    sb.write("\n<rect x=\"0\" y=\"0\" width=\"" + bounds.width + "\" height=\"" + bounds.height + "\" />");
                    sb.write("\n</clipPath>");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addUseOfDef(String id, int x, int y, int width, int height, Writer sb, float lineOpacity) {
        String use = "\n<use xlink:href=\"#" + id + "\" x=\"" + x + "\" y=\"" + y + "\" width=\"" + width + "\" height=\"" + height + "\" fill-opacity=\"" + lineOpacity + "\"/>";
        try {
            sb.write(use);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void addUseOfDef(String id, int x, int y, int width, int height, Writer sb) {
        DiagramToSVG.addUseOfDef(id, x, y, width, height, sb, OPACITY_ICON);
    }

    public static void initNumIDs(DesignPart dp) {
        int counter = 1;
        for (Object obj : dp.getAllTopLevelObjects()) {
            if (!(obj instanceof ModelIDObject)) continue;
            ModelIDObject next = (ModelIDObject)obj;
            next.setNumID(counter);
            ++counter;
        }
        List<DesignPartView> diagrams = dp.getAllSubviews();
        diagrams.add(dp.getMainView());
        for (DesignPartView dpv : diagrams) {
            Legend legend = dpv.getLegend();
            if (legend == null) continue;
            legend.setNumID(counter);
            ++counter;
        }
    }

    static String getClipPathID(Shape tv) {
        String res = "clipPath";
        return res + "_" + tv.clipID;
    }

    static String getClipPathID(TopView tv, String id_suffix) {
        String res = "clipPath";
        int num = tv.getModel().getNumID();
        int vnum = tv.getViewNumber();
        return res + num + "_" + vnum + "_" + id_suffix;
    }

    private static void testThumbnailFromDB(Connection conn, boolean dmwdef) {
        try {
            String id = "27";
            String layout = DiagramToSVG.getLayoutFromDB(conn, id);
            DiagramThumbnailModel dm = DiagramToSVG.createDiagramThumbnailModel(layout);
            Rectangle2D.Double dim = new Rectangle2D.Double(1.0, 1.0, 1.0, 1.0);
            String diagram = DiagramToSVG.getSVGThumbnailFromModel(dm, "diagram_" + id, dim, false);
            FileWriter fw = new FileWriter("d:/dmweb_svg_2721_diagr_thumbn.html");
            fw.write("<html>");
            fw.write(diagram);
            String tn_test = THUMBNAIL_TEST.replaceAll("#diagramxxxid", "#diagram_" + id);
            String width = ALLOW_NULL + (int)(((RectangularShape)dim).getWidth() + 5.0);
            String height = ALLOW_NULL + (int)(((RectangularShape)dim).getHeight() + 5.0);
            tn_test = tn_test.replace("def_width", width);
            tn_test = tn_test.replace("def_height", height);
            fw.write(tn_test);
            fw.write("</html>");
            fw.flush();
            fw.close();
            fw = new FileWriter("d:/dmweb_svg_45_diagr_thumbn_nosymbol.html");
            fw.write("<html>");
            String str = Base64.base64Encode((byte[])diagram.getBytes(StandardCharsets.UTF_8));
            String img = "<img src=\"data:image/svg+xml;charset=utf-8;base64," + str + "\"/>";
            fw.write(img);
            fw.write(tn_test);
            fw.write("</html>");
            fw.flush();
            fw.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getLayoutFromDB(Connection conn, String id) {
        return DiagramToSVG.getDiagramHelperFromDB((Connection)conn, (String)id).layout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DHelper getDiagramHelperFromDB(Connection conn, String id) {
        DHelper dhelper = new DHelper();
        String layout = null;
        String sql = "select name,description, last_update, layout from osddmw_diagrams where id = " + id;
        Statement st = null;
        try {
            st = conn.createStatement();
            ResultSet rs = st.executeQuery(sql);
            if (rs != null && rs.next()) {
                String name;
                dhelper.name = name = rs.getString(1);
                String descr = rs.getString(2);
                String ts = rs.getString(3);
                Clob clob = rs.getClob(4);
                dhelper.layout = layout = DiagramToSVG.clobToString(clob);
                rs.close();
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return dhelper;
    }

    private static String clobToString(Clob clob) {
        try {
            return clob.getSubString(1L, (int)clob.length());
        }
        catch (SQLException sQLException) {
            return ALLOW_NULL;
        }
    }

    public static void createThumbnailTestfromDB(Connection conn, Writer wr, String id, boolean asSymbol) {
        String layout = DiagramToSVG.getLayoutFromDB(conn, id);
        DiagramToSVG.createThumbnailTest(id, layout, wr, asSymbol, true);
    }

    public static void createThumbnailTest(String id, String layout, Writer wr, boolean asSymbol, boolean dmwdef) {
        try {
            DiagramThumbnailModel dm = DiagramToSVG.createDiagramThumbnailModel(layout);
            Rectangle2D.Double dim = new Rectangle2D.Double(1.0, 1.0, 1.0, 1.0);
            String diagram = DiagramToSVG.getSVGThumbnailFromModel(dm, "diagram_" + id, dim, asSymbol);
            wr.write("<html>");
            wr.write(diagram);
            String tn_test = THUMBNAIL_TEST.replaceAll("#diagramxxxid", "#diagram_" + id);
            String width = ALLOW_NULL + (int)(((RectangularShape)dim).getWidth() + 5.0);
            String height = ALLOW_NULL + (int)(((RectangularShape)dim).getHeight() + 5.0);
            tn_test = tn_test.replace("def_width", width);
            tn_test = tn_test.replace("def_height", height);
            wr.write(tn_test);
            wr.write("</html>");
            wr.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static DiagramThumbnailModel createDiagramThumbnailModel(String layout) {
        DiagramThumbnailModel dm = new DiagramThumbnailModel();
        if (layout != null && !layout.isEmpty()) {
            int d = 5;
            ByteArrayInputStream stream = new ByteArrayInputStream(layout.getBytes(StandardCharsets.UTF_8));
            JsonObject jo = null;
            try {
                jo = Json.createReader((InputStream)stream).readObject();
            }
            catch (Throwable e1) {
                e1.printStackTrace();
            }
            JsonArray ja = jo.getJsonArray("items");
            int size = ja.size();
            if (ja != null) {
                for (int i = 0; i < size; ++i) {
                    double topacity;
                    int tcol;
                    int vnum;
                    JsonNumber jvn;
                    int height;
                    int x;
                    JsonNumber jnum;
                    JsonObject jbounds;
                    Shape tv;
                    String viewID;
                    String schema;
                    String name;
                    JsonObject job = ja.getJsonObject(i);
                    String type = job.getString("type");
                    if ("TABLE".equalsIgnoreCase(type)) {
                        int bcol;
                        JsonNumber jn;
                        name = job.getString("name");
                        schema = job.getString("schema");
                        viewID = job.getString("viewID");
                        tv = null;
                        jbounds = job.getJsonObject("bounds");
                        if (jbounds != null) {
                            jnum = jbounds.getJsonNumber("x");
                            x = jnum.intValue();
                            jnum = jbounds.getJsonNumber("y");
                            int y = jnum.intValue();
                            jnum = jbounds.getJsonNumber("width");
                            int width = jnum.intValue();
                            jnum = jbounds.getJsonNumber("height");
                            height = jnum.intValue();
                            tv = new Shape();
                            tv.name = name;
                            tv.schema = schema;
                            tv.viewID = viewID;
                            tv.bounds = new Rectangle(x + d, y + d, width, height);
                            dm.shapes.add(tv);
                        }
                        if (tv == null) continue;
                        jvn = job.getJsonNumber("viewNum");
                        if (jvn != null && (vnum = jvn.intValue()) > 0) {
                            tv.vnum = vnum;
                        }
                        if ((jn = job.getJsonNumber("bgColor")) != null) {
                            bcol = jn.intValue();
                            tv.bgCol = new Color(bcol);
                        } else {
                            tv.bgCol = Color.yellow;
                        }
                        jn = job.getJsonNumber("fgColor");
                        if (jn != null) {
                            int fcol = jn.intValue();
                            tv.fgCol = new Color(fcol);
                        } else {
                            tv.fgCol = Color.blue;
                        }
                        bcol = job.getJsonNumber("bgColor").intValue();
                        int fcol = job.getJsonNumber("fgColor").intValue();
                        try {
                            double fgopacity;
                            double bgopacity;
                            try {
                                bgopacity = job.getJsonNumber("bgOpacity").doubleValue();
                            }
                            catch (Exception e) {
                                bgopacity = 1.0;
                            }
                            try {
                                fgopacity = job.getJsonNumber("fgOpacity").doubleValue();
                            }
                            catch (Exception e) {
                                fgopacity = 1.0;
                            }
                            int ncolor = ColorUtil.getIntColorWithAlpha(bcol, (int)(bgopacity * 255.0));
                            tv.bgCol = new Color(ncolor, true);
                            ncolor = ColorUtil.getIntColorWithAlpha(fcol, (int)(fgopacity * 255.0));
                            tv.fgCol = new Color(ncolor, true);
                        }
                        catch (Exception e) {
                            tv.bgCol = new Color(bcol);
                            tv.fgCol = new Color(fcol);
                        }
                        continue;
                    }
                    if ("VIEW".equalsIgnoreCase(type)) {
                        name = job.getString("name");
                        schema = job.getString("schema");
                        viewID = job.getString("viewID");
                        tv = null;
                        jbounds = job.getJsonObject("bounds");
                        if (jbounds != null) {
                            jnum = jbounds.getJsonNumber("x");
                            x = jnum.intValue();
                            jnum = jbounds.getJsonNumber("y");
                            int y = jnum.intValue();
                            jnum = jbounds.getJsonNumber("width");
                            int width = jnum.intValue();
                            jnum = jbounds.getJsonNumber("height");
                            height = jnum.intValue();
                            tv = new Shape();
                            tv.name = name;
                            tv.schema = schema;
                            tv.viewID = viewID;
                            tv.type = SHAPE_TYPE_VIEW;
                            tv.bounds = new Rectangle(x + d, y + d, width, height);
                            dm.shapes.add(tv);
                        }
                        if (tv == null) continue;
                        jvn = job.getJsonNumber("viewNum");
                        if (jvn != null && (vnum = jvn.intValue()) > 0) {
                            tv.vnum = vnum;
                        }
                        int bcol = 0;
                        int fcol = 0;
                        JsonNumber jn = job.getJsonNumber("bgColor");
                        if (jn != null) {
                            bcol = jn.intValue();
                            tv.bgCol = new Color(bcol);
                        } else {
                            tv.bgCol = Color.green;
                        }
                        jn = job.getJsonNumber("fgColor");
                        if (jn != null) {
                            fcol = jn.intValue();
                            tv.fgCol = new Color(fcol);
                        } else {
                            tv.fgCol = Color.blue;
                        }
                        try {
                            double fgopacity;
                            double bgopacity;
                            try {
                                bgopacity = job.getJsonNumber("bgOpacity").doubleValue();
                            }
                            catch (Exception e) {
                                bgopacity = 1.0;
                            }
                            try {
                                fgopacity = job.getJsonNumber("fgOpacity").doubleValue();
                            }
                            catch (Exception e) {
                                fgopacity = 1.0;
                            }
                            int ncolor = ColorUtil.getIntColorWithAlpha(bcol, (int)(bgopacity * 255.0));
                            tv.bgCol = new Color(ncolor, true);
                            ncolor = ColorUtil.getIntColorWithAlpha(fcol, (int)(fgopacity * 255.0));
                            tv.fgCol = new Color(ncolor, true);
                        }
                        catch (Exception bgopacity) {}
                        continue;
                    }
                    if ("RELATION".equalsIgnoreCase(type) || "REFERENCE".equalsIgnoreCase(type)) {
                        JsonArray jv;
                        Point2D.Double p;
                        String style22;
                        Line line = new Line();
                        dm.lines.add(line);
                        List<Point2D> points = line.points;
                        String name2 = job.getString("name");
                        if (!"REFERENCE".equalsIgnoreCase(type)) {
                            String sourceID = job.getString("sourceID");
                            String targetID = job.getString("targetID");
                            line.sourceID = sourceID;
                            line.targetID = targetID;
                        }
                        String sourceViewID = job.getString("sourceViewID");
                        String targetViewID = job.getString("targetViewID");
                        line.name = name2;
                        line.sourceViewID = sourceViewID;
                        line.targetViewID = targetViewID;
                        try {
                            double topacity2;
                            tcol = 0;
                            JsonNumber jn1 = job.getJsonNumber("color");
                            if (jn1 != null) {
                                tcol = jn1.intValue();
                                line.fgCol = new Color(tcol);
                            } else {
                                line.fgCol = Color.BLACK;
                            }
                            try {
                                topacity2 = job.getJsonNumber("opacity").doubleValue();
                            }
                            catch (Exception e) {
                                topacity2 = 1.0;
                            }
                            int tcolor = ColorUtil.getIntColorWithAlpha(tcol, (int)(topacity2 * 255.0));
                            line.fgCol = new Color(tcolor, true);
                        }
                        catch (Exception tcol2) {
                            // empty catch block
                        }
                        JsonValue st = (JsonValue)job.get((Object)"style");
                        if (st != null && (style22 = ((JsonString)st).getString()) != null) {
                            line.dashed = "dash".equalsIgnoreCase(style22);
                        }
                        if ("REFERENCE".equalsIgnoreCase(type)) {
                            line.dashed = true;
                            line.dashArray = "2,6";
                        }
                        try {
                            line.width = job.getJsonNumber("width").intValue();
                        }
                        catch (Exception style22) {
                            // empty catch block
                        }
                        JsonObject sp = job.getJsonObject("sourcePort");
                        if (sp != null) {
                            double x2 = sp.getJsonNumber("x").doubleValue();
                            double y = sp.getJsonNumber("y").doubleValue();
                            p = new Point2D.Double(x2 + (double)d, y + (double)d);
                            points.add(p);
                        }
                        if ((jv = job.getJsonArray("vertices")) != null) {
                            for (int k = 0; k < jv.size(); ++k) {
                                JsonObject jp = jv.getJsonObject(k);
                                double x3 = jp.getJsonNumber("x").doubleValue();
                                double y = jp.getJsonNumber("y").doubleValue();
                                p = new Point2D.Double(x3 + (double)d, y + (double)d);
                                points.add(p);
                            }
                        }
                        if ((sp = job.getJsonObject("targetPort")) == null) continue;
                        double x4 = sp.getJsonNumber("x").doubleValue();
                        double y = sp.getJsonNumber("y").doubleValue();
                        p = new Point2D.Double(x4 + (double)d, y + (double)d);
                        points.add(p);
                        continue;
                    }
                    if (!"NOTE".equalsIgnoreCase(type)) continue;
                    Shape tv2 = null;
                    String viewID2 = job.getString("viewID");
                    String text = job.getString("text");
                    JsonNumber fsize = job.getJsonNumber("fontSize");
                    jbounds = job.getJsonObject("bounds");
                    if (jbounds != null) {
                        jnum = jbounds.getJsonNumber("x");
                        x = jnum.intValue();
                        jnum = jbounds.getJsonNumber("y");
                        int y = jnum.intValue();
                        jnum = jbounds.getJsonNumber("width");
                        int width = jnum.intValue();
                        jnum = jbounds.getJsonNumber("height");
                        height = jnum.intValue();
                        tv2 = new Shape();
                        tv2.name = null;
                        tv2.schema = null;
                        tv2.viewID = viewID2;
                        tv2.text = text;
                        if (fsize != null) {
                            tv2.textFontSize = fsize.intValue();
                        }
                        tv2.type = SHAPE_TYPE_NOTE;
                        tv2.bounds = new Rectangle(x + d, y + d, width, height);
                        dm.shapes.add(tv2);
                    }
                    if (tv2 == null) continue;
                    jvn = job.getJsonNumber("viewNum");
                    if (jvn != null && (vnum = jvn.intValue()) > 0) {
                        tv2.vnum = vnum;
                    }
                    tcol = 0;
                    JsonNumber jn1 = job.getJsonNumber("textColor");
                    if (jn1 != null) {
                        tcol = jn1.intValue();
                        tv2.textColor = new Color(tcol);
                    } else {
                        tv2.textColor = Color.BLACK;
                    }
                    try {
                        topacity = job.getJsonNumber("textOpacity").doubleValue();
                    }
                    catch (Exception e) {
                        topacity = 1.0;
                    }
                    int tcolor = ColorUtil.getIntColorWithAlpha(tcol, (int)(topacity * 255.0));
                    tv2.textColor = new Color(tcolor, true);
                    int bcol = 0;
                    int fcol = 0;
                    JsonNumber jn = job.getJsonNumber("bgColor");
                    if (jn != null) {
                        bcol = jn.intValue();
                        tv2.bgCol = new Color(bcol);
                    } else {
                        tv2.bgCol = Color.GRAY;
                    }
                    jn = job.getJsonNumber("fgColor");
                    if (jn != null) {
                        fcol = jn.intValue();
                        tv2.fgCol = new Color(fcol);
                    } else {
                        tv2.fgCol = Color.BLACK;
                    }
                    try {
                        double fgopacity;
                        double bgopacity;
                        try {
                            bgopacity = job.getJsonNumber("bgOpacity").doubleValue();
                        }
                        catch (Exception e) {
                            bgopacity = 1.0;
                        }
                        try {
                            fgopacity = job.getJsonNumber("fgOpacity").doubleValue();
                        }
                        catch (Exception e) {
                            fgopacity = 1.0;
                        }
                        int ncolor = ColorUtil.getIntColorWithAlpha(bcol, (int)(bgopacity * 255.0));
                        tv2.bgCol = new Color(ncolor, true);
                        ncolor = ColorUtil.getIntColorWithAlpha(fcol, (int)(fgopacity * 255.0));
                        tv2.fgCol = new Color(ncolor, true);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return dm;
    }

    public static void main(String[] args) {
        try {
            DriverManager.registerDriver((Driver)new OracleDriver());
            Connection conn = DriverManager.getConnection("jdbc:oracle:thin:@localhost:1521:fdb11r21", "hr", "hr");
            DiagramToSVG.testThumbnailFromDB(conn, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getCompareThumbnail(DPVRelational dpv, int width, int height) {
        String layout = DiagramToSVG.layoutDPV_ToJSON(dpv);
        return DiagramToSVG.getCompareThumbnail(layout, dpv.getDPVId(), width, height, false);
    }

    public static String getCompareThumbnail(String layout, String id, int width, int height, boolean dmwdef) {
        Object res = "<html>";
        try {
            DiagramThumbnailModel dm = DiagramToSVG.createDiagramThumbnailModel(layout);
            Rectangle2D.Double dim = new Rectangle2D.Double(1.0, 1.0, 1.0, 1.0);
            String did = "diagram_" + id;
            String diagram = DiagramToSVG.getSVGThumbnailFromModel(dm, did, dim, true);
            res = (String)res + diagram + "<figure>\n  <div>\n    <svg viewBox=\"0 0 def_width def_height\" width=\"" + width + "\" height=\"" + height + "\">\n      <use xlink:href=\"#" + did + "\"/>\n    </svg>\n  </div>\n</figure>\n<figure>\n";
            res = (String)res + "</html>";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public static String layoutDPV_ToJSON(DPVRelational dpv) {
        StringWriter sb = new StringWriter();
        DiagramToJSON.DPV_ToJSON(dpv, sb);
        String layout = sb.toString();
        return layout;
    }

    private static void getObjectsFomLayout(String layout, List<String> tables, List<String> views, List<String> ext_tables, List<String> fkeys) {
        if (layout != null && !layout.isEmpty()) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            ByteArrayInputStream stream = new ByteArrayInputStream(layout.getBytes(StandardCharsets.UTF_8));
            JsonObject jo = Json.createReader((InputStream)stream).readObject();
            JsonArray ja = jo.getJsonArray("items");
            if (ja != null) {
                for (int i = 0; i < ja.size(); ++i) {
                    String lname;
                    Object lname2;
                    String schema;
                    String name;
                    JsonObject job = ja.getJsonObject(i);
                    String type = job.getString("type");
                    if ("TABLE".equalsIgnoreCase(type)) {
                        name = job.getString("name");
                        schema = job.getString("schema");
                        lname2 = name;
                        if (schema != null) {
                            lname2 = schema + "." + name;
                        }
                        if (map.get(lname2) != null) continue;
                        map.put(lname2, lname2);
                        boolean ext = job.getBoolean("external", false);
                        if (ext) {
                            ext_tables.add(schema + "." + name);
                            continue;
                        }
                        tables.add(schema + "." + name);
                        continue;
                    }
                    if ("VIEW".equalsIgnoreCase(type)) {
                        name = job.getString("name");
                        schema = job.getString("schema");
                        lname2 = name;
                        if (schema != null) {
                            lname2 = schema + "." + name;
                        }
                        if (map.get(lname2) != null) continue;
                        map.put(lname2, lname2);
                        views.add(schema + "." + name);
                        continue;
                    }
                    if (!"RELATION".equalsIgnoreCase(type) || map.get(lname = (name = job.getString("name"))) != null) continue;
                    map.put(lname, lname);
                    fkeys.add(lname);
                }
            }
        }
    }

    public static class ObjectHelper {
        public String type = "table";
        public String schema = "";
        public String name = "";

        public String getLongName() {
            if (this.schema != null && !this.schema.isEmpty()) {
                return this.schema + "." + this.name;
            }
            return this.name;
        }

        public String tosString() {
            return this.getLongName();
        }
    }

    public static class ColorUtil {
        public static int getRed(int color) {
            return (color & 0xFF0000) >>> 16;
        }

        public static int getGreen(int color) {
            return (color & 0xFF00) >>> 8;
        }

        public static int getBlue(int color) {
            return color & 0xFF;
        }

        public static int getAlpha(int color) {
            return (color & 0xFF000000) >>> 24;
        }

        public static int getIntColorNoAlpha(int color) {
            return color & 0xFFFFFF;
        }

        public static int getIntColorWithAlpha(int color, int alpha) {
            int t = alpha << 24;
            return color & 0xFFFFFF | t;
        }

        public static Color getColor(int color, int alpha) {
            return new Color(ColorUtil.getRed(color), ColorUtil.getGreen(color), ColorUtil.getBlue(color), alpha);
        }

        public static String getHexcolor(int color) {
            try {
                String res = Integer.toHexString(color);
                if (res.length() > 6) {
                    return "#" + res.substring(2);
                }
                return "#" + res;
            }
            catch (Exception exception) {
                return "#000000";
            }
        }
    }

    static class DHelper {
        String layout;
        String name;

        DHelper() {
        }
    }

    public static class Line {
        public boolean dashed = false;
        public String dashArray = "8,8";
        public String name;
        public List<Point2D> points = new ArrayList<Point2D>();
        public Color fgCol;
        public String sourceID;
        public String targetID;
        public String sourceViewID;
        public String targetViewID;
        public int width = 1;

        public Rectangle getBounds() {
            if (this.points.size() > 0) {
                Object tmp = null;
                boolean first = true;
                double xmin = 0.0;
                double ymin = 0.0;
                double xmax = 0.0;
                double ymax = 0.0;
                for (Point2D p : this.points) {
                    if (first) {
                        first = false;
                        xmin = xmax = p.getX();
                        ymin = ymax = p.getY();
                        continue;
                    }
                    double x = p.getX();
                    double y = p.getY();
                    if (x < xmin) {
                        xmin = x;
                    } else if (x > xmax) {
                        xmax = x;
                    }
                    if (y < ymin) {
                        ymin = y;
                        continue;
                    }
                    if (!(y > ymax)) continue;
                    ymax = y;
                }
                return new Rectangle((int)xmin, (int)ymin, (int)(xmax - xmin), (int)(ymax - ymin));
            }
            return new Rectangle(1, 1, 1, 1);
        }

        public String getID() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Line)) {
                return false;
            }
            Line l = (Line)obj;
            if (l.width != this.width) {
                return false;
            }
            if (l.fgCol != null && !l.fgCol.equals(this.fgCol)) {
                return false;
            }
            if (l.points.size() != this.points.size()) {
                return false;
            }
            if (l.sourceID != null && !l.sourceID.equalsIgnoreCase(this.sourceID)) {
                return false;
            }
            if (l.targetID != null && !l.targetID.equalsIgnoreCase(this.targetID)) {
                return false;
            }
            if (!l.sourceViewID.equalsIgnoreCase(this.sourceViewID)) {
                return false;
            }
            if (!l.targetViewID.equalsIgnoreCase(this.targetViewID)) {
                return false;
            }
            if (!l.name.equalsIgnoreCase(this.name)) {
                return false;
            }
            for (int i = 0; i < this.points.size(); ++i) {
                Point2D lp;
                Point2D p = this.points.get(i);
                if (p.equals(lp = l.points.get(i))) continue;
                return false;
            }
            return true;
        }
    }

    public static class Shape {
        public String type = SHAPE_TYPE_TABLE;
        public String name;
        public String schema;
        public Rectangle bounds;
        public int vnum;
        public int clipID;
        public Color fgCol;
        public Color bgCol;
        public String viewID;
        public String text;
        public int textFontSize = 12;
        public Color textColor;

        public String getID() {
            if (SHAPE_TYPE_TABLE.equals(this.type) || SHAPE_TYPE_VIEW.equals(this.type)) {
                if (this.schema != null && !this.schema.isEmpty()) {
                    return this.schema + "." + this.name + "." + String.valueOf(this.viewID);
                }
                return this.name + "." + String.valueOf(this.viewID);
            }
            return this.viewID;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Shape)) {
                return false;
            }
            Shape s = (Shape)obj;
            if (!this.type.equals(s.type)) {
                return false;
            }
            if (!s.getID().equalsIgnoreCase(this.getID())) {
                return false;
            }
            if (!s.bounds.equals(this.bounds)) {
                return false;
            }
            if (SHAPE_TYPE_TABLE.equals(this.type) || SHAPE_TYPE_VIEW.equals(this.type)) {
                if (s.fgCol != null && !s.fgCol.equals(this.fgCol)) {
                    return false;
                }
                if (s.bgCol != null && !s.bgCol.equals(this.bgCol)) {
                    return false;
                }
            } else if (SHAPE_TYPE_NOTE.equals(this.type)) {
                if (s.textColor != null && !s.textColor.equals(this.textColor)) {
                    return false;
                }
                if (s.text != null && !s.text.equals(this.text)) {
                    return false;
                }
            }
            return true;
        }
    }

    public static class DiagramThumbnailModel {
        public List<Shape> shapes = new ArrayList<Shape>();
        public List<Line> lines = new ArrayList<Line>();
        public List<DiagramProcessor.JoinsHolder> joins = new ArrayList<DiagramProcessor.JoinsHolder>();

        public boolean equals(Object obj) {
            if (!(obj instanceof DiagramThumbnailModel)) {
                return false;
            }
            DiagramThumbnailModel dm = (DiagramThumbnailModel)obj;
            if (dm.shapes.size() != this.shapes.size()) {
                return false;
            }
            if (dm.lines.size() != this.lines.size()) {
                return false;
            }
            HashMap<String, Shape> map = new HashMap<String, Shape>();
            for (Shape s : this.shapes) {
                map.put(s.getID(), s);
            }
            for (Shape ds : dm.shapes) {
                Shape s = (Shape)map.get(ds.getID());
                if (s == null || !s.equals(ds)) {
                    return false;
                }
                boolean bl = false;
            }
            map.clear();
            HashMap<String, Line> lmap = new HashMap<String, Line>();
            for (Line l : this.lines) {
                lmap.put(l.getID(), l);
            }
            for (Line dl : dm.lines) {
                Line l = (Line)lmap.get(dl.getID());
                if (l != null && l.equals(dl)) continue;
                return false;
            }
            lmap.clear();
            return true;
        }

        public Rectangle2D getBounds() {
            Rectangle tmp;
            Rectangle2D.Double ret = null;
            if (this.shapes.size() > 0) {
                for (Shape shape : this.shapes) {
                    tmp = null;
                    tmp = shape.bounds;
                    if (ret == null) {
                        ret = new Rectangle2D.Double(((RectangularShape)tmp).getX(), ((RectangularShape)tmp).getY(), ((RectangularShape)tmp).getWidth(), ((RectangularShape)tmp).getHeight());
                    }
                    if (tmp == null) continue;
                    Rectangle2D.union(ret, tmp, ret);
                }
            }
            if (this.lines.size() > 0) {
                for (Line line : this.lines) {
                    tmp = null;
                    tmp = line.getBounds();
                    if (ret == null) {
                        ret = new Rectangle2D.Double(((RectangularShape)tmp).getX(), ((RectangularShape)tmp).getY(), ((RectangularShape)tmp).getWidth(), ((RectangularShape)tmp).getHeight());
                    }
                    if (tmp == null) continue;
                    Rectangle2D.union(ret, tmp, ret);
                }
            }
            return ret;
        }

        public void move(int dx, int dy) {
            for (Shape shape : this.shapes) {
                shape.bounds.setLocation(shape.bounds.x + dx, shape.bounds.y + dy);
            }
            for (Line line : this.lines) {
                for (Point2D p : line.points) {
                    p.setLocation(p.getX() + (double)dx, p.getY() + (double)dy);
                }
            }
        }

        public void setClipID() {
            int i = 0;
            for (Shape shape : this.shapes) {
                shape.clipID = ++i;
            }
        }
    }
}

