/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.compare;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.crest.util.compare.CompareMapping;
import oracle.dbtools.crest.util.compare.CompareMappingObject;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class CompareMappingDialog
extends CustomDialog {
    private JDialog dialog;
    private List mappingList;
    private JTable mappingTable;
    private JPanel general;
    private JButton bnOK;
    private JButton bnCancel;
    private Map selectedValuesMap;
    private JButton bnRemoveColumn;
    private JButton bnSelectAll;
    private JButton bnDeselectAll;
    private static final String BTN_REMOVE = Messages.getString("CompareMappingDialog.Remove");
    private Design design;

    public CompareMappingDialog(ApplicationView appView, Design target) {
        super(appView);
        this.design = target;
        this.selectedValuesMap = new TreeMap();
        this.general = new JPanel(new BorderLayout());
        this.general.setPreferredSize(new Dimension(500, 300));
        JPanel pnButtons = new JPanel(new FlowLayout(2));
        this.bnOK = new JButton(this.createOKButton());
        this.bnOK.setMnemonic(79);
        this.bnCancel = new JButton(this.createCancelButton());
        this.bnCancel.setMnemonic(67);
        JButton bnHelp = new JButton(this.getHelpAction());
        bnHelp.setMnemonic(72);
        pnButtons.add(this.bnOK);
        pnButtons.add(this.bnCancel);
        pnButtons.add(bnHelp);
        this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.add((Component)this.general, "Center");
        this.add((Component)pnButtons, "South");
        this.createTable();
        this.add((Component)this.general, "Center");
        this.initTable();
    }

    public JPanel getGeneralPane() {
        return this.general;
    }

    private void createTable() {
        JPanel mappingPanel = new JPanel(new BorderLayout());
        this.mappingList = new ArrayList();
        CompareMappingModel mappingModel = new CompareMappingModel();
        this.mappingTable = new JTable(mappingModel);
        this.mappingTable.setSelectionMode(0);
        JScrollPane scrollpane = new JScrollPane(this.mappingTable);
        JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
        buttonGeneral.setPreferredSize(new Dimension(325, 35));
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.bnRemoveColumn = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
        this.bnRemoveColumn.setToolTipText(BTN_REMOVE);
        this.bnRemoveColumn.addActionListener(new RemoveCompareMappingObject());
        this.bnSelectAll = new JButton(configuration.getIcon("SELECT_ALL", this.getPreferredIconSize()));
        this.bnSelectAll.setToolTipText(Messages.getString("CompareMappingDialog.SelectAll"));
        this.bnSelectAll.addActionListener(new SelectAllCompareMappingObject());
        this.bnDeselectAll = new JButton(configuration.getIcon("DESELECT_ALL", this.getPreferredIconSize()));
        this.bnDeselectAll.setToolTipText(Messages.getString("CompareMappingDialog.DeselectAll"));
        this.bnDeselectAll.addActionListener(new DeselectAllCompareMappingObject());
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.addSeparator();
        toolBar.add(this.bnRemoveColumn);
        toolBar.addSeparator();
        toolBar.add(this.bnSelectAll);
        toolBar.add(this.bnDeselectAll);
        buttonGeneral.add(toolBar);
        mappingPanel.add((Component)buttonGeneral, "North");
        mappingPanel.add((Component)scrollpane, "Center");
        this.general.add(mappingPanel);
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), this.getCaption(), false);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setContentPane(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    public String getCaption() {
        return Messages.getString("CompareMappingDialog.CompareMapping");
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return "COMPARE_MAPPING_DIALOG";
    }

    @Override
    public void show() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    private void initTable() {
        for (CompareMappingObject compObject : this.getDesign().getDesignLevelSettings().getCompareMapping().asList()) {
            CompareMappingObject newCompObj = new CompareMappingObject(compObject.getSourceParentName(), compObject.getSourceObjectName(), compObject.getTargetParentName(), compObject.getTargetObjectName());
            newCompObj.setSelected(compObject.isSelected());
            this.mappingList.add(newCompObj);
            this.addToSelectedValueMap(this.mappingList.size() - 1, newCompObj);
        }
        this.mappingTable.updateUI();
    }

    private void addToSelectedValueMap(int index, CompareMappingObject compObject) {
        String longName = compObject.getTargetParentName() + "." + compObject.getTargetObjectName();
        if (this.selectedValuesMap.containsKey(longName)) {
            ArrayList list = (ArrayList)this.selectedValuesMap.get(longName);
            list.add(new Integer(index));
        } else {
            ArrayList<Integer> list = new ArrayList<Integer>();
            list.add(new Integer(index));
            this.selectedValuesMap.put(longName, list);
        }
    }

    public void setMapping() {
        int icol = this.mappingTable.getEditingColumn();
        int irow = this.mappingTable.getEditingRow();
        if (icol > -1 && irow > -1) {
            this.mappingTable.getCellEditor(irow, icol).stopCellEditing();
        }
        Iterator it = this.mappingList.iterator();
        CompareMapping compareMapping = this.getApplicationView().getCurrentDesign().getDesignLevelSettings().getCompareMapping();
        compareMapping.getCompareMap().clear();
        while (it.hasNext()) {
            CompareMappingObject object = (CompareMappingObject)it.next();
            compareMapping.addCompareMappingObject(object);
        }
    }

    public Action createOKButton() {
        AbstractAction action = new AbstractAction(Messages.getString("CompareMappingDialog.OK")){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompareMappingDialog.this.setMapping();
                CompareMappingDialog.this.close();
            }
        };
        return action;
    }

    public Action createCancelButton() {
        AbstractAction action = new AbstractAction(Messages.getString("CompareMappingDialog.Cancel")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int icol = CompareMappingDialog.this.mappingTable.getEditingColumn();
                int irow = CompareMappingDialog.this.mappingTable.getEditingRow();
                if (icol > -1 && irow > -1) {
                    CompareMappingDialog.this.mappingTable.getCellEditor(irow, icol).cancelCellEditing();
                }
                CompareMappingDialog.this.close();
            }
        };
        return action;
    }

    private int getPreferredIconSize() {
        return 16;
    }

    @Override
    public Design getDesign() {
        if (this.design != null) {
            return this.design;
        }
        return super.getDesign();
    }

    private class RemoveCompareMappingObject
    implements ActionListener {
        private RemoveCompareMappingObject() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = CompareMappingDialog.this.mappingTable.getSelectedRow();
            if (row != -1 && CompareMappingDialog.this.mappingList.size() > 0 && row < CompareMappingDialog.this.mappingList.size()) {
                CompareMappingObject compObject = (CompareMappingObject)CompareMappingDialog.this.mappingList.get(row);
                String longName = (String)CompareMappingDialog.this.mappingTable.getValueAt(row, 2);
                CompareMappingDialog.this.selectedValuesMap.remove(longName);
                CompareMappingDialog.this.mappingList.remove(compObject);
                CompareMappingDialog.this.mappingTable.updateUI();
            }
        }
    }

    private class DeselectAllCompareMappingObject
    implements ActionListener {
        private DeselectAllCompareMappingObject() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (CompareMappingObject compObject : CompareMappingDialog.this.mappingList) {
                compObject.setSelected(false);
            }
            CompareMappingDialog.this.mappingTable.updateUI();
        }
    }

    private class SelectAllCompareMappingObject
    implements ActionListener {
        private SelectAllCompareMappingObject() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Iterator it = CompareMappingDialog.this.selectedValuesMap.keySet().iterator();
            while (it.hasNext()) {
                ArrayList list = (ArrayList)CompareMappingDialog.this.selectedValuesMap.get(it.next());
                if (list.size() <= 0) continue;
                Integer index = (Integer)list.get(0);
                CompareMappingDialog.this.mappingTable.setValueAt(Boolean.TRUE, index, 0);
            }
        }
    }

    public class CompareMappingModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return CompareMappingDialog.this.mappingList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("CompareMappingDialog.Selected");
            }
            if (column == 1) {
                return Messages.getString("CompareMappingDialog.SourceObject");
            }
            if (column == 2) {
                return Messages.getString("CompareMappingDialog.TargetObject");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            CompareMappingObject mappingObject = (CompareMappingObject)CompareMappingDialog.this.mappingList.get(row);
            if (col == 0) {
                return mappingObject.isSelected();
            }
            if (col == 1) {
                return mappingObject.getSourceParentName() + "." + mappingObject.getSourceObjectName();
            }
            if (col == 2) {
                return mappingObject.getTargetParentName() + "." + mappingObject.getTargetObjectName();
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            CompareMappingObject mappingObject = (CompareMappingObject)CompareMappingDialog.this.mappingList.get(row);
            if (col == 0) {
                mappingObject.setSelected((Boolean)aValue);
                if (mappingObject.isSelected()) {
                    String longName = (String)this.getValueAt(row, 2);
                    if (CompareMappingDialog.this.selectedValuesMap.containsKey(longName)) {
                        for (Integer index : (List)CompareMappingDialog.this.selectedValuesMap.get(longName)) {
                            if (row == index) continue;
                            CompareMappingObject object = (CompareMappingObject)CompareMappingDialog.this.mappingList.get(index);
                            object.setSelected(false);
                        }
                    }
                    this.fireTableDataChanged();
                }
            }
        }
    }
}

