/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.compare;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.crest.util.compare.CompareMappingObject;
import oracle.dbtools.crest.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CompareMapping {
    private static final String COMPARE_MAPPING_FILE_NAME = "comparemapping.xml";
    private static final String COMPARE_MAPPING_ELEMENT = "mapping";
    private static final String COMPARE_MAPPING_SOURCE_PARENT = "sourceparent";
    private static final String COMPARE_MAPPING_TARGET_PARENT = "targetparent";
    private static final String COMPARE_MAPPING_SOURCE_OBJECT = "sourceobject";
    private static final String COMPARE_MAPPING_TARGET_OBJECT = "targetobject";
    private static final String COMPARE_MAPPING_SELECTED = "selected";
    private Map<String, CompareMappingObject> compareMapping = new TreeMap<String, CompareMappingObject>();
    private static final Logger LOGGER = new Logger(CompareMapping.class);

    public Map<String, CompareMappingObject> getCompareMap() {
        return this.compareMapping;
    }

    public void addCompareMappingObject(CompareMappingObject object) {
        this.compareMapping.put(object.toString(), object);
    }

    public void clearCompareMappingsList() {
        this.compareMapping.clear();
    }

    public void init() {
        try {
            File file = new File(COMPARE_MAPPING_FILE_NAME);
            if (file.exists()) {
                FileInputStream fis = new FileInputStream(file);
                InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
                InputSource inputSource = new InputSource(isr);
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                Document doc = builder.parse(inputSource);
                NodeList list = doc.getElementsByTagName(COMPARE_MAPPING_ELEMENT);
                int listLength = list.getLength();
                for (int i = 0; i < listLength; ++i) {
                    Element element = (Element)list.item(i);
                    String sourceParent = element.getAttribute(COMPARE_MAPPING_SOURCE_PARENT);
                    String targetParent = element.getAttribute(COMPARE_MAPPING_TARGET_PARENT);
                    String sourceObject = element.getAttribute(COMPARE_MAPPING_SOURCE_OBJECT);
                    String targetObject = element.getAttribute(COMPARE_MAPPING_TARGET_OBJECT);
                    boolean selected = Boolean.valueOf(element.getAttribute(COMPARE_MAPPING_SELECTED));
                    CompareMappingObject compObj = new CompareMappingObject(sourceParent, sourceObject, targetParent, targetObject);
                    compObj.setSelected(selected);
                    this.addCompareMappingObject(compObj);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to initialize Compare Mapping: ", e);
        }
    }

    public List<CompareMappingObject> asList() {
        ArrayList<CompareMappingObject> list = new ArrayList<CompareMappingObject>();
        Iterator<String> it = this.compareMapping.keySet().iterator();
        while (it.hasNext()) {
            list.add(this.compareMapping.get(it.next()));
        }
        return list;
    }
}

