/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class WinRegistry {
    public static final int _HKEY_LOCAL_MACHINE = -2147483646;
    public static final int KEY_READ = 131097;
    private Method openKey = null;
    private Method closeKey = null;
    private Method queryInfoKey = null;
    private Method enumKey = null;
    private Method queryValue = null;

    public WinRegistry() throws Exception {
        this.initMethods();
    }

    public int openKey(int key, String subkey, int security_mask) throws Exception {
        int[] result = (int[])this.openKey.invoke(null, new Integer(key), this.getString(subkey), new Integer(security_mask));
        if (result == null || result[1] != 0) {
            return -1;
        }
        return result[0];
    }

    private int[] getChildInformation(int key) throws Exception {
        return (int[])this.queryInfoKey.invoke(null, new Integer(key));
    }

    private byte[] enumKeys(int key, int subkeyIndex, int maxKeyNameLength) throws Exception {
        return (byte[])this.enumKey.invoke(null, new Integer(key), new Integer(subkeyIndex), new Integer(maxKeyNameLength));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getKeys(int key, String subkey) throws Exception {
        int handle = -1;
        try {
            int[] info;
            handle = this.openKey(key, subkey, 131097);
            if (handle != -1 && (info = this.getChildInformation(handle)) != null && info[0] != -1) {
                ArrayList<String> ret = new ArrayList<String>();
                for (int x = 0; x != info[0]; ++x) {
                    String tmp = WinRegistry.parseValue(this.enumKeys(handle, x, info[3] + 1));
                    if (tmp == null) continue;
                    ret.add(tmp);
                }
                ArrayList<String> arrayList = ret.isEmpty() ? null : ret;
                return arrayList;
            }
        }
        finally {
            this.closeKey(handle);
        }
        return null;
    }

    public int closeKey(int key) throws Exception {
        Integer ret = (Integer)this.closeKey.invoke(null, new Integer(key));
        if (ret != null) {
            return ret;
        }
        return -1;
    }

    public static String parseValue(byte[] buf) {
        if (buf == null) {
            return null;
        }
        String ret = new String(buf);
        if (ret.charAt(ret.length() - 1) == '\u0000') {
            return ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    private byte[] getString(String str) {
        if (str == null) {
            str = "";
        }
        str = (String)str + "\u0000";
        return ((String)str).getBytes();
    }

    private void initMethods() throws Exception {
        Class<?> clazz = null;
        clazz = Class.forName("java.util.prefs.WindowsPreferences");
        Method[] ms = clazz.getDeclaredMethods();
        if (ms == null) {
            throw new Exception("Cannot access java.util.prefs.WindowsPreferences class!");
        }
        for (int x = 0; x != ms.length; ++x) {
            if (ms[x] == null) continue;
            if (ms[x].getName().equals("WindowsRegOpenKey")) {
                this.openKey = ms[x];
                this.openKey.setAccessible(true);
                continue;
            }
            if (ms[x].getName().equals("WindowsRegCloseKey")) {
                this.closeKey = ms[x];
                this.closeKey.setAccessible(true);
                continue;
            }
            if (ms[x].getName().equals("WindowsRegQueryInfoKey")) {
                this.queryInfoKey = ms[x];
                this.queryInfoKey.setAccessible(true);
                continue;
            }
            if (ms[x].getName().equals("WindowsRegEnumKeyEx")) {
                this.enumKey = ms[x];
                this.enumKey.setAccessible(true);
                continue;
            }
            if (!ms[x].getName().equals("WindowsRegQueryValueEx")) continue;
            this.queryValue = ms[x];
            this.queryValue.setAccessible(true);
        }
    }

    public byte[] readValue(int key, String valueName) throws Exception {
        byte[] ret = (byte[])this.queryValue.invoke(null, new Integer(key), this.getString(valueName));
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] arg) {
        String oracleKey = "Software\\Oracle";
        try {
            WinRegistry winReg = new WinRegistry();
            List list = winReg.getKeys(-2147483646, oracleKey);
            if (list != null) {
                for (Object obj : list) {
                    int key = winReg.openKey(-2147483646, oracleKey + "\\" + (String)obj, 131097);
                    if (key <= -1) continue;
                    try {
                        byte[] ora_home = winReg.readValue(key, "ORACLE_HOME");
                        if (ora_home == null) continue;
                        System.out.println(WinRegistry.parseValue(ora_home));
                    }
                    finally {
                        winReg.closeKey(key);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

