/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.swingui.ExternalLogDialog;
import oracle.dbtools.crest.util.Messages;
import oracle.ide.Ide;

public class MessageDialogs {
    public static final Dimension BUTTON_SIZE_EXTRASMALL = new Dimension(69, 23);
    public static final Dimension BUTTON_SIZE_SMALL = new Dimension(23, 23);
    public static final Dimension BUTTON_SIZE = new Dimension(100, 23);
    public static final Dimension BUTTON_SIZE_126 = new Dimension(126, 23);
    public static final Dimension BUTTON_SIZE_EX = new Dimension(140, 23);
    public static final Dimension BUTTON_SIZE_160 = new Dimension(160, 23);
    public static final Dimension BUTTON_SIZE_180 = new Dimension(180, 23);
    public static final Dimension BUTTON_SIZE_200 = new Dimension(200, 23);
    public static final Dimension DEFAULT_COMBOBOX_SIZE = new Dimension(250, 23);
    private static final String MESSAGE_TITLE_ERROR = Messages.getString("MessageDialogs.Error");
    private static final String MESSAGE_TITLE_WARNING = Messages.getString("MessageDialogs.Warning");

    public static void showErrorMessage(String message) {
        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), message, MESSAGE_TITLE_ERROR, 0);
    }

    public static void showErrorMessage(String title, String message) {
        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), message, title, 0);
    }

    public static void showErrorMessage(Component parent, String message) {
        JOptionPane.showMessageDialog(parent, message, MESSAGE_TITLE_ERROR, 0);
    }

    public static void showWarningMessage(String message) {
        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), message, MESSAGE_TITLE_WARNING, 2);
    }

    public static void showWarningMessage(Component parent, String message) {
        JOptionPane.showMessageDialog(parent, message, MESSAGE_TITLE_WARNING, 2);
    }

    public static void showMessage(String message) {
        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), message);
    }

    public static void showMessage(Component parent, String message) {
        JOptionPane.showMessageDialog(parent, message);
    }

    public static void showErrorMessage(String message, boolean showLog) {
        MessageDialogs.showErrorMessage((Component)Ide.getMainWindow(), message, showLog);
    }

    public static void showErrorMessage(Component parent, String message, boolean showLog) {
        if (showLog) {
            Object[] choices = new String[]{Messages.getString("MessageDialogs.OK"), Messages.getString("MessageDialogs.ShowLog")};
            int response = JOptionPane.showOptionDialog(parent, message, MESSAGE_TITLE_ERROR, 0, 0, null, choices, Messages.getString("MessageDialogs.OK"));
            switch (response) {
                case 1: {
                    ExternalLogDialog.showExternalLog();
                    break;
                }
            }
        } else {
            MessageDialogs.showErrorMessage(message);
        }
    }
}

