/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.dbtools.crest.model.LongNameObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.swingui.search.JSearchTextField;
import oracle.dbtools.crest.util.Messages;

public class FilteredJList
extends JList {
    private JSearchTextField filterField;
    private int DEFAULT_FIELD_WIDTH = 20;

    public FilteredJList() {
        this.setModel((ListModel)new FilterModel());
        this.filterField = new JSearchTextField(true, true, Messages.getString("FilteredJList.Name"));
        this.filterField.getDocument().addDocumentListener(new FilterListener());
    }

    public void setModel(ListModel m) {
        if (!(m instanceof FilterModel)) {
            throw new IllegalArgumentException();
        }
        super.setModel(m);
    }

    public void addItem(Object o) {
        ((FilterModel)this.getModel()).addElement(o);
    }

    public void removeItem(Object o) {
        ((FilterModel)this.getModel()).removeElement(o);
    }

    public JTextField getFilterField() {
        return this.filterField;
    }

    private static boolean match(String string, String regex) {
        if ("*".equalsIgnoreCase(regex)) {
            return true;
        }
        if (regex.indexOf(42) > -1) {
            regex = regex.replaceAll("\\*", "\\.*");
        }
        Pattern p = null;
        try {
            p = Pattern.compile(regex, 2);
            Matcher m = p.matcher(string);
            return m.find();
        }
        catch (PatternSyntaxException ex) {
            return false;
        }
    }

    public void sort(FilterModel model) {
        Collections.sort(model.filterItems, ModelObjectSet.NAME_COMPARATOR);
    }

    private class FilterListener
    implements DocumentListener {
        private FilterListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ((FilterModel)FilteredJList.this.getModel()).refilter();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ((FilterModel)FilteredJList.this.getModel()).refilter();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ((FilterModel)FilteredJList.this.getModel()).refilter();
        }
    }

    public class FilterModel
    extends AbstractListModel {
        ArrayList items = new ArrayList();
        ArrayList filterItems = new ArrayList();

        @Override
        public Object getElementAt(int index) {
            if (index < this.filterItems.size()) {
                return this.filterItems.get(index);
            }
            return null;
        }

        @Override
        public int getSize() {
            return this.filterItems.size();
        }

        public void addElement(Object o) {
            this.items.add(o);
            this.fireIntervalAdded(this, 0, this.getSize());
        }

        public void addElementAt(int index, Object o) {
            this.items.add(index, o);
            this.fireIntervalAdded(this, 0, this.getSize());
        }

        public void removeElement(Object obj) {
            this.items.remove(obj);
            this.fireIntervalRemoved(this, 0, this.getSize());
        }

        public void removeElement(int index) {
            this.items.remove(index);
            this.fireIntervalRemoved(this, 0, this.getSize());
        }

        public void refilter() {
            this.filterItems.clear();
            String term = FilteredJList.this.getFilterField().getText();
            for (int i = 0; i < this.items.size(); ++i) {
                if (!FilteredJList.match(((LongNameObject)this.items.get(i)).getName(), term)) continue;
                this.filterItems.add(this.items.get(i));
            }
            this.fireContentsChanged(this, 0, this.getSize());
            FilteredJList.this.sort(this);
        }

        public boolean contains(Object element) {
            return this.items.contains(element);
        }

        public int indexOf(Object element) {
            return this.filterItems.indexOf(element);
        }

        public void clear() {
            this.items.clear();
        }
    }
}

