/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.TableViewSet;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.wizards.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;

public class View2TableDialog
extends CustomDialog {
    public static final String VIEW_OBJECT_ID = "view.object_id";
    public static final String VIEW_SQL = "view.sql";
    public static final String OPEN_BRACKET = "(";
    private JButton btnGenerate;
    private JButton btnClose;
    private JComboBox cmbRelationals;
    private JButton bnSelectAll;
    private JButton bnDeselectAll;
    private JScrollPane spnViews;
    private JTable tblViews;
    private String title;
    private JDialog dialog;
    private static final Logger LOGGER = new Logger(View2TableDialog.class);
    private JTextField tfNamingRule;
    private JButton btnAddVariable;

    public View2TableDialog(ApplicationView applView, String title) {
        super(applView);
        this.title = title;
        this.setLayout(new BorderLayout());
        this.cmbRelationals = new JComboBox();
        this.bnSelectAll = new JButton(Messages.getString("Table2ViewDialog.SelectAll"));
        this.bnSelectAll.setMnemonic(65);
        this.bnSelectAll.setPreferredSize(MessageDialogs.BUTTON_SIZE_160);
        this.bnSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                View2TableDialog.this.selectAllRows(true);
            }
        });
        this.bnDeselectAll = new JButton(Messages.getString("Table2ViewDialog.DeselectAll"));
        this.bnDeselectAll.setMnemonic(68);
        this.bnDeselectAll.setPreferredSize(MessageDialogs.BUTTON_SIZE_180);
        this.bnDeselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                View2TableDialog.this.selectAllRows(false);
            }
        });
        this.spnViews = new JScrollPane();
        this.tblViews = new JTable();
        this.add((Component)this.makeTopPanel(), "North");
        this.add(this.makeCenterPanel(), "Center");
        this.add(this.makeDialogButtonsPanel(), "South");
    }

    @Override
    protected String getHelpIndex() {
        return "VIEW_TO_TABLE_WIZARD";
    }

    @Override
    protected void close() {
        if (this.dialog != null) {
            this.dialog.dispose();
        }
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), this.title, true);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.addListeners();
            this.dialog.setResizable(true);
            this.dialog.setMinimumSize(new Dimension(630, 250));
            this.dialog.pack();
        }
        return this.dialog;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.refreshComponents();
        this.getDialog().setVisible(true);
    }

    private void refreshComponents() {
        DefaultComboBoxModel mdlCombo = (DefaultComboBoxModel)this.cmbRelationals.getModel();
        ActionListener[] actList = this.cmbRelationals.getActionListeners();
        for (int i = 0; i < actList.length; ++i) {
            this.cmbRelationals.removeActionListener(actList[i]);
        }
        mdlCombo.removeAllElements();
        Object[] relDesigns = this.getApplicationView().getCurrentDesign().getRelationalDesigns().toArray();
        for (int i = 0; i < relDesigns.length; ++i) {
            mdlCombo.addElement(relDesigns[i]);
        }
        this.cmbRelationals.setEditable(false);
        RelationalDesign phyDesign = (RelationalDesign)this.cmbRelationals.getSelectedItem();
        this.tblViews.setModel(new CustomTableModel(phyDesign.getTableViewSet()));
        this.setTableWidths();
        for (int i = 0; i < actList.length; ++i) {
            this.cmbRelationals.addActionListener(actList[i]);
        }
        this.handleGenerateButton();
    }

    private void addListeners() {
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                View2TableDialog.this.close();
            }
        });
        this.btnGenerate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                View2TableDialog.this.generateTables();
            }
        });
        this.cmbRelationals.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                View2TableDialog.this.loadNewViewSet();
            }
        });
    }

    protected void loadNewViewSet() {
        try {
            RelationalDesign phyDesign = (RelationalDesign)this.cmbRelationals.getSelectedItem();
            CustomTableModel mdlTable = new CustomTableModel(phyDesign.getTableViewSet());
            this.tblViews.setModel(mdlTable);
            this.setTableWidths();
            this.handleGenerateButton();
        }
        catch (ClassCastException e) {
            LOGGER.error("ERROR::View2TableDialog::loadNewViewSet() -> ClassCastException", e);
        }
    }

    protected void selectAllRows(boolean selected) {
        CustomTableModel mdlTable = (CustomTableModel)this.tblViews.getModel();
        int rowsCount = mdlTable != null ? mdlTable.getRowCount() : 0;
        for (int i = 0; i < rowsCount; ++i) {
            mdlTable.setValueAt(selected, i, 0);
        }
        this.tblViews.invalidate();
        this.tblViews.repaint();
        this.handleGenerateButton();
    }

    private void handleGenerateButton() {
        CustomTableModel mdlTable = (CustomTableModel)this.tblViews.getModel();
        int rowsCount = mdlTable != null ? mdlTable.getRowCount() : 0;
        for (int i = 0; i < rowsCount; ++i) {
            Boolean isSelected = (Boolean)mdlTable.getValueAt(i, 0);
            if (!isSelected.booleanValue()) continue;
            this.btnGenerate.setEnabled(true);
            return;
        }
        this.btnGenerate.setEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateTables() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        ApplicationView.canLogging = false;
        try {
            CustomTableModel mdlTable = (CustomTableModel)this.tblViews.getModel();
            int rowsCount = mdlTable != null ? mdlTable.getRowCount() : 0;
            Boolean isSelected = null;
            ArrayList<Object> arrSelTables = new ArrayList<Object>();
            try {
                for (int i = 0; i < rowsCount; ++i) {
                    isSelected = (Boolean)mdlTable.getValueAt(i, 0);
                    if (!isSelected.booleanValue()) continue;
                    arrSelTables.add(mdlTable.getElementAt(i, 1));
                }
                RelationalDesign phDesign = (RelationalDesign)this.cmbRelationals.getSelectedItem();
                ArrayList<Table> arrTables = new ArrayList<Table>();
                for (TableView tableView : arrSelTables) {
                    arrTables.add(this.addTable(tableView, phDesign, new Rectangle(0, 0)));
                }
                Rectangle2D rectangle2D = phDesign.getMainView().getWorkSpace().getDiagramBounds();
                if (rectangle2D != null) {
                    Rectangle rect = rectangle2D.getBounds();
                    this.rearrangeTables(rect, arrTables);
                }
                phDesign.setDirty(true);
                JOptionPane.showMessageDialog(this, Messages.getString("View2TableDialog.TablesGeneratedSuccessfully"));
            }
            catch (ClassCastException e) {
                LOGGER.error("ERROR::View2TableDialog::generateTables() -> ClassCastException", e);
                JOptionPane.showMessageDialog(this, Messages.getString("View2TableDialog.ErrorOccuredWhileGeneratingTables"));
                ApplicationView.canLogging = true;
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
        }
        finally {
            ApplicationView.canLogging = true;
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void rearrangeTables(Rectangle usedRect, List tables) {
        int offsetLeft = 20;
        int horizontalOffset = 50;
        int verticalOffset = 50;
        int width = 200;
        int height = 80;
        int left = offsetLeft;
        int top = (int)Math.round(usedRect.getMaxY()) + verticalOffset;
        int count = 0;
        if (tables != null && tables.size() > 0) {
            Iterator it = tables.iterator();
            count = 0;
            int res = ((int)usedRect.getMaxX() - offsetLeft) / (width + horizontalOffset);
            if (res > width) {
                ++res;
            }
            int maxTablePerRow = (int)Math.floor(res);
            while (it.hasNext()) {
                Table table = (Table)it.next();
                TopView topView = table.getTopView();
                if (topView == null) continue;
                ++count;
                Rectangle rec = topView.getBounds();
                if (topView.getCellView() != null) {
                    topView.getCellView().setNewBounds(new Rectangle(left, top, rec.width, rec.height));
                }
                left = left + rec.width + horizontalOffset;
                height = Math.max(height, rec.height);
                if (count != maxTablePerRow) continue;
                count = 0;
                left = offsetLeft;
                top = top + height + verticalOffset;
                height = 80;
            }
        }
    }

    private Table addTable(TableView view, RelationalDesign phDesign, Rectangle r) {
        Table table = phDesign.getTableSet().createTable(null);
        String viewName = ApplyNamingStandards.createTableName(view.getName(), this.tfNamingRule.getText(), view.getDesignPart().getName());
        this.getApplicationView().getSettings().setTableNamingRule(this.tfNamingRule.getText());
        ApplicationView.log(Messages.getString("View2TableDialog.CreateTable") + " - " + viewName);
        table.setName(viewName);
        table.setSchemaObject(view.getSchemaObject());
        table.setProperty(VIEW_OBJECT_ID, view.getObjectID());
        table.setProperty(VIEW_SQL, view.getUserDefinedSQL());
        if (view.isBST()) {
            table.setBasedOnStructuredType(view.getBasedOnStructuredType());
        } else {
            for (ContainedObject colView : view.getElementsCollection()) {
                Column column = table.createColumn();
                colView.copyDefaults(column);
                if (!(colView instanceof ColumnView)) continue;
                String dataTypeStr = ((ColumnView)colView).getDataTypeString();
                String dataType = dataTypeStr.trim();
                String params = null;
                if (Token.getFirstToken(dataTypeStr).equals("INTERVAL")) {
                    dataType = Token.cutTokenFromFront(dataTypeStr, "INTERVAL").startsWith("YEAR") ? "INTERVAL YEAR TO MONTH" : "INTERVAL DAY TO SECOND";
                } else if (dataTypeStr.startsWith("SYS.XMLTYPE")) {
                    dataType = "XMLTYPE";
                }
                if (dataType.equals("INTERVAL YEAR TO MONTH")) {
                    String precision = "2";
                    if ((dataTypeStr = Token.getStringAfter(dataTypeStr, "YEAR")).startsWith(OPEN_BRACKET)) {
                        precision = Token.getValBetweenBrackets(dataTypeStr, 1).trim();
                    }
                    column.setDataTypeParameter("precision", precision);
                } else if (dataType.equals("INTERVAL DAY TO SECOND")) {
                    String dayPrecision = "2";
                    String secondsPrecision = "6";
                    if ((dataTypeStr = Token.getStringAfter(dataTypeStr, "DAY")).startsWith(OPEN_BRACKET)) {
                        dayPrecision = Token.getValBetweenBrackets(dataTypeStr, 1).trim();
                    }
                    if ((dataTypeStr = Token.getStringAfter(dataTypeStr, "SECOND")).startsWith(OPEN_BRACKET)) {
                        secondsPrecision = Token.getValBetweenBrackets(dataTypeStr, 1).trim();
                    }
                    column.setDataTypeParameter("precision", dayPrecision);
                    column.setDataTypeParameter("scale", secondsPrecision);
                } else if (Token.hasCloseAndOpenBrackets(dataTypeStr)) {
                    dataType = Token.getValBeforeBrackets(dataTypeStr);
                    params = Token.getValBetweenBrackets(dataTypeStr);
                }
                String usedDatatype = StandardDatatypeNames.getUsedDatatypeName(dataType);
                usedDatatype = StandardDatatypeNames.getTransformedDatatypeName(usedDatatype, phDesign.getSelectedRDBMSType());
                LogicalDatatype logicalDT = MappingDatatypeNameLogicalDataType.getLogicalDatatype(phDesign.getSelectedRDBMSType(), usedDatatype);
                column.setLogicalDatatype(logicalDT);
                column.setUse((short)1);
                if (params == null) continue;
                int positionKomma = params.indexOf(",");
                if (positionKomma != -1) {
                    column.setDataTypeParameter("size", "0");
                    column.setDataTypeParameter("precision", params.substring(0, positionKomma).trim());
                    column.setDataTypeParameter("scale", params.substring(positionKomma + 1).trim());
                    continue;
                }
                if (StandardDatatypeNames.isPackedSized(dataType)) {
                    column.setDataTypeParameter("size", "0");
                    column.setDataTypeParameter("precision", params.trim());
                    column.setDataTypeParameter("scale", "0");
                    continue;
                }
                column.setDataTypeParameter("size", params.trim());
                column.setDataTypeParameter("precision", "0");
                column.setDataTypeParameter("scale", "0");
            }
        }
        TopView topView = phDesign.getMainView().getViewFor(table);
        Dimension dim = phDesign.getTableSize(table);
        if (topView != null && topView.getCellView() != null) {
            r.width = dim.width;
            r.height = dim.height;
            topView.getCellView().setNewBounds(r);
        }
        return table;
    }

    private Component makeCenterPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add((Component)this.makeTable(), "Center");
        pnl.add((Component)this.makeNamingRule(), "South");
        return pnl;
    }

    private Component makeDialogButtonsPanel() {
        JPanel pnl = new JPanel(new FlowLayout(2));
        this.btnGenerate = new JButton(Messages.getString("Table2ViewDialog.Generate"));
        this.btnGenerate.setMnemonic(71);
        this.btnClose = new JButton(Messages.getString("Table2ViewDialog.Close"));
        this.btnClose.setMnemonic(67);
        this.btnGenerate.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        JButton btnHelp = new JButton(this.getHelpAction());
        btnHelp.setMnemonic(72);
        btnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        pnl.add(this.btnGenerate);
        pnl.add(this.btnClose);
        pnl.add(btnHelp);
        return pnl;
    }

    private JComponent makeTopPanel() {
        JPanel pnl = new JPanel(new FlowLayout(0));
        DefaultComboBoxModel mdlCombo = new DefaultComboBoxModel();
        this.cmbRelationals.setModel(mdlCombo);
        this.cmbRelationals.setEditable(false);
        this.cmbRelationals.setPreferredSize(new Dimension(250, 23));
        JPanel jpanel = new JPanel(new FlowLayout(2));
        jpanel.add(this.bnSelectAll);
        jpanel.add(this.bnDeselectAll);
        pnl.add(this.cmbRelationals);
        pnl.add(jpanel);
        return pnl;
    }

    private JComponent makeTable() {
        this.tblViews.getSelectionModel().setSelectionMode(0);
        this.tblViews.setCellSelectionEnabled(false);
        this.tblViews.setRowSelectionAllowed(true);
        this.tblViews.setColumnSelectionAllowed(false);
        this.tblViews.setBorder(LineBorder.createBlackLineBorder());
        this.tblViews.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                View2TableDialog.this.handleGenerateButton();
            }
        });
        CustomTableModel mdlTable = new CustomTableModel(new TableViewSet(null));
        this.tblViews.setModel(mdlTable);
        this.setTableWidths();
        this.spnViews.setViewportView(this.tblViews);
        return this.spnViews;
    }

    private void setTableWidths() {
        int column_offset = 20;
        CustomTableModel mdlTable = (CustomTableModel)this.tblViews.getModel();
        Enumeration<TableColumn> enumCol = this.tblViews.getColumnModel().getColumns();
        int colNum = 0;
        FontMetrics fm = this.tblViews.getFontMetrics(this.tblViews.getFont());
        String name = "default";
        while (enumCol.hasMoreElements()) {
            TableColumn col = enumCol.nextElement();
            if (colNum == 0 && enumCol.hasMoreElements()) {
                name = mdlTable.getColumnName(colNum);
                int colWidth = fm.stringWidth(name) + 20;
                col.setMaxWidth(colWidth);
            }
            ++colNum;
        }
    }

    private JComponent makeNamingRule() {
        JPanel pnNamingRule = new JPanel(new FlowLayout(0));
        JLabel label = new JLabel(Messages.getString("Table2ViewDialog.NamingRule"));
        label.setHorizontalAlignment(4);
        pnNamingRule.add(label);
        this.tfNamingRule = new JTextField();
        this.tfNamingRule.setText(this.getApplicationView().getSettings().getTableNamingRule());
        this.tfNamingRule.setPreferredSize(new Dimension(250, 23));
        pnNamingRule.add(this.tfNamingRule);
        this.btnAddVariable = new JButton(Messages.getString("Table2ViewDialog.AddVariable"));
        this.btnAddVariable.setMnemonic(86);
        this.btnAddVariable.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        this.btnAddVariable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[][] names = new String[][]{{"{model}", "model name"}, {"{view}", "view name"}};
                View2TableDialog.this.createDialog(names, View2TableDialog.this.tfNamingRule);
            }
        });
        pnNamingRule.add(this.btnAddVariable);
        return pnNamingRule;
    }

    private void createDialog(String[][] value, JTextField field) {
        KeyDialog keyDialog = new KeyDialog(this.getApplicationView());
        keyDialog.setValues(value);
        keyDialog.setVisible(true);
        StringBuffer buffer = new StringBuffer();
        int cursorPos = field.getCaretPosition();
        int tfSize = field.getText().length();
        if (cursorPos == 0) {
            buffer.append(keyDialog.getProviderName());
        }
        if (tfSize != 0) {
            for (int i = 0; i < tfSize; ++i) {
                String providerName;
                buffer.append(field.getText().charAt(i));
                if (cursorPos != i + 1 || (providerName = keyDialog.getProviderName()) == null) continue;
                buffer.append(providerName);
            }
            field.setText(buffer.toString());
        } else {
            field.setText(keyDialog.getProviderName());
        }
    }

    class CustomTableModel
    extends AbstractTableModel {
        private TableViewSet mdlData = null;
        private ArrayList checkedState = null;
        private Class[] columnTypes = new Class[]{Boolean.class, Object.class};
        private String[] columnNames = new String[]{Messages.getString("Table2ViewDialog.Selected"), Messages.getString("View2TableDialog.Views")};
        private boolean[] columnEditable = new boolean[]{true, false};

        public CustomTableModel(TableViewSet model) {
            this.mdlData = model;
            this.initCheckedState();
        }

        private void initCheckedState() {
            if (this.mdlData != null) {
                int size = this.mdlData.size();
                this.checkedState = new ArrayList(size);
                for (int i = 0; i < size; ++i) {
                    this.checkedState.add(i, Boolean.TRUE);
                }
            }
        }

        public Class getColumnClass(int columnIndex) {
            return this.columnTypes[columnIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return this.columnEditable[columnIndex];
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.mdlData != null ? this.mdlData.size() : -1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.getColumnClass(columnIndex).equals(Boolean.class)) {
                return this.checkedState.get(rowIndex);
            }
            if (this.getColumnClass(columnIndex).equals(Object.class)) {
                TableView obj = (TableView)this.mdlData.getElement(rowIndex);
                return obj.getName();
            }
            return "Unexpected class at: " + rowIndex + " " + columnIndex;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            if (this.isCellEditable(rowIndex, columnIndex) && this.getColumnClass(columnIndex).equals(Boolean.class)) {
                this.checkedState.set(rowIndex, value);
            }
        }

        public Object getElementAt(int rowIndex, int columnIndex) {
            return this.mdlData.getElement(rowIndex);
        }

        public boolean[] getColumnEditable() {
            return this.columnEditable;
        }

        public void setColumnEditable(boolean[] columnEditable) {
            this.columnEditable = columnEditable;
        }

        public String[] getColumnNames() {
            return this.columnNames;
        }

        public void setColumnNames(String[] columnNames) {
            this.columnNames = columnNames;
        }

        public Class[] getColumnTypes() {
            return this.columnTypes;
        }

        public void setColumnTypes(Class[] columnTypes) {
            this.columnTypes = columnTypes;
        }

        public TableViewSet getMdlData() {
            return this.mdlData;
        }
    }

    private class KeyDialog
    extends JDialog {
        private JTable nameTable;
        private JScrollPane pane;
        private JPanel buttonsPanel;
        private String[][] values;
        private NameProvider provider;

        public KeyDialog(ApplicationView view) {
            super(view.getFrame());
            this.values = new String[0][];
            this.provider = new NameProvider();
            this.setTitle(Messages.getString("Table2ViewDialog.NameElementProvider"));
            this.nameTable = new JTable(new KeyTableModel());
            this.nameTable.setSelectionMode(0);
            this.nameTable.setTableHeader(null);
            this.pane = new JScrollPane(this.nameTable);
            this.pane.setPreferredSize(new Dimension(350, 100));
            this.getContentPane().add(this.pane);
            this.getContentPane().add((Component)this.getButtonPanel(), "South");
            this.setResizable(false);
            this.setModal(true);
            this.pack();
            CommonUtil.centerOnScreen(this);
        }

        protected JPanel getButtonPanel() {
            if (this.buttonsPanel == null) {
                this.buttonsPanel = new JPanel();
                JButton ok = new JButton(Messages.getString("Table2ViewDialog.OK"));
                ok.setPreferredSize(MessageDialogs.BUTTON_SIZE);
                ok.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (KeyDialog.this.nameTable.getSelectedRow() != -1) {
                            KeyDialog.this.provider.setName(KeyDialog.this.nameTable.getValueAt(KeyDialog.this.nameTable.getSelectedRow(), 0).toString());
                        }
                        KeyDialog.this.dispose();
                    }
                });
                JButton cancel = new JButton(Messages.getString("Table2ViewDialog.Cancel"));
                cancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
                cancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        KeyDialog.this.dispose();
                    }
                });
                this.buttonsPanel.add(ok);
                this.buttonsPanel.add(cancel);
            }
            return this.buttonsPanel;
        }

        public String getProviderName() {
            return this.provider.getName();
        }

        public void setValues(String[][] value) {
            this.values = value;
        }

        class KeyTableModel
        extends AbstractTableModel {
            KeyTableModel() {
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public int getRowCount() {
                return KeyDialog.this.values.length;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return KeyDialog.this.values[rowIndex][columnIndex];
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        }
    }

    class NameProvider {
        private String name;

        NameProvider() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String newName) {
            this.name = newName;
        }
    }
}

