/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.transformations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.designrules.DRCustomScript;

public class ApplyCustomTransformation {
    private RelationalDesign rd;
    private String type;
    private DesignPart dp;
    private ArrayList<DRCustomScript> customTransformationScripts;

    public ApplyCustomTransformation(String type, DesignPart dp, ArrayList<DRCustomScript> customTransformationScripts) {
        this.type = type;
        this.dp = dp;
        this.customTransformationScripts = customTransformationScripts;
    }

    public boolean runTransformation() {
        boolean hasErr = false;
        for (DRCustomScript script : this.customTransformationScripts) {
            script.init();
            script.doCheck(this.dp);
            if (!script.hasEvalError()) continue;
            hasErr = true;
            break;
        }
        return hasErr;
    }

    private List getConstraintSet() {
        if (this.rd != null) {
            ArrayList list = new ArrayList();
            Iterator it = this.rd.getTableSet().iterator();
            while (it.hasNext()) {
                Table table = (Table)it.next();
                list.addAll(table.getCheckConstraints());
            }
            return list;
        }
        return null;
    }
}

