/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.storage;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.MDBAction;
import oracle.dbtools.crest.swingui.MenuUtils;
import oracle.dbtools.crest.swingui.SelectableObject;
import oracle.dbtools.crest.swingui.storage.Messages;
import oracle.ide.Ide;

public class ControllerStorage
extends AbstractController {
    private StoreDesign storeDesign;
    private final String[] STORAGE_PATH = new String[]{AbstractController.STORAGE_CAPTION};
    private final String[] FILE_PATH = this.STORAGE_PATH;

    public ControllerStorage(ApplicationView appView) {
        super(appView);
    }

    public StoreDesign getStoreDesign() {
        return this.storeDesign;
    }

    @Override
    public void initializeActions() {
        if (this.isEditable()) {
            this.storeDesign = new StoreDesign();
            this.add(this.storeDesign);
        }
    }

    @Override
    public void setDesignPartView(DesignPartView dpv) {
    }

    @Override
    public void select_SelectAction() {
    }

    @Override
    protected void configureActions() {
        Iterator it = this.getActionsIterator();
        while (it.hasNext()) {
            MDBAction action = (MDBAction)it.next();
            if (!action.needSelectedObject()) continue;
            action.setEnabled(false);
        }
    }

    public RDBMSSite getSelectedSite() {
        RDBMSSite site = this.getPhysicalDesign() != null ? this.getPhysicalDesign().getSelectedRDBMSSite() : this.getDesign().getSelectedRDBMSSite();
        return site;
    }

    public StorageDesign getSelectedStorageDesign() {
        RDBMSSite site = this.getSelectedSite();
        StorageDesign storageDesign = this.getDesign().getStorageDesign(site);
        return storageDesign;
    }

    @Override
    public SelectableObject getCurrentSelection() {
        return null;
    }

    @Override
    public DesignPartView getDesignPartView() {
        return null;
    }

    @Override
    public String getToolBarName() {
        return Messages.getString("ControllerStorage.PhysicalModel");
    }

    public class StoreDesign
    extends MDBAction {
        private StoreDesign() {
            super(MenuUtils.getMnemonicStr(AbstractController.SAVE_STORAGE_DESIGN_CAPTION), ControllerStorage.this.getConfiguration().getIcon("SAVE_ICON", ControllerStorage.this.getPreferredIconSize()));
            this.setMenuPath(ControllerStorage.this.FILE_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.SAVE_STORAGE_DESIGN_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(83, 576, false));
        }

        @Override
        public boolean addSeparatorBefore() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (!ControllerStorage.this.getDesign().isNewDesign()) {
                RelationalDesign relDesign = ControllerStorage.this.getApplicationView().selectRelationalDesign();
                if (relDesign != null) {
                    StorageDesign[] storageDesigns = relDesign.getStorageDesignFactory().getOpenStorageDesigns();
                    ArrayList<RDBMSSite> list = new ArrayList<RDBMSSite>();
                    Object[] selection = null;
                    for (int i = 0; i < storageDesigns.length; ++i) {
                        StorageDesign storageDesign = storageDesigns[i];
                        if (!storageDesign.isDirty() && !storageDesign.hasDirtyStorableObjects()) continue;
                        list.add(storageDesign.getRDBMSSite());
                    }
                    if (list.toArray().length > 1) {
                        JList<Object> jlist = new JList<Object>(list.toArray());
                        if (relDesign.getSelectedRDBMSSite() != null) {
                            jlist.setSelectedValue(relDesign.getSelectedRDBMSSite(), true);
                        }
                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new JScrollPane(jlist), Messages.getString("ControllerStorage.SavePhysicalModels"), 3);
                        selection = jlist.getSelectedValues();
                    } else if (list.toArray().length == 1) {
                        selection = list.toArray();
                    } else {
                        ApplicationView.log(Messages.getString("ControllerStorage.NoPhysicalModelOpened"));
                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("ControllerStorage.NoPhysicalModelOpened"));
                        return;
                    }
                    for (int i = 0; i < selection.length; ++i) {
                        RDBMSSite site = (RDBMSSite)selection[i];
                        StorageDesign storageDesign = relDesign.getStorageDesign(site);
                        ApplicationView.log(Messages.getString("ControllerStorage.SavePhysicalModel") + storageDesign.getFileName());
                        if (storageDesign.isTempModel()) continue;
                        storageDesign.save();
                        storageDesign.setDirty(false);
                    }
                }
            } else {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("ControllerStorage.SaveMainDesign"), Messages.getString("ControllerStorage.Warning"), 2);
            }
        }
    }
}

