/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.search;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.datatypes.TVStructuredType;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.swingui.logical.TVEntityView;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.swingui.multidimensional.TVCube;
import oracle.dbtools.crest.swingui.multidimensional.TVDimension;
import oracle.dbtools.crest.swingui.multidimensional.TVLevel;
import oracle.dbtools.crest.swingui.process.TVAgent;
import oracle.dbtools.crest.swingui.process.TVInfoStore;
import oracle.dbtools.crest.swingui.process.TVProcess;
import oracle.dbtools.crest.swingui.relational.TVFKRelation;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.swingui.relational.TVView;
import oracle.dbtools.crest.swingui.search.ItemsHolder;
import oracle.dbtools.crest.swingui.search.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.string.ToStringComparator;

public class SearchResultsList
extends JDialog
implements ListSelectionListener,
PropertyChangeListener {
    private ApplicationView appView;
    JDialog dlg;
    private JOptionPane optionPane;
    private JList list;
    private DefaultListModel listModel;
    ToStringComparator toStringComparator = new ToStringComparator();

    public SearchResultsList(ApplicationView applicationView) {
        super((Frame)applicationView.getFrame(), true);
        this.setTitle(Messages.getString("SearchResultsList.ResultList"));
        this.appView = applicationView;
        this.setModal(false);
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        this.list.addListSelectionListener(this);
        this.list.setSelectionMode(0);
        this.list.setVisibleRowCount(-1);
        this.list.setCellRenderer(new SearchCellRenderer());
        JScrollPane scrollPane = new JScrollPane(this.list);
        scrollPane.setPreferredSize(new Dimension(300, 200));
        Object[] array = new Object[]{scrollPane};
        Object[] options = new Object[]{this.getButtonsPanel()};
        this.optionPane = new JOptionPane(array, -1, 0, null, options, options[0]);
        this.setContentPane(this.optionPane);
        this.setDefaultCloseOperation(2);
        this.optionPane.addPropertyChangeListener(this);
    }

    private JPanel getButtonsPanel() {
        JPanel jpanel = new JPanel();
        JButton bnFindAgain = new JButton(Messages.getString("SearchResultsList.NewSearch"));
        bnFindAgain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchResultsList.this.dispose();
            }
        });
        JButton bnClose = new JButton(Messages.getString("SearchResultsList.Close"));
        bnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchResultsList.this.dispose();
            }
        });
        bnFindAgain.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        bnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        jpanel.add(bnFindAgain);
        jpanel.add(bnClose);
        return jpanel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (this.isVisible() && e.getSource() == this.optionPane && ("value".equals(prop) || "inputValue".equals(prop))) {
            Object value = this.optionPane.getValue();
            if (value == JOptionPane.UNINITIALIZED_VALUE) {
                return;
            }
            this.optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
        }
    }

    private void selectInTree(DesignObject desObj) {
        this.appView.getBrowserPanel().getJTree().setSelectionPath(new TreePath(desObj.getPath()));
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting() && this.list.getSelectedIndex() != -1) {
            Object object = this.list.getSelectedValue();
            if (object instanceof TVEntity) {
                TVEntity tventity = (TVEntity)object;
                DesignPartView dpv = tventity.getDesignPartView();
                if (tventity != null) {
                    dpv.setCurrentSelection(tventity.getSelectableObject(), tventity);
                    this.selectInTree(tventity.getModel());
                }
            } else if (object instanceof TVTable) {
                TVTable tvtable = (TVTable)object;
                DesignPartView dpv = tvtable.getDesignPartView();
                if (tvtable != null) {
                    dpv.setCurrentSelection(tvtable.getSelectableObject(), tvtable);
                    this.selectInTree(tvtable.getModel());
                }
            } else if (object instanceof ItemsHolder) {
                ItemsHolder ih = (ItemsHolder)object;
                if (ih.dobject instanceof Attribute) {
                    DesignPartView dpv = ih.tv.getDesignPartView();
                    ContainerView view = (ContainerView)ih.tv;
                    if (view != null) {
                        dpv.setCurrentSelection(view.getSelectableObject(), view);
                        this.selectInTree(ih.dobject);
                    }
                } else if (ih.dobject instanceof Column) {
                    DesignPartView dpv = ih.tv.getDesignPartView();
                    ContainerView view = (ContainerView)ih.tv;
                    if (view != null) {
                        dpv.setCurrentSelection(view.getSelectableObject(), view);
                        this.selectInTree(ih.dobject);
                    }
                } else if (ih.dobject instanceof CandidateKey) {
                    DesignPartView dpv = ih.tv.getDesignPartView();
                    TopView tv = ih.tv;
                    if (tv != null) {
                        dpv.setCurrentSelection(tv.getSelectableObject(), tv);
                        this.selectInTree(ih.dobject);
                    }
                } else if (ih.dobject instanceof Index) {
                    DesignPartView dpv = ih.tv.getDesignPartView();
                    TopView tv = ih.tv;
                    if (tv != null) {
                        dpv.setCurrentSelection(tv.getSelectableObject(), tv);
                        this.selectInTree(ih.dobject);
                    }
                }
            } else if (object instanceof TVView) {
                TVView view = (TVView)object;
                DesignPartView dpv = view.getDesignPartView();
                TVView tv = view;
                if (tv != null) {
                    dpv.setCurrentSelection(((TopView)tv).getSelectableObject(), view);
                    this.selectInTree(view.getModel());
                }
            } else if (object instanceof TVEntityView) {
                TVEntityView view = (TVEntityView)object;
                DesignPartView dpv = view.getDesignPartView();
                TVEntityView tv = view;
                if (tv != null) {
                    dpv.setCurrentSelection(((TopView)tv).getSelectableObject(), view);
                    this.selectInTree(view.getModel());
                }
            } else if (object instanceof TVFKRelation) {
                TVFKRelation view = (TVFKRelation)object;
                DesignPartView dpv = view.getDesignPartView();
                TVFKRelation tv = view;
                if (tv != null) {
                    dpv.setCurrentSelection(((TopView)tv).getSelectableObject(), view);
                    this.selectInTree(view.getModel());
                }
            } else if (object instanceof TVRelation) {
                TVRelation view = (TVRelation)object;
                DesignPartView dpv = view.getDesignPartView();
                TVRelation tv = view;
                if (tv != null) {
                    dpv.setCurrentSelection(((TopView)tv).getSelectableObject(), view);
                    this.selectInTree(view.getModel());
                }
            } else if (object instanceof TVProcess) {
                TVProcess tvProc = (TVProcess)object;
                DesignPartView dpv = tvProc.getDesignPartView();
                TVProcess tv = tvProc;
                if (tv != null) {
                    dpv.setCurrentSelection(((TopView)tv).getSelectableObject(), tvProc);
                    this.selectInTree(tvProc.getModel());
                }
            } else if (object instanceof TVAgent) {
                TVAgent tvAgent = (TVAgent)object;
                DesignPartView dpv = tvAgent.getDesignPartView();
                TVAgent tv = tvAgent;
                if (tv != null) {
                    dpv.setCurrentSelection(((TopView)tv).getSelectableObject(), tvAgent);
                    this.selectInTree(tvAgent.getModel());
                }
            } else if (object instanceof TVInfoStore) {
                TVInfoStore tvStore = (TVInfoStore)object;
                DesignPartView dpv = tvStore.getDesignPartView();
                TVInfoStore tv = tvStore;
                if (tv != null) {
                    dpv.setCurrentSelection(((TopView)tv).getSelectableObject(), tvStore);
                    this.selectInTree(tvStore.getModel());
                }
            } else if (object instanceof TVCube) {
                TVCube tvCube = (TVCube)object;
                DesignPartView dpv = tvCube.getDesignPartView();
                TVCube tv = tvCube;
                if (tv != null) {
                    dpv.setCurrentSelection(((TopView)tv).getSelectableObject(), tvCube);
                    this.selectInTree(tvCube.getModel());
                }
            } else if (object instanceof TVLevel) {
                TVLevel tvLevel = (TVLevel)object;
                DesignPartView dpv = tvLevel.getDesignPartView();
                TVLevel tv = tvLevel;
                if (tv != null) {
                    dpv.setCurrentSelection(((TopView)tv).getSelectableObject(), tvLevel);
                    this.selectInTree(tvLevel.getModel());
                }
            } else if (object instanceof TVDimension) {
                TVDimension tvDimension = (TVDimension)object;
                DesignPartView dpv = tvDimension.getDesignPartView();
                TVDimension tv = tvDimension;
                if (tv != null) {
                    dpv.setCurrentSelection(((TopView)tv).getSelectableObject(), tvDimension);
                    this.selectInTree(tvDimension.getModel());
                }
            } else if (object instanceof TVStructuredType) {
                TVStructuredType tvST = (TVStructuredType)object;
                DesignPartView dpv = tvST.getDesignPartView();
                TVStructuredType tv = tvST;
                if (tv != null) {
                    dpv.setCurrentSelection(((TopView)tv).getSelectableObject(), tvST);
                    this.selectInTree(tvST.getModel());
                }
            }
        }
    }

    public void clear() {
        this.listModel.clear();
    }

    public void addDesignObject(Object object) {
        this.listModel.addElement(object);
    }

    public void sort() {
        ArrayList col = new ArrayList();
        Enumeration e = this.listModel.elements();
        while (e.hasMoreElements()) {
            col.add(e.nextElement());
        }
        Collections.sort(col, this.toStringComparator);
        this.listModel.clear();
        Iterator it = col.iterator();
        while (it.hasNext()) {
            this.listModel.addElement(it.next());
        }
    }

    public boolean isEmpty() {
        return this.listModel.getSize() == 0;
    }

    class SearchCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public SearchCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof ItemsHolder) {
                ItemsHolder ih = (ItemsHolder)value;
                if (ih.dobject instanceof Column || ih.dobject instanceof Attribute || ih.dobject instanceof KeyObject) {
                    this.setText(((ItemsHolder)value).dobject.toString() + " (" + ((ItemsHolder)value).tv.toString() + ")");
                }
            } else {
                this.setText(value.toString());
            }
            this.setBackground(isSelected ? Color.blue : Color.white);
            this.setForeground(isSelected ? Color.white : Color.black);
            return this;
        }
    }
}

