/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.search;

import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.MetaDataManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.LogReport;
import oracle.dbtools.crest.swingui.search.Messages;
import oracle.dbtools.crest.swingui.search.PropertyObject;
import oracle.dbtools.crest.swingui.search.SearchSet;
import oracle.dbtools.crest.swingui.wizards.reports.ReportUtils;
import oracle.dbtools.crest.util.logging.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ImportExcelFile {
    private final String TRUE_STR = "true";
    private final String FALSE_STR = "false";
    private MetaDataManager metaDataManager;
    private StringBuffer buffer = new StringBuffer();
    private StringBuffer okPropertiesBuffer;
    private StringBuffer errPropertiesBuffer;
    private String dateTime = "";
    private int totalCount = 0;
    private int totalSuccessfullyAttemptedUpdatesCount = 0;
    private int totalNonSuccessfullyAttemptedUpdatesCount = 0;
    private int errCount = 0;
    private int objOKayPropsCount = 0;
    private int objErrPropsCount = 0;
    private LogReport logPanel;
    private List collection;
    private LinkedHashMap<Class, Map> usedPropertiesMap;
    private static final Logger LOGGER = new Logger(ImportExcelFile.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importFile(ApplicationView appView, File file, ModelIDObject currentModel) {
        this.logPanel = new LogReport(appView);
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.buffer.append(this.dateTime + "Updating current model with data from XLS file.");
        this.buffer.append("\n");
        this.buffer.append("Current date : " + dateFormat.format(cal.getTime()));
        this.buffer.append("\n");
        this.buffer.append(this.dateTime + "Current design : " + currentModel.getDesign().getName() + " (ID : " + currentModel.getDesign().getObjectID() + ")");
        this.buffer.append("\n");
        this.buffer.append(this.dateTime + "Current model : " + currentModel.getName() + " (ID : " + currentModel.getObjectID() + ")");
        this.buffer.append("\n");
        this.buffer.append(this.dateTime + "XLS file : " + file.getAbsolutePath());
        boolean getModelId = false;
        boolean noCommentInAnyFirstColumnCell = false;
        boolean noCommentInAnySecondColumnCell = false;
        ModelObject obj = null;
        String designId = "";
        String modelId = "";
        this.metaDataManager = appView.getXMLTransformationManager().getMetaDataManager();
        FileInputStream inp = null;
        this.collection = new ArrayList();
        Iterator setsIt = null;
        if (currentModel instanceof DesignPart) {
            setsIt = ((DesignPart)currentModel).getSearchableSets().iterator();
        } else if (currentModel instanceof StorageDesign) {
            setsIt = ((StorageDesign)currentModel).getSearchableSets().iterator();
        }
        while (setsIt.hasNext()) {
            SearchSet ss = (SearchSet)setsIt.next();
            ((ElementSet)((Object)ss.getSet())).addAllElementsTo(this.collection);
        }
        try {
            inp = new FileInputStream(file);
            Workbook wb = WorkbookFactory.create((InputStream)inp);
            this.usedPropertiesMap = new LinkedHashMap();
            Sheet propertiesMapWS = wb.getSheetAt(1);
            Iterator rIt = propertiesMapWS.rowIterator();
            while (rIt.hasNext()) {
                Row row = (Row)rIt.next();
                if (row == null) continue;
                Class<?> clazz = null;
                int col = 0;
                LinkedHashMap<Integer, String> properties = new LinkedHashMap<Integer, String>();
                Iterator cIt = row.cellIterator();
                while (cIt.hasNext()) {
                    Cell cell = (Cell)cIt.next();
                    cell.setCellType(CellType.STRING);
                    String xlsCellValue = cell.getRichStringCellValue().toString();
                    if (cell.getColumnIndex() == 0) {
                        col = new Integer(xlsCellValue);
                        continue;
                    }
                    if (cell.getColumnIndex() == 1) {
                        clazz = Class.forName(xlsCellValue);
                        continue;
                    }
                    properties.put(col, xlsCellValue);
                    ++col;
                }
                this.usedPropertiesMap.put(clazz, properties);
            }
            Sheet sheet = wb.getSheetAt(0);
            rIt = sheet.rowIterator();
            while (rIt.hasNext()) {
                Row row = (Row)rIt.next();
                if (row == null) continue;
                this.okPropertiesBuffer = new StringBuffer();
                this.errPropertiesBuffer = new StringBuffer();
                this.objOKayPropsCount = 0;
                this.objErrPropsCount = 0;
                boolean hasSingleAttemptForUpdate = false;
                boolean isDataRow = false;
                String part3 = "";
                String part4 = "";
                Iterator cIt = row.cellIterator();
                while (cIt.hasNext()) {
                    boolean upd;
                    boolean found;
                    Cell cell = (Cell)cIt.next();
                    int columnIdx = cell.getColumnIndex();
                    if (columnIdx >= 30) continue;
                    Comment comment = cell.getCellComment();
                    String xlsCellValue = "";
                    if (cell.getCellType() == CellType.STRING) {
                        xlsCellValue = cell.getRichStringCellValue().getString();
                    } else if (cell.getCellType() == CellType.NUMERIC) {
                        if (DateUtil.isCellDateFormatted((Cell)cell)) {
                            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                            xlsCellValue = df.format(cell.getDateCellValue());
                        } else {
                            xlsCellValue = Double.toString(cell.getNumericCellValue());
                        }
                    } else {
                        xlsCellValue = cell.getCellType() == CellType.BOOLEAN ? Boolean.toString(cell.getBooleanCellValue()) : cell.getRichStringCellValue().getString();
                    }
                    String part1 = "";
                    String part2 = "";
                    if (columnIdx == 0) {
                        if (comment == null) continue;
                        String str = comment.getString().getString();
                        if (str.indexOf(";") == -1) {
                            part1 = str.substring(0, str.indexOf(":") + 1);
                            part2 = str.substring(str.indexOf(":") + 1, str.length());
                        } else if (str.indexOf(";") > -1) {
                            part1 = str.substring(0, str.indexOf(":") + 1);
                            part2 = str.substring(str.indexOf(":") + 1, str.indexOf(";"));
                            part3 = str.substring(str.indexOf(";") + 2, str.lastIndexOf(":"));
                            part4 = str.substring(str.lastIndexOf(":") + 1, str.length());
                        }
                        if (!part1.equals("")) {
                            if (!part2.equals("")) {
                                if (part1.equals("DesignID:")) {
                                    designId = part2;
                                    this.buffer.append("\n");
                                    this.buffer.append(this.dateTime + "XLS file design ID: " + designId);
                                    if (currentModel.getDesign().getObjectID().equals(designId)) {
                                        getModelId = true;
                                        continue;
                                    }
                                    this.buffer.append("\n");
                                    this.buffer.append("\n___________________________");
                                    this.buffer.append("\n");
                                    this.buffer.append("\nERROR");
                                    this.buffer.append("\n");
                                    this.buffer.append(this.dateTime + "Selected XLS file does not contain data for current design i.e. the string 'DesignID:' in first cell of table header row comment does not correspond to current design.");
                                    this.buffer.append("\n");
                                    this.buffer.append(this.dateTime + "Updating model is aborted.");
                                    this.logPanel.setLog(this.buffer.toString());
                                    this.logPanel.showDialog(new Dimension(750, 550));
                                    return;
                                }
                                if (part1.equals("ObjectID:")) {
                                    isDataRow = true;
                                    obj = null;
                                    found = false;
                                    if (currentModel instanceof DesignPart) {
                                        obj = ((DesignPart)currentModel).getDesign().getDesignObject(part2);
                                    } else if (currentModel instanceof StorageDesign) {
                                        obj = ((StorageDesign)currentModel).getStorageObject(part2);
                                    }
                                    if (obj != null) {
                                        upd = this.updateValue((ModelIDObject)obj, columnIdx, xlsCellValue, part4);
                                        if (!hasSingleAttemptForUpdate) {
                                            hasSingleAttemptForUpdate = upd;
                                        }
                                        found = true;
                                    }
                                    if (!found) {
                                        this.buffer.append("\n");
                                        this.buffer.append(this.dateTime + "Processing XLS row " + (row.getRowNum() + 1) + ". Object with ID " + part2 + " is not found in the model hence can not be updated. Skipping.");
                                        ++this.errCount;
                                    }
                                    getModelId = false;
                                    continue;
                                }
                                this.buffer.append("\n");
                                this.buffer.append(this.getGeneralErrMsg());
                                this.buffer.append("\n");
                                this.buffer.append(this.dateTime + "String 'DesignID:' must be present in first cell of table header row comment! Full syntax is : 'DesignID:<designID string>' ");
                                this.buffer.append("\n");
                                this.buffer.append(this.dateTime + "Updating model is aborted.");
                                this.logPanel.setLog(this.buffer.toString());
                                this.logPanel.showDialog(new Dimension(750, 550));
                                return;
                            }
                            if (part1.equals("DesignID:")) {
                                this.buffer.append("\n");
                                this.buffer.append(this.getGeneralErrMsg());
                                this.buffer.append("\n");
                                this.buffer.append(this.dateTime + "Design ID must be present in first cell of table header row comment! Full syntax is : 'DesignID:<designID string>' ");
                                this.buffer.append("\n");
                                this.buffer.append(this.dateTime + "Updating model is aborted.");
                                this.logPanel.setLog(this.buffer.toString());
                                this.logPanel.showDialog(new Dimension(750, 550));
                                return;
                            }
                            if (!part1.equals("ObjectID:")) continue;
                            this.buffer.append("\n");
                            this.buffer.append(this.dateTime + "Object ID is missing in row " + row.getRowNum() + "! Object can not be updated. Skipping.");
                            this.logPanel.setLog(this.buffer.toString());
                            this.logPanel.showDialog(new Dimension(750, 550));
                            return;
                        }
                        this.buffer.append("\n");
                        this.buffer.append(this.getGeneralErrMsg());
                        this.buffer.append("\n");
                        this.buffer.append(this.dateTime + "String 'DesignID:' must be present in first cell of table header row comment! Full syntax is : 'DesignID:<designID string>' ");
                        this.buffer.append("\n");
                        this.buffer.append(this.dateTime + "Updating model is aborted.");
                        this.logPanel.setLog(this.buffer.toString());
                        this.logPanel.showDialog(new Dimension(750, 550));
                        return;
                    }
                    if (columnIdx == 1) {
                        if (getModelId) {
                            if (comment == null) continue;
                            String str = comment.getString().getString();
                            part1 = str.substring(0, str.indexOf(":") + 1);
                            part2 = str.substring(str.indexOf(":") + 1, str.length());
                            if (!part1.equals("")) {
                                if (!part2.equals("")) {
                                    if (!part1.equals("ModelID:")) continue;
                                    modelId = part2;
                                    this.buffer.append("\n");
                                    this.buffer.append(this.dateTime + "XLS file model ID: " + modelId);
                                    this.buffer.append("\n___________________________");
                                    this.buffer.append("\n");
                                    if (currentModel.getObjectID().equals(modelId)) continue;
                                    this.buffer.append("\n");
                                    this.buffer.append(this.dateTime + "String 'ModelID:' in second cell of table header row comment does not correspond to current model!");
                                    this.buffer.append("\n");
                                    this.buffer.append(this.dateTime + "Updating model is aborted.");
                                    this.logPanel.setLog(this.buffer.toString());
                                    this.logPanel.showDialog(new Dimension(750, 550));
                                    return;
                                }
                                this.buffer.append("\n");
                                this.buffer.append(this.getGeneralErrMsg());
                                this.buffer.append("\n");
                                this.buffer.append(this.dateTime + "Model ID must be present in second cell of table header row comment! Full syntax is : 'ModelID:<modelID string>' ");
                                this.buffer.append("\n");
                                this.buffer.append(this.dateTime + "Updating model is aborted.");
                                this.logPanel.setLog(this.buffer.toString());
                                this.logPanel.showDialog(new Dimension(750, 550));
                                return;
                            }
                            this.buffer.append("\n");
                            this.buffer.append(this.getGeneralErrMsg());
                            this.buffer.append("\n");
                            this.buffer.append(this.dateTime + "String 'ModelID:' must be present in second cell of table header row comment! Full syntax is : 'ModelID:<modelID string>' ");
                            this.buffer.append("\n");
                            this.buffer.append(this.dateTime + "Updating model is aborted.");
                            this.logPanel.setLog(this.buffer.toString());
                            this.logPanel.showDialog(new Dimension(750, 550));
                            return;
                        }
                        if (comment != null) {
                            String str = comment.getString().getString();
                            part1 = str.substring(0, str.indexOf(":") + 1);
                            part2 = str.substring(str.indexOf(":") + 1, str.indexOf(";"));
                            part3 = str.substring(str.indexOf(";") + 2, str.lastIndexOf(":"));
                            part4 = str.substring(str.lastIndexOf(":") + 1, str.length());
                            isDataRow = true;
                            obj = null;
                            found = false;
                            if (currentModel instanceof DesignPart) {
                                obj = ((DesignPart)currentModel).getDesign().getDesignObject(part2);
                            } else if (currentModel instanceof StorageDesign) {
                                obj = ((StorageDesign)currentModel).getStorageObject(part2);
                            }
                            if (obj == null) continue;
                            upd = this.updateValue((ModelIDObject)obj, columnIdx, xlsCellValue, part4);
                            if (!hasSingleAttemptForUpdate) {
                                hasSingleAttemptForUpdate = upd;
                            }
                            found = true;
                            continue;
                        }
                        if (obj == null) continue;
                        boolean upd2 = this.updateValue((ModelIDObject)obj, columnIdx, xlsCellValue, part4);
                        if (!hasSingleAttemptForUpdate) {
                            hasSingleAttemptForUpdate = upd2;
                        }
                        ++this.totalCount;
                        continue;
                    }
                    if (obj == null) continue;
                    boolean upd3 = this.updateValue((ModelIDObject)obj, columnIdx, xlsCellValue, part4);
                    if (hasSingleAttemptForUpdate) continue;
                    hasSingleAttemptForUpdate = upd3;
                }
                if (!isDataRow || !hasSingleAttemptForUpdate) continue;
                this.buffer.append("\n\n");
                this.buffer.append(this.dateTime + "Processing XLS row " + (row.getRowNum() + 1) + ". ");
                this.buffer.append(this.dateTime + "Object " + obj.getName() + " found. Updating properties...");
                this.buffer.append("\n");
                if (this.objOKayPropsCount > 0) {
                    this.buffer.append(" Successfully updated properties : ");
                    this.buffer.append(this.okPropertiesBuffer);
                    this.buffer.append("\n");
                }
                if (this.objErrPropsCount > 0) {
                    this.buffer.append(" Non updated properties : ");
                    this.buffer.append(this.errPropertiesBuffer);
                    this.buffer.append("\n");
                }
                this.buffer.append(" ---");
                this.buffer.append("\n");
                this.buffer.append(" Results for object: " + obj.getName());
                this.buffer.append("\n");
                this.buffer.append(" Successfully updated properties count: " + this.objOKayPropsCount);
                this.buffer.append("\n");
                this.buffer.append(" Non updated properties count: " + this.objErrPropsCount);
                this.buffer.append("\n");
                this.buffer.append(" ----------");
            }
            if (noCommentInAnyFirstColumnCell) {
                this.buffer.append("\n");
                this.buffer.append(this.getGeneralErrMsg());
                this.buffer.append("\n");
                this.buffer.append(this.dateTime + "There is no comments in any of the first column cells!");
            }
            if (noCommentInAnyFirstColumnCell) {
                this.buffer.append("\n");
                this.buffer.append(this.getGeneralErrMsg());
                this.buffer.append("\n");
                this.buffer.append(this.dateTime + "There is no comments in any of the second column cells! There must be exactly one comment in table header second cell.");
            }
            this.buffer.append("\n");
            this.buffer.append("\n___________________________");
            this.buffer.append("\n");
            this.buffer.append("Total XLS data rows processed: " + this.totalCount);
            this.buffer.append("\n");
            this.buffer.append("Successfully updated objects: " + this.totalSuccessfullyAttemptedUpdatesCount);
            this.buffer.append("\n");
            this.buffer.append("Unsuccessful attempts for update: " + this.totalNonSuccessfullyAttemptedUpdatesCount);
            this.buffer.append("\n");
            this.buffer.append("Skipped XLS rows: " + this.errCount);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(appView.getFrame(), Messages.getString("ImportExcelFile.XLSNotImported"), Messages.getString("ImportExcelFile.ImportXLS"), 0);
            this.buffer.append("\n");
            this.buffer.append(this.getGeneralErrMsg());
            this.buffer.append("\n");
            this.buffer.append(e);
            LOGGER.error("ImportExcelFile : ", e);
        }
        finally {
            if (inp != null) {
                try {
                    ((InputStream)inp).close();
                }
                catch (IOException e) {
                    LOGGER.error("ImportExcelFile : ", e);
                }
            }
        }
        this.logPanel.setLog(this.buffer.toString());
        this.logPanel.showDialog(new Dimension(750, 550));
    }

    private LinkedHashMap getProperties(Map map, Class clazz) {
        Object obj = map.get(clazz);
        if (obj == null) {
            Class cl;
            Iterator it = map.keySet().iterator();
            while (it.hasNext() && (!clazz.isAssignableFrom(cl = (Class)it.next()) || (obj = map.get(cl)) == null)) {
            }
            if (obj != null) {
                map.put(clazz, obj);
            } else {
                for (Class sup = clazz.getSuperclass(); sup != null && !sup.getName().equalsIgnoreCase("Object"); sup = sup.getSuperclass()) {
                    obj = map.get(sup);
                    if (obj == null) {
                        continue;
                    }
                    map.put(clazz, obj);
                    break;
                }
            }
        }
        return (LinkedHashMap)obj;
    }

    private boolean updateValue(ModelIDObject obj, int columnIdx, String xlsCellValue, String clsName) {
        boolean attemptedToUpdate;
        block21: {
            attemptedToUpdate = false;
            try {
                if (clsName.equals("")) break block21;
                Class<?> clazz = Class.forName(clsName);
                LinkedHashMap properties = this.getProperties(this.usedPropertiesMap, clazz);
                String currentCellPropertyName = (String)properties.get(columnIdx);
                block2: for (PropertyObject po : ReportUtils.getSearchablePropertyObjects(obj.getClass(), this.metaDataManager)) {
                    if (!po.isProperty()) continue;
                    ClassDescription.PropertyDescription pd = po.getPropertyDescription();
                    String className = pd.className;
                    Method gMethod = pd.getter;
                    Method sMethod = pd.setter;
                    Object oldPropertyValue = "";
                    String currentPropertyName = po.getName();
                    if (gMethod != null && currentPropertyName.equals(currentCellPropertyName)) {
                        if (className.indexOf("java.lang.String") > -1 || className.indexOf("java.lang.Integer") > -1 || className.indexOf("java.lang.Boolean") > -1 || className.indexOf("boolean") > -1 || className.indexOf("float") > -1 || className.indexOf("short") > -1 || className.indexOf("long") > -1 || className.indexOf("double") > -1 || className.indexOf("int") > -1) {
                            oldPropertyValue = gMethod.invoke((Object)obj, new Object[0]);
                            if (oldPropertyValue instanceof Boolean) {
                                oldPropertyValue = ((Boolean)oldPropertyValue).toString();
                            } else if (oldPropertyValue instanceof Integer) {
                                oldPropertyValue = ((Integer)oldPropertyValue).toString();
                            }
                            boolean go = false;
                            if (oldPropertyValue == null) {
                                if (!xlsCellValue.equals("")) {
                                    go = true;
                                }
                            } else if (!((String)oldPropertyValue).equals(xlsCellValue)) {
                                go = true;
                            }
                            if (go && sMethod != null) {
                                if (xlsCellValue.equalsIgnoreCase("true") || xlsCellValue.equalsIgnoreCase("false")) {
                                    sMethod.invoke((Object)obj, Boolean.parseBoolean(xlsCellValue));
                                } else {
                                    sMethod.invoke((Object)obj, xlsCellValue);
                                }
                                Object newPropertyValue = gMethod.invoke((Object)obj, new Object[0]);
                                if (oldPropertyValue != newPropertyValue) {
                                    this.okPropertiesBuffer.append("\n   Property : " + po.getName());
                                    this.okPropertiesBuffer.append("\n    Old value : " + oldPropertyValue);
                                    this.okPropertiesBuffer.append("\n    New value : " + xlsCellValue);
                                    ++this.totalSuccessfullyAttemptedUpdatesCount;
                                    attemptedToUpdate = true;
                                    obj.setDirty(true);
                                    ++this.objOKayPropsCount;
                                } else {
                                    this.errPropertiesBuffer.append("\n   Property : " + po.getName());
                                    this.errPropertiesBuffer.append("\n    Old value : " + oldPropertyValue);
                                    this.errPropertiesBuffer.append("\n    New value : " + xlsCellValue);
                                    ++this.totalNonSuccessfullyAttemptedUpdatesCount;
                                    attemptedToUpdate = true;
                                    ++this.objErrPropsCount;
                                }
                            }
                            break;
                        }
                        ModelIDObject oo = (ModelIDObject)gMethod.invoke((Object)obj, new Object[0]);
                        if (oo != null) {
                            oldPropertyValue = oo.getName();
                        }
                        if (oldPropertyValue.equals(xlsCellValue)) continue;
                        Iterator objectsIt = this.collection.iterator();
                        boolean found = false;
                        ModelIDObject currentsearchableObj = null;
                        while (objectsIt.hasNext()) {
                            currentsearchableObj = (ModelIDObject)objectsIt.next();
                            if (!currentsearchableObj.getName().equals(xlsCellValue)) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                        sMethod.invoke((Object)obj, currentsearchableObj);
                        Object newPropertyValue = gMethod.invoke((Object)obj, new Object[0]);
                        if (oldPropertyValue != newPropertyValue) {
                            this.okPropertiesBuffer.append("\n   Property : " + po.getName());
                            this.okPropertiesBuffer.append("\n    Old value : " + oldPropertyValue);
                            this.okPropertiesBuffer.append("\n    New value : " + xlsCellValue);
                            ++this.totalSuccessfullyAttemptedUpdatesCount;
                            attemptedToUpdate = true;
                            obj.setDirty(true);
                            ++this.objOKayPropsCount;
                            continue;
                        }
                        this.errPropertiesBuffer.append("\n   Property : " + po.getName());
                        this.errPropertiesBuffer.append("\n    Old value : " + oldPropertyValue);
                        this.errPropertiesBuffer.append("\n    New value : " + xlsCellValue);
                        ++this.totalNonSuccessfullyAttemptedUpdatesCount;
                        attemptedToUpdate = true;
                        ++this.objErrPropsCount;
                        continue;
                    }
                    Iterator pNamesIt = obj.getPropertyNames();
                    while (pNamesIt.hasNext()) {
                        String name = (String)pNamesIt.next();
                        if (!name.equals(currentCellPropertyName)) continue;
                        oldPropertyValue = obj.getProperty(currentCellPropertyName);
                        obj.setProperty(currentCellPropertyName, xlsCellValue);
                        obj.setDirty(true);
                        this.okPropertiesBuffer.append("\n   Property : " + name);
                        this.okPropertiesBuffer.append("\n    Old value : " + oldPropertyValue);
                        this.okPropertiesBuffer.append("\n    New value : " + xlsCellValue);
                        ++this.totalSuccessfullyAttemptedUpdatesCount;
                        attemptedToUpdate = true;
                        continue block2;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("ImportExcelFile.updateValue() : ", e);
            }
        }
        return attemptedToUpdate;
    }

    private String getGeneralErrMsg() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n___________________________");
        sb.append("\n");
        sb.append("Error in importing data from excel file. Operation aborted.");
        sb.append("\nReasons can be:");
        sb.append("\n - This file is not originaly exported from Oracle SQL Developer Data Modeler.");
        sb.append("\n - Cell comments are modified/deleted");
        return sb.toString();
    }
}

