/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.process;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopViewListener;
import oracle.dbtools.crest.swingui.process.Messages;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;

public abstract class AbstractDataFlowTV
extends ContainerView {
    protected Set listeners = new HashSet();
    protected static Logger LOGGER = new Logger(AbstractDataFlowTV.class);

    public AbstractDataFlowTV(ApplicationView appView, DesignPartView dpv) {
        super(appView, dpv);
    }

    @Override
    public void addTopViewListener(TopViewListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeTopViewListener(TopViewListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void setModel(DesignObject object) {
        if (this.model != null) {
            this.model.removeObjectListener(this);
        }
        this.model = object;
        object.setTopView(this);
        this.model.addObjectListener(this);
    }

    @Override
    public DesignPartView getDesignPartView() {
        if (this.dpv == null) {
            return this.getApplicationView().getCurrentDPV();
        }
        return this.dpv;
    }

    @Override
    public String toString() {
        int i = this.getModel().getViewNumber(this);
        Object s = i == 0 ? "" : ":" + i;
        return this.getModel().getName() + (String)s;
    }

    @Override
    protected void fireChange(ObjectChangeEvent event) {
        TopViewListener[] listenersCopy = this.listeners.toArray(new TopViewListener[0]);
        for (int i = 0; i < listenersCopy.length; ++i) {
            try {
                listenersCopy[i].changed(this, event);
                continue;
            }
            catch (Exception e) {
                LOGGER.error("Listener caused exception: ", e);
            }
        }
    }

    @Override
    public void remove(boolean removeModel) {
        if (removeModel) {
            int res = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("AbstractDataFlowTV.SureYouWantToDelete"), this.getModel().getName()), Messages.getString("AbstractDataFlowTV.ConfirmObjectDelete"), 0);
            if (res == 0) {
                this.getModel().remove();
                this.getDesignPartView().getWorkSpace().repaint();
            }
        } else {
            this.doPrivateActions();
            this.getDesignPartView().removeView(this);
            if (this.getCellView() != null) {
                Object[] cells = new Object[]{this.getCellView().getCell()};
                this.getDesignPartView().getWorkSpace().removeCells(cells);
                this.getDesignPartView().getWorkSpace().repaint();
            }
        }
    }

    public void addTVFlows() {
    }

    public boolean isConnected() {
        AbstractProcessObject po = (AbstractProcessObject)this.getModel();
        Flow.Connection[] flows = po.getAllFlows();
        for (int i = 0; i < flows.length; ++i) {
            Flow flow = flows[i].getFlow();
            if (flow.getViewFor(this.getDesignPartView()) == null) continue;
            return true;
        }
        return false;
    }
}

