/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.printing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.JViewport;
import oracle.dbtools.crest.swingui.printing.PagePreview;
import oracle.dbtools.crest.swingui.printing.PrintPreviewModel;

public class PrintPreviewView
extends JPanel
implements Observer {
    private PrintPreviewModel model;

    public PrintPreviewView(PrintPreviewModel model) {
        this.model = model;
        this.model.addObserver(this);
        this.model.updateObservers(this);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        int n = this.getComponentCount();
        if (n == 0) {
            return new Dimension(16, 10);
        }
        Component comp = this.getComponent(0);
        Dimension dc = comp.getPreferredSize();
        int w = dc.width;
        int h = dc.height;
        Dimension dp = this.getParent().getSize();
        int nCol = Math.max((dp.width - 16) / (w + 16), 1);
        int nRow = n / nCol;
        if (nRow * nCol < n) {
            ++nRow;
        }
        int ww = nCol * (w + 16) + 16;
        int hh = nRow * (h + 10) + 10;
        Insets ins = this.getInsets();
        return new Dimension(ww + ins.left + ins.right, hh + ins.top + ins.bottom);
    }

    @Override
    public void doLayout() {
        Insets ins = this.getInsets();
        int x = ins.left + 16;
        int y = ins.top + 10;
        int n = this.getComponentCount();
        if (n == 0) {
            return;
        }
        Component comp = this.getComponent(0);
        Dimension dc = comp.getPreferredSize();
        int w = dc.width;
        int h = dc.height;
        Dimension dp = this.getParent().getSize();
        int nCol = Math.max((dp.width - 16) / (w + 16), 1);
        int nRow = n / nCol;
        if (nRow * nCol < n) {
            ++nRow;
        }
        int index = 0;
        for (int k = 0; k < nRow; ++k) {
            for (int m = 0; m < nCol; ++m) {
                if (index >= n) {
                    return;
                }
                comp = this.getComponent(index++);
                comp.setBounds(x, y, w, h);
                x += w + 16;
            }
            y += h + 10;
            x = ins.left + 16;
        }
    }

    public void prepareGC() {
        Component[] cmps = this.getComponents();
        if (cmps != null) {
            for (int i = 0; i < cmps.length; ++i) {
                if (!(cmps[i] instanceof PagePreview)) continue;
                if (cmps[i].getGraphics() != null) {
                    cmps[i].getGraphics().dispose();
                }
                cmps[i] = null;
            }
        }
        cmps = null;
        this.removeAll();
        this.repaint();
    }

    @Override
    public void update(Observable o, Object arg) {
        this.prepareGC();
        int numberOfPages = this.model.getNumberOfPages();
        for (int pageindex = 0; pageindex < numberOfPages; ++pageindex) {
            PagePreview pp = new PagePreview(this.model, pageindex);
            this.add(pp);
        }
        Container parent = this.getParent();
        if (parent instanceof JViewport) {
            parent = parent.getParent();
        }
        if (parent != null) {
            ((Component)parent).validate();
        }
    }
}

