/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.printing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.printing.Messages;
import oracle.dbtools.crest.swingui.printing.PDFPrinter;
import oracle.dbtools.crest.swingui.printing.PrintPreviewModel;
import oracle.dbtools.crest.util.print.Config;

public class PrintPreviewController
extends JPanel
implements ActionListener {
    private PrintPreviewModel model;
    private PrinterJob prnJob;
    private JLabel jlblZoomPrint;
    private JComboBox jedtZoomPrint;
    private JLabel jlblZoomPreview;
    private JComboBox jedtZoomPreview;
    private JButton jactPageSetup;
    private JButton jactPrint;
    GUIConfiguration config = GUIConfiguration.getInstance();
    private JLabel lbNbrPages;
    private JDialog dialog = null;
    private JCheckBox chPrintToPDF;

    public PrintPreviewController(PrintPreviewModel model) {
        this.model = model;
        this.initGUIComponents();
        this.prnJob = PrinterJob.getPrinterJob();
        this.updateNumberOfPagesLabel(model.getNumberOfPages());
    }

    private void initGUIComponents() {
        this.setLayout(new BorderLayout());
        JPanel jpanel = new JPanel(new FlowLayout(0));
        this.jlblZoomPreview = new JLabel(Messages.getString("PrintPreviewController.Zoom"));
        String[] scales = new String[]{"25%", "50%", "75%", "100%", "200%", "400%"};
        this.jedtZoomPreview = new JComboBox<String>(scales);
        this.jedtZoomPreview.setPreferredSize(new Dimension(70, 20));
        this.jedtZoomPreview.setMinimumSize(this.jedtZoomPreview.getPreferredSize());
        this.jedtZoomPreview.setMaximumSize(this.jedtZoomPreview.getPreferredSize());
        this.jedtZoomPreview.setEditable(true);
        this.jedtZoomPreview.setSelectedItem(this.model.getPreviewXScalingFactor() + "%");
        this.jedtZoomPreview.addActionListener(this);
        this.jlblZoomPrint = new JLabel(Messages.getString("PrintPreviewController.PrintScale"));
        this.jedtZoomPrint = new JComboBox<String>(scales);
        this.jedtZoomPrint.setPreferredSize(new Dimension(70, 20));
        this.jedtZoomPrint.setMinimumSize(this.jedtZoomPrint.getPreferredSize());
        this.jedtZoomPrint.setMaximumSize(this.jedtZoomPrint.getPreferredSize());
        this.jedtZoomPrint.setEditable(true);
        this.jedtZoomPrint.setSelectedItem(this.model.getPrintXScalingFactor() + "%");
        this.jedtZoomPrint.addActionListener(this);
        Icon icon = this.config.getIcon("PAGE_SETUP_ICON");
        this.jactPageSetup = new JButton(Messages.getString("PrintPreviewController.PageSetup"), icon);
        this.jactPageSetup.addActionListener(this);
        icon = this.config.getIcon("PRINT_ICON");
        this.jactPrint = new JButton(Messages.getString("PrintPreviewController.Print"), icon);
        this.jactPrint.setPreferredSize(this.jactPageSetup.getPreferredSize());
        this.jactPrint.addActionListener(this);
        this.chPrintToPDF = new JCheckBox(Messages.getString("PrintPreviewController.PrintToPDF"));
        this.lbNbrPages = new JLabel();
        jpanel.add(this.jlblZoomPrint);
        jpanel.add(this.jedtZoomPrint);
        jpanel.add(new JPanel());
        jpanel.add(this.jlblZoomPreview);
        jpanel.add(this.jedtZoomPreview);
        jpanel.add(new JPanel());
        jpanel.add(this.jactPageSetup);
        jpanel.add(new JPanel());
        jpanel.add(this.jactPrint);
        jpanel.add(new JPanel());
        jpanel.add(this.chPrintToPDF);
        jpanel.add(new JPanel());
        jpanel.add(this.lbNbrPages);
        this.add((Component)jpanel, "Center");
        JPanel pnClose = new JPanel();
        JButton bnClose = new JButton(Messages.getString("PrintPreviewController.Close"));
        bnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PrintPreviewController.this.dialog != null) {
                    PrintPreviewController.this.dialog.dispose();
                }
            }
        });
        bnClose.setPreferredSize(this.jactPageSetup.getPreferredSize());
        pnClose.add(bnClose);
        this.add((Component)pnClose, "East");
    }

    private void updateNumberOfPagesLabel(int n) {
        this.lbNbrPages.setText(String.format(Messages.getString("PrintPreviewController.Pages"), n));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object cmp = e.getSource();
        if (cmp == this.jactPageSetup) {
            this.pageSetup();
        } else if (cmp == this.jedtZoomPrint) {
            this.zoomPrint();
        } else if (cmp == this.jedtZoomPreview) {
            this.zoomPreview();
        } else if (cmp == this.jactPrint) {
            this.print();
        }
    }

    private void zoomPrint() {
        try {
            int zoom = this.validateZoomFactor(this.jedtZoomPrint.getSelectedItem().toString());
            this.model.setPrintScalingFactors(zoom, zoom);
            this.updateNumberOfPagesLabel(this.model.getNumberOfPages());
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this, nfe.getMessage());
            this.jedtZoomPrint.setSelectedItem(this.model.getPrintXScalingFactor() + "%");
        }
    }

    private void zoomPreview() {
        try {
            int zoom = this.validateZoomFactor(this.jedtZoomPreview.getSelectedItem().toString());
            this.model.setPreviewScalingFactors(zoom, zoom);
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this, nfe.getMessage());
            this.jedtZoomPreview.setSelectedItem(this.model.getPreviewXScalingFactor() + "%");
        }
    }

    public void pageSetup() {
        Config conf = Config.getConfig();
        if (conf.openPageSetup()) {
            this.model.setPageFormat(conf.getPageFormat());
            this.updateNumberOfPagesLabel(this.model.getNumberOfPages());
            ApplicationView.getInstance().savePageSetupSettings(conf);
        }
    }

    public void print() {
        try {
            if (this.model.getObjectToPrint() instanceof Diagram) {
                if (this.chPrintToPDF.isSelected()) {
                    new PDFPrinter(this.prnJob, this.model, this.chPrintToPDF.isSelected()).print();
                } else if (this.prnJob.printDialog()) {
                    new PDFPrinter(this.prnJob, this.model, this.chPrintToPDF.isSelected()).print();
                }
            } else {
                this.prnJob.setPageable(this.model);
                if (this.prnJob.printDialog()) {
                    this.prnJob.print();
                }
            }
        }
        catch (PrinterException pe) {
            JOptionPane.showMessageDialog(this, pe.getMessage());
        }
    }

    private int validateZoomFactor(String zoom) throws NumberFormatException {
        if (zoom.endsWith("%")) {
            zoom = zoom.substring(0, zoom.length() - 1);
        }
        zoom = zoom.trim();
        int number = 0;
        try {
            number = Integer.parseInt(zoom);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(Messages.getString("PrintPreviewController.EnterZoomFactorBetween"));
        }
        if (number < 2 || number > 1000) {
            throw new NumberFormatException(Messages.getString("PrintPreviewController.EnterZoomFactorBetween"));
        }
        return number;
    }

    public void setDialog(JDialog dialog) {
        this.dialog = dialog;
    }
}

