/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.printing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import oracle.dbtools.crest.swingui.printing.PrintPreviewModel;

public class PagePreview
extends JPanel {
    private int previewWidth;
    private int previewHeight;
    private int pageindex;
    private PrintPreviewModel model;

    public PagePreview(PrintPreviewModel model, int pageindex) {
        this.previewWidth = model.getPreviewWidth();
        this.previewHeight = model.getPreviewHeight();
        this.pageindex = pageindex;
        this.model = model;
        this.setBackground(Color.white);
        this.setBorder(new MatteBorder(1, 1, 2, 2, Color.black));
    }

    @Override
    public final void setBackground(Color c) {
        super.setBackground(c);
    }

    @Override
    public final void setBorder(Border b) {
        super.setBorder(b);
    }

    @Override
    public Dimension getPreferredSize() {
        Insets ins = this.getInsets();
        return new Dimension(this.previewWidth + ins.left + ins.right, this.previewHeight + ins.top + ins.bottom);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.paintBorder(g);
        this.model.printPreview(g, this.pageindex);
    }
}

