/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.logical;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.InheritanceRelation;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.placeholder.PlaceHolder;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.ModelPropertiesDialogEx;
import oracle.dbtools.crest.swingui.logical.ControllerLogical;
import oracle.dbtools.crest.swingui.logical.DPVLogical;
import oracle.dbtools.crest.swingui.logical.Messages;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.swingui.logical.TVEntityView;
import oracle.dbtools.crest.swingui.logical.TVInheritanceRelation;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.swingui.relational.TVView;

public class DPVLogicalSubView
extends DPVLogical {
    private AbstractController controller;
    private DesignObjectCollection tvEntities = new DesignObjectCollection(true);
    private DesignObjectCollection tvViews = new DesignObjectCollection(true);
    private DesignObjectCollection tvRelations = new DesignObjectCollection(true);
    private DesignObjectCollection tvInhRelations = new DesignObjectCollection(true);

    public DPVLogicalSubView(ApplicationView appView, DesignPart desPart) {
        super(appView, desPart);
        ((LogicalDesign)desPart).getEntitySet().addSetListener(this.tvEntities);
        ((LogicalDesign)desPart).getEntityViewSet().addSetListener(this.tvViews);
        ((LogicalDesign)desPart).getRelationSet().addSetListener(this.tvRelations);
        ((LogicalDesign)desPart).getInheritanceRelationSet().addSetListener(this.tvInhRelations);
        this.controller = new ControllerLogical(appView);
        this.controller.setName("Logical_SubView");
        this.controller.setDesignPartView(this);
        this.tvEntities.setElementDescriptor(Entity.class);
        this.tvEntities.setName(Messages.getString("DPVLogicalSubView.Entities"));
        this.tvViews.setElementDescriptor(EntityView.class);
        this.tvViews.setName(Messages.getString("DPVLogicalSubView.Views"));
        this.tvRelations.setElementDescriptor(Relation.class);
        this.tvRelations.setName(Messages.getString("DPVLogicalSubView.Relations"));
        this.tvInhRelations.setElementDescriptor(InheritanceRelation.class);
        this.tvInhRelations.setName(Messages.getString("DPVLogicalSubView.Hierarchies"));
    }

    @Override
    public void clearDPV() {
        ((LogicalDesign)this.getDesignPart()).getEntitySet().removeSetListener(this.tvEntities);
        ((LogicalDesign)this.getDesignPart()).getEntityViewSet().removeSetListener(this.tvViews);
        ((LogicalDesign)this.getDesignPart()).getRelationSet().removeSetListener(this.tvRelations);
        ((LogicalDesign)this.getDesignPart()).getInheritanceRelationSet().removeSetListener(this.tvInhRelations);
        super.clearDPV();
    }

    @Override
    public void sortCollections() {
        this.tvEntities.sort();
        this.tvViews.sort();
        this.tvRelations.sort();
        this.tvInhRelations.sort();
    }

    @Override
    public void objectAdded(DesignPart designPart, DesignObject object) {
        if (ApplicationView.loading || !this.isCurrentDPV()) {
            return;
        }
        TopView view = this.getViewFor(object);
        if (view == null) {
            this.addViewFor(object);
        }
    }

    @Override
    public TopView createViewFor(DesignObject object) {
        if (ApplicationView.loading || !this.isCurrentDPV()) {
            return null;
        }
        return this.createTopViewFor(object);
    }

    @Override
    public int getNumberOfChildren() {
        return 5;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.tvEntities;
            }
            case 1: {
                return this.tvViews;
            }
            case 2: {
                return this.tvRelations;
            }
            case 3: {
                return this.tvInhRelations;
            }
            case 4: {
                return this.getDisplays();
            }
        }
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.tvEntities) {
            return 0;
        }
        if (child == this.tvViews) {
            return 1;
        }
        if (child == this.tvRelations) {
            return 2;
        }
        if (child == this.tvInhRelations) {
            return 3;
        }
        if (child == this.getDisplays()) {
            return 4;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public AbstractController getController() {
        return this.controller;
    }

    @Override
    public void setPlaceHolder(PlaceHolder host) {
        super.setPlaceHolder(host);
        this.tvEntities.setParent(this.getPlaceHolder());
        this.tvViews.setParent(this.getPlaceHolder());
        this.tvRelations.setParent(this.getPlaceHolder());
        this.tvInhRelations.setParent(this.getPlaceHolder());
        this.getDisplays().setParent(this.getPlaceHolder());
    }

    @Override
    public boolean isMainDiagram() {
        return false;
    }

    @Override
    public void registerForTreemodel(TopView tv) {
        DesignObjectPlaceHolder tvph = new DesignObjectPlaceHolder(tv.getModel().getDesignPart(), tv.getModel());
        tvph.setTopView(tv);
        if (tv instanceof TVEntity && !this.tvEntities.containsPlaceHolderFor(tv.getModel())) {
            this.tvEntities.add(tvph);
        } else if (tv instanceof TVEntityView && !this.tvViews.containsPlaceHolderFor(tv.getModel())) {
            this.tvViews.add(tvph);
        } else if (tv instanceof TVInheritanceRelation && !this.tvInhRelations.containsPlaceHolderFor(tv.getModel())) {
            this.tvInhRelations.add(tvph);
        } else if (tv instanceof TVRelation && !this.tvRelations.containsPlaceHolderFor(tv.getModel())) {
            this.tvRelations.add(tvph);
        }
        if (this.getViewFor(tv.getModel()) == null) {
            this.modelToView.put(tv.getModel(), tv);
        }
    }

    @Override
    public void unregisterFromTreemodel(TopView tv) {
        if (tv != null) {
            this.unregisterTopView(tv);
            DesignObject object = tv.getModel();
            TopView firstv = this.getFirstViewFor(object);
            if (firstv == null) {
                if (tv instanceof TVEntity) {
                    this.tvEntities.removePlaceHolderFor(object);
                }
                if (tv instanceof TVView) {
                    this.tvViews.removePlaceHolderFor(object);
                }
                if (tv instanceof TVInheritanceRelation) {
                    this.tvInhRelations.removePlaceHolderFor(object);
                }
                if (tv instanceof TVRelation) {
                    this.tvRelations.removePlaceHolderFor(object);
                }
            }
        }
    }

    public Collection getTVEnities() {
        ArrayList<TopView> col = new ArrayList<TopView>();
        for (TopView tv : this.topViews) {
            if (!(tv instanceof TVEntity)) continue;
            col.add(tv);
        }
        return col;
    }

    @Override
    public Collection getTVEntityViews() {
        ArrayList<TopView> col = new ArrayList<TopView>();
        for (TopView tv : this.topViews) {
            if (!(tv instanceof TVEntityView)) continue;
            col.add(tv);
        }
        return col;
    }

    public Collection getTVRelations() {
        ArrayList<TopView> col = new ArrayList<TopView>();
        for (TopView tv : this.topViews) {
            if (!(tv instanceof TVRelation)) continue;
            col.add(tv);
        }
        return col;
    }

    public void rearrangeDiagram() {
        int left = 20;
        int top = 20;
        int width = 35;
        int height = 25;
        int count = 0;
        Collection entities = this.getTVEnities();
        float square = (float)Math.sqrt(entities.size());
        long maxTablePerRow = (int)square;
        if (Math.sqrt(square * square) != (double)square) {
            ++maxTablePerRow;
        }
        ++maxTablePerRow;
        Iterator it = entities.iterator();
        while (it.hasNext()) {
            Dimension dim;
            ++count;
            TopView topView = (TopView)it.next();
            Entity ent = (Entity)topView.getModel();
            if (ent.isHierarchicalEntityType() && this.isBoxInBox()) {
                if (!ent.isHierarchicalRoot()) continue;
                HashMap map = new HashMap();
                dim = this.getHierEntitySize(ent, topView, this.getFontMetrics(topView), map);
            } else {
                dim = this.getEntitySize(topView, ent);
            }
            width = dim.width;
            height = Math.max(dim.height, height);
            if (topView.getCellView() != null) {
                topView.getCellView().setNewBounds(new Rectangle(new Point(left, top), dim));
            } else {
                topView.setBounds(new Rectangle(new Point(left, top), dim));
            }
            left = left + width + 50;
            if ((long)count != maxTablePerRow) continue;
            count = 0;
            left = 20;
            top = top + height + 50;
            height = 25;
        }
    }

    @Override
    public DesignPartView createSubordinateView(ApplicationView applicationView, DesignPart desPart) {
        return new DPVLogicalSubView(this.getApplicationView(), this.getDesignPart());
    }

    @Override
    protected void showPropertiesDialog() {
        if (!this.getPlaceHolder().isDialogVisible()) {
            ModelPropertiesDialogEx dialog = new ModelPropertiesDialogEx(this.getDesign().getAppView(), this.getPlaceHolder());
            dialog.initProperties(this.getPlaceHolder());
            dialog.show();
        }
    }

    @Override
    public void setVisible(boolean flag) {
        super.setVisible(flag);
        if (flag && this.isBoxInBox()) {
            this.fixBoxInBox();
        }
    }

    @Override
    public void setVisible(boolean flag, ProgressDialog monitor) {
        super.setVisible(flag, monitor);
        if (flag && this.isBoxInBox()) {
            this.fixBoxInBox();
        }
    }
}

