/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.logical;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import oracle.dbtools.crest.fcp.SearchDockable;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.ImageObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.compare.cwddesign.MergingCWDDesigns;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GlassComponent;
import oracle.dbtools.crest.swingui.MDBAction;
import oracle.dbtools.crest.swingui.MenuUtils;
import oracle.dbtools.crest.swingui.PointsEnteredCallback;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerDiagramCell;
import oracle.dbtools.crest.swingui.diagram.logical.EntityDiagramCell;
import oracle.dbtools.crest.swingui.editor.logical.RelationPropertiesDialogEx;
import oracle.dbtools.crest.swingui.engineeringcompare.EngineeringCompareDialog;
import oracle.dbtools.crest.swingui.logical.DPVLogical;
import oracle.dbtools.crest.swingui.logical.Messages;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.swingui.search.SearchPanel;
import oracle.dbtools.crest.util.GUID;
import oracle.ide.Ide;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.layout.ViewId;

public class ControllerLogical
extends AbstractController {
    private DockStation dockStation = null;
    private Select select;
    private ZoomIn zoomIn;
    private ZoomOut zoomOut;
    private FitScreen fitScreen;
    private ActualSize actualSize;
    private Search search;
    private FWDEngineer fwdEngineer;
    private EntityCollector eCollector = null;
    private NewArc newArc;
    private AddToArc add2Arc;
    private RemoveFromArc removeFromArc;
    private NewEntity newEntity;
    private NewEntityView newEntityView;
    private NewRelationManyToMany newRelMany2Many;
    private NewRelationOneToMany newRelOne2Many;
    private NewRelationOneToManyIdentifying newRelOne2ManyIdent;
    private NewRelationOneToOne newRelOne2One;
    private NewTypeSubstitution newTypeSubstitution;
    private NewNote newNote;
    private NewImage newImage;
    private Delete delete;
    DesignPartView designPV = null;
    private final String[] OBJECT_LOGICAL_PATH = new String[]{AbstractController.OBJECT_CAPTION, AbstractController.LOGICAL_CAPTION};
    private final String[] DESIGN_PATH = new String[]{AbstractController.DESIGN_CAPTION};

    public ControllerLogical(ApplicationView appView) {
        super(appView);
    }

    @Override
    public void initializeActions() {
        if (this.isEditable()) {
            this.select = new Select();
            this.newEntity = new NewEntity();
            this.newEntityView = new NewEntityView();
            this.newRelMany2Many = new NewRelationManyToMany();
            this.newRelOne2Many = new NewRelationOneToMany();
            this.newRelOne2ManyIdent = new NewRelationOneToManyIdentifying();
            this.newRelOne2One = new NewRelationOneToOne();
            this.newTypeSubstitution = new NewTypeSubstitution();
            this.newNote = new NewNote();
            this.newImage = new NewImage();
            this.delete = new Delete();
            this.newArc = new NewArc();
            this.add2Arc = new AddToArc();
            this.removeFromArc = new RemoveFromArc();
            this.fwdEngineer = new FWDEngineer();
            this.add(this.select);
            this.add(this.newEntity);
            this.add(this.newEntityView);
            this.add(this.newRelMany2Many);
            this.add(this.newRelOne2Many);
            this.add(this.newRelOne2ManyIdent);
            this.add(this.newRelOne2One);
            this.add(this.newTypeSubstitution);
            this.add(this.newArc);
            this.add(this.add2Arc);
            this.add(this.removeFromArc);
            this.add(this.newNote);
            this.add(this.newImage);
            this.add(this.delete);
            this.add(this.fwdEngineer);
        }
        this.zoomIn = new ZoomIn();
        this.add(this.zoomIn);
        this.zoomOut = new ZoomOut();
        this.add(this.zoomOut);
        this.fitScreen = new FitScreen();
        this.add(this.fitScreen);
        this.actualSize = new ActualSize();
        this.add(this.actualSize);
        this.search = new Search();
        this.add(this.search);
    }

    @Override
    public String getToolBarName() {
        return Messages.getString("ControllerLogical.Logical");
    }

    public DPVLogical getDPVLogical() {
        return this.getApplicationView().getDPVLogical();
    }

    @Override
    public void setDesignPartView(DesignPartView dpv) {
        this.designPV = dpv;
    }

    @Override
    public DesignPartView getDesignPartView() {
        if (this.designPV != null) {
            return this.designPV;
        }
        return this.getDPVLogical();
    }

    @Override
    public boolean canPaste() {
        for (Object obj : this.getApplicationView().getCopiedObjects()) {
            if (obj == null || !(obj instanceof Entity) && !(obj instanceof EntityView) && !(obj instanceof Relation) && !(obj instanceof Note) && !(obj instanceof ImageObject)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paste(Point pt) {
        try {
            Entity ent;
            Entity tent;
            Rectangle2D rect;
            DesignPartView dpv = this.getDesignPartView();
            ApplicationView.canLogging = false;
            int xx = 0;
            int yy = 0;
            Point2D pp = null;
            if (pt != null) {
                pp = this.getDesignPartView().getWorkSpace().fromScreen(new Point2D.Double(pt.x, pt.y));
            } else {
                Rectangle2D r2d = this.getDesignPartView().getTopViewsBounds();
                Rectangle r = null;
                if (r2d != null) {
                    r = r2d.getBounds();
                }
                pp = r != null ? new Point2D.Double(r.x, r.y + r.height + 10) : new Point2D.Double(10.0, 10.0);
            }
            ArrayList<TopView> selectedTVs = this.getApplicationView().getCopiedTopViews();
            DesignPartView sdpv = null;
            DesignPartView tdpv = this.getDesignPartView();
            boolean noTVs = false;
            if (selectedTVs.size() == 0) {
                noTVs = true;
                selectedTVs = new ArrayList<TopView>();
                for (Object obj : this.getApplicationView().getCopiedObjects()) {
                    if (!(obj instanceof DesignObject)) continue;
                    selectedTVs.add(((DesignObject)obj).getTopView());
                }
            }
            if (selectedTVs.size() > 0) {
                sdpv = ((TopView)selectedTVs.get(0)).getDesignPartView();
            }
            if ((rect = this.getDesignPartView().getTopViewsBounds(selectedTVs)) != null && sdpv != null && sdpv == this.getDesignPartView()) {
                xx = (int)(pp.getX() - rect.getX());
                yy = (int)(pp.getY() - rect.getY());
            } else {
                xx = (int)(pp.getX() - rect.getX());
                yy = (int)(pp.getY() - rect.getY());
            }
            HashMap<DesignObject, DesignObject> map = new HashMap<DesignObject, DesignObject>();
            Iterator it = selectedTVs.iterator();
            HashMap<String, ID_ObjectPropertyTranslator> copiedMap = new HashMap<String, ID_ObjectPropertyTranslator>();
            ArrayList<DesignObject> entities = new ArrayList<DesignObject>();
            while (it.hasNext()) {
                DesignObject obj;
                TopView topView = (TopView)it.next();
                Rectangle r = topView.getBounds();
                if (topView.getCellView() != null) {
                    r = new Rectangle(topView.getCellView().getBounds().getBounds());
                }
                if (!map.containsKey(obj = topView.getModel())) {
                    TopView ctv;
                    TopView topView2;
                    TopView topView3;
                    TopView topView4;
                    map.put(obj, obj);
                    boolean process = false;
                    if (!(obj instanceof DesignObject)) continue;
                    DesignObject copied = obj;
                    ContainerWithKeyObject newObj = null;
                    if (copied instanceof Entity) {
                        ApplicationView.log(Messages.getString("ControllerLogical.CreateEntity"));
                        newObj = ((LogicalDesign)this.getDesignPartView().getDesignPart()).createEntity();
                        copiedMap.put(copied.getObjectID(), newObj);
                        ((Entity)copied).copy(newObj, copiedMap);
                        entities.add(copied);
                        topView4 = this.getDesignPartView().getViewFor(newObj);
                        if (topView4 != null && topView4.getCellView() != null) {
                            copiedMap.put(topView.getViewID(), topView4);
                            if (pp != null) {
                                r.x += xx;
                                r.y += yy;
                            } else {
                                r.x += 30 + xx;
                                r.y += 30 + yy;
                            }
                            topView.copy(topView4);
                            topView4.getCellView().setNewBounds(r);
                        }
                    } else if (copied instanceof EntityView) {
                        ApplicationView.log(Messages.getString("ControllerLogical.CreateEntityView"));
                        newObj = ((LogicalDesign)this.getDesignPartView().getDesignPart()).createEntityView();
                        copiedMap.put(copied.getObjectID(), newObj);
                        copied.copy(newObj);
                        topView4 = this.getDesignPartView().getViewFor(newObj);
                        if (topView4 != null && topView4.getCellView() != null) {
                            copiedMap.put(topView.getViewID(), topView4);
                            if (pp != null) {
                                r.x += xx;
                                r.y += yy;
                            } else {
                                r.x += 30 + xx;
                                r.y += 30 + yy;
                            }
                            topView.copy(topView4);
                            topView4.getCellView().setNewBounds(r);
                        }
                    } else if (obj instanceof Note) {
                        ApplicationView.log(Messages.getString("ControllerLogical.CreateNote"));
                        Note note = ((LogicalDesign)this.getDesignPartView().getDesignPart()).createNote();
                        copied.copy(note);
                        process = false;
                        topView3 = this.getDesignPartView().getViewFor(note);
                        if (topView3 != null && topView3.getCellView() != null) {
                            copiedMap.put(topView.getViewID(), topView3);
                            TopView ctv2 = topView;
                            if (ctv2 != null) {
                                if (pp != null) {
                                    r.x = (int)pp.getX() + xx;
                                    r.y = (int)pp.getY() + yy;
                                } else {
                                    r.x += 30 + xx;
                                    r.y += 30 + yy;
                                }
                                topView3.getCellView().setNewBounds(r);
                                ctv2.copy(topView3);
                            }
                        }
                    } else if (obj instanceof ImageObject) {
                        ApplicationView.log(Messages.getString("ControllerLogical.CreateImage"));
                        ImageObject image = ((LogicalDesign)this.getDesignPartView().getDesignPart()).createImage();
                        copied.copy(image);
                        process = false;
                        topView3 = this.getDesignPartView().getViewFor(image);
                        if (topView3 != null && topView3.getCellView() != null) {
                            copiedMap.put(topView.getViewID(), topView3);
                            TopView ctv2 = topView;
                            if (ctv2 != null) {
                                if (pp != null) {
                                    r.x += xx;
                                    r.y += yy;
                                } else {
                                    r.x += 30 + xx;
                                    r.y += 30 + yy;
                                }
                                topView.copy(topView3);
                                topView3.getCellView().setNewBounds(r);
                            }
                        }
                    }
                    if (!process || newObj == null || (topView2 = this.getDesignPartView().getViewFor(newObj)) == null || topView2.getCellView() == null || (ctv = copied.getTopView()) == null || ctv.getCellView() == null) continue;
                    if (pp != null) {
                        r.x += xx;
                        r.y += yy;
                    } else {
                        r.x += 30 + xx;
                        r.y += 30 + yy;
                    }
                    topView.copy(topView2);
                    topView2.getCellView().setNewBounds(r);
                    continue;
                }
                DesignObject copied = (DesignObject)copiedMap.get(obj.getObjectID());
                if (copied == null) continue;
                TopView topView5 = tdpv.createTopViewFor(copied);
                tdpv.add(topView5);
                if (topView5 == null || topView5.getCellView() == null) continue;
                copiedMap.put(topView.getViewID(), topView5);
                TopView ctv = topView;
                if (ctv == null) continue;
                if (pp != null) {
                    r.x += xx;
                    r.y += yy;
                } else {
                    r.x += 30 + xx;
                    r.y += 30 + yy;
                }
                ctv.copy(topView5);
                topView5.getCellView().setNewBounds(r);
            }
            this.processAttributeProps(entities, copiedMap);
            for (Object e : entities) {
                Entity parent;
                if (!(e instanceof Entity) || (tent = (Entity)copiedMap.get((ent = (Entity)e).getObjectID())) == null || (parent = ent.getHierarchicalParent()) == null) continue;
                Entity newparent = (Entity)copiedMap.get(parent.getObjectID());
                if (newparent != null) {
                    tent.setHierarchicalParent(newparent);
                    continue;
                }
                if (ent.getDesign() != tent.getDesign()) continue;
                tent.setHierarchicalParent(parent);
            }
            for (Object e : entities) {
                if (!(e instanceof Entity) || (tent = (Entity)copiedMap.get((ent = (Entity)e).getObjectID())) == null) continue;
                List rels = ((LogicalDesign)ent.getDesignPart()).getRelationSet().getRelationsTo(ent);
                for (Relation rel : rels) {
                    Relation targetRelation = null;
                    boolean newrel = false;
                    targetRelation = (Relation)copiedMap.get(rel.getObjectID());
                    if (targetRelation == null) {
                        targetRelation = MergingCWDDesigns.copyRelationShiptoNew(rel, this.getLogicalDesign(), copiedMap);
                        copiedMap.put(rel.getObjectID(), targetRelation);
                        newrel = true;
                        if (targetRelation == null || targetRelation.getDesign() != rel.getDesign()) {
                            // empty if block
                        }
                    }
                    if (!newrel || targetRelation == null) continue;
                    if (targetRelation.getSourceObject() == targetRelation.getTargetObject()) {
                        targetRelation.createDefaultSelfReferencePoints();
                    }
                    TopView ostv = rel.getSourceTopView(sdpv);
                    TopView ottv = rel.getTargetTopView(sdpv);
                    if (ostv != null && ottv != null) {
                        TopView nstv = (TopView)copiedMap.get(ostv.getViewID());
                        TopView nttv = (TopView)copiedMap.get(ottv.getViewID());
                        if (nstv != null && nttv != null) {
                            targetRelation.setTargetTopView(nttv);
                            targetRelation.setSourceTopView(nstv);
                        }
                        TVConnector stvc = (TVConnector)rel.getViewFor(sdpv);
                        TVConnector ttvc = (TVConnector)targetRelation.getViewFor(tdpv);
                        if (stvc != null && ttvc != null) {
                            sdpv.copyConectorPoints(stvc, ttvc, xx, yy);
                        }
                    }
                    for (TVRelation tv : targetRelation.getAllTVRelations()) {
                        tv.resetEdgeParams();
                    }
                }
            }
            for (Object e : entities) {
                if (!(e instanceof Entity) || (tent = (Entity)copiedMap.get((ent = (Entity)e).getObjectID())) == null) continue;
                for (Arc arc : ent.getArcs()) {
                    MergingCWDDesigns.processArc(arc, copiedMap);
                }
            }
            this.getDesignPartView().getDesignPart().sortCollections();
            this.getDesignPartView().sortCollections();
        }
        finally {
            ApplicationView.canLogging = true;
        }
    }

    private void processAttributeProps(List entities, Map copyMap) {
        for (Entity sourceEntity : entities) {
            ContainedObject[] elems = sourceEntity.getElements();
            for (int i = 0; i < elems.length; ++i) {
                Attribute refTarget;
                Attribute target;
                Attribute attr = (Attribute)elems[i];
                String refID = attr.getReferedAttribute();
                if (refID == null || (target = (Attribute)copyMap.get(attr.getObjectID())) == null || (refTarget = (Attribute)copyMap.get(refID)) == null) continue;
                target.setReferedAttribute(refTarget.getObjectID());
            }
        }
    }

    public JMenu getObjectLogicalMenu() {
        return this.getApplicationView().getControllerSet().getMenuStructure().get(this.OBJECT_LOGICAL_PATH);
    }

    @Override
    public void select_SelectAction() {
        if (this.eCollector != null) {
            this.eCollector.stopWaiting();
        }
        this.getDesignPartView().getWorkSpace().setDrawnObjectID(-1);
        this.getDesignPartView().getWorkSpace().setCursor(new Cursor(0));
    }

    public Select getSelectAction() {
        return this.select;
    }

    public NewEntity getNewEntityAction() {
        return this.newEntity;
    }

    public NewEntityView getNewEntityViewAction() {
        return this.newEntityView;
    }

    public NewRelationManyToMany getNewRelationManyToManyAction() {
        return this.newRelMany2Many;
    }

    public NewRelationOneToMany getNewRelationOneToManyAction() {
        return this.newRelOne2Many;
    }

    public NewRelationOneToManyIdentifying getNewRelationOneToManyIdentifyingAction() {
        return this.newRelOne2ManyIdent;
    }

    public NewRelationOneToOne getNewRelationOneToOneAction() {
        return this.newRelOne2One;
    }

    public NewTypeSubstitution getNewTypeSubstitutionAction() {
        return this.newTypeSubstitution;
    }

    public NewNote getNewNoteAction() {
        return this.newNote;
    }

    public NewImage getNewImageAction() {
        return this.newImage;
    }

    public Delete getDeleteAction() {
        return this.delete;
    }

    public FWDEngineer getFWDEngineerAction() {
        return this.fwdEngineer;
    }

    public NewArc getNewArcAction() {
        return this.newArc;
    }

    public AddToArc getAddToArcAction() {
        return this.add2Arc;
    }

    public RemoveFromArc getRemoveFromArcAction() {
        return this.removeFromArc;
    }

    public ZoomIn getZoomInAction() {
        return this.zoomIn;
    }

    public ZoomOut getZoomOutAction() {
        return this.zoomOut;
    }

    public FitScreen getFitScreenAction() {
        return this.fitScreen;
    }

    public ActualSize getDefaultSizeAction() {
        return this.actualSize;
    }

    @Override
    public MDBAction getFindAction() {
        return this.search;
    }

    @Override
    public void updateActions() {
        boolean enabled = true;
        if (this.getDesign().isLoadFromDB() && this.getDesignPartView().getDesignPart().getRepositoryOID() != null) {
            enabled = this.getDesignPartView().getDesignPart().isCheckedOutByMe();
        }
        this.getDesignPartView().getWorkSpace().updateReadOnlyStatus();
        this.setEnabled(this.newEntity, enabled);
        this.setEnabled(this.newEntityView, enabled);
        this.setEnabled(this.newRelMany2Many, enabled);
        this.setEnabled(this.newRelOne2Many, enabled);
        this.setEnabled(this.newRelOne2ManyIdent, enabled);
        this.setEnabled(this.newRelOne2One, enabled);
        this.setEnabled(this.newTypeSubstitution, enabled);
        this.setEnabled(this.newArc, enabled);
        this.setEnabled(this.add2Arc, enabled);
        this.setEnabled(this.removeFromArc, enabled);
        this.setEnabled(this.newNote, enabled);
        this.setEnabled(this.newImage, enabled);
        this.setEnabled(this.delete, enabled);
    }

    public DockStation getDockStation() {
        if (this.dockStation == null) {
            this.dockStation = DockStation.getDockStation();
        }
        return this.dockStation;
    }

    class Search
    extends MDBAction {
        private Search() {
            super(MenuUtils.getMnemonicStr(AbstractController.SEARCH_CAPTION), ControllerLogical.this.getConfiguration().getIcon("SEARCH_ICON", ControllerLogical.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.SEARCH_CAPTION));
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public boolean addToolbarSeparator() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            DesignPart dp = ControllerLogical.this.getDesignPartView().getDesignPart();
            SearchDockable lastNonPinnedView = dp.getLastNonPinnedSearchDockable();
            if (lastNonPinnedView == null) {
                ViewId vId = new ViewId(new GUID().toString(), Integer.toString(dp.getSearchDockableIdSequence()));
                SearchDockable sdNew = new SearchDockable(vId);
                dp.addSearchDockable(sdNew);
                ((SearchPanel)sdNew.getGUI()).resetItems(dp);
                sdNew.show();
            } else {
                ControllerLogical.this.getDockStation().activateDockable((Dockable)lastNonPinnedView);
            }
        }
    }

    class ActualSize
    extends MDBAction {
        private ActualSize() {
            super(MenuUtils.getMnemonicStr(AbstractController.ACTUAL_SIZE_CAPTION), ControllerLogical.this.getConfiguration().getIcon("ACTUAL_SIZE_ICON", ControllerLogical.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ACTUAL_SIZE_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            DesignPartView dpv = ControllerLogical.this.getApplicationView().getCurrentDPV();
            dpv.actualSize();
        }
    }

    class FitScreen
    extends MDBAction {
        private FitScreen() {
            super(MenuUtils.getMnemonicStr(AbstractController.FIT_SCREEN_CAPTION), ControllerLogical.this.getConfiguration().getIcon("FIT_SCREEN_ICON", ControllerLogical.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.FIT_SCREEN_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            DesignPartView dpv = ControllerLogical.this.getApplicationView().getCurrentDPV();
            dpv.fitScreen();
        }
    }

    class ZoomOut
    extends MDBAction {
        private ZoomOut() {
            super(MenuUtils.getMnemonicStr(AbstractController.ZOOM_OUT_CAPTION), ControllerLogical.this.getConfiguration().getIcon("ZOOM_OUT_ICON", ControllerLogical.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ZOOM_OUT_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            DesignPartView dpv = ControllerLogical.this.getApplicationView().getCurrentDPV();
            dpv.zoomOut();
        }
    }

    class ZoomIn
    extends MDBAction {
        private ZoomIn() {
            super(MenuUtils.getMnemonicStr(AbstractController.ZOOM_IN_CAPTION), ControllerLogical.this.getConfiguration().getIcon("ZOOM_IN_ICON", ControllerLogical.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ZOOM_IN_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addToolbarSeparator() {
            return ControllerLogical.this.isEditable();
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            DesignPartView dpv = ControllerLogical.this.getApplicationView().getCurrentDPV();
            dpv.zoomIn();
        }
    }

    class TypedElementCollector
    implements PointsEnteredCallback {
        private GlassComponent glassComp = null;
        protected boolean showSwapColumnsDialog;

        protected TypedElementCollector() {
            this.collect();
        }

        protected void collect() {
            this.glassComp = ControllerLogical.this.getDesignPartView().getGlassPane();
            this.glassComp.getPoints(this, 2);
        }

        public void stopWaiting() {
            if (this.glassComp != null) {
                this.glassComp.stopAll();
            }
        }

        private String title() {
            return Messages.getString("ControllerLogical.NewTypeSubstitution");
        }

        @Override
        public void rectangleSelected(Rectangle rectangle) {
        }

        @Override
        public void pointSelected(Point point) {
        }

        @Override
        public void pointsSelected(Point[] points) {
            ContainerView sourceTV = this.getContainerViewFor(points[0]);
            ContainerView targetTV = this.getContainerViewFor(points[1]);
            ContainerObject source = null;
            ContainerObject target = null;
            if (sourceTV != null) {
                source = (ContainerObject)sourceTV.getModel();
            }
            if (targetTV != null) {
                target = (ContainerObject)targetTV.getModel();
            }
            ArrayList<String> errors = new ArrayList<String>(2);
            if (source != null && target != null) {
                if (target == source) {
                    errors.add(Messages.getString("ControllerLogical.TwoDifferentObjectsMustBeSelected"));
                }
                if (source.getClass() != target.getClass()) {
                    errors.add(Messages.getString("ControllerLogical.TwoObjectsSameKindShouldBeSelected"));
                }
                if (!source.isBST() || !target.isBST()) {
                    errors.add(Messages.getString("ControllerLogical.ObjectsStructuredTypeCanBeSelected"));
                }
                if (source.isBST() && target.isBST()) {
                    if (source.getBasedOnStructuredType().getParentType() != target.getBasedOnStructuredType() && target.getBasedOnStructuredType().getParentType() != source.getBasedOnStructuredType()) {
                        errors.add(Messages.getString("ControllerLogical.ObjectsStructuredTypeDirectSubtypeCanBeSelected"));
                    } else if (source.getBasedOnStructuredType().getParentType() == target.getBasedOnStructuredType()) {
                        if (source.getTypeSubstitution() != null) {
                            errors.add(MessageFormat.format(Messages.getString("ControllerLogical.TypeSubstitutionAlreadyDefined"), source.getName()));
                        }
                    } else if (target.getTypeSubstitution() != null) {
                        errors.add(MessageFormat.format(Messages.getString("ControllerLogical.TypeSubstitutionAlreadyDefined"), target.getName()));
                    }
                }
                if (errors.size() == 0) {
                    this.doIt(sourceTV, targetTV);
                } else {
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), errors.toArray(), this.title(), 0);
                }
            } else {
                errors.add(Messages.getString("ControllerLogical.ErrorInObjectSelection"));
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), errors.toArray(), this.title(), 0);
            }
            ControllerLogical.this.select_SelectAction();
        }

        protected ContainerView getContainerViewFor(Point point) {
            Object cell = ControllerLogical.this.getDesignPartView().getWorkSpace().getFirstCellForLocation(point.getX(), point.getY());
            if (cell != null && cell instanceof ContainerDiagramCell) {
                return (ContainerView)((ContainerDiagramCell)cell).getTopView();
            }
            return null;
        }

        public void doIt(ContainerView sourceTV, ContainerView targetTV) {
            ContainerObject child = null;
            ContainerObject parent = null;
            ContainerObject source = null;
            ContainerObject target = null;
            ContainerView childTV = null;
            ContainerView parentTV = null;
            if (sourceTV != null) {
                source = (ContainerObject)sourceTV.getModel();
            }
            if (targetTV != null) {
                target = (ContainerObject)targetTV.getModel();
            }
            if (source != null && target != null) {
                if (source.getBasedOnStructuredType() == target.getBasedOnStructuredType().getParentType()) {
                    parent = source;
                    child = target;
                    parentTV = sourceTV;
                    childTV = targetTV;
                } else if (source.getBasedOnStructuredType().getParentType() == target.getBasedOnStructuredType()) {
                    child = source;
                    parent = target;
                    childTV = sourceTV;
                    parentTV = targetTV;
                }
                if (child != null && parent != null) {
                    TypeSubstitution ts = ControllerLogical.this.getDesign().getLogicalDesign().createTypeSubstitution();
                    ts.setChildCV(childTV);
                    ts.setParentCV(parentTV);
                    ts.addToAllDPVs();
                }
            }
        }

        @Override
        public Component getTargetCoordinateSpace() {
            return ControllerLogical.this.getDesignPartView().getWorkSpace();
        }
    }

    class NewTypeSubstitution
    extends MDBAction {
        TypedElementCollector collector;

        private NewTypeSubstitution() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_TYPE_SUBSTITUTION_CAPTION), ControllerLogical.this.getConfiguration().getIcon("RAGGED_LINK_ICON", ControllerLogical.this.getPreferredIconSize()));
            this.setMenuPath(ControllerLogical.this.OBJECT_LOGICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_TYPE_SUBSTITUTION_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            ControllerLogical.this.getDesignPartView().getWorkSpace().setDrawnObjectID(18);
            ControllerLogical.this.getDesignPartView().getWorkSpace().setCursor(Diagram.LINE_CURSOR);
            ControllerLogical.this.updateToolbar(this);
            if (this.collector != null) {
                this.collector.stopWaiting();
            }
            this.collector = new TypedElementCollector();
        }
    }

    public class EntityCollector
    implements PointsEnteredCallback {
        private GlassComponent glassComp = null;
        private int relationType = 0;

        public EntityCollector(int relationType) {
            this.relationType = relationType;
            this.startCollecting();
        }

        public void startCollecting() {
            ControllerLogical.this.getDesignPartView().getWorkSpace().clearSelection();
            this.collect();
        }

        private void collect() {
            this.glassComp = ControllerLogical.this.getDesignPartView().getGlassPane();
            this.glassComp.getPoints(this, 2);
        }

        public void stopWaiting() {
            if (this.glassComp != null) {
                this.glassComp.stopAll();
            }
        }

        @Override
        public void rectangleSelected(Rectangle rectangle) {
        }

        @Override
        public void pointSelected(Point point) {
        }

        @Override
        public void pointsSelected(Point[] points) {
            KeyObject pk;
            TVEntity sourceTV = this.getTVEntityFor(points[0]);
            TVEntity targetTV = this.getTVEntityFor(points[1]);
            ArrayList<String> errors = new ArrayList<String>();
            Entity source = null;
            Entity target = null;
            if (sourceTV != null) {
                source = (Entity)sourceTV.getModel();
            }
            if (targetTV != null) {
                target = (Entity)targetTV.getModel();
            }
            if (sourceTV == null) {
                errors.add(Messages.getString("ControllerLogical.NoSourceEntitySelected"));
            }
            if (targetTV == null) {
                errors.add(Messages.getString("ControllerLogical.NoTargetEntitySelected"));
            }
            if (source != null && source.isBST() && (pk = source.getPK()) == null) {
                errors.add(Messages.getString("ControllerLogical.ParEntityShouldHavePK"));
            }
            if (source != null && target != null) {
                if (source.getTypeSubstitution() != null || target.getTypeSubstitution() != null) {
                    errors.add(Messages.getString("ControllerLogical.EntityCannotParticipateFKRelationship"));
                }
                if ((source.isBST() || target.isBST()) && (LogicalDesign.ONE_TO_MANY_IDENTIFYING == this.relationType || LogicalDesign.ONE_TO_ONE_IDENTIFYING == this.relationType)) {
                    errors.add(Messages.getString("ControllerLogical.EntityCannotBePartIdentifyingRelationship"));
                }
            }
            this.checkFKPossibility(source, target, errors);
            if (errors.size() == 0) {
                Relation rel;
                boolean haspath;
                if (source == target && (LogicalDesign.ONE_TO_MANY_IDENTIFYING == this.relationType || LogicalDesign.ONE_TO_ONE_IDENTIFYING == this.relationType)) {
                    this.relationType = LogicalDesign.ONE_TO_MANY_IDENTIFYING == this.relationType ? LogicalDesign.ONE_TO_MANY : LogicalDesign.ONE_TO_ONE;
                    String message = Messages.getString("ControllerLogical.RecRelationshipCannotBeIdentifying");
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), message, Messages.getString("ControllerLogical.NewRelation"), 2);
                }
                if ((haspath = source.hasFK_Rel_PathTo(target)) && (LogicalDesign.ONE_TO_MANY_IDENTIFYING == this.relationType || LogicalDesign.ONE_TO_ONE_IDENTIFYING == this.relationType)) {
                    this.relationType = LogicalDesign.ONE_TO_MANY_IDENTIFYING == this.relationType ? LogicalDesign.ONE_TO_MANY : LogicalDesign.ONE_TO_ONE;
                    String message = Messages.getString("ControllerLogical.CiclicRefWillBeCreated");
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), message, Messages.getString("ControllerLogical.NewRelation"), 2);
                }
                if ((rel = this.createRelation(sourceTV, targetTV)) != null && sourceTV == targetTV && !sourceTV.getDesignPartView().isAutoRoute()) {
                    rel.createDefaultSelfReferencePoints();
                }
                if (rel != null && rel.getDesign().getAppView().getSettings().showPropertiesDialogOnNew()) {
                    RelationPropertiesDialogEx dialog = new RelationPropertiesDialogEx(ControllerLogical.this.getApplicationView(), rel);
                    rel.setShowForFirstTime(true);
                    dialog.initProperties(rel);
                    dialog.setModal(true);
                    dialog.show();
                }
            } else {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), errors.toArray(), Messages.getString("ControllerLogical.NewRelation"), 0);
            }
            ControllerLogical.this.select_SelectAction();
        }

        private void checkFKPossibility(Entity parent, Entity child, List errors) {
            KeyObject parentPK;
            if (parent != null && child != null && child.isBST() && parent.isBST() && (parentPK = parent.getPK()) != null) {
                Iterator it = parentPK.getElementsCollection().iterator();
                while (it.hasNext()) {
                    Attribute col;
                    if (!((Attribute)it.next()).isOid() || (col = child.getRefToStructurtedType(parent.getBasedOnStructuredType(), parent)) != null) continue;
                    errors.add(Messages.getString("ControllerLogical.ChildEntityDoesntHaveAttribute"));
                }
            }
        }

        private TVEntity getTVEntityFor(Point point) {
            Object cell = ControllerLogical.this.getDesignPartView().getWorkSpace().getFirstCellForLocation(point.getX(), point.getY());
            if (cell != null && cell instanceof EntityDiagramCell) {
                return (TVEntity)((EntityDiagramCell)cell).getTopView();
            }
            return null;
        }

        private Relation createRelation(TVEntity sourceTV, TVEntity targetTV) {
            ApplicationView.log(Messages.getString("ControllerLogical.CreateRelation"));
            Relation relation = ControllerLogical.this.getLogicalDesign().createRelation(this.relationType);
            if (LogicalDesign.ONE_TO_ONE_IDENTIFYING == this.relationType) {
                relation.setDominantRole((Entity)sourceTV.getModel());
                relation.setOptionalTarget(false);
            } else if (LogicalDesign.ONE_TO_MANY_IDENTIFYING == this.relationType) {
                relation.setOptionalTarget(false);
            }
            relation.setTargetEntity((Entity)targetTV.getModel());
            relation.setSourceEntity((Entity)sourceTV.getModel());
            relation.setSourceTV(sourceTV);
            relation.setTargetTV(targetTV);
            relation.addToAllDPVs();
            TVRelation tv = (TVRelation)relation.getTopView();
            tv.addConnection();
            return relation;
        }

        @Override
        public Component getTargetCoordinateSpace() {
            return ControllerLogical.this.getDesignPartView().getWorkSpace();
        }
    }

    class RemoveFromArc
    extends MDBAction {
        private RemoveFromArc() {
            super(MenuUtils.getMnemonicStr(AbstractController.REMOVE_FROM_ARC), ControllerLogical.this.getConfiguration().getIcon("REMOVE_FROM_ARC_ICON", ControllerLogical.this.getPreferredIconSize()));
            this.setMenuPath(ControllerLogical.this.OBJECT_LOGICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.REMOVE_FROM_ARC));
            this.setObjectAction(true);
        }

        @Override
        public void setEnabled(boolean enable) {
            super.setEnabled(enable && this.canHandle());
        }

        private boolean canHandle() {
            if (ControllerLogical.this.getDesign().isLoadFromDB() && !ControllerLogical.this.getDesignPartView().getDesignPart().isCheckedOutByMe()) {
                return false;
            }
            Object[] selectedObjects = ControllerLogical.this.getDesignPartView().getSelectedObjects();
            return ControllerLogical.this.getLogicalDesign().canRemoveFromArc(selectedObjects);
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            Object[] selectedObjects = ControllerLogical.this.getDesignPartView().getSelectedObjects();
            ControllerLogical.this.getLogicalDesign().removeFromArc(selectedObjects);
            this.setEnabled(false);
        }
    }

    class AddToArc
    extends MDBAction {
        private AddToArc() {
            super(MenuUtils.getMnemonicStr(AbstractController.ADD_TO_ARC), ControllerLogical.this.getConfiguration().getIcon("ADD_TO_ARC_ICON", ControllerLogical.this.getPreferredIconSize()));
            this.setMenuPath(ControllerLogical.this.OBJECT_LOGICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ADD_TO_ARC));
            this.setObjectAction(true);
        }

        @Override
        public void setEnabled(boolean enable) {
            super.setEnabled(enable && this.canHandle());
        }

        private boolean canHandle() {
            if (ControllerLogical.this.getDesign().isLoadFromDB() && !ControllerLogical.this.getDesignPartView().getDesignPart().isCheckedOutByMe()) {
                return false;
            }
            Object[] selectedObjects = ControllerLogical.this.getDesignPartView().getSelectedObjects();
            return ControllerLogical.this.getLogicalDesign().canAddToArc(selectedObjects);
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            Object[] selectedObjects = ControllerLogical.this.getDesignPartView().getSelectedObjects();
            ControllerLogical.this.getLogicalDesign().addToArc(selectedObjects);
            this.setEnabled(false);
        }
    }

    class NewArc
    extends MDBAction {
        private NewArc() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_ARC), ControllerLogical.this.getConfiguration().getIcon("NEW_ARC_ICON", ControllerLogical.this.getPreferredIconSize()));
            this.setMenuPath(ControllerLogical.this.OBJECT_LOGICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_ARC));
            this.setObjectAction(true);
        }

        @Override
        public void setEnabled(boolean enable) {
            super.setEnabled(enable && this.canHandle());
        }

        private boolean canHandle() {
            if (ControllerLogical.this.getDesign().isLoadFromDB() && !ControllerLogical.this.getDesignPartView().getDesignPart().isCheckedOutByMe()) {
                return false;
            }
            Object[] selectedObjects = ControllerLogical.this.getDesignPartView().getSelectedObjects();
            return ControllerLogical.this.getLogicalDesign().canCreateArc(selectedObjects);
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            Object[] selectedObjects = ControllerLogical.this.getDesignPartView().getSelectedObjects();
            ControllerLogical.this.getLogicalDesign().createArc(selectedObjects);
            this.setEnabled(false);
        }
    }

    class NewRelationOneToOne
    extends MDBAction {
        private NewRelationOneToOne() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_1_TO_1_RELATION_CAPTION), ControllerLogical.this.getConfiguration().getIcon("ONE_TO_1_RELATION_ICON", ControllerLogical.this.getPreferredIconSize()));
            this.setMenuPath(ControllerLogical.this.OBJECT_LOGICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_1_TO_1_RELATION_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            ControllerLogical.this.getDesignPartView().getWorkSpace().setDrawnObjectID(1);
            ControllerLogical.this.getDesignPartView().getWorkSpace().setCursor(Diagram.LINE_CURSOR);
            ControllerLogical.this.updateToolbar(this);
            if (ControllerLogical.this.eCollector != null) {
                ControllerLogical.this.eCollector.stopWaiting();
            }
            ControllerLogical.this.eCollector = new EntityCollector(LogicalDesign.ONE_TO_ONE);
        }
    }

    class NewRelationOneToManyIdentifying
    extends MDBAction {
        private NewRelationOneToManyIdentifying() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_1_TO_N_IDENTIFYING_RELATION_CAPTION), ControllerLogical.this.getConfiguration().getIcon("ONE_TO_N_I_RELATION_ICON", ControllerLogical.this.getPreferredIconSize()));
            this.setMenuPath(ControllerLogical.this.OBJECT_LOGICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_1_TO_N_IDENTIFYING_RELATION_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            ControllerLogical.this.getDesignPartView().getWorkSpace().setDrawnObjectID(1);
            ControllerLogical.this.getDesignPartView().getWorkSpace().setCursor(Diagram.LINE_CURSOR);
            ControllerLogical.this.updateToolbar(this);
            if (ControllerLogical.this.eCollector != null) {
                ControllerLogical.this.eCollector.stopWaiting();
            }
            ControllerLogical.this.eCollector = new EntityCollector(LogicalDesign.ONE_TO_MANY_IDENTIFYING);
        }
    }

    class NewRelationOneToMany
    extends MDBAction {
        private NewRelationOneToMany() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_1_TO_N_RELATION_CAPTION), ControllerLogical.this.getConfiguration().getIcon("ONE_TO_N_RELATION_ICON", ControllerLogical.this.getPreferredIconSize()));
            this.setMenuPath(ControllerLogical.this.OBJECT_LOGICAL_PATH);
            this.setObjectAction(true);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_1_TO_N_RELATION_CAPTION));
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            ControllerLogical.this.getDesignPartView().getWorkSpace().setDrawnObjectID(1);
            ControllerLogical.this.getDesignPartView().getWorkSpace().setCursor(Diagram.LINE_CURSOR);
            ControllerLogical.this.updateToolbar(this);
            if (ControllerLogical.this.eCollector != null) {
                ControllerLogical.this.eCollector.stopWaiting();
            }
            ControllerLogical.this.eCollector = new EntityCollector(LogicalDesign.ONE_TO_MANY);
        }
    }

    class NewRelationManyToMany
    extends MDBAction {
        private NewRelationManyToMany() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_M_TO_N_RELATION_CAPTION), ControllerLogical.this.getConfiguration().getIcon("M_TO_N_RELATION_ICON", ControllerLogical.this.getPreferredIconSize()));
            this.setMenuPath(ControllerLogical.this.OBJECT_LOGICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_M_TO_N_RELATION_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            ControllerLogical.this.getDesignPartView().getWorkSpace().setDrawnObjectID(1);
            ControllerLogical.this.getDesignPartView().getWorkSpace().setCursor(Diagram.LINE_CURSOR);
            ControllerLogical.this.updateToolbar(this);
            if (ControllerLogical.this.eCollector != null) {
                ControllerLogical.this.eCollector.stopWaiting();
            }
            ControllerLogical.this.eCollector = new EntityCollector(LogicalDesign.MANY_TO_MANY);
        }
    }

    public class FWDEngineer
    extends MDBAction {
        private FWDEngineer() {
            super(MenuUtils.getMnemonicStr(AbstractController.FORWARD_ENGINEER_CAPTION), ControllerLogical.this.getConfiguration().getIcon("FORWARD_ENGINEER_ICON", ControllerLogical.this.getPreferredIconSize()));
            this.setMenuPath(ControllerLogical.this.DESIGN_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.FORWARD_ENGINEER_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(70, 192, false));
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public boolean addToolbarSeparator() {
            return true;
        }

        @Override
        public void setEnabled(boolean enable) {
            super.setEnabled(enable && this.canHandle());
        }

        private boolean canHandle() {
            return !ControllerLogical.this.getDesign().isLoadFromDB() || ControllerLogical.this.getDesignPartView().getDesignPart().isCheckedOutByMe();
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerLogical.this.getDesign().getFirstOpenRelationalDesign() != null) {
                EngineeringCompareDialog engDial = new EngineeringCompareDialog(ControllerLogical.this.getApplicationView(), ControllerLogical.this.getApplicationView().getCurrentDPV().getDesignPart());
                engDial.setModal(true);
                engDial.show();
            } else {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("ControllerLogical.NoRelModelsAvailable"), Messages.getString("ControllerLogical.Warning"), 2);
            }
        }
    }

    class NewImage
    extends MDBAction {
        private NewImage() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_IMAGE_CAPTION), ControllerLogical.this.getConfiguration().getIcon("IMAGE_ICON", ControllerLogical.this.getPreferredIconSize()));
            this.setMenuPath(ControllerLogical.this.OBJECT_LOGICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_IMAGE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerLogical.this.eCollector != null) {
                ControllerLogical.this.eCollector.stopWaiting();
            }
            ControllerLogical.this.getDesignPartView().getWorkSpace().setDrawnObjectID(25);
            ControllerLogical.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerLogical.this.updateToolbar(this);
        }
    }

    class NewNote
    extends MDBAction {
        private NewNote() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_NOTE_CAPTION), ControllerLogical.this.getConfiguration().getIcon("NOTE_ICON", ControllerLogical.this.getPreferredIconSize()));
            this.setMenuPath(ControllerLogical.this.OBJECT_LOGICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_NOTE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerLogical.this.eCollector != null) {
                ControllerLogical.this.eCollector.stopWaiting();
            }
            ControllerLogical.this.getDesignPartView().getWorkSpace().setDrawnObjectID(5);
            ControllerLogical.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerLogical.this.updateToolbar(this);
        }
    }

    class NewEntityView
    extends MDBAction {
        private NewEntityView() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_VIEW_CAPTION), ControllerLogical.this.getConfiguration().getIcon("ENTITY_VIEW_ICON", ControllerLogical.this.getPreferredIconSize()));
            this.setMenuPath(ControllerLogical.this.OBJECT_LOGICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_VIEW_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerLogical.this.eCollector != null) {
                ControllerLogical.this.eCollector.stopWaiting();
            }
            ControllerLogical.this.getDesignPartView().getWorkSpace().setDrawnObjectID(19);
            ControllerLogical.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerLogical.this.updateToolbar(this);
        }
    }

    class NewEntity
    extends MDBAction {
        private NewEntity() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_ENTITY_CAPTION), ControllerLogical.this.getConfiguration().getIcon("ENTITY_ICON", ControllerLogical.this.getPreferredIconSize()));
            this.setMenuPath(ControllerLogical.this.OBJECT_LOGICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_ENTITY_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerLogical.this.eCollector != null) {
                ControllerLogical.this.eCollector.stopWaiting();
            }
            ControllerLogical.this.getDesignPartView().getWorkSpace().setDrawnObjectID(0);
            ControllerLogical.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerLogical.this.updateToolbar(this);
        }
    }

    class Delete
    extends MDBAction {
        private Delete() {
            super(MenuUtils.getMnemonicStr(AbstractController.DELETE_CAPTION), ControllerLogical.this.getConfiguration().getIcon("DELETE_ICON", ControllerLogical.this.getPreferredIconSize()));
            this.setMenuPath(ControllerLogical.this.OBJECT_LOGICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.DELETE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerLogical.this.eCollector != null) {
                ControllerLogical.this.eCollector.stopWaiting();
            }
            ControllerLogical.this.getDesignPartView().getWorkSpace().setDrawnObjectID(6);
            ControllerLogical.this.getDesignPartView().getWorkSpace().setCursor(Diagram.DELETE_CURSOR);
            ControllerLogical.this.updateToolbar(this);
        }
    }

    class Select
    extends MDBAction {
        private Select() {
            super(MenuUtils.getMnemonicStr(AbstractController.SELECT_CAPTION), ControllerLogical.this.getConfiguration().getIcon("SELECT_ICON", ControllerLogical.this.getPreferredIconSize()));
            this.setMenuPath(ControllerLogical.this.OBJECT_LOGICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.SELECT_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerLogical.this.eCollector != null) {
                ControllerLogical.this.eCollector.stopWaiting();
            }
            ControllerLogical.this.getDesignPartView().getWorkSpace().setDrawnObjectID(-1);
            ControllerLogical.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(0));
            ControllerLogical.this.updateToolbar(this);
        }
    }
}

