/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb;

import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.TypeElementProxyUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class TypeElementPropertyDialogUDB
extends AbstractUDBPropertyDialog {
    private TypeElementProxyUDB typeElement;
    private JTextField tfDatatype;

    public TypeElementPropertyDialogUDB(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.typeElement = (TypeElementProxyUDB)object;
        this.setHeight(120);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("TypeElementPropertyDialogUDB.TypeElementProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initDatatype();
    }

    private void initDatatype() {
        JLabel label = new JLabel(Messages.getString("TypeElementPropertyDialogUDB.Datatype"));
        this.general.add(label);
        this.tfDatatype = new JTextField("", 26);
        this.tfDatatype.setEnabled(false);
        this.general.add(this.tfDatatype);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.tfDatatype, 50);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.typeElement.getName());
        this.tfName.setText(this.typeElement.getName());
        this.tfDatatype.setText(this.typeElement.getDatatype("DB2/UDB 7.1"));
        this.getCommentsList().insert(this.typeElement.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.typeElement != null) {
            this.typeElement.setName(this.tfName.getText());
            this.typeElement.setComment(this.getCommentsList().getText());
        }
    }
}

